// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/health_checks/v1/health_checks.proto

#include "google/cloud/compute/health_checks/v1/health_checks_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_health_checks_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

HealthChecksClient::HealthChecksClient(
    std::shared_ptr<HealthChecksConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
HealthChecksClient::~HealthChecksClient() = default;

StreamRange<std::pair<std::string,
                      google::cloud::cpp::compute::v1::HealthChecksScopedList>>
HealthChecksClient::AggregatedListHealthChecks(std::string const& project,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::health_checks::v1::
      AggregatedListHealthChecksRequest request;
  request.set_project(project);
  return connection_->AggregatedListHealthChecks(request);
}

StreamRange<std::pair<std::string,
                      google::cloud::cpp::compute::v1::HealthChecksScopedList>>
HealthChecksClient::AggregatedListHealthChecks(
    google::cloud::cpp::compute::health_checks::v1::
        AggregatedListHealthChecksRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AggregatedListHealthChecks(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HealthChecksClient::DeleteHealthCheck(std::string const& project,
                                      std::string const& health_check,
                                      Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::health_checks::v1::DeleteHealthCheckRequest
      request;
  request.set_project(project);
  request.set_health_check(health_check);
  return connection_->DeleteHealthCheck(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
HealthChecksClient::DeleteHealthCheck(NoAwaitTag, std::string const& project,
                                      std::string const& health_check,
                                      Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::health_checks::v1::DeleteHealthCheckRequest
      request;
  request.set_project(project);
  request.set_health_check(health_check);
  return connection_->DeleteHealthCheck(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HealthChecksClient::DeleteHealthCheck(
    google::cloud::cpp::compute::health_checks::v1::
        DeleteHealthCheckRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteHealthCheck(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
HealthChecksClient::DeleteHealthCheck(
    NoAwaitTag,
    google::cloud::cpp::compute::health_checks::v1::
        DeleteHealthCheckRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteHealthCheck(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HealthChecksClient::DeleteHealthCheck(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteHealthCheck(operation);
}

StatusOr<google::cloud::cpp::compute::v1::HealthCheck>
HealthChecksClient::GetHealthCheck(std::string const& project,
                                   std::string const& health_check,
                                   Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::health_checks::v1::GetHealthCheckRequest request;
  request.set_project(project);
  request.set_health_check(health_check);
  return connection_->GetHealthCheck(request);
}

StatusOr<google::cloud::cpp::compute::v1::HealthCheck>
HealthChecksClient::GetHealthCheck(
    google::cloud::cpp::compute::health_checks::v1::GetHealthCheckRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetHealthCheck(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HealthChecksClient::InsertHealthCheck(
    std::string const& project,
    google::cloud::cpp::compute::v1::HealthCheck const& health_check_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::health_checks::v1::InsertHealthCheckRequest
      request;
  request.set_project(project);
  *request.mutable_health_check_resource() = health_check_resource;
  return connection_->InsertHealthCheck(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
HealthChecksClient::InsertHealthCheck(
    NoAwaitTag, std::string const& project,
    google::cloud::cpp::compute::v1::HealthCheck const& health_check_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::health_checks::v1::InsertHealthCheckRequest
      request;
  request.set_project(project);
  *request.mutable_health_check_resource() = health_check_resource;
  return connection_->InsertHealthCheck(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HealthChecksClient::InsertHealthCheck(
    google::cloud::cpp::compute::health_checks::v1::
        InsertHealthCheckRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertHealthCheck(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
HealthChecksClient::InsertHealthCheck(
    NoAwaitTag,
    google::cloud::cpp::compute::health_checks::v1::
        InsertHealthCheckRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertHealthCheck(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HealthChecksClient::InsertHealthCheck(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertHealthCheck(operation);
}

StreamRange<google::cloud::cpp::compute::v1::HealthCheck>
HealthChecksClient::ListHealthChecks(std::string const& project, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::health_checks::v1::ListHealthChecksRequest
      request;
  request.set_project(project);
  return connection_->ListHealthChecks(request);
}

StreamRange<google::cloud::cpp::compute::v1::HealthCheck>
HealthChecksClient::ListHealthChecks(
    google::cloud::cpp::compute::health_checks::v1::ListHealthChecksRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListHealthChecks(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HealthChecksClient::PatchHealthCheck(
    std::string const& project, std::string const& health_check,
    google::cloud::cpp::compute::v1::HealthCheck const& health_check_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::health_checks::v1::PatchHealthCheckRequest
      request;
  request.set_project(project);
  request.set_health_check(health_check);
  *request.mutable_health_check_resource() = health_check_resource;
  return connection_->PatchHealthCheck(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
HealthChecksClient::PatchHealthCheck(
    NoAwaitTag, std::string const& project, std::string const& health_check,
    google::cloud::cpp::compute::v1::HealthCheck const& health_check_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::health_checks::v1::PatchHealthCheckRequest
      request;
  request.set_project(project);
  request.set_health_check(health_check);
  *request.mutable_health_check_resource() = health_check_resource;
  return connection_->PatchHealthCheck(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HealthChecksClient::PatchHealthCheck(
    google::cloud::cpp::compute::health_checks::v1::
        PatchHealthCheckRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchHealthCheck(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
HealthChecksClient::PatchHealthCheck(
    NoAwaitTag,
    google::cloud::cpp::compute::health_checks::v1::
        PatchHealthCheckRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchHealthCheck(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HealthChecksClient::PatchHealthCheck(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchHealthCheck(operation);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HealthChecksClient::UpdateHealthCheck(
    std::string const& project, std::string const& health_check,
    google::cloud::cpp::compute::v1::HealthCheck const& health_check_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::health_checks::v1::UpdateHealthCheckRequest
      request;
  request.set_project(project);
  request.set_health_check(health_check);
  *request.mutable_health_check_resource() = health_check_resource;
  return connection_->UpdateHealthCheck(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
HealthChecksClient::UpdateHealthCheck(
    NoAwaitTag, std::string const& project, std::string const& health_check,
    google::cloud::cpp::compute::v1::HealthCheck const& health_check_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::health_checks::v1::UpdateHealthCheckRequest
      request;
  request.set_project(project);
  request.set_health_check(health_check);
  *request.mutable_health_check_resource() = health_check_resource;
  return connection_->UpdateHealthCheck(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HealthChecksClient::UpdateHealthCheck(
    google::cloud::cpp::compute::health_checks::v1::
        UpdateHealthCheckRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateHealthCheck(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
HealthChecksClient::UpdateHealthCheck(
    NoAwaitTag,
    google::cloud::cpp::compute::health_checks::v1::
        UpdateHealthCheckRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateHealthCheck(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HealthChecksClient::UpdateHealthCheck(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateHealthCheck(operation);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_health_checks_v1
}  // namespace cloud
}  // namespace google
