// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/global_network_endpoint_groups/v1/global_network_endpoint_groups.proto

#include "google/cloud/compute/global_network_endpoint_groups/v1/global_network_endpoint_groups_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_global_network_endpoint_groups_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

GlobalNetworkEndpointGroupsClient::GlobalNetworkEndpointGroupsClient(
    std::shared_ptr<GlobalNetworkEndpointGroupsConnection> connection,
    Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
GlobalNetworkEndpointGroupsClient::~GlobalNetworkEndpointGroupsClient() =
    default;

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
GlobalNetworkEndpointGroupsClient::AttachNetworkEndpoints(
    std::string const& project, std::string const& network_endpoint_group,
    google::cloud::cpp::compute::v1::
        GlobalNetworkEndpointGroupsAttachEndpointsRequest const&
            global_network_endpoint_groups_attach_endpoints_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::global_network_endpoint_groups::v1::
      AttachNetworkEndpointsRequest request;
  request.set_project(project);
  request.set_network_endpoint_group(network_endpoint_group);
  *request
       .mutable_global_network_endpoint_groups_attach_endpoints_request_resource() =
      global_network_endpoint_groups_attach_endpoints_request_resource;
  return connection_->AttachNetworkEndpoints(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
GlobalNetworkEndpointGroupsClient::AttachNetworkEndpoints(
    NoAwaitTag, std::string const& project,
    std::string const& network_endpoint_group,
    google::cloud::cpp::compute::v1::
        GlobalNetworkEndpointGroupsAttachEndpointsRequest const&
            global_network_endpoint_groups_attach_endpoints_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::global_network_endpoint_groups::v1::
      AttachNetworkEndpointsRequest request;
  request.set_project(project);
  request.set_network_endpoint_group(network_endpoint_group);
  *request
       .mutable_global_network_endpoint_groups_attach_endpoints_request_resource() =
      global_network_endpoint_groups_attach_endpoints_request_resource;
  return connection_->AttachNetworkEndpoints(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
GlobalNetworkEndpointGroupsClient::AttachNetworkEndpoints(
    google::cloud::cpp::compute::global_network_endpoint_groups::v1::
        AttachNetworkEndpointsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AttachNetworkEndpoints(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
GlobalNetworkEndpointGroupsClient::AttachNetworkEndpoints(
    NoAwaitTag,
    google::cloud::cpp::compute::global_network_endpoint_groups::v1::
        AttachNetworkEndpointsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AttachNetworkEndpoints(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
GlobalNetworkEndpointGroupsClient::AttachNetworkEndpoints(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AttachNetworkEndpoints(operation);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
GlobalNetworkEndpointGroupsClient::DeleteNetworkEndpointGroup(
    std::string const& project, std::string const& network_endpoint_group,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::global_network_endpoint_groups::v1::
      DeleteNetworkEndpointGroupRequest request;
  request.set_project(project);
  request.set_network_endpoint_group(network_endpoint_group);
  return connection_->DeleteNetworkEndpointGroup(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
GlobalNetworkEndpointGroupsClient::DeleteNetworkEndpointGroup(
    NoAwaitTag, std::string const& project,
    std::string const& network_endpoint_group, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::global_network_endpoint_groups::v1::
      DeleteNetworkEndpointGroupRequest request;
  request.set_project(project);
  request.set_network_endpoint_group(network_endpoint_group);
  return connection_->DeleteNetworkEndpointGroup(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
GlobalNetworkEndpointGroupsClient::DeleteNetworkEndpointGroup(
    google::cloud::cpp::compute::global_network_endpoint_groups::v1::
        DeleteNetworkEndpointGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNetworkEndpointGroup(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
GlobalNetworkEndpointGroupsClient::DeleteNetworkEndpointGroup(
    NoAwaitTag,
    google::cloud::cpp::compute::global_network_endpoint_groups::v1::
        DeleteNetworkEndpointGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNetworkEndpointGroup(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
GlobalNetworkEndpointGroupsClient::DeleteNetworkEndpointGroup(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNetworkEndpointGroup(operation);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
GlobalNetworkEndpointGroupsClient::DetachNetworkEndpoints(
    std::string const& project, std::string const& network_endpoint_group,
    google::cloud::cpp::compute::v1::
        GlobalNetworkEndpointGroupsDetachEndpointsRequest const&
            global_network_endpoint_groups_detach_endpoints_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::global_network_endpoint_groups::v1::
      DetachNetworkEndpointsRequest request;
  request.set_project(project);
  request.set_network_endpoint_group(network_endpoint_group);
  *request
       .mutable_global_network_endpoint_groups_detach_endpoints_request_resource() =
      global_network_endpoint_groups_detach_endpoints_request_resource;
  return connection_->DetachNetworkEndpoints(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
GlobalNetworkEndpointGroupsClient::DetachNetworkEndpoints(
    NoAwaitTag, std::string const& project,
    std::string const& network_endpoint_group,
    google::cloud::cpp::compute::v1::
        GlobalNetworkEndpointGroupsDetachEndpointsRequest const&
            global_network_endpoint_groups_detach_endpoints_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::global_network_endpoint_groups::v1::
      DetachNetworkEndpointsRequest request;
  request.set_project(project);
  request.set_network_endpoint_group(network_endpoint_group);
  *request
       .mutable_global_network_endpoint_groups_detach_endpoints_request_resource() =
      global_network_endpoint_groups_detach_endpoints_request_resource;
  return connection_->DetachNetworkEndpoints(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
GlobalNetworkEndpointGroupsClient::DetachNetworkEndpoints(
    google::cloud::cpp::compute::global_network_endpoint_groups::v1::
        DetachNetworkEndpointsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DetachNetworkEndpoints(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
GlobalNetworkEndpointGroupsClient::DetachNetworkEndpoints(
    NoAwaitTag,
    google::cloud::cpp::compute::global_network_endpoint_groups::v1::
        DetachNetworkEndpointsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DetachNetworkEndpoints(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
GlobalNetworkEndpointGroupsClient::DetachNetworkEndpoints(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DetachNetworkEndpoints(operation);
}

StatusOr<google::cloud::cpp::compute::v1::NetworkEndpointGroup>
GlobalNetworkEndpointGroupsClient::GetNetworkEndpointGroup(
    std::string const& project, std::string const& network_endpoint_group,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::global_network_endpoint_groups::v1::
      GetNetworkEndpointGroupRequest request;
  request.set_project(project);
  request.set_network_endpoint_group(network_endpoint_group);
  return connection_->GetNetworkEndpointGroup(request);
}

StatusOr<google::cloud::cpp::compute::v1::NetworkEndpointGroup>
GlobalNetworkEndpointGroupsClient::GetNetworkEndpointGroup(
    google::cloud::cpp::compute::global_network_endpoint_groups::v1::
        GetNetworkEndpointGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetNetworkEndpointGroup(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
GlobalNetworkEndpointGroupsClient::InsertNetworkEndpointGroup(
    std::string const& project,
    google::cloud::cpp::compute::v1::NetworkEndpointGroup const&
        network_endpoint_group_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::global_network_endpoint_groups::v1::
      InsertNetworkEndpointGroupRequest request;
  request.set_project(project);
  *request.mutable_network_endpoint_group_resource() =
      network_endpoint_group_resource;
  return connection_->InsertNetworkEndpointGroup(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
GlobalNetworkEndpointGroupsClient::InsertNetworkEndpointGroup(
    NoAwaitTag, std::string const& project,
    google::cloud::cpp::compute::v1::NetworkEndpointGroup const&
        network_endpoint_group_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::global_network_endpoint_groups::v1::
      InsertNetworkEndpointGroupRequest request;
  request.set_project(project);
  *request.mutable_network_endpoint_group_resource() =
      network_endpoint_group_resource;
  return connection_->InsertNetworkEndpointGroup(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
GlobalNetworkEndpointGroupsClient::InsertNetworkEndpointGroup(
    google::cloud::cpp::compute::global_network_endpoint_groups::v1::
        InsertNetworkEndpointGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertNetworkEndpointGroup(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
GlobalNetworkEndpointGroupsClient::InsertNetworkEndpointGroup(
    NoAwaitTag,
    google::cloud::cpp::compute::global_network_endpoint_groups::v1::
        InsertNetworkEndpointGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertNetworkEndpointGroup(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
GlobalNetworkEndpointGroupsClient::InsertNetworkEndpointGroup(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertNetworkEndpointGroup(operation);
}

StreamRange<google::cloud::cpp::compute::v1::NetworkEndpointGroup>
GlobalNetworkEndpointGroupsClient::ListGlobalNetworkEndpointGroups(
    std::string const& project, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::global_network_endpoint_groups::v1::
      ListGlobalNetworkEndpointGroupsRequest request;
  request.set_project(project);
  return connection_->ListGlobalNetworkEndpointGroups(request);
}

StreamRange<google::cloud::cpp::compute::v1::NetworkEndpointGroup>
GlobalNetworkEndpointGroupsClient::ListGlobalNetworkEndpointGroups(
    google::cloud::cpp::compute::global_network_endpoint_groups::v1::
        ListGlobalNetworkEndpointGroupsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListGlobalNetworkEndpointGroups(std::move(request));
}

StreamRange<google::cloud::cpp::compute::v1::NetworkEndpointWithHealthStatus>
GlobalNetworkEndpointGroupsClient::ListNetworkEndpoints(
    std::string const& project, std::string const& network_endpoint_group,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::global_network_endpoint_groups::v1::
      ListNetworkEndpointsRequest request;
  request.set_project(project);
  request.set_network_endpoint_group(network_endpoint_group);
  return connection_->ListNetworkEndpoints(request);
}

StreamRange<google::cloud::cpp::compute::v1::NetworkEndpointWithHealthStatus>
GlobalNetworkEndpointGroupsClient::ListNetworkEndpoints(
    google::cloud::cpp::compute::global_network_endpoint_groups::v1::
        ListNetworkEndpointsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListNetworkEndpoints(std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_global_network_endpoint_groups_v1
}  // namespace cloud
}  // namespace google
