// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/orchestration/airflow/service/v1/environments.proto

#include "google/cloud/composer/v1/internal/environments_auth_decorator.h"
#include <google/cloud/orchestration/airflow/service/v1/environments.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace composer_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

EnvironmentsAuth::EnvironmentsAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<EnvironmentsStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

future<StatusOr<google::longrunning::Operation>>
EnvironmentsAuth::AsyncCreateEnvironment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::orchestration::airflow::service::v1::
        CreateEnvironmentRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncCreateEnvironment(cq, *std::move(context),
                                             std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> EnvironmentsAuth::CreateEnvironment(
    grpc::ClientContext& context, Options options,
    google::cloud::orchestration::airflow::service::v1::
        CreateEnvironmentRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateEnvironment(context, options, request);
}

StatusOr<google::cloud::orchestration::airflow::service::v1::Environment>
EnvironmentsAuth::GetEnvironment(
    grpc::ClientContext& context, Options const& options,
    google::cloud::orchestration::airflow::service::v1::
        GetEnvironmentRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetEnvironment(context, options, request);
}

StatusOr<google::cloud::orchestration::airflow::service::v1::
             ListEnvironmentsResponse>
EnvironmentsAuth::ListEnvironments(
    grpc::ClientContext& context, Options const& options,
    google::cloud::orchestration::airflow::service::v1::
        ListEnvironmentsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListEnvironments(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
EnvironmentsAuth::AsyncUpdateEnvironment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::orchestration::airflow::service::v1::
        UpdateEnvironmentRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncUpdateEnvironment(cq, *std::move(context),
                                             std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> EnvironmentsAuth::UpdateEnvironment(
    grpc::ClientContext& context, Options options,
    google::cloud::orchestration::airflow::service::v1::
        UpdateEnvironmentRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateEnvironment(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
EnvironmentsAuth::AsyncDeleteEnvironment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::orchestration::airflow::service::v1::
        DeleteEnvironmentRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncDeleteEnvironment(cq, *std::move(context),
                                             std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> EnvironmentsAuth::DeleteEnvironment(
    grpc::ClientContext& context, Options options,
    google::cloud::orchestration::airflow::service::v1::
        DeleteEnvironmentRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteEnvironment(context, options, request);
}

StatusOr<google::cloud::orchestration::airflow::service::v1::
             ExecuteAirflowCommandResponse>
EnvironmentsAuth::ExecuteAirflowCommand(
    grpc::ClientContext& context, Options const& options,
    google::cloud::orchestration::airflow::service::v1::
        ExecuteAirflowCommandRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ExecuteAirflowCommand(context, options, request);
}

StatusOr<google::cloud::orchestration::airflow::service::v1::
             StopAirflowCommandResponse>
EnvironmentsAuth::StopAirflowCommand(
    grpc::ClientContext& context, Options const& options,
    google::cloud::orchestration::airflow::service::v1::
        StopAirflowCommandRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->StopAirflowCommand(context, options, request);
}

StatusOr<google::cloud::orchestration::airflow::service::v1::
             PollAirflowCommandResponse>
EnvironmentsAuth::PollAirflowCommand(
    grpc::ClientContext& context, Options const& options,
    google::cloud::orchestration::airflow::service::v1::
        PollAirflowCommandRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->PollAirflowCommand(context, options, request);
}

StatusOr<
    google::cloud::orchestration::airflow::service::v1::ListWorkloadsResponse>
EnvironmentsAuth::ListWorkloads(grpc::ClientContext& context,
                                Options const& options,
                                google::cloud::orchestration::airflow::service::
                                    v1::ListWorkloadsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListWorkloads(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
EnvironmentsAuth::AsyncCheckUpgrade(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::orchestration::airflow::service::v1::
        CheckUpgradeRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncCheckUpgrade(cq, *std::move(context),
                                        std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> EnvironmentsAuth::CheckUpgrade(
    grpc::ClientContext& context, Options options,
    google::cloud::orchestration::airflow::service::v1::
        CheckUpgradeRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CheckUpgrade(context, options, request);
}

StatusOr<
    google::cloud::orchestration::airflow::service::v1::UserWorkloadsSecret>
EnvironmentsAuth::CreateUserWorkloadsSecret(
    grpc::ClientContext& context, Options const& options,
    google::cloud::orchestration::airflow::service::v1::
        CreateUserWorkloadsSecretRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateUserWorkloadsSecret(context, options, request);
}

StatusOr<
    google::cloud::orchestration::airflow::service::v1::UserWorkloadsSecret>
EnvironmentsAuth::GetUserWorkloadsSecret(
    grpc::ClientContext& context, Options const& options,
    google::cloud::orchestration::airflow::service::v1::
        GetUserWorkloadsSecretRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetUserWorkloadsSecret(context, options, request);
}

StatusOr<google::cloud::orchestration::airflow::service::v1::
             ListUserWorkloadsSecretsResponse>
EnvironmentsAuth::ListUserWorkloadsSecrets(
    grpc::ClientContext& context, Options const& options,
    google::cloud::orchestration::airflow::service::v1::
        ListUserWorkloadsSecretsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListUserWorkloadsSecrets(context, options, request);
}

StatusOr<
    google::cloud::orchestration::airflow::service::v1::UserWorkloadsSecret>
EnvironmentsAuth::UpdateUserWorkloadsSecret(
    grpc::ClientContext& context, Options const& options,
    google::cloud::orchestration::airflow::service::v1::
        UpdateUserWorkloadsSecretRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateUserWorkloadsSecret(context, options, request);
}

Status EnvironmentsAuth::DeleteUserWorkloadsSecret(
    grpc::ClientContext& context, Options const& options,
    google::cloud::orchestration::airflow::service::v1::
        DeleteUserWorkloadsSecretRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteUserWorkloadsSecret(context, options, request);
}

StatusOr<
    google::cloud::orchestration::airflow::service::v1::UserWorkloadsConfigMap>
EnvironmentsAuth::CreateUserWorkloadsConfigMap(
    grpc::ClientContext& context, Options const& options,
    google::cloud::orchestration::airflow::service::v1::
        CreateUserWorkloadsConfigMapRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateUserWorkloadsConfigMap(context, options, request);
}

StatusOr<
    google::cloud::orchestration::airflow::service::v1::UserWorkloadsConfigMap>
EnvironmentsAuth::GetUserWorkloadsConfigMap(
    grpc::ClientContext& context, Options const& options,
    google::cloud::orchestration::airflow::service::v1::
        GetUserWorkloadsConfigMapRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetUserWorkloadsConfigMap(context, options, request);
}

StatusOr<google::cloud::orchestration::airflow::service::v1::
             ListUserWorkloadsConfigMapsResponse>
EnvironmentsAuth::ListUserWorkloadsConfigMaps(
    grpc::ClientContext& context, Options const& options,
    google::cloud::orchestration::airflow::service::v1::
        ListUserWorkloadsConfigMapsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListUserWorkloadsConfigMaps(context, options, request);
}

StatusOr<
    google::cloud::orchestration::airflow::service::v1::UserWorkloadsConfigMap>
EnvironmentsAuth::UpdateUserWorkloadsConfigMap(
    grpc::ClientContext& context, Options const& options,
    google::cloud::orchestration::airflow::service::v1::
        UpdateUserWorkloadsConfigMapRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateUserWorkloadsConfigMap(context, options, request);
}

Status EnvironmentsAuth::DeleteUserWorkloadsConfigMap(
    grpc::ClientContext& context, Options const& options,
    google::cloud::orchestration::airflow::service::v1::
        DeleteUserWorkloadsConfigMapRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteUserWorkloadsConfigMap(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
EnvironmentsAuth::AsyncSaveSnapshot(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::orchestration::airflow::service::v1::
        SaveSnapshotRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncSaveSnapshot(cq, *std::move(context),
                                        std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> EnvironmentsAuth::SaveSnapshot(
    grpc::ClientContext& context, Options options,
    google::cloud::orchestration::airflow::service::v1::
        SaveSnapshotRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->SaveSnapshot(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
EnvironmentsAuth::AsyncLoadSnapshot(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::orchestration::airflow::service::v1::
        LoadSnapshotRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncLoadSnapshot(cq, *std::move(context),
                                        std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> EnvironmentsAuth::LoadSnapshot(
    grpc::ClientContext& context, Options options,
    google::cloud::orchestration::airflow::service::v1::
        LoadSnapshotRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->LoadSnapshot(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
EnvironmentsAuth::AsyncDatabaseFailover(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::orchestration::airflow::service::v1::
        DatabaseFailoverRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncDatabaseFailover(cq, *std::move(context),
                                            std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> EnvironmentsAuth::DatabaseFailover(
    grpc::ClientContext& context, Options options,
    google::cloud::orchestration::airflow::service::v1::
        DatabaseFailoverRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DatabaseFailover(context, options, request);
}

StatusOr<google::cloud::orchestration::airflow::service::v1::
             FetchDatabasePropertiesResponse>
EnvironmentsAuth::FetchDatabaseProperties(
    grpc::ClientContext& context, Options const& options,
    google::cloud::orchestration::airflow::service::v1::
        FetchDatabasePropertiesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->FetchDatabaseProperties(context, options, request);
}

StatusOr<google::longrunning::ListOperationsResponse>
EnvironmentsAuth::ListOperations(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::ListOperationsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListOperations(context, options, request);
}

StatusOr<google::longrunning::Operation> EnvironmentsAuth::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetOperation(context, options, request);
}

Status EnvironmentsAuth::DeleteOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::DeleteOperationRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteOperation(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
EnvironmentsAuth::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncGetOperation(cq, *std::move(context),
                                        std::move(options), request);
      });
}

future<Status> EnvironmentsAuth::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) return make_ready_future(std::move(context).status());
        return child->AsyncCancelOperation(cq, *std::move(context),
                                           std::move(options), request);
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace composer_v1_internal
}  // namespace cloud
}  // namespace google
