// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/commerce/consumer/procurement/v1/procurement_service.proto

#include "google/cloud/commerce/consumer/procurement/v1/internal/consumer_procurement_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace commerce_consumer_procurement_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

ConsumerProcurementServiceTracingStub::ConsumerProcurementServiceTracingStub(
    std::shared_ptr<ConsumerProcurementServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

future<StatusOr<google::longrunning::Operation>>
ConsumerProcurementServiceTracingStub::AsyncPlaceOrder(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::commerce::consumer::procurement::v1::PlaceOrderRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.commerce.consumer.procurement.v1."
      "ConsumerProcurementService",
      "PlaceOrder");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncPlaceOrder(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ConsumerProcurementServiceTracingStub::PlaceOrder(
    grpc::ClientContext& context, Options options,
    google::cloud::commerce::consumer::procurement::v1::PlaceOrderRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.commerce.consumer.procurement.v1."
      "ConsumerProcurementService",
      "PlaceOrder");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->PlaceOrder(context, options, request));
}

StatusOr<google::cloud::commerce::consumer::procurement::v1::Order>
ConsumerProcurementServiceTracingStub::GetOrder(
    grpc::ClientContext& context, Options const& options,
    google::cloud::commerce::consumer::procurement::v1::GetOrderRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.commerce.consumer.procurement.v1."
      "ConsumerProcurementService",
      "GetOrder");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetOrder(context, options, request));
}

StatusOr<google::cloud::commerce::consumer::procurement::v1::ListOrdersResponse>
ConsumerProcurementServiceTracingStub::ListOrders(
    grpc::ClientContext& context, Options const& options,
    google::cloud::commerce::consumer::procurement::v1::ListOrdersRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.commerce.consumer.procurement.v1."
      "ConsumerProcurementService",
      "ListOrders");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListOrders(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ConsumerProcurementServiceTracingStub::AsyncModifyOrder(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::commerce::consumer::procurement::v1::
        ModifyOrderRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.commerce.consumer.procurement.v1."
      "ConsumerProcurementService",
      "ModifyOrder");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncModifyOrder(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ConsumerProcurementServiceTracingStub::ModifyOrder(
    grpc::ClientContext& context, Options options,
    google::cloud::commerce::consumer::procurement::v1::
        ModifyOrderRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.commerce.consumer.procurement.v1."
      "ConsumerProcurementService",
      "ModifyOrder");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ModifyOrder(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ConsumerProcurementServiceTracingStub::AsyncCancelOrder(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::commerce::consumer::procurement::v1::
        CancelOrderRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.commerce.consumer.procurement.v1."
      "ConsumerProcurementService",
      "CancelOrder");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCancelOrder(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ConsumerProcurementServiceTracingStub::CancelOrder(
    grpc::ClientContext& context, Options options,
    google::cloud::commerce::consumer::procurement::v1::
        CancelOrderRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.commerce.consumer.procurement.v1."
      "ConsumerProcurementService",
      "CancelOrder");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CancelOrder(context, options, request));
}

StatusOr<google::longrunning::Operation>
ConsumerProcurementServiceTracingStub::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.commerce.consumer.procurement.v1."
      "ConsumerProcurementService",
      "GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetOperation(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ConsumerProcurementServiceTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> ConsumerProcurementServiceTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCancelOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<ConsumerProcurementServiceStub>
MakeConsumerProcurementServiceTracingStub(
    std::shared_ptr<ConsumerProcurementServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<ConsumerProcurementServiceTracingStub>(
      std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace commerce_consumer_procurement_v1_internal
}  // namespace cloud
}  // namespace google
