// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/commerce/consumer/procurement/v1/procurement_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMMERCE_CONSUMER_PROCUREMENT_V1_INTERNAL_CONSUMER_PROCUREMENT_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMMERCE_CONSUMER_PROCUREMENT_V1_INTERNAL_CONSUMER_PROCUREMENT_TRACING_CONNECTION_H

#include "google/cloud/commerce/consumer/procurement/v1/consumer_procurement_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace commerce_consumer_procurement_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class ConsumerProcurementServiceTracingConnection
    : public commerce_consumer_procurement_v1::
          ConsumerProcurementServiceConnection {
 public:
  ~ConsumerProcurementServiceTracingConnection() override = default;

  explicit ConsumerProcurementServiceTracingConnection(
      std::shared_ptr<commerce_consumer_procurement_v1::
                          ConsumerProcurementServiceConnection>
          child);

  Options options() override { return child_->options(); }

  future<StatusOr<google::cloud::commerce::consumer::procurement::v1::Order>>
  PlaceOrder(google::cloud::commerce::consumer::procurement::v1::
                 PlaceOrderRequest const& request) override;

  StatusOr<google::longrunning::Operation> PlaceOrder(
      NoAwaitTag, google::cloud::commerce::consumer::procurement::v1::
                      PlaceOrderRequest const& request) override;

  future<StatusOr<google::cloud::commerce::consumer::procurement::v1::Order>>
  PlaceOrder(google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::commerce::consumer::procurement::v1::Order> GetOrder(
      google::cloud::commerce::consumer::procurement::v1::GetOrderRequest const&
          request) override;

  StreamRange<google::cloud::commerce::consumer::procurement::v1::Order>
  ListOrders(
      google::cloud::commerce::consumer::procurement::v1::ListOrdersRequest
          request) override;

  future<StatusOr<google::cloud::commerce::consumer::procurement::v1::Order>>
  ModifyOrder(google::cloud::commerce::consumer::procurement::v1::
                  ModifyOrderRequest const& request) override;

  StatusOr<google::longrunning::Operation> ModifyOrder(
      NoAwaitTag, google::cloud::commerce::consumer::procurement::v1::
                      ModifyOrderRequest const& request) override;

  future<StatusOr<google::cloud::commerce::consumer::procurement::v1::Order>>
  ModifyOrder(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::commerce::consumer::procurement::v1::Order>>
  CancelOrder(google::cloud::commerce::consumer::procurement::v1::
                  CancelOrderRequest const& request) override;

  StatusOr<google::longrunning::Operation> CancelOrder(
      NoAwaitTag, google::cloud::commerce::consumer::procurement::v1::
                      CancelOrderRequest const& request) override;

  future<StatusOr<google::cloud::commerce::consumer::procurement::v1::Order>>
  CancelOrder(google::longrunning::Operation const& operation) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request) override;

 private:
  std::shared_ptr<
      commerce_consumer_procurement_v1::ConsumerProcurementServiceConnection>
      child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<
    commerce_consumer_procurement_v1::ConsumerProcurementServiceConnection>
MakeConsumerProcurementServiceTracingConnection(
    std::shared_ptr<
        commerce_consumer_procurement_v1::ConsumerProcurementServiceConnection>
        conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace commerce_consumer_procurement_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMMERCE_CONSUMER_PROCUREMENT_V1_INTERNAL_CONSUMER_PROCUREMENT_TRACING_CONNECTION_H
