// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/cloudcontrolspartner/v1/monitoring.proto

#include "google/cloud/cloudcontrolspartner/v1/cloud_controls_partner_monitoring_connection.h"
#include "google/cloud/cloudcontrolspartner/v1/cloud_controls_partner_monitoring_options.h"
#include "google/cloud/cloudcontrolspartner/v1/internal/cloud_controls_partner_monitoring_connection_impl.h"
#include "google/cloud/cloudcontrolspartner/v1/internal/cloud_controls_partner_monitoring_option_defaults.h"
#include "google/cloud/cloudcontrolspartner/v1/internal/cloud_controls_partner_monitoring_stub_factory.h"
#include "google/cloud/cloudcontrolspartner/v1/internal/cloud_controls_partner_monitoring_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace cloudcontrolspartner_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudControlsPartnerMonitoringConnection::
    ~CloudControlsPartnerMonitoringConnection() = default;

StreamRange<google::cloud::cloudcontrolspartner::v1::Violation>
CloudControlsPartnerMonitoringConnection::ListViolations(
    google::cloud::cloudcontrolspartner::v1::
        ListViolationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::cloudcontrolspartner::v1::Violation>>();
}

StatusOr<google::cloud::cloudcontrolspartner::v1::Violation>
CloudControlsPartnerMonitoringConnection::GetViolation(
    google::cloud::cloudcontrolspartner::v1::GetViolationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<CloudControlsPartnerMonitoringConnection>
MakeCloudControlsPartnerMonitoringConnection(Options options) {
  internal::CheckExpectedOptions<
      CommonOptionList, GrpcOptionList, UnifiedCredentialsOptionList,
      CloudControlsPartnerMonitoringPolicyOptionList>(options, __func__);
  options = cloudcontrolspartner_v1_internal::
      CloudControlsPartnerMonitoringDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = cloudcontrolspartner_v1_internal::
      CreateDefaultCloudControlsPartnerMonitoringStub(std::move(auth), options);
  return cloudcontrolspartner_v1_internal::
      MakeCloudControlsPartnerMonitoringTracingConnection(
          std::make_shared<cloudcontrolspartner_v1_internal::
                               CloudControlsPartnerMonitoringConnectionImpl>(
              std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudcontrolspartner_v1
}  // namespace cloud
}  // namespace google
