// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/cloudcontrolspartner/v1/monitoring.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDCONTROLSPARTNER_V1_CLOUD_CONTROLS_PARTNER_MONITORING_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDCONTROLSPARTNER_V1_CLOUD_CONTROLS_PARTNER_MONITORING_CLIENT_H

#include "google/cloud/cloudcontrolspartner/v1/cloud_controls_partner_monitoring_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace cloudcontrolspartner_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Service describing handlers for resources
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class CloudControlsPartnerMonitoringClient {
 public:
  explicit CloudControlsPartnerMonitoringClient(
      std::shared_ptr<CloudControlsPartnerMonitoringConnection> connection,
      Options opts = {});
  ~CloudControlsPartnerMonitoringClient();

  ///@{
  /// @name Copy and move support
  CloudControlsPartnerMonitoringClient(
      CloudControlsPartnerMonitoringClient const&) = default;
  CloudControlsPartnerMonitoringClient& operator=(
      CloudControlsPartnerMonitoringClient const&) = default;
  CloudControlsPartnerMonitoringClient(CloudControlsPartnerMonitoringClient&&) =
      default;
  CloudControlsPartnerMonitoringClient& operator=(
      CloudControlsPartnerMonitoringClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(CloudControlsPartnerMonitoringClient const& a,
                         CloudControlsPartnerMonitoringClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(CloudControlsPartnerMonitoringClient const& a,
                         CloudControlsPartnerMonitoringClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists Violations for a workload
  /// Callers may also choose to read across multiple Customers or for a single
  /// customer as per
  /// [AIP-159](https://google.aip.dev/159) by using '-' (the hyphen or dash
  /// character) as a wildcard character instead of {customer} & {workload}.
  /// Format:
  /// `organizations/{organization}/locations/{location}/customers/{customer}/workloads/{workload}`
  ///
  /// @param parent  Required. Parent resource
  ///  Format
  ///  `organizations/{organization}/locations/{location}/customers/{customer}/workloads/{workload}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.cloudcontrolspartner.v1.Violation], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cloudcontrolspartner.v1.ListViolationsRequest]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/violations.proto#L178}
  /// [google.cloud.cloudcontrolspartner.v1.Violation]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/violations.proto#L33}
  ///
  // clang-format on
  StreamRange<google::cloud::cloudcontrolspartner::v1::Violation>
  ListViolations(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists Violations for a workload
  /// Callers may also choose to read across multiple Customers or for a single
  /// customer as per
  /// [AIP-159](https://google.aip.dev/159) by using '-' (the hyphen or dash
  /// character) as a wildcard character instead of {customer} & {workload}.
  /// Format:
  /// `organizations/{organization}/locations/{location}/customers/{customer}/workloads/{workload}`
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.cloudcontrolspartner.v1.ListViolationsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.cloudcontrolspartner.v1.Violation], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cloudcontrolspartner.v1.ListViolationsRequest]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/violations.proto#L178}
  /// [google.cloud.cloudcontrolspartner.v1.Violation]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/violations.proto#L33}
  ///
  // clang-format on
  StreamRange<google::cloud::cloudcontrolspartner::v1::Violation>
  ListViolations(
      google::cloud::cloudcontrolspartner::v1::ListViolationsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Violation.
  ///
  /// @param name  Required. Format:
  ///  `organizations/{organization}/locations/{location}/customers/{customer}/workloads/{workload}/violations/{violation}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.cloudcontrolspartner.v1.Violation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cloudcontrolspartner.v1.GetViolationRequest]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/violations.proto#L224}
  /// [google.cloud.cloudcontrolspartner.v1.Violation]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/violations.proto#L33}
  ///
  // clang-format on
  StatusOr<google::cloud::cloudcontrolspartner::v1::Violation> GetViolation(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Violation.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.cloudcontrolspartner.v1.GetViolationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.cloudcontrolspartner.v1.Violation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cloudcontrolspartner.v1.GetViolationRequest]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/violations.proto#L224}
  /// [google.cloud.cloudcontrolspartner.v1.Violation]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/violations.proto#L33}
  ///
  // clang-format on
  StatusOr<google::cloud::cloudcontrolspartner::v1::Violation> GetViolation(
      google::cloud::cloudcontrolspartner::v1::GetViolationRequest const&
          request,
      Options opts = {});

 private:
  std::shared_ptr<CloudControlsPartnerMonitoringConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudcontrolspartner_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDCONTROLSPARTNER_V1_CLOUD_CONTROLS_PARTNER_MONITORING_CLIENT_H
