// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/cloudbuild/v2/repositories.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDBUILD_V2_REPOSITORY_MANAGER_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDBUILD_V2_REPOSITORY_MANAGER_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/devtools/cloudbuild/v2/repositories.grpc.pb.h>
#include <google/iam/v1/iam_policy.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace cloudbuild_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class RepositoryManagerConnectionIdempotencyPolicy {
 public:
  virtual ~RepositoryManagerConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<RepositoryManagerConnectionIdempotencyPolicy> clone()
      const;

  virtual google::cloud::Idempotency CreateConnection(
      google::devtools::cloudbuild::v2::CreateConnectionRequest const& request);

  virtual google::cloud::Idempotency GetConnection(
      google::devtools::cloudbuild::v2::GetConnectionRequest const& request);

  virtual google::cloud::Idempotency ListConnections(
      google::devtools::cloudbuild::v2::ListConnectionsRequest request);

  virtual google::cloud::Idempotency UpdateConnection(
      google::devtools::cloudbuild::v2::UpdateConnectionRequest const& request);

  virtual google::cloud::Idempotency DeleteConnection(
      google::devtools::cloudbuild::v2::DeleteConnectionRequest const& request);

  virtual google::cloud::Idempotency CreateRepository(
      google::devtools::cloudbuild::v2::CreateRepositoryRequest const& request);

  virtual google::cloud::Idempotency BatchCreateRepositories(
      google::devtools::cloudbuild::v2::BatchCreateRepositoriesRequest const&
          request);

  virtual google::cloud::Idempotency GetRepository(
      google::devtools::cloudbuild::v2::GetRepositoryRequest const& request);

  virtual google::cloud::Idempotency ListRepositories(
      google::devtools::cloudbuild::v2::ListRepositoriesRequest request);

  virtual google::cloud::Idempotency DeleteRepository(
      google::devtools::cloudbuild::v2::DeleteRepositoryRequest const& request);

  virtual google::cloud::Idempotency FetchReadWriteToken(
      google::devtools::cloudbuild::v2::FetchReadWriteTokenRequest const&
          request);

  virtual google::cloud::Idempotency FetchReadToken(
      google::devtools::cloudbuild::v2::FetchReadTokenRequest const& request);

  virtual google::cloud::Idempotency FetchLinkableRepositories(
      google::devtools::cloudbuild::v2::FetchLinkableRepositoriesRequest
          request);

  virtual google::cloud::Idempotency FetchGitRefs(
      google::devtools::cloudbuild::v2::FetchGitRefsRequest const& request);

  virtual google::cloud::Idempotency SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request);

  virtual google::cloud::Idempotency GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request);

  virtual google::cloud::Idempotency TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request);

  virtual google::cloud::Idempotency GetOperation(
      google::longrunning::GetOperationRequest const& request);

  virtual google::cloud::Idempotency CancelOperation(
      google::longrunning::CancelOperationRequest const& request);
};

std::unique_ptr<RepositoryManagerConnectionIdempotencyPolicy>
MakeDefaultRepositoryManagerConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudbuild_v2
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDBUILD_V2_REPOSITORY_MANAGER_CONNECTION_IDEMPOTENCY_POLICY_H
