// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/v2/model.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERYCONTROL_V2_MODEL_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERYCONTROL_V2_MODEL_CLIENT_H

#include "google/cloud/bigquerycontrol/v2/model_rest_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace bigquerycontrol_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Model Service for BigQuery ML
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class ModelServiceClient {
 public:
  explicit ModelServiceClient(
      std::shared_ptr<ModelServiceConnection> connection, Options opts = {});
  ~ModelServiceClient();

  ///@{
  /// @name Copy and move support
  ModelServiceClient(ModelServiceClient const&) = default;
  ModelServiceClient& operator=(ModelServiceClient const&) = default;
  ModelServiceClient(ModelServiceClient&&) = default;
  ModelServiceClient& operator=(ModelServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(ModelServiceClient const& a,
                         ModelServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(ModelServiceClient const& a,
                         ModelServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Gets the specified model resource by model ID.
  ///
  /// @param project_id  Required. Project ID of the requested model.
  /// @param dataset_id  Required. Dataset ID of the requested model.
  /// @param model_id  Required. Model ID of the requested model.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.v2.Model])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.v2.GetModelRequest]: @googleapis_reference_link{google/cloud/bigquery/v2/model.proto#L1993}
  /// [google.cloud.bigquery.v2.Model]: @googleapis_reference_link{google/cloud/bigquery/v2/model.proto#L149}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::v2::Model> GetModel(
      std::string const& project_id, std::string const& dataset_id,
      std::string const& model_id, Options opts = {});

  // clang-format off
  ///
  /// Gets the specified model resource by model ID.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.bigquery.v2.GetModelRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.v2.Model])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.v2.GetModelRequest]: @googleapis_reference_link{google/cloud/bigquery/v2/model.proto#L1993}
  /// [google.cloud.bigquery.v2.Model]: @googleapis_reference_link{google/cloud/bigquery/v2/model.proto#L149}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::v2::Model> GetModel(
      google::cloud::bigquery::v2::GetModelRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists all models in the specified dataset. Requires the READER dataset
  /// role. After retrieving the list of models, you can get information about a
  /// particular model by calling the models.get method.
  ///
  /// @param project_id  Required. Project ID of the models to list.
  /// @param dataset_id  Required. Dataset ID of the models to list.
  /// @param max_results  The maximum number of results to return in a single response page.
  ///  Leverage the page tokens to iterate through the entire collection.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.bigquery.v2.Model], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.v2.ListModelsRequest]: @googleapis_reference_link{google/cloud/bigquery/v2/model.proto#L2033}
  /// [google.cloud.bigquery.v2.Model]: @googleapis_reference_link{google/cloud/bigquery/v2/model.proto#L149}
  ///
  // clang-format on
  StreamRange<google::cloud::bigquery::v2::Model> ListModels(
      std::string const& project_id, std::string const& dataset_id,
      google::protobuf::UInt32Value const& max_results, Options opts = {});

  // clang-format off
  ///
  /// Lists all models in the specified dataset. Requires the READER dataset
  /// role. After retrieving the list of models, you can get information about a
  /// particular model by calling the models.get method.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.bigquery.v2.ListModelsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.bigquery.v2.Model], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.v2.ListModelsRequest]: @googleapis_reference_link{google/cloud/bigquery/v2/model.proto#L2033}
  /// [google.cloud.bigquery.v2.Model]: @googleapis_reference_link{google/cloud/bigquery/v2/model.proto#L149}
  ///
  // clang-format on
  StreamRange<google::cloud::bigquery::v2::Model> ListModels(
      google::cloud::bigquery::v2::ListModelsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Patch specific fields in the specified model.
  ///
  /// @param project_id  Required. Project ID of the model to patch.
  /// @param dataset_id  Required. Dataset ID of the model to patch.
  /// @param model_id  Required. Model ID of the model to patch.
  /// @param model  Required. Patched model.
  ///  Follows RFC5789 patch semantics. Missing fields are not updated.
  ///  To clear a field, explicitly set to default value.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.v2.Model])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.v2.Model]: @googleapis_reference_link{google/cloud/bigquery/v2/model.proto#L149}
  /// [google.cloud.bigquery.v2.PatchModelRequest]: @googleapis_reference_link{google/cloud/bigquery/v2/model.proto#L2004}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::v2::Model> PatchModel(
      std::string const& project_id, std::string const& dataset_id,
      std::string const& model_id,
      google::cloud::bigquery::v2::Model const& model, Options opts = {});

  // clang-format off
  ///
  /// Patch specific fields in the specified model.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.bigquery.v2.PatchModelRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.v2.Model])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.v2.Model]: @googleapis_reference_link{google/cloud/bigquery/v2/model.proto#L149}
  /// [google.cloud.bigquery.v2.PatchModelRequest]: @googleapis_reference_link{google/cloud/bigquery/v2/model.proto#L2004}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::v2::Model> PatchModel(
      google::cloud::bigquery::v2::PatchModelRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes the model specified by modelId from the dataset.
  ///
  /// @param project_id  Required. Project ID of the model to delete.
  /// @param dataset_id  Required. Dataset ID of the model to delete.
  /// @param model_id  Required. Model ID of the model to delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.v2.DeleteModelRequest]: @googleapis_reference_link{google/cloud/bigquery/v2/model.proto#L2021}
  ///
  // clang-format on
  Status DeleteModel(std::string const& project_id,
                     std::string const& dataset_id, std::string const& model_id,
                     Options opts = {});

  // clang-format off
  ///
  /// Deletes the model specified by modelId from the dataset.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.bigquery.v2.DeleteModelRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.v2.DeleteModelRequest]: @googleapis_reference_link{google/cloud/bigquery/v2/model.proto#L2021}
  ///
  // clang-format on
  Status DeleteModel(
      google::cloud::bigquery::v2::DeleteModelRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<ModelServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquerycontrol_v2
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERYCONTROL_V2_MODEL_CLIENT_H
