// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/v2/table.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERYCONTROL_V2_INTERNAL_TABLE_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERYCONTROL_V2_INTERNAL_TABLE_TRACING_CONNECTION_H

#include "google/cloud/bigquerycontrol/v2/table_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace bigquerycontrol_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class TableServiceTracingConnection
    : public bigquerycontrol_v2::TableServiceConnection {
 public:
  ~TableServiceTracingConnection() override = default;

  explicit TableServiceTracingConnection(
      std::shared_ptr<bigquerycontrol_v2::TableServiceConnection> child);

  Options options() override { return child_->options(); }

  StatusOr<google::cloud::bigquery::v2::Table> GetTable(
      google::cloud::bigquery::v2::GetTableRequest const& request) override;

  StatusOr<google::cloud::bigquery::v2::Table> InsertTable(
      google::cloud::bigquery::v2::InsertTableRequest const& request) override;

  StatusOr<google::cloud::bigquery::v2::Table> PatchTable(
      google::cloud::bigquery::v2::UpdateOrPatchTableRequest const& request)
      override;

  StatusOr<google::cloud::bigquery::v2::Table> UpdateTable(
      google::cloud::bigquery::v2::UpdateOrPatchTableRequest const& request)
      override;

  Status DeleteTable(
      google::cloud::bigquery::v2::DeleteTableRequest const& request) override;

  StreamRange<google::cloud::bigquery::v2::ListFormatTable> ListTables(
      google::cloud::bigquery::v2::ListTablesRequest request) override;

 private:
  std::shared_ptr<bigquerycontrol_v2::TableServiceConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<bigquerycontrol_v2::TableServiceConnection>
MakeTableServiceTracingConnection(
    std::shared_ptr<bigquerycontrol_v2::TableServiceConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquerycontrol_v2_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERYCONTROL_V2_INTERNAL_TABLE_TRACING_CONNECTION_H
