// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/migration/v2/migration_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_MIGRATION_V2_MIGRATION_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_MIGRATION_V2_MIGRATION_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/bigquery/migration/v2/migration_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace bigquery_migration_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class MigrationServiceConnectionIdempotencyPolicy {
 public:
  virtual ~MigrationServiceConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<MigrationServiceConnectionIdempotencyPolicy> clone()
      const;

  virtual google::cloud::Idempotency CreateMigrationWorkflow(
      google::cloud::bigquery::migration::v2::
          CreateMigrationWorkflowRequest const& request);

  virtual google::cloud::Idempotency GetMigrationWorkflow(
      google::cloud::bigquery::migration::v2::GetMigrationWorkflowRequest const&
          request);

  virtual google::cloud::Idempotency ListMigrationWorkflows(
      google::cloud::bigquery::migration::v2::ListMigrationWorkflowsRequest
          request);

  virtual google::cloud::Idempotency DeleteMigrationWorkflow(
      google::cloud::bigquery::migration::v2::
          DeleteMigrationWorkflowRequest const& request);

  virtual google::cloud::Idempotency StartMigrationWorkflow(
      google::cloud::bigquery::migration::v2::
          StartMigrationWorkflowRequest const& request);

  virtual google::cloud::Idempotency GetMigrationSubtask(
      google::cloud::bigquery::migration::v2::GetMigrationSubtaskRequest const&
          request);

  virtual google::cloud::Idempotency ListMigrationSubtasks(
      google::cloud::bigquery::migration::v2::ListMigrationSubtasksRequest
          request);
};

std::unique_ptr<MigrationServiceConnectionIdempotencyPolicy>
MakeDefaultMigrationServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_migration_v2
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_MIGRATION_V2_MIGRATION_CONNECTION_IDEMPOTENCY_POLICY_H
