// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/beyondcorp/appconnectors/v1/app_connectors_service.proto

#include "google/cloud/beyondcorp/appconnectors/v1/app_connectors_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace beyondcorp_appconnectors_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

AppConnectorsServiceConnectionIdempotencyPolicy::
    ~AppConnectorsServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<AppConnectorsServiceConnectionIdempotencyPolicy>
AppConnectorsServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<AppConnectorsServiceConnectionIdempotencyPolicy>(
      *this);
}

Idempotency AppConnectorsServiceConnectionIdempotencyPolicy::ListAppConnectors(
    google::cloud::beyondcorp::appconnectors::v1::
        ListAppConnectorsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency AppConnectorsServiceConnectionIdempotencyPolicy::GetAppConnector(
    google::cloud::beyondcorp::appconnectors::v1::
        GetAppConnectorRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency AppConnectorsServiceConnectionIdempotencyPolicy::CreateAppConnector(
    google::cloud::beyondcorp::appconnectors::v1::
        CreateAppConnectorRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AppConnectorsServiceConnectionIdempotencyPolicy::UpdateAppConnector(
    google::cloud::beyondcorp::appconnectors::v1::
        UpdateAppConnectorRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AppConnectorsServiceConnectionIdempotencyPolicy::DeleteAppConnector(
    google::cloud::beyondcorp::appconnectors::v1::
        DeleteAppConnectorRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AppConnectorsServiceConnectionIdempotencyPolicy::ReportStatus(
    google::cloud::beyondcorp::appconnectors::v1::ReportStatusRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AppConnectorsServiceConnectionIdempotencyPolicy::ListLocations(
    google::cloud::location::ListLocationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency AppConnectorsServiceConnectionIdempotencyPolicy::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency AppConnectorsServiceConnectionIdempotencyPolicy::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return request.policy().etag().empty() ? Idempotency::kNonIdempotent
                                         : Idempotency::kIdempotent;
}

Idempotency AppConnectorsServiceConnectionIdempotencyPolicy::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency AppConnectorsServiceConnectionIdempotencyPolicy::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency AppConnectorsServiceConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency AppConnectorsServiceConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency AppConnectorsServiceConnectionIdempotencyPolicy::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AppConnectorsServiceConnectionIdempotencyPolicy::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<AppConnectorsServiceConnectionIdempotencyPolicy>
MakeDefaultAppConnectorsServiceConnectionIdempotencyPolicy() {
  return std::make_unique<AppConnectorsServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace beyondcorp_appconnectors_v1
}  // namespace cloud
}  // namespace google
