// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/beyondcorp/appconnections/v1/app_connections_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BEYONDCORP_APPCONNECTIONS_V1_INTERNAL_APP_CONNECTIONS_TRACING_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BEYONDCORP_APPCONNECTIONS_V1_INTERNAL_APP_CONNECTIONS_TRACING_STUB_H

#include "google/cloud/beyondcorp/appconnections/v1/internal/app_connections_stub.h"
#include "google/cloud/internal/trace_propagator.h"
#include "google/cloud/options.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace beyondcorp_appconnections_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class AppConnectionsServiceTracingStub : public AppConnectionsServiceStub {
 public:
  ~AppConnectionsServiceTracingStub() override = default;

  explicit AppConnectionsServiceTracingStub(
      std::shared_ptr<AppConnectionsServiceStub> child);

  StatusOr<
      google::cloud::beyondcorp::appconnections::v1::ListAppConnectionsResponse>
  ListAppConnections(grpc::ClientContext& context, Options const& options,
                     google::cloud::beyondcorp::appconnections::v1::
                         ListAppConnectionsRequest const& request) override;

  StatusOr<google::cloud::beyondcorp::appconnections::v1::AppConnection>
  GetAppConnection(grpc::ClientContext& context, Options const& options,
                   google::cloud::beyondcorp::appconnections::v1::
                       GetAppConnectionRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateAppConnection(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::beyondcorp::appconnections::v1::
          CreateAppConnectionRequest const& request) override;

  StatusOr<google::longrunning::Operation> CreateAppConnection(
      grpc::ClientContext& context, Options options,
      google::cloud::beyondcorp::appconnections::v1::
          CreateAppConnectionRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncUpdateAppConnection(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::beyondcorp::appconnections::v1::
          UpdateAppConnectionRequest const& request) override;

  StatusOr<google::longrunning::Operation> UpdateAppConnection(
      grpc::ClientContext& context, Options options,
      google::cloud::beyondcorp::appconnections::v1::
          UpdateAppConnectionRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteAppConnection(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::beyondcorp::appconnections::v1::
          DeleteAppConnectionRequest const& request) override;

  StatusOr<google::longrunning::Operation> DeleteAppConnection(
      grpc::ClientContext& context, Options options,
      google::cloud::beyondcorp::appconnections::v1::
          DeleteAppConnectionRequest const& request) override;

  StatusOr<google::cloud::beyondcorp::appconnections::v1::
               ResolveAppConnectionsResponse>
  ResolveAppConnections(
      grpc::ClientContext& context, Options const& options,
      google::cloud::beyondcorp::appconnections::v1::
          ResolveAppConnectionsRequest const& request) override;

  StatusOr<google::cloud::location::ListLocationsResponse> ListLocations(
      grpc::ClientContext& context, Options const& options,
      google::cloud::location::ListLocationsRequest const& request) override;

  StatusOr<google::cloud::location::Location> GetLocation(
      grpc::ClientContext& context, Options const& options,
      google::cloud::location::GetLocationRequest const& request) override;

  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::SetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::GetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::TestIamPermissionsRequest const& request) override;

  StatusOr<google::longrunning::ListOperationsResponse> ListOperations(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::ListOperationsRequest const& request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::GetOperationRequest const& request) override;

  Status DeleteOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::DeleteOperationRequest const& request) override;

  Status CancelOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::CancelOperationRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::GetOperationRequest const& request) override;

  future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::shared_ptr<AppConnectionsServiceStub> child_;
  std::shared_ptr<opentelemetry::context::propagation::TextMapPropagator>
      propagator_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Applies the tracing decorator to the given stub.
 *
 * The stub is only decorated if the library has been compiled with
 * OpenTelemetry.
 */
std::shared_ptr<AppConnectionsServiceStub> MakeAppConnectionsServiceTracingStub(
    std::shared_ptr<AppConnectionsServiceStub> stub);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace beyondcorp_appconnections_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BEYONDCORP_APPCONNECTIONS_V1_INTERNAL_APP_CONNECTIONS_TRACING_STUB_H
