// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/batch/v1/batch.proto

#include "google/cloud/batch/v1/batch_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace batch_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

BatchServiceConnectionIdempotencyPolicy::
    ~BatchServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<BatchServiceConnectionIdempotencyPolicy>
BatchServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<BatchServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency BatchServiceConnectionIdempotencyPolicy::CreateJob(
    google::cloud::batch::v1::CreateJobRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BatchServiceConnectionIdempotencyPolicy::GetJob(
    google::cloud::batch::v1::GetJobRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency BatchServiceConnectionIdempotencyPolicy::DeleteJob(
    google::cloud::batch::v1::DeleteJobRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BatchServiceConnectionIdempotencyPolicy::ListJobs(
    google::cloud::batch::v1::ListJobsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency BatchServiceConnectionIdempotencyPolicy::GetTask(
    google::cloud::batch::v1::GetTaskRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency BatchServiceConnectionIdempotencyPolicy::ListTasks(
    google::cloud::batch::v1::ListTasksRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency BatchServiceConnectionIdempotencyPolicy::ListLocations(
    google::cloud::location::ListLocationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency BatchServiceConnectionIdempotencyPolicy::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency BatchServiceConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency BatchServiceConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency BatchServiceConnectionIdempotencyPolicy::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BatchServiceConnectionIdempotencyPolicy::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<BatchServiceConnectionIdempotencyPolicy>
MakeDefaultBatchServiceConnectionIdempotencyPolicy() {
  return std::make_unique<BatchServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace batch_v1
}  // namespace cloud
}  // namespace google
