// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/baremetalsolution/v2/baremetalsolution.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BAREMETALSOLUTION_V2_BARE_METAL_SOLUTION_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BAREMETALSOLUTION_V2_BARE_METAL_SOLUTION_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/baremetalsolution/v2/baremetalsolution.grpc.pb.h>
#include <google/cloud/location/locations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace baremetalsolution_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class BareMetalSolutionConnectionIdempotencyPolicy {
 public:
  virtual ~BareMetalSolutionConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<BareMetalSolutionConnectionIdempotencyPolicy> clone()
      const;

  virtual google::cloud::Idempotency ListInstances(
      google::cloud::baremetalsolution::v2::ListInstancesRequest request);

  virtual google::cloud::Idempotency GetInstance(
      google::cloud::baremetalsolution::v2::GetInstanceRequest const& request);

  virtual google::cloud::Idempotency UpdateInstance(
      google::cloud::baremetalsolution::v2::UpdateInstanceRequest const&
          request);

  virtual google::cloud::Idempotency RenameInstance(
      google::cloud::baremetalsolution::v2::RenameInstanceRequest const&
          request);

  virtual google::cloud::Idempotency ResetInstance(
      google::cloud::baremetalsolution::v2::ResetInstanceRequest const&
          request);

  virtual google::cloud::Idempotency StartInstance(
      google::cloud::baremetalsolution::v2::StartInstanceRequest const&
          request);

  virtual google::cloud::Idempotency StopInstance(
      google::cloud::baremetalsolution::v2::StopInstanceRequest const& request);

  virtual google::cloud::Idempotency EnableInteractiveSerialConsole(
      google::cloud::baremetalsolution::v2::
          EnableInteractiveSerialConsoleRequest const& request);

  virtual google::cloud::Idempotency DisableInteractiveSerialConsole(
      google::cloud::baremetalsolution::v2::
          DisableInteractiveSerialConsoleRequest const& request);

  virtual google::cloud::Idempotency DetachLun(
      google::cloud::baremetalsolution::v2::DetachLunRequest const& request);

  virtual google::cloud::Idempotency ListSSHKeys(
      google::cloud::baremetalsolution::v2::ListSSHKeysRequest request);

  virtual google::cloud::Idempotency CreateSSHKey(
      google::cloud::baremetalsolution::v2::CreateSSHKeyRequest const& request);

  virtual google::cloud::Idempotency DeleteSSHKey(
      google::cloud::baremetalsolution::v2::DeleteSSHKeyRequest const& request);

  virtual google::cloud::Idempotency ListVolumes(
      google::cloud::baremetalsolution::v2::ListVolumesRequest request);

  virtual google::cloud::Idempotency GetVolume(
      google::cloud::baremetalsolution::v2::GetVolumeRequest const& request);

  virtual google::cloud::Idempotency UpdateVolume(
      google::cloud::baremetalsolution::v2::UpdateVolumeRequest const& request);

  virtual google::cloud::Idempotency RenameVolume(
      google::cloud::baremetalsolution::v2::RenameVolumeRequest const& request);

  virtual google::cloud::Idempotency EvictVolume(
      google::cloud::baremetalsolution::v2::EvictVolumeRequest const& request);

  virtual google::cloud::Idempotency ResizeVolume(
      google::cloud::baremetalsolution::v2::ResizeVolumeRequest const& request);

  virtual google::cloud::Idempotency ListNetworks(
      google::cloud::baremetalsolution::v2::ListNetworksRequest request);

  virtual google::cloud::Idempotency ListNetworkUsage(
      google::cloud::baremetalsolution::v2::ListNetworkUsageRequest const&
          request);

  virtual google::cloud::Idempotency GetNetwork(
      google::cloud::baremetalsolution::v2::GetNetworkRequest const& request);

  virtual google::cloud::Idempotency UpdateNetwork(
      google::cloud::baremetalsolution::v2::UpdateNetworkRequest const&
          request);

  virtual google::cloud::Idempotency CreateVolumeSnapshot(
      google::cloud::baremetalsolution::v2::CreateVolumeSnapshotRequest const&
          request);

  virtual google::cloud::Idempotency RestoreVolumeSnapshot(
      google::cloud::baremetalsolution::v2::RestoreVolumeSnapshotRequest const&
          request);

  virtual google::cloud::Idempotency DeleteVolumeSnapshot(
      google::cloud::baremetalsolution::v2::DeleteVolumeSnapshotRequest const&
          request);

  virtual google::cloud::Idempotency GetVolumeSnapshot(
      google::cloud::baremetalsolution::v2::GetVolumeSnapshotRequest const&
          request);

  virtual google::cloud::Idempotency ListVolumeSnapshots(
      google::cloud::baremetalsolution::v2::ListVolumeSnapshotsRequest request);

  virtual google::cloud::Idempotency GetLun(
      google::cloud::baremetalsolution::v2::GetLunRequest const& request);

  virtual google::cloud::Idempotency ListLuns(
      google::cloud::baremetalsolution::v2::ListLunsRequest request);

  virtual google::cloud::Idempotency EvictLun(
      google::cloud::baremetalsolution::v2::EvictLunRequest const& request);

  virtual google::cloud::Idempotency GetNfsShare(
      google::cloud::baremetalsolution::v2::GetNfsShareRequest const& request);

  virtual google::cloud::Idempotency ListNfsShares(
      google::cloud::baremetalsolution::v2::ListNfsSharesRequest request);

  virtual google::cloud::Idempotency UpdateNfsShare(
      google::cloud::baremetalsolution::v2::UpdateNfsShareRequest const&
          request);

  virtual google::cloud::Idempotency CreateNfsShare(
      google::cloud::baremetalsolution::v2::CreateNfsShareRequest const&
          request);

  virtual google::cloud::Idempotency RenameNfsShare(
      google::cloud::baremetalsolution::v2::RenameNfsShareRequest const&
          request);

  virtual google::cloud::Idempotency DeleteNfsShare(
      google::cloud::baremetalsolution::v2::DeleteNfsShareRequest const&
          request);

  virtual google::cloud::Idempotency ListProvisioningQuotas(
      google::cloud::baremetalsolution::v2::ListProvisioningQuotasRequest
          request);

  virtual google::cloud::Idempotency SubmitProvisioningConfig(
      google::cloud::baremetalsolution::v2::
          SubmitProvisioningConfigRequest const& request);

  virtual google::cloud::Idempotency GetProvisioningConfig(
      google::cloud::baremetalsolution::v2::GetProvisioningConfigRequest const&
          request);

  virtual google::cloud::Idempotency CreateProvisioningConfig(
      google::cloud::baremetalsolution::v2::
          CreateProvisioningConfigRequest const& request);

  virtual google::cloud::Idempotency UpdateProvisioningConfig(
      google::cloud::baremetalsolution::v2::
          UpdateProvisioningConfigRequest const& request);

  virtual google::cloud::Idempotency RenameNetwork(
      google::cloud::baremetalsolution::v2::RenameNetworkRequest const&
          request);

  virtual google::cloud::Idempotency ListOSImages(
      google::cloud::baremetalsolution::v2::ListOSImagesRequest request);

  virtual google::cloud::Idempotency ListLocations(
      google::cloud::location::ListLocationsRequest request);

  virtual google::cloud::Idempotency GetLocation(
      google::cloud::location::GetLocationRequest const& request);
};

std::unique_ptr<BareMetalSolutionConnectionIdempotencyPolicy>
MakeDefaultBareMetalSolutionConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace baremetalsolution_v2
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BAREMETALSOLUTION_V2_BARE_METAL_SOLUTION_CONNECTION_IDEMPOTENCY_POLICY_H
