// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/baremetalsolution/v2/baremetalsolution.proto

#include "google/cloud/baremetalsolution/v2/bare_metal_solution_connection.h"
#include "google/cloud/baremetalsolution/v2/bare_metal_solution_options.h"
#include "google/cloud/baremetalsolution/v2/internal/bare_metal_solution_connection_impl.h"
#include "google/cloud/baremetalsolution/v2/internal/bare_metal_solution_option_defaults.h"
#include "google/cloud/baremetalsolution/v2/internal/bare_metal_solution_stub_factory.h"
#include "google/cloud/baremetalsolution/v2/internal/bare_metal_solution_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace baremetalsolution_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

BareMetalSolutionConnection::~BareMetalSolutionConnection() = default;

StreamRange<google::cloud::baremetalsolution::v2::Instance>
BareMetalSolutionConnection::ListInstances(
    google::cloud::baremetalsolution::v2::
        ListInstancesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::baremetalsolution::v2::Instance>>();
}

StatusOr<google::cloud::baremetalsolution::v2::Instance>
BareMetalSolutionConnection::GetInstance(
    google::cloud::baremetalsolution::v2::GetInstanceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::baremetalsolution::v2::Instance>>
BareMetalSolutionConnection::UpdateInstance(
    google::cloud::baremetalsolution::v2::UpdateInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
BareMetalSolutionConnection::UpdateInstance(
    NoAwaitTag,
    google::cloud::baremetalsolution::v2::UpdateInstanceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::baremetalsolution::v2::Instance>>
BareMetalSolutionConnection::UpdateInstance(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::baremetalsolution::v2::Instance>
BareMetalSolutionConnection::RenameInstance(
    google::cloud::baremetalsolution::v2::RenameInstanceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::baremetalsolution::v2::ResetInstanceResponse>>
BareMetalSolutionConnection::ResetInstance(
    google::cloud::baremetalsolution::v2::ResetInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::ResetInstanceResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
BareMetalSolutionConnection::ResetInstance(
    NoAwaitTag,
    google::cloud::baremetalsolution::v2::ResetInstanceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::baremetalsolution::v2::ResetInstanceResponse>>
BareMetalSolutionConnection::ResetInstance(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::ResetInstanceResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::baremetalsolution::v2::StartInstanceResponse>>
BareMetalSolutionConnection::StartInstance(
    google::cloud::baremetalsolution::v2::StartInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::StartInstanceResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
BareMetalSolutionConnection::StartInstance(
    NoAwaitTag,
    google::cloud::baremetalsolution::v2::StartInstanceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::baremetalsolution::v2::StartInstanceResponse>>
BareMetalSolutionConnection::StartInstance(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::StartInstanceResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::baremetalsolution::v2::StopInstanceResponse>>
BareMetalSolutionConnection::StopInstance(
    google::cloud::baremetalsolution::v2::StopInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::StopInstanceResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
BareMetalSolutionConnection::StopInstance(
    NoAwaitTag,
    google::cloud::baremetalsolution::v2::StopInstanceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::baremetalsolution::v2::StopInstanceResponse>>
BareMetalSolutionConnection::StopInstance(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::StopInstanceResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::baremetalsolution::v2::
                    EnableInteractiveSerialConsoleResponse>>
BareMetalSolutionConnection::EnableInteractiveSerialConsole(
    google::cloud::baremetalsolution::v2::
        EnableInteractiveSerialConsoleRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::
                   EnableInteractiveSerialConsoleResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
BareMetalSolutionConnection::EnableInteractiveSerialConsole(
    NoAwaitTag, google::cloud::baremetalsolution::v2::
                    EnableInteractiveSerialConsoleRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::baremetalsolution::v2::
                    EnableInteractiveSerialConsoleResponse>>
BareMetalSolutionConnection::EnableInteractiveSerialConsole(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::
                   EnableInteractiveSerialConsoleResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::baremetalsolution::v2::
                    DisableInteractiveSerialConsoleResponse>>
BareMetalSolutionConnection::DisableInteractiveSerialConsole(
    google::cloud::baremetalsolution::v2::
        DisableInteractiveSerialConsoleRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::
                   DisableInteractiveSerialConsoleResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
BareMetalSolutionConnection::DisableInteractiveSerialConsole(
    NoAwaitTag, google::cloud::baremetalsolution::v2::
                    DisableInteractiveSerialConsoleRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::baremetalsolution::v2::
                    DisableInteractiveSerialConsoleResponse>>
BareMetalSolutionConnection::DisableInteractiveSerialConsole(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::
                   DisableInteractiveSerialConsoleResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::baremetalsolution::v2::Instance>>
BareMetalSolutionConnection::DetachLun(
    google::cloud::baremetalsolution::v2::DetachLunRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> BareMetalSolutionConnection::DetachLun(
    NoAwaitTag, google::cloud::baremetalsolution::v2::DetachLunRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::baremetalsolution::v2::Instance>>
BareMetalSolutionConnection::DetachLun(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::baremetalsolution::v2::SSHKey>
BareMetalSolutionConnection::ListSSHKeys(
    google::cloud::baremetalsolution::v2::
        ListSSHKeysRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::baremetalsolution::v2::SSHKey>>();
}

StatusOr<google::cloud::baremetalsolution::v2::SSHKey>
BareMetalSolutionConnection::CreateSSHKey(
    google::cloud::baremetalsolution::v2::CreateSSHKeyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status BareMetalSolutionConnection::DeleteSSHKey(
    google::cloud::baremetalsolution::v2::DeleteSSHKeyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::baremetalsolution::v2::Volume>
BareMetalSolutionConnection::ListVolumes(
    google::cloud::baremetalsolution::v2::
        ListVolumesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::baremetalsolution::v2::Volume>>();
}

StatusOr<google::cloud::baremetalsolution::v2::Volume>
BareMetalSolutionConnection::GetVolume(
    google::cloud::baremetalsolution::v2::GetVolumeRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::baremetalsolution::v2::Volume>>
BareMetalSolutionConnection::UpdateVolume(
    google::cloud::baremetalsolution::v2::UpdateVolumeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::Volume>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
BareMetalSolutionConnection::UpdateVolume(
    NoAwaitTag,
    google::cloud::baremetalsolution::v2::UpdateVolumeRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::baremetalsolution::v2::Volume>>
BareMetalSolutionConnection::UpdateVolume(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::Volume>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::baremetalsolution::v2::Volume>
BareMetalSolutionConnection::RenameVolume(
    google::cloud::baremetalsolution::v2::RenameVolumeRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::baremetalsolution::v2::OperationMetadata>>
BareMetalSolutionConnection::EvictVolume(
    google::cloud::baremetalsolution::v2::EvictVolumeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
BareMetalSolutionConnection::EvictVolume(
    NoAwaitTag,
    google::cloud::baremetalsolution::v2::EvictVolumeRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::baremetalsolution::v2::OperationMetadata>>
BareMetalSolutionConnection::EvictVolume(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::baremetalsolution::v2::Volume>>
BareMetalSolutionConnection::ResizeVolume(
    google::cloud::baremetalsolution::v2::ResizeVolumeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::Volume>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
BareMetalSolutionConnection::ResizeVolume(
    NoAwaitTag,
    google::cloud::baremetalsolution::v2::ResizeVolumeRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::baremetalsolution::v2::Volume>>
BareMetalSolutionConnection::ResizeVolume(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::Volume>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::baremetalsolution::v2::Network>
BareMetalSolutionConnection::ListNetworks(
    google::cloud::baremetalsolution::v2::
        ListNetworksRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::baremetalsolution::v2::Network>>();
}

StatusOr<google::cloud::baremetalsolution::v2::ListNetworkUsageResponse>
BareMetalSolutionConnection::ListNetworkUsage(
    google::cloud::baremetalsolution::v2::ListNetworkUsageRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::baremetalsolution::v2::Network>
BareMetalSolutionConnection::GetNetwork(
    google::cloud::baremetalsolution::v2::GetNetworkRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::baremetalsolution::v2::Network>>
BareMetalSolutionConnection::UpdateNetwork(
    google::cloud::baremetalsolution::v2::UpdateNetworkRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::Network>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
BareMetalSolutionConnection::UpdateNetwork(
    NoAwaitTag,
    google::cloud::baremetalsolution::v2::UpdateNetworkRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::baremetalsolution::v2::Network>>
BareMetalSolutionConnection::UpdateNetwork(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::Network>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::baremetalsolution::v2::VolumeSnapshot>
BareMetalSolutionConnection::CreateVolumeSnapshot(
    google::cloud::baremetalsolution::v2::CreateVolumeSnapshotRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::baremetalsolution::v2::VolumeSnapshot>>
BareMetalSolutionConnection::RestoreVolumeSnapshot(
    google::cloud::baremetalsolution::v2::RestoreVolumeSnapshotRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::VolumeSnapshot>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
BareMetalSolutionConnection::RestoreVolumeSnapshot(
    NoAwaitTag,
    google::cloud::baremetalsolution::v2::RestoreVolumeSnapshotRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::baremetalsolution::v2::VolumeSnapshot>>
BareMetalSolutionConnection::RestoreVolumeSnapshot(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::VolumeSnapshot>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

Status BareMetalSolutionConnection::DeleteVolumeSnapshot(
    google::cloud::baremetalsolution::v2::DeleteVolumeSnapshotRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::baremetalsolution::v2::VolumeSnapshot>
BareMetalSolutionConnection::GetVolumeSnapshot(
    google::cloud::baremetalsolution::v2::GetVolumeSnapshotRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::baremetalsolution::v2::VolumeSnapshot>
BareMetalSolutionConnection::ListVolumeSnapshots(
    google::cloud::baremetalsolution::v2::
        ListVolumeSnapshotsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::baremetalsolution::v2::VolumeSnapshot>>();
}

StatusOr<google::cloud::baremetalsolution::v2::Lun>
BareMetalSolutionConnection::GetLun(
    google::cloud::baremetalsolution::v2::GetLunRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::baremetalsolution::v2::Lun>
BareMetalSolutionConnection::ListLuns(
    google::cloud::baremetalsolution::v2::
        ListLunsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::baremetalsolution::v2::Lun>>();
}

future<StatusOr<google::cloud::baremetalsolution::v2::OperationMetadata>>
BareMetalSolutionConnection::EvictLun(
    google::cloud::baremetalsolution::v2::EvictLunRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> BareMetalSolutionConnection::EvictLun(
    NoAwaitTag, google::cloud::baremetalsolution::v2::EvictLunRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::baremetalsolution::v2::OperationMetadata>>
BareMetalSolutionConnection::EvictLun(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::baremetalsolution::v2::NfsShare>
BareMetalSolutionConnection::GetNfsShare(
    google::cloud::baremetalsolution::v2::GetNfsShareRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::baremetalsolution::v2::NfsShare>
BareMetalSolutionConnection::ListNfsShares(
    google::cloud::baremetalsolution::v2::
        ListNfsSharesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::baremetalsolution::v2::NfsShare>>();
}

future<StatusOr<google::cloud::baremetalsolution::v2::NfsShare>>
BareMetalSolutionConnection::UpdateNfsShare(
    google::cloud::baremetalsolution::v2::UpdateNfsShareRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::NfsShare>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
BareMetalSolutionConnection::UpdateNfsShare(
    NoAwaitTag,
    google::cloud::baremetalsolution::v2::UpdateNfsShareRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::baremetalsolution::v2::NfsShare>>
BareMetalSolutionConnection::UpdateNfsShare(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::NfsShare>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::baremetalsolution::v2::NfsShare>>
BareMetalSolutionConnection::CreateNfsShare(
    google::cloud::baremetalsolution::v2::CreateNfsShareRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::NfsShare>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
BareMetalSolutionConnection::CreateNfsShare(
    NoAwaitTag,
    google::cloud::baremetalsolution::v2::CreateNfsShareRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::baremetalsolution::v2::NfsShare>>
BareMetalSolutionConnection::CreateNfsShare(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::NfsShare>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::baremetalsolution::v2::NfsShare>
BareMetalSolutionConnection::RenameNfsShare(
    google::cloud::baremetalsolution::v2::RenameNfsShareRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::baremetalsolution::v2::OperationMetadata>>
BareMetalSolutionConnection::DeleteNfsShare(
    google::cloud::baremetalsolution::v2::DeleteNfsShareRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
BareMetalSolutionConnection::DeleteNfsShare(
    NoAwaitTag,
    google::cloud::baremetalsolution::v2::DeleteNfsShareRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::baremetalsolution::v2::OperationMetadata>>
BareMetalSolutionConnection::DeleteNfsShare(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::baremetalsolution::v2::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::baremetalsolution::v2::ProvisioningQuota>
BareMetalSolutionConnection::ListProvisioningQuotas(
    google::cloud::baremetalsolution::v2::
        ListProvisioningQuotasRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::baremetalsolution::v2::ProvisioningQuota>>();
}

StatusOr<google::cloud::baremetalsolution::v2::SubmitProvisioningConfigResponse>
BareMetalSolutionConnection::SubmitProvisioningConfig(
    google::cloud::baremetalsolution::v2::
        SubmitProvisioningConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::baremetalsolution::v2::ProvisioningConfig>
BareMetalSolutionConnection::GetProvisioningConfig(
    google::cloud::baremetalsolution::v2::GetProvisioningConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::baremetalsolution::v2::ProvisioningConfig>
BareMetalSolutionConnection::CreateProvisioningConfig(
    google::cloud::baremetalsolution::v2::
        CreateProvisioningConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::baremetalsolution::v2::ProvisioningConfig>
BareMetalSolutionConnection::UpdateProvisioningConfig(
    google::cloud::baremetalsolution::v2::
        UpdateProvisioningConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::baremetalsolution::v2::Network>
BareMetalSolutionConnection::RenameNetwork(
    google::cloud::baremetalsolution::v2::RenameNetworkRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::baremetalsolution::v2::OSImage>
BareMetalSolutionConnection::ListOSImages(
    google::cloud::baremetalsolution::v2::
        ListOSImagesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::baremetalsolution::v2::OSImage>>();
}

StreamRange<google::cloud::location::Location>
BareMetalSolutionConnection::ListLocations(
    google::cloud::location::
        ListLocationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::location::Location>>();
}

StatusOr<google::cloud::location::Location>
BareMetalSolutionConnection::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<BareMetalSolutionConnection> MakeBareMetalSolutionConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 BareMetalSolutionPolicyOptionList>(options,
                                                                    __func__);
  options = baremetalsolution_v2_internal::BareMetalSolutionDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = baremetalsolution_v2_internal::CreateDefaultBareMetalSolutionStub(
      std::move(auth), options);
  return baremetalsolution_v2_internal::MakeBareMetalSolutionTracingConnection(
      std::make_shared<
          baremetalsolution_v2_internal::BareMetalSolutionConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace baremetalsolution_v2
}  // namespace cloud
}  // namespace google
