// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/baremetalsolution/v2/baremetalsolution.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BAREMETALSOLUTION_V2_BARE_METAL_SOLUTION_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BAREMETALSOLUTION_V2_BARE_METAL_SOLUTION_CLIENT_H

#include "google/cloud/baremetalsolution/v2/bare_metal_solution_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace baremetalsolution_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Performs management operations on Bare Metal Solution servers.
///
/// The `baremetalsolution.googleapis.com` service provides management
/// capabilities for Bare Metal Solution servers. To access the API methods, you
/// must assign Bare Metal Solution IAM roles containing the desired permissions
/// to your staff in your Google Cloud project. You must also enable the Bare
/// Metal Solution API. Once enabled, the methods act
/// upon specific servers in your Bare Metal Solution environment.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class BareMetalSolutionClient {
 public:
  explicit BareMetalSolutionClient(
      std::shared_ptr<BareMetalSolutionConnection> connection,
      Options opts = {});
  ~BareMetalSolutionClient();

  ///@{
  /// @name Copy and move support
  BareMetalSolutionClient(BareMetalSolutionClient const&) = default;
  BareMetalSolutionClient& operator=(BareMetalSolutionClient const&) = default;
  BareMetalSolutionClient(BareMetalSolutionClient&&) = default;
  BareMetalSolutionClient& operator=(BareMetalSolutionClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(BareMetalSolutionClient const& a,
                         BareMetalSolutionClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(BareMetalSolutionClient const& a,
                         BareMetalSolutionClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// List servers in a given project and location.
  ///
  /// @param parent  Required. Parent value for ListInstancesRequest.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.baremetalsolution.v2.Instance], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.Instance]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L37}
  /// [google.cloud.baremetalsolution.v2.ListInstancesRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L165}
  ///
  // clang-format on
  StreamRange<google::cloud::baremetalsolution::v2::Instance> ListInstances(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List servers in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.ListInstancesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.baremetalsolution.v2.Instance], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.Instance]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L37}
  /// [google.cloud.baremetalsolution.v2.ListInstancesRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L165}
  ///
  // clang-format on
  StreamRange<google::cloud::baremetalsolution::v2::Instance> ListInstances(
      google::cloud::baremetalsolution::v2::ListInstancesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Get details about a single server.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.Instance])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.GetInstanceRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L154}
  /// [google.cloud.baremetalsolution.v2.Instance]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L37}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::Instance> GetInstance(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Get details about a single server.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.GetInstanceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.Instance])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.GetInstanceRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L154}
  /// [google.cloud.baremetalsolution.v2.Instance]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L37}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::Instance> GetInstance(
      google::cloud::baremetalsolution::v2::GetInstanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Update details of a single server.
  ///
  /// @param instance  Required. The server to update.
  ///  @n
  ///  The `name` field is used to identify the instance to update.
  ///  Format: projects/{project}/locations/{location}/instances/{instance}
  /// @param update_mask  The list of fields to update.
  ///  The currently supported fields are:
  ///    `labels`
  ///    `hyperthreading_enabled`
  ///    `os_image`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.Instance]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L37}
  /// [google.cloud.baremetalsolution.v2.UpdateInstanceRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L198}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::Instance>>
  UpdateInstance(google::cloud::baremetalsolution::v2::Instance const& instance,
                 google::protobuf::FieldMask const& update_mask,
                 Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateInstance
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateInstance(
      NoAwaitTag,
      google::cloud::baremetalsolution::v2::Instance const& instance,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Update details of a single server.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.UpdateInstanceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.Instance]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L37}
  /// [google.cloud.baremetalsolution.v2.UpdateInstanceRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L198}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::Instance>>
  UpdateInstance(
      google::cloud::baremetalsolution::v2::UpdateInstanceRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateInstance
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateInstance(
      NoAwaitTag,
      google::cloud::baremetalsolution::v2::UpdateInstanceRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateInstance
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::Instance>>
  UpdateInstance(google::longrunning::Operation const& operation,
                 Options opts = {});

  // clang-format off
  ///
  /// RenameInstance sets a new name for an instance.
  /// Use with caution, previous names become immediately invalidated.
  ///
  /// @param name  Required. The `name` field is used to identify the instance.
  ///  Format: projects/{project}/locations/{location}/instances/{instance}
  /// @param new_instance_id  Required. The new `id` of the instance.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.Instance])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.Instance]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L37}
  /// [google.cloud.baremetalsolution.v2.RenameInstanceRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L214}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::Instance> RenameInstance(
      std::string const& name, std::string const& new_instance_id,
      Options opts = {});

  // clang-format off
  ///
  /// RenameInstance sets a new name for an instance.
  /// Use with caution, previous names become immediately invalidated.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.RenameInstanceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.Instance])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.Instance]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L37}
  /// [google.cloud.baremetalsolution.v2.RenameInstanceRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L214}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::Instance> RenameInstance(
      google::cloud::baremetalsolution::v2::RenameInstanceRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Perform an ungraceful, hard reset on a server. Equivalent to shutting the
  /// power off and then turning it back on.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.ResetInstanceResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.ResetInstanceRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L229}
  /// [google.cloud.baremetalsolution.v2.ResetInstanceResponse]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/baremetalsolution.proto#L563}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::ResetInstanceResponse>>
  ResetInstance(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief ResetInstance
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ResetInstance(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Perform an ungraceful, hard reset on a server. Equivalent to shutting the
  /// power off and then turning it back on.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.ResetInstanceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.ResetInstanceResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.ResetInstanceRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L229}
  /// [google.cloud.baremetalsolution.v2.ResetInstanceResponse]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/baremetalsolution.proto#L563}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::ResetInstanceResponse>>
  ResetInstance(
      google::cloud::baremetalsolution::v2::ResetInstanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ResetInstance
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ResetInstance(
      NoAwaitTag,
      google::cloud::baremetalsolution::v2::ResetInstanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ResetInstance
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::ResetInstanceResponse>>
  ResetInstance(google::longrunning::Operation const& operation,
                Options opts = {});

  // clang-format off
  ///
  /// Starts a server that was shutdown.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.StartInstanceResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.StartInstanceRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L240}
  /// [google.cloud.baremetalsolution.v2.StartInstanceResponse]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L251}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::StartInstanceResponse>>
  StartInstance(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief StartInstance
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> StartInstance(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Starts a server that was shutdown.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.StartInstanceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.StartInstanceResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.StartInstanceRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L240}
  /// [google.cloud.baremetalsolution.v2.StartInstanceResponse]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L251}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::StartInstanceResponse>>
  StartInstance(
      google::cloud::baremetalsolution::v2::StartInstanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief StartInstance
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> StartInstance(
      NoAwaitTag,
      google::cloud::baremetalsolution::v2::StartInstanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief StartInstance
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::StartInstanceResponse>>
  StartInstance(google::longrunning::Operation const& operation,
                Options opts = {});

  // clang-format off
  ///
  /// Stop a running server.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.StopInstanceResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.StopInstanceRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L254}
  /// [google.cloud.baremetalsolution.v2.StopInstanceResponse]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L265}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::StopInstanceResponse>>
  StopInstance(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief StopInstance
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> StopInstance(NoAwaitTag,
                                                        std::string const& name,
                                                        Options opts = {});

  // clang-format off
  ///
  /// Stop a running server.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.StopInstanceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.StopInstanceResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.StopInstanceRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L254}
  /// [google.cloud.baremetalsolution.v2.StopInstanceResponse]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L265}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::StopInstanceResponse>>
  StopInstance(
      google::cloud::baremetalsolution::v2::StopInstanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief StopInstance
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> StopInstance(
      NoAwaitTag,
      google::cloud::baremetalsolution::v2::StopInstanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief StopInstance
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::StopInstanceResponse>>
  StopInstance(google::longrunning::Operation const& operation,
               Options opts = {});

  // clang-format off
  ///
  /// Enable the interactive serial console feature on an instance.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.EnableInteractiveSerialConsoleResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.EnableInteractiveSerialConsoleRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L268}
  /// [google.cloud.baremetalsolution.v2.EnableInteractiveSerialConsoleResponse]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L279}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::
                      EnableInteractiveSerialConsoleResponse>>
  EnableInteractiveSerialConsole(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief EnableInteractiveSerialConsole
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> EnableInteractiveSerialConsole(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Enable the interactive serial console feature on an instance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.EnableInteractiveSerialConsoleRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.EnableInteractiveSerialConsoleResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.EnableInteractiveSerialConsoleRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L268}
  /// [google.cloud.baremetalsolution.v2.EnableInteractiveSerialConsoleResponse]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L279}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::
                      EnableInteractiveSerialConsoleResponse>>
  EnableInteractiveSerialConsole(
      google::cloud::baremetalsolution::v2::
          EnableInteractiveSerialConsoleRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief EnableInteractiveSerialConsole
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> EnableInteractiveSerialConsole(
      NoAwaitTag,
      google::cloud::baremetalsolution::v2::
          EnableInteractiveSerialConsoleRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief EnableInteractiveSerialConsole
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::
                      EnableInteractiveSerialConsoleResponse>>
  EnableInteractiveSerialConsole(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Disable the interactive serial console feature on an instance.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.DisableInteractiveSerialConsoleResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.DisableInteractiveSerialConsoleRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L282}
  /// [google.cloud.baremetalsolution.v2.DisableInteractiveSerialConsoleResponse]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L293}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::
                      DisableInteractiveSerialConsoleResponse>>
  DisableInteractiveSerialConsole(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DisableInteractiveSerialConsole
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DisableInteractiveSerialConsole(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Disable the interactive serial console feature on an instance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.DisableInteractiveSerialConsoleRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.DisableInteractiveSerialConsoleResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.DisableInteractiveSerialConsoleRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L282}
  /// [google.cloud.baremetalsolution.v2.DisableInteractiveSerialConsoleResponse]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L293}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::
                      DisableInteractiveSerialConsoleResponse>>
  DisableInteractiveSerialConsole(
      google::cloud::baremetalsolution::v2::
          DisableInteractiveSerialConsoleRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DisableInteractiveSerialConsole
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DisableInteractiveSerialConsole(
      NoAwaitTag,
      google::cloud::baremetalsolution::v2::
          DisableInteractiveSerialConsoleRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DisableInteractiveSerialConsole
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::
                      DisableInteractiveSerialConsoleResponse>>
  DisableInteractiveSerialConsole(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Detach LUN from Instance.
  ///
  /// @param instance  Required. Name of the instance.
  /// @param lun  Required. Name of the Lun to detach.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.DetachLunRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L296}
  /// [google.cloud.baremetalsolution.v2.Instance]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L37}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::Instance>> DetachLun(
      std::string const& instance, std::string const& lun, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DetachLun
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DetachLun(
      NoAwaitTag, std::string const& instance, std::string const& lun,
      Options opts = {});

  // clang-format off
  ///
  /// Detach LUN from Instance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.DetachLunRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.DetachLunRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L296}
  /// [google.cloud.baremetalsolution.v2.Instance]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/instance.proto#L37}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::Instance>> DetachLun(
      google::cloud::baremetalsolution::v2::DetachLunRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DetachLun
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DetachLun(
      NoAwaitTag,
      google::cloud::baremetalsolution::v2::DetachLunRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DetachLun
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::Instance>> DetachLun(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Lists the public SSH keys registered for the specified project.
  /// These SSH keys are used only for the interactive serial console feature.
  ///
  /// @param parent  Required. The parent containing the SSH keys.
  ///  Currently, the only valid value for the location is "global".
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.baremetalsolution.v2.SSHKey], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.ListSSHKeysRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/ssh_key.proto#L46}
  /// [google.cloud.baremetalsolution.v2.SSHKey]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/ssh_key.proto#L31}
  ///
  // clang-format on
  StreamRange<google::cloud::baremetalsolution::v2::SSHKey> ListSSHKeys(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists the public SSH keys registered for the specified project.
  /// These SSH keys are used only for the interactive serial console feature.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.ListSSHKeysRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.baremetalsolution.v2.SSHKey], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.ListSSHKeysRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/ssh_key.proto#L46}
  /// [google.cloud.baremetalsolution.v2.SSHKey]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/ssh_key.proto#L31}
  ///
  // clang-format on
  StreamRange<google::cloud::baremetalsolution::v2::SSHKey> ListSSHKeys(
      google::cloud::baremetalsolution::v2::ListSSHKeysRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Register a public SSH key in the specified project for use with the
  /// interactive serial console feature.
  ///
  /// @param parent  Required. The parent containing the SSH keys.
  /// @param ssh_key  Required. The SSH key to register.
  /// @param ssh_key_id  Required. The ID to use for the key, which will become the final component
  ///  of the key's resource name.
  ///  @n
  ///  This value must match the regex:
  ///    [a-zA-Z0-9@.\-_]{1,64}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.SSHKey])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.CreateSSHKeyRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/ssh_key.proto#L74}
  /// [google.cloud.baremetalsolution.v2.SSHKey]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/ssh_key.proto#L31}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::SSHKey> CreateSSHKey(
      std::string const& parent,
      google::cloud::baremetalsolution::v2::SSHKey const& ssh_key,
      std::string const& ssh_key_id, Options opts = {});

  // clang-format off
  ///
  /// Register a public SSH key in the specified project for use with the
  /// interactive serial console feature.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.CreateSSHKeyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.SSHKey])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.CreateSSHKeyRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/ssh_key.proto#L74}
  /// [google.cloud.baremetalsolution.v2.SSHKey]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/ssh_key.proto#L31}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::SSHKey> CreateSSHKey(
      google::cloud::baremetalsolution::v2::CreateSSHKeyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a public SSH key registered in the specified project.
  ///
  /// @param name  Required. The name of the SSH key to delete.
  ///  Currently, the only valid value for the location is "global".
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.DeleteSSHKeyRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/ssh_key.proto#L95}
  ///
  // clang-format on
  Status DeleteSSHKey(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a public SSH key registered in the specified project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.DeleteSSHKeyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.DeleteSSHKeyRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/ssh_key.proto#L95}
  ///
  // clang-format on
  Status DeleteSSHKey(
      google::cloud::baremetalsolution::v2::DeleteSSHKeyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// List storage volumes in a given project and location.
  ///
  /// @param parent  Required. Parent value for ListVolumesRequest.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.baremetalsolution.v2.Volume], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.ListVolumesRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume.proto#L247}
  /// [google.cloud.baremetalsolution.v2.Volume]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume.proto#L34}
  ///
  // clang-format on
  StreamRange<google::cloud::baremetalsolution::v2::Volume> ListVolumes(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List storage volumes in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.ListVolumesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.baremetalsolution.v2.Volume], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.ListVolumesRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume.proto#L247}
  /// [google.cloud.baremetalsolution.v2.Volume]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume.proto#L34}
  ///
  // clang-format on
  StreamRange<google::cloud::baremetalsolution::v2::Volume> ListVolumes(
      google::cloud::baremetalsolution::v2::ListVolumesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Get details of a single storage volume.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.Volume])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.GetVolumeRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume.proto#L236}
  /// [google.cloud.baremetalsolution.v2.Volume]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume.proto#L34}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::Volume> GetVolume(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Get details of a single storage volume.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.GetVolumeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.Volume])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.GetVolumeRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume.proto#L236}
  /// [google.cloud.baremetalsolution.v2.Volume]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume.proto#L34}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::Volume> GetVolume(
      google::cloud::baremetalsolution::v2::GetVolumeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Update details of a single storage volume.
  ///
  /// @param volume  Required. The volume to update.
  ///  @n
  ///  The `name` field is used to identify the volume to update.
  ///  Format: projects/{project}/locations/{location}/volumes/{volume}
  /// @param update_mask  The list of fields to update.
  ///  The only currently supported fields are:
  ///    'labels'
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.Volume] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.UpdateVolumeRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume.proto#L280}
  /// [google.cloud.baremetalsolution.v2.Volume]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume.proto#L34}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::Volume>> UpdateVolume(
      google::cloud::baremetalsolution::v2::Volume const& volume,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateVolume
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateVolume(
      NoAwaitTag, google::cloud::baremetalsolution::v2::Volume const& volume,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Update details of a single storage volume.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.UpdateVolumeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.Volume] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.UpdateVolumeRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume.proto#L280}
  /// [google.cloud.baremetalsolution.v2.Volume]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume.proto#L34}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::Volume>> UpdateVolume(
      google::cloud::baremetalsolution::v2::UpdateVolumeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateVolume
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateVolume(
      NoAwaitTag,
      google::cloud::baremetalsolution::v2::UpdateVolumeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateVolume
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::Volume>> UpdateVolume(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// RenameVolume sets a new name for a volume.
  /// Use with caution, previous names become immediately invalidated.
  ///
  /// @param name  Required. The `name` field is used to identify the volume.
  ///  Format: projects/{project}/locations/{location}/volumes/{volume}
  /// @param new_volume_id  Required. The new `id` of the volume.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.Volume])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.RenameVolumeRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume.proto#L294}
  /// [google.cloud.baremetalsolution.v2.Volume]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume.proto#L34}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::Volume> RenameVolume(
      std::string const& name, std::string const& new_volume_id,
      Options opts = {});

  // clang-format off
  ///
  /// RenameVolume sets a new name for a volume.
  /// Use with caution, previous names become immediately invalidated.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.RenameVolumeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.Volume])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.RenameVolumeRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume.proto#L294}
  /// [google.cloud.baremetalsolution.v2.Volume]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume.proto#L34}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::Volume> RenameVolume(
      google::cloud::baremetalsolution::v2::RenameVolumeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Skips volume's cooloff and deletes it now.
  /// Volume must be in cooloff state.
  ///
  /// @param name  Required. The name of the Volume.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.EvictVolumeRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume.proto#L309}
  /// [google.cloud.baremetalsolution.v2.OperationMetadata]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/baremetalsolution.proto#L533}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::OperationMetadata>>
  EvictVolume(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief EvictVolume
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> EvictVolume(NoAwaitTag,
                                                       std::string const& name,
                                                       Options opts = {});

  // clang-format off
  ///
  /// Skips volume's cooloff and deletes it now.
  /// Volume must be in cooloff state.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.EvictVolumeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.EvictVolumeRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume.proto#L309}
  /// [google.cloud.baremetalsolution.v2.OperationMetadata]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/baremetalsolution.proto#L533}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::OperationMetadata>>
  EvictVolume(
      google::cloud::baremetalsolution::v2::EvictVolumeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief EvictVolume
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> EvictVolume(
      NoAwaitTag,
      google::cloud::baremetalsolution::v2::EvictVolumeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief EvictVolume
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::OperationMetadata>>
  EvictVolume(google::longrunning::Operation const& operation,
              Options opts = {});

  // clang-format off
  ///
  /// Emergency Volume resize.
  ///
  /// @param volume  Required. Volume to resize.
  /// @param size_gib  New Volume size, in GiB.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.Volume] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.ResizeVolumeRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume.proto#L320}
  /// [google.cloud.baremetalsolution.v2.Volume]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume.proto#L34}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::Volume>> ResizeVolume(
      std::string const& volume, std::int64_t size_gib, Options opts = {});

  // clang-format off
  ///
  /// @copybrief ResizeVolume
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ResizeVolume(
      NoAwaitTag, std::string const& volume, std::int64_t size_gib,
      Options opts = {});

  // clang-format off
  ///
  /// Emergency Volume resize.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.ResizeVolumeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.Volume] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.ResizeVolumeRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume.proto#L320}
  /// [google.cloud.baremetalsolution.v2.Volume]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume.proto#L34}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::Volume>> ResizeVolume(
      google::cloud::baremetalsolution::v2::ResizeVolumeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ResizeVolume
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ResizeVolume(
      NoAwaitTag,
      google::cloud::baremetalsolution::v2::ResizeVolumeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ResizeVolume
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::Volume>> ResizeVolume(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// List network in a given project and location.
  ///
  /// @param parent  Required. Parent value for ListNetworksRequest.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.baremetalsolution.v2.Network], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.ListNetworksRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/network.proto#L259}
  /// [google.cloud.baremetalsolution.v2.Network]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/network.proto#L36}
  ///
  // clang-format on
  StreamRange<google::cloud::baremetalsolution::v2::Network> ListNetworks(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List network in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.ListNetworksRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.baremetalsolution.v2.Network], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.ListNetworksRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/network.proto#L259}
  /// [google.cloud.baremetalsolution.v2.Network]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/network.proto#L36}
  ///
  // clang-format on
  StreamRange<google::cloud::baremetalsolution::v2::Network> ListNetworks(
      google::cloud::baremetalsolution::v2::ListNetworksRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// List all Networks (and used IPs for each Network) in the vendor account
  /// associated with the specified project.
  ///
  /// @param location  Required. Parent value (project and location).
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.ListNetworkUsageResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.ListNetworkUsageRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/network.proto#L315}
  /// [google.cloud.baremetalsolution.v2.ListNetworkUsageResponse]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/network.proto#L326}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::ListNetworkUsageResponse>
  ListNetworkUsage(std::string const& location, Options opts = {});

  // clang-format off
  ///
  /// List all Networks (and used IPs for each Network) in the vendor account
  /// associated with the specified project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.ListNetworkUsageRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.ListNetworkUsageResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.ListNetworkUsageRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/network.proto#L315}
  /// [google.cloud.baremetalsolution.v2.ListNetworkUsageResponse]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/network.proto#L326}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::ListNetworkUsageResponse>
  ListNetworkUsage(
      google::cloud::baremetalsolution::v2::ListNetworkUsageRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Get details of a single network.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.Network])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.GetNetworkRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/network.proto#L248}
  /// [google.cloud.baremetalsolution.v2.Network]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/network.proto#L36}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::Network> GetNetwork(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Get details of a single network.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.GetNetworkRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.Network])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.GetNetworkRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/network.proto#L248}
  /// [google.cloud.baremetalsolution.v2.Network]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/network.proto#L36}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::Network> GetNetwork(
      google::cloud::baremetalsolution::v2::GetNetworkRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Update details of a single network.
  ///
  /// @param network  Required. The network to update.
  ///  @n
  ///  The `name` field is used to identify the instance to update.
  ///  Format: projects/{project}/locations/{location}/networks/{network}
  /// @param update_mask  The list of fields to update.
  ///  The only currently supported fields are:
  ///    `labels`, `reservations`, `vrf.vlan_attachments`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.Network] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.Network]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/network.proto#L36}
  /// [google.cloud.baremetalsolution.v2.UpdateNetworkRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/network.proto#L292}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::Network>> UpdateNetwork(
      google::cloud::baremetalsolution::v2::Network const& network,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateNetwork
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateNetwork(
      NoAwaitTag, google::cloud::baremetalsolution::v2::Network const& network,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Update details of a single network.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.UpdateNetworkRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.Network] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.Network]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/network.proto#L36}
  /// [google.cloud.baremetalsolution.v2.UpdateNetworkRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/network.proto#L292}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::Network>> UpdateNetwork(
      google::cloud::baremetalsolution::v2::UpdateNetworkRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateNetwork
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateNetwork(
      NoAwaitTag,
      google::cloud::baremetalsolution::v2::UpdateNetworkRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateNetwork
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::Network>> UpdateNetwork(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Takes a snapshot of a boot volume.
  /// Returns INVALID_ARGUMENT if called for a non-boot volume.
  ///
  /// @param parent  Required. The volume to snapshot.
  /// @param volume_snapshot  Required. The snapshot to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.VolumeSnapshot])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.CreateVolumeSnapshotRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume_snapshot.proto#L129}
  /// [google.cloud.baremetalsolution.v2.VolumeSnapshot]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume_snapshot.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::VolumeSnapshot>
  CreateVolumeSnapshot(
      std::string const& parent,
      google::cloud::baremetalsolution::v2::VolumeSnapshot const&
          volume_snapshot,
      Options opts = {});

  // clang-format off
  ///
  /// Takes a snapshot of a boot volume.
  /// Returns INVALID_ARGUMENT if called for a non-boot volume.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.CreateVolumeSnapshotRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.VolumeSnapshot])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.CreateVolumeSnapshotRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume_snapshot.proto#L129}
  /// [google.cloud.baremetalsolution.v2.VolumeSnapshot]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume_snapshot.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::VolumeSnapshot>
  CreateVolumeSnapshot(
      google::cloud::baremetalsolution::v2::CreateVolumeSnapshotRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Uses the specified snapshot to restore its parent volume.
  /// Returns INVALID_ARGUMENT if called for a non-boot volume.
  ///
  /// @param volume_snapshot  Required. Name of the snapshot which will be used to restore its parent
  ///  volume.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.VolumeSnapshot] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.RestoreVolumeSnapshotRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume_snapshot.proto#L143}
  /// [google.cloud.baremetalsolution.v2.VolumeSnapshot]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume_snapshot.proto#L32}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::VolumeSnapshot>>
  RestoreVolumeSnapshot(std::string const& volume_snapshot, Options opts = {});

  // clang-format off
  ///
  /// @copybrief RestoreVolumeSnapshot
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> RestoreVolumeSnapshot(
      NoAwaitTag, std::string const& volume_snapshot, Options opts = {});

  // clang-format off
  ///
  /// Uses the specified snapshot to restore its parent volume.
  /// Returns INVALID_ARGUMENT if called for a non-boot volume.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.RestoreVolumeSnapshotRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.VolumeSnapshot] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.RestoreVolumeSnapshotRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume_snapshot.proto#L143}
  /// [google.cloud.baremetalsolution.v2.VolumeSnapshot]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume_snapshot.proto#L32}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::VolumeSnapshot>>
  RestoreVolumeSnapshot(
      google::cloud::baremetalsolution::v2::RestoreVolumeSnapshotRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RestoreVolumeSnapshot
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> RestoreVolumeSnapshot(
      NoAwaitTag,
      google::cloud::baremetalsolution::v2::RestoreVolumeSnapshotRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RestoreVolumeSnapshot
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::VolumeSnapshot>>
  RestoreVolumeSnapshot(google::longrunning::Operation const& operation,
                        Options opts = {});

  // clang-format off
  ///
  /// Deletes a volume snapshot.
  /// Returns INVALID_ARGUMENT if called for a non-boot volume.
  ///
  /// @param name  Required. The name of the snapshot to delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.DeleteVolumeSnapshotRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume_snapshot.proto#L118}
  ///
  // clang-format on
  Status DeleteVolumeSnapshot(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a volume snapshot.
  /// Returns INVALID_ARGUMENT if called for a non-boot volume.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.DeleteVolumeSnapshotRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.DeleteVolumeSnapshotRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume_snapshot.proto#L118}
  ///
  // clang-format on
  Status DeleteVolumeSnapshot(
      google::cloud::baremetalsolution::v2::DeleteVolumeSnapshotRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns the specified snapshot resource.
  /// Returns INVALID_ARGUMENT if called for a non-boot volume.
  ///
  /// @param name  Required. The name of the snapshot.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.VolumeSnapshot])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.GetVolumeSnapshotRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume_snapshot.proto#L77}
  /// [google.cloud.baremetalsolution.v2.VolumeSnapshot]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume_snapshot.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::VolumeSnapshot>
  GetVolumeSnapshot(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Returns the specified snapshot resource.
  /// Returns INVALID_ARGUMENT if called for a non-boot volume.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.GetVolumeSnapshotRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.VolumeSnapshot])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.GetVolumeSnapshotRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume_snapshot.proto#L77}
  /// [google.cloud.baremetalsolution.v2.VolumeSnapshot]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume_snapshot.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::VolumeSnapshot>
  GetVolumeSnapshot(
      google::cloud::baremetalsolution::v2::GetVolumeSnapshotRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves the list of snapshots for the specified volume.
  /// Returns a response with an empty list of snapshots if called
  /// for a non-boot volume.
  ///
  /// @param parent  Required. Parent value for ListVolumesRequest.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.baremetalsolution.v2.VolumeSnapshot], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.ListVolumeSnapshotsRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume_snapshot.proto#L88}
  /// [google.cloud.baremetalsolution.v2.VolumeSnapshot]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume_snapshot.proto#L32}
  ///
  // clang-format on
  StreamRange<google::cloud::baremetalsolution::v2::VolumeSnapshot>
  ListVolumeSnapshots(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Retrieves the list of snapshots for the specified volume.
  /// Returns a response with an empty list of snapshots if called
  /// for a non-boot volume.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.ListVolumeSnapshotsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.baremetalsolution.v2.VolumeSnapshot], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.ListVolumeSnapshotsRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume_snapshot.proto#L88}
  /// [google.cloud.baremetalsolution.v2.VolumeSnapshot]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/volume_snapshot.proto#L32}
  ///
  // clang-format on
  StreamRange<google::cloud::baremetalsolution::v2::VolumeSnapshot>
  ListVolumeSnapshots(
      google::cloud::baremetalsolution::v2::ListVolumeSnapshotsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Get details of a single storage logical unit number(LUN).
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.Lun])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.GetLunRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/lun.proto#L128}
  /// [google.cloud.baremetalsolution.v2.Lun]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/lun.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::Lun> GetLun(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Get details of a single storage logical unit number(LUN).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.GetLunRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.Lun])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.GetLunRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/lun.proto#L128}
  /// [google.cloud.baremetalsolution.v2.Lun]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/lun.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::Lun> GetLun(
      google::cloud::baremetalsolution::v2::GetLunRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// List storage volume luns for given storage volume.
  ///
  /// @param parent  Required. Parent value for ListLunsRequest.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.baremetalsolution.v2.Lun], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.ListLunsRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/lun.proto#L139}
  /// [google.cloud.baremetalsolution.v2.Lun]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/lun.proto#L32}
  ///
  // clang-format on
  StreamRange<google::cloud::baremetalsolution::v2::Lun> ListLuns(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List storage volume luns for given storage volume.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.ListLunsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.baremetalsolution.v2.Lun], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.ListLunsRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/lun.proto#L139}
  /// [google.cloud.baremetalsolution.v2.Lun]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/lun.proto#L32}
  ///
  // clang-format on
  StreamRange<google::cloud::baremetalsolution::v2::Lun> ListLuns(
      google::cloud::baremetalsolution::v2::ListLunsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Skips lun's cooloff and deletes it now.
  /// Lun must be in cooloff state.
  ///
  /// @param name  Required. The name of the lun.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.EvictLunRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/lun.proto#L169}
  /// [google.cloud.baremetalsolution.v2.OperationMetadata]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/baremetalsolution.proto#L533}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::OperationMetadata>>
  EvictLun(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief EvictLun
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> EvictLun(NoAwaitTag,
                                                    std::string const& name,
                                                    Options opts = {});

  // clang-format off
  ///
  /// Skips lun's cooloff and deletes it now.
  /// Lun must be in cooloff state.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.EvictLunRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.EvictLunRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/lun.proto#L169}
  /// [google.cloud.baremetalsolution.v2.OperationMetadata]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/baremetalsolution.proto#L533}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::OperationMetadata>>
  EvictLun(google::cloud::baremetalsolution::v2::EvictLunRequest const& request,
           Options opts = {});

  // clang-format off
  ///
  /// @copybrief EvictLun
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> EvictLun(
      NoAwaitTag,
      google::cloud::baremetalsolution::v2::EvictLunRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief EvictLun
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::OperationMetadata>>
  EvictLun(google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Get details of a single NFS share.
  ///
  /// @param name  Required. Name of the resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.NfsShare])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.GetNfsShareRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/nfs_share.proto#L151}
  /// [google.cloud.baremetalsolution.v2.NfsShare]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/nfs_share.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::NfsShare> GetNfsShare(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Get details of a single NFS share.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.GetNfsShareRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.NfsShare])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.GetNfsShareRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/nfs_share.proto#L151}
  /// [google.cloud.baremetalsolution.v2.NfsShare]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/nfs_share.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::NfsShare> GetNfsShare(
      google::cloud::baremetalsolution::v2::GetNfsShareRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// List NFS shares.
  ///
  /// @param parent  Required. Parent value for ListNfsSharesRequest.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.baremetalsolution.v2.NfsShare], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.ListNfsSharesRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/nfs_share.proto#L162}
  /// [google.cloud.baremetalsolution.v2.NfsShare]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/nfs_share.proto#L32}
  ///
  // clang-format on
  StreamRange<google::cloud::baremetalsolution::v2::NfsShare> ListNfsShares(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List NFS shares.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.ListNfsSharesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.baremetalsolution.v2.NfsShare], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.ListNfsSharesRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/nfs_share.proto#L162}
  /// [google.cloud.baremetalsolution.v2.NfsShare]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/nfs_share.proto#L32}
  ///
  // clang-format on
  StreamRange<google::cloud::baremetalsolution::v2::NfsShare> ListNfsShares(
      google::cloud::baremetalsolution::v2::ListNfsSharesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Update details of a single NFS share.
  ///
  /// @param nfs_share  Required. The NFS share to update.
  ///  @n
  ///  The `name` field is used to identify the NFS share to update.
  ///  Format: projects/{project}/locations/{location}/nfsShares/{nfs_share}
  /// @param update_mask  The list of fields to update.
  ///  The only currently supported fields are:
  ///    `labels`
  ///    `allowed_clients`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.NfsShare] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.NfsShare]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/nfs_share.proto#L32}
  /// [google.cloud.baremetalsolution.v2.UpdateNfsShareRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/nfs_share.proto#L195}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::NfsShare>>
  UpdateNfsShare(
      google::cloud::baremetalsolution::v2::NfsShare const& nfs_share,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateNfsShare
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateNfsShare(
      NoAwaitTag,
      google::cloud::baremetalsolution::v2::NfsShare const& nfs_share,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Update details of a single NFS share.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.UpdateNfsShareRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.NfsShare] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.NfsShare]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/nfs_share.proto#L32}
  /// [google.cloud.baremetalsolution.v2.UpdateNfsShareRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/nfs_share.proto#L195}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::NfsShare>>
  UpdateNfsShare(
      google::cloud::baremetalsolution::v2::UpdateNfsShareRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateNfsShare
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateNfsShare(
      NoAwaitTag,
      google::cloud::baremetalsolution::v2::UpdateNfsShareRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateNfsShare
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::NfsShare>>
  UpdateNfsShare(google::longrunning::Operation const& operation,
                 Options opts = {});

  // clang-format off
  ///
  /// Create an NFS share.
  ///
  /// @param parent  Required. The parent project and location.
  /// @param nfs_share  Required. The NfsShare to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.NfsShare] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.CreateNfsShareRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/nfs_share.proto#L225}
  /// [google.cloud.baremetalsolution.v2.NfsShare]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/nfs_share.proto#L32}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::NfsShare>>
  CreateNfsShare(
      std::string const& parent,
      google::cloud::baremetalsolution::v2::NfsShare const& nfs_share,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateNfsShare
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateNfsShare(
      NoAwaitTag, std::string const& parent,
      google::cloud::baremetalsolution::v2::NfsShare const& nfs_share,
      Options opts = {});

  // clang-format off
  ///
  /// Create an NFS share.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.CreateNfsShareRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.NfsShare] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.CreateNfsShareRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/nfs_share.proto#L225}
  /// [google.cloud.baremetalsolution.v2.NfsShare]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/nfs_share.proto#L32}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::NfsShare>>
  CreateNfsShare(
      google::cloud::baremetalsolution::v2::CreateNfsShareRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateNfsShare
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateNfsShare(
      NoAwaitTag,
      google::cloud::baremetalsolution::v2::CreateNfsShareRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateNfsShare
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::NfsShare>>
  CreateNfsShare(google::longrunning::Operation const& operation,
                 Options opts = {});

  // clang-format off
  ///
  /// RenameNfsShare sets a new name for an nfsshare.
  /// Use with caution, previous names become immediately invalidated.
  ///
  /// @param name  Required. The `name` field is used to identify the nfsshare.
  ///  Format: projects/{project}/locations/{location}/nfsshares/{nfsshare}
  /// @param new_nfsshare_id  Required. The new `id` of the nfsshare.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.NfsShare])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.NfsShare]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/nfs_share.proto#L32}
  /// [google.cloud.baremetalsolution.v2.RenameNfsShareRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/nfs_share.proto#L210}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::NfsShare> RenameNfsShare(
      std::string const& name, std::string const& new_nfsshare_id,
      Options opts = {});

  // clang-format off
  ///
  /// RenameNfsShare sets a new name for an nfsshare.
  /// Use with caution, previous names become immediately invalidated.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.RenameNfsShareRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.NfsShare])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.NfsShare]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/nfs_share.proto#L32}
  /// [google.cloud.baremetalsolution.v2.RenameNfsShareRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/nfs_share.proto#L210}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::NfsShare> RenameNfsShare(
      google::cloud::baremetalsolution::v2::RenameNfsShareRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Delete an NFS share. The underlying volume is automatically deleted.
  ///
  /// @param name  Required. The name of the NFS share to delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.DeleteNfsShareRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/nfs_share.proto#L239}
  /// [google.cloud.baremetalsolution.v2.OperationMetadata]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/baremetalsolution.proto#L533}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::OperationMetadata>>
  DeleteNfsShare(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteNfsShare
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteNfsShare(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Delete an NFS share. The underlying volume is automatically deleted.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.DeleteNfsShareRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.baremetalsolution.v2.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.DeleteNfsShareRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/nfs_share.proto#L239}
  /// [google.cloud.baremetalsolution.v2.OperationMetadata]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/baremetalsolution.proto#L533}
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::OperationMetadata>>
  DeleteNfsShare(
      google::cloud::baremetalsolution::v2::DeleteNfsShareRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteNfsShare
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteNfsShare(
      NoAwaitTag,
      google::cloud::baremetalsolution::v2::DeleteNfsShareRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteNfsShare
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::baremetalsolution::v2::OperationMetadata>>
  DeleteNfsShare(google::longrunning::Operation const& operation,
                 Options opts = {});

  // clang-format off
  ///
  /// List the budget details to provision resources on a given project.
  ///
  /// @param parent  Required. Parent value for ListProvisioningQuotasRequest.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.baremetalsolution.v2.ProvisioningQuota], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.ListProvisioningQuotasRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/provisioning.proto#L202}
  /// [google.cloud.baremetalsolution.v2.ProvisioningQuota]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/provisioning.proto#L146}
  ///
  // clang-format on
  StreamRange<google::cloud::baremetalsolution::v2::ProvisioningQuota>
  ListProvisioningQuotas(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List the budget details to provision resources on a given project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.ListProvisioningQuotasRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.baremetalsolution.v2.ProvisioningQuota], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.ListProvisioningQuotasRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/provisioning.proto#L202}
  /// [google.cloud.baremetalsolution.v2.ProvisioningQuota]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/provisioning.proto#L146}
  ///
  // clang-format on
  StreamRange<google::cloud::baremetalsolution::v2::ProvisioningQuota>
  ListProvisioningQuotas(
      google::cloud::baremetalsolution::v2::ListProvisioningQuotasRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Submit a provisiong configuration for a given project.
  ///
  /// @param parent  Required. The parent project and location containing the
  ///  ProvisioningConfig.
  /// @param provisioning_config  Required. The ProvisioningConfig to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.SubmitProvisioningConfigResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.SubmitProvisioningConfigRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/provisioning.proto#L120}
  /// [google.cloud.baremetalsolution.v2.SubmitProvisioningConfigResponse]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/provisioning.proto#L140}
  ///
  // clang-format on
  StatusOr<
      google::cloud::baremetalsolution::v2::SubmitProvisioningConfigResponse>
  SubmitProvisioningConfig(
      std::string const& parent,
      google::cloud::baremetalsolution::v2::ProvisioningConfig const&
          provisioning_config,
      Options opts = {});

  // clang-format off
  ///
  /// Submit a provisiong configuration for a given project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.SubmitProvisioningConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.SubmitProvisioningConfigResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.SubmitProvisioningConfigRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/provisioning.proto#L120}
  /// [google.cloud.baremetalsolution.v2.SubmitProvisioningConfigResponse]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/provisioning.proto#L140}
  ///
  // clang-format on
  StatusOr<
      google::cloud::baremetalsolution::v2::SubmitProvisioningConfigResponse>
  SubmitProvisioningConfig(google::cloud::baremetalsolution::v2::
                               SubmitProvisioningConfigRequest const& request,
                           Options opts = {});

  // clang-format off
  ///
  /// Get ProvisioningConfig by name.
  ///
  /// @param name  Required. Name of the ProvisioningConfig.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.ProvisioningConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.GetProvisioningConfigRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/provisioning.proto#L565}
  /// [google.cloud.baremetalsolution.v2.ProvisioningConfig]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/provisioning.proto#L35}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::ProvisioningConfig>
  GetProvisioningConfig(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Get ProvisioningConfig by name.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.GetProvisioningConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.ProvisioningConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.GetProvisioningConfigRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/provisioning.proto#L565}
  /// [google.cloud.baremetalsolution.v2.ProvisioningConfig]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/provisioning.proto#L35}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::ProvisioningConfig>
  GetProvisioningConfig(
      google::cloud::baremetalsolution::v2::GetProvisioningConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Create new ProvisioningConfig.
  ///
  /// @param parent  Required. The parent project and location containing the
  ///  ProvisioningConfig.
  /// @param provisioning_config  Required. The ProvisioningConfig to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.ProvisioningConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.CreateProvisioningConfigRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/provisioning.proto#L576}
  /// [google.cloud.baremetalsolution.v2.ProvisioningConfig]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/provisioning.proto#L35}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::ProvisioningConfig>
  CreateProvisioningConfig(
      std::string const& parent,
      google::cloud::baremetalsolution::v2::ProvisioningConfig const&
          provisioning_config,
      Options opts = {});

  // clang-format off
  ///
  /// Create new ProvisioningConfig.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.CreateProvisioningConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.ProvisioningConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.CreateProvisioningConfigRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/provisioning.proto#L576}
  /// [google.cloud.baremetalsolution.v2.ProvisioningConfig]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/provisioning.proto#L35}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::ProvisioningConfig>
  CreateProvisioningConfig(google::cloud::baremetalsolution::v2::
                               CreateProvisioningConfigRequest const& request,
                           Options opts = {});

  // clang-format off
  ///
  /// Update existing ProvisioningConfig.
  ///
  /// @param provisioning_config  Required. The ProvisioningConfig to update.
  /// @param update_mask  Required. The list of fields to update.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.ProvisioningConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.ProvisioningConfig]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/provisioning.proto#L35}
  /// [google.cloud.baremetalsolution.v2.UpdateProvisioningConfigRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/provisioning.proto#L596}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::ProvisioningConfig>
  UpdateProvisioningConfig(
      google::cloud::baremetalsolution::v2::ProvisioningConfig const&
          provisioning_config,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Update existing ProvisioningConfig.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.UpdateProvisioningConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.ProvisioningConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.ProvisioningConfig]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/provisioning.proto#L35}
  /// [google.cloud.baremetalsolution.v2.UpdateProvisioningConfigRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/provisioning.proto#L596}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::ProvisioningConfig>
  UpdateProvisioningConfig(google::cloud::baremetalsolution::v2::
                               UpdateProvisioningConfigRequest const& request,
                           Options opts = {});

  // clang-format off
  ///
  /// RenameNetwork sets a new name for a network.
  /// Use with caution, previous names become immediately invalidated.
  ///
  /// @param name  Required. The `name` field is used to identify the network.
  ///  Format: projects/{project}/locations/{location}/networks/{network}
  /// @param new_network_id  Required. The new `id` of the network.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.Network])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.Network]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/network.proto#L36}
  /// [google.cloud.baremetalsolution.v2.RenameNetworkRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/network.proto#L349}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::Network> RenameNetwork(
      std::string const& name, std::string const& new_network_id,
      Options opts = {});

  // clang-format off
  ///
  /// RenameNetwork sets a new name for a network.
  /// Use with caution, previous names become immediately invalidated.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.RenameNetworkRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.baremetalsolution.v2.Network])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.Network]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/network.proto#L36}
  /// [google.cloud.baremetalsolution.v2.RenameNetworkRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/network.proto#L349}
  ///
  // clang-format on
  StatusOr<google::cloud::baremetalsolution::v2::Network> RenameNetwork(
      google::cloud::baremetalsolution::v2::RenameNetworkRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves the list of OS images which are currently approved.
  ///
  /// @param parent  Required. Parent value for ListProvisioningQuotasRequest.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.baremetalsolution.v2.OSImage], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.ListOSImagesRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/osimage.proto#L58}
  /// [google.cloud.baremetalsolution.v2.OSImage]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/osimage.proto#L31}
  ///
  // clang-format on
  StreamRange<google::cloud::baremetalsolution::v2::OSImage> ListOSImages(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Retrieves the list of OS images which are currently approved.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.baremetalsolution.v2.ListOSImagesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.baremetalsolution.v2.OSImage], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.baremetalsolution.v2.ListOSImagesRequest]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/osimage.proto#L58}
  /// [google.cloud.baremetalsolution.v2.OSImage]: @googleapis_reference_link{google/cloud/baremetalsolution/v2/osimage.proto#L31}
  ///
  // clang-format on
  StreamRange<google::cloud::baremetalsolution::v2::OSImage> ListOSImages(
      google::cloud::baremetalsolution::v2::ListOSImagesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists information about the supported locations for this service.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.location.ListLocationsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.location.Location], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.location.ListLocationsRequest]: @googleapis_reference_link{google/cloud/location/locations.proto#L58}
  /// [google.cloud.location.Location]: @googleapis_reference_link{google/cloud/location/locations.proto#L88}
  ///
  // clang-format on
  StreamRange<google::cloud::location::Location> ListLocations(
      google::cloud::location::ListLocationsRequest request, Options opts = {});

  // clang-format off
  ///
  /// Gets information about a location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.location.GetLocationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.location.Location])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.location.GetLocationRequest]: @googleapis_reference_link{google/cloud/location/locations.proto#L82}
  /// [google.cloud.location.Location]: @googleapis_reference_link{google/cloud/location/locations.proto#L88}
  ///
  // clang-format on
  StatusOr<google::cloud::location::Location> GetLocation(
      google::cloud::location::GetLocationRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<BareMetalSolutionConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace baremetalsolution_v2
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BAREMETALSOLUTION_V2_BARE_METAL_SOLUTION_CLIENT_H
