// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/backupdr/v1/backupdr.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BACKUPDR_V1_MOCKS_MOCK_BACKUP_DR_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BACKUPDR_V1_MOCKS_MOCK_BACKUP_DR_CONNECTION_H

#include "google/cloud/backupdr/v1/backup_dr_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace backupdr_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `BackupDRConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `BackupDRClient`. To do so,
 * construct an object of type `BackupDRClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockBackupDRConnection : public backupdr_v1::BackupDRConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::backupdr::v1::ManagementServer>),
      ListManagementServers,
      (google::cloud::backupdr::v1::ListManagementServersRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::backupdr::v1::ManagementServer>,
      GetManagementServer,
      (google::cloud::backupdr::v1::GetManagementServerRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateManagementServer(Matcher<google::cloud::backupdr::v1::CreateManagementServerRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::backupdr::v1::ManagementServer>>,
              CreateManagementServer,
              (google::cloud::backupdr::v1::CreateManagementServerRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateManagementServer(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, CreateManagementServer,
              (NoAwaitTag,
               google::cloud::backupdr::v1::CreateManagementServerRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateManagementServer(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::backupdr::v1::ManagementServer>>,
              CreateManagementServer,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteManagementServer(Matcher<google::cloud::backupdr::v1::DeleteManagementServerRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::backupdr::v1::OperationMetadata>>,
              DeleteManagementServer,
              (google::cloud::backupdr::v1::DeleteManagementServerRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteManagementServer(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, DeleteManagementServer,
              (NoAwaitTag,
               google::cloud::backupdr::v1::DeleteManagementServerRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteManagementServer(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::backupdr::v1::OperationMetadata>>,
              DeleteManagementServer,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateBackupVault(Matcher<google::cloud::backupdr::v1::CreateBackupVaultRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::backupdr::v1::BackupVault>>,
      CreateBackupVault,
      (google::cloud::backupdr::v1::CreateBackupVaultRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateBackupVault(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateBackupVault,
      (NoAwaitTag,
       google::cloud::backupdr::v1::CreateBackupVaultRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateBackupVault(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::backupdr::v1::BackupVault>>,
              CreateBackupVault,
              (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD((StreamRange<google::cloud::backupdr::v1::BackupVault>),
              ListBackupVaults,
              (google::cloud::backupdr::v1::ListBackupVaultsRequest request),
              (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::backupdr::v1::BackupVault>),
      FetchUsableBackupVaults,
      (google::cloud::backupdr::v1::FetchUsableBackupVaultsRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::backupdr::v1::BackupVault>, GetBackupVault,
      (google::cloud::backupdr::v1::GetBackupVaultRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateBackupVault(Matcher<google::cloud::backupdr::v1::UpdateBackupVaultRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::backupdr::v1::BackupVault>>,
      UpdateBackupVault,
      (google::cloud::backupdr::v1::UpdateBackupVaultRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateBackupVault(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdateBackupVault,
      (NoAwaitTag,
       google::cloud::backupdr::v1::UpdateBackupVaultRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateBackupVault(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::backupdr::v1::BackupVault>>,
              UpdateBackupVault,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteBackupVault(Matcher<google::cloud::backupdr::v1::DeleteBackupVaultRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::backupdr::v1::OperationMetadata>>,
      DeleteBackupVault,
      (google::cloud::backupdr::v1::DeleteBackupVaultRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteBackupVault(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteBackupVault,
      (NoAwaitTag,
       google::cloud::backupdr::v1::DeleteBackupVaultRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteBackupVault(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::backupdr::v1::OperationMetadata>>,
              DeleteBackupVault,
              (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD((StreamRange<google::cloud::backupdr::v1::DataSource>),
              ListDataSources,
              (google::cloud::backupdr::v1::ListDataSourcesRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::backupdr::v1::DataSource>, GetDataSource,
      (google::cloud::backupdr::v1::GetDataSourceRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateDataSource(Matcher<google::cloud::backupdr::v1::UpdateDataSourceRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::backupdr::v1::DataSource>>,
      UpdateDataSource,
      (google::cloud::backupdr::v1::UpdateDataSourceRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateDataSource(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdateDataSource,
      (NoAwaitTag,
       google::cloud::backupdr::v1::UpdateDataSourceRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, UpdateDataSource(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::backupdr::v1::DataSource>>,
              UpdateDataSource,
              (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD((StreamRange<google::cloud::backupdr::v1::Backup>), ListBackups,
              (google::cloud::backupdr::v1::ListBackupsRequest request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::backupdr::v1::Backup>, GetBackup,
              (google::cloud::backupdr::v1::GetBackupRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateBackup(Matcher<google::cloud::backupdr::v1::UpdateBackupRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::backupdr::v1::Backup>>,
              UpdateBackup,
              (google::cloud::backupdr::v1::UpdateBackupRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateBackup(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, UpdateBackup,
              (NoAwaitTag,
               google::cloud::backupdr::v1::UpdateBackupRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, UpdateBackup(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::backupdr::v1::Backup>>,
              UpdateBackup, (google::longrunning::Operation const& operation),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteBackup(Matcher<google::cloud::backupdr::v1::DeleteBackupRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::backupdr::v1::Backup>>,
              DeleteBackup,
              (google::cloud::backupdr::v1::DeleteBackupRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteBackup(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, DeleteBackup,
              (NoAwaitTag,
               google::cloud::backupdr::v1::DeleteBackupRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, DeleteBackup(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::backupdr::v1::Backup>>,
              DeleteBackup, (google::longrunning::Operation const& operation),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// RestoreBackup(Matcher<google::cloud::backupdr::v1::RestoreBackupRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::backupdr::v1::RestoreBackupResponse>>,
      RestoreBackup,
      (google::cloud::backupdr::v1::RestoreBackupRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, RestoreBackup(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, RestoreBackup,
      (NoAwaitTag,
       google::cloud::backupdr::v1::RestoreBackupRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, RestoreBackup(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::backupdr::v1::RestoreBackupResponse>>,
      RestoreBackup, (google::longrunning::Operation const& operation),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateBackupPlan(Matcher<google::cloud::backupdr::v1::CreateBackupPlanRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::backupdr::v1::BackupPlan>>,
      CreateBackupPlan,
      (google::cloud::backupdr::v1::CreateBackupPlanRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateBackupPlan(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateBackupPlan,
      (NoAwaitTag,
       google::cloud::backupdr::v1::CreateBackupPlanRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, CreateBackupPlan(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::backupdr::v1::BackupPlan>>,
              CreateBackupPlan,
              (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD(
      StatusOr<google::cloud::backupdr::v1::BackupPlan>, GetBackupPlan,
      (google::cloud::backupdr::v1::GetBackupPlanRequest const& request),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::backupdr::v1::BackupPlan>),
              ListBackupPlans,
              (google::cloud::backupdr::v1::ListBackupPlansRequest request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteBackupPlan(Matcher<google::cloud::backupdr::v1::DeleteBackupPlanRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::backupdr::v1::OperationMetadata>>,
      DeleteBackupPlan,
      (google::cloud::backupdr::v1::DeleteBackupPlanRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteBackupPlan(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteBackupPlan,
      (NoAwaitTag,
       google::cloud::backupdr::v1::DeleteBackupPlanRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, DeleteBackupPlan(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::backupdr::v1::OperationMetadata>>,
              DeleteBackupPlan,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateBackupPlanAssociation(Matcher<google::cloud::backupdr::v1::CreateBackupPlanAssociationRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::backupdr::v1::BackupPlanAssociation>>,
      CreateBackupPlanAssociation,
      (google::cloud::backupdr::v1::CreateBackupPlanAssociationRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateBackupPlanAssociation(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateBackupPlanAssociation,
      (NoAwaitTag,
       google::cloud::backupdr::v1::CreateBackupPlanAssociationRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateBackupPlanAssociation(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::backupdr::v1::BackupPlanAssociation>>,
      CreateBackupPlanAssociation,
      (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD(
      StatusOr<google::cloud::backupdr::v1::BackupPlanAssociation>,
      GetBackupPlanAssociation,
      (google::cloud::backupdr::v1::GetBackupPlanAssociationRequest const&
           request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::backupdr::v1::BackupPlanAssociation>),
      ListBackupPlanAssociations,
      (google::cloud::backupdr::v1::ListBackupPlanAssociationsRequest request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteBackupPlanAssociation(Matcher<google::cloud::backupdr::v1::DeleteBackupPlanAssociationRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::backupdr::v1::OperationMetadata>>,
      DeleteBackupPlanAssociation,
      (google::cloud::backupdr::v1::DeleteBackupPlanAssociationRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteBackupPlanAssociation(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteBackupPlanAssociation,
      (NoAwaitTag,
       google::cloud::backupdr::v1::DeleteBackupPlanAssociationRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteBackupPlanAssociation(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::backupdr::v1::OperationMetadata>>,
              DeleteBackupPlanAssociation,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// TriggerBackup(Matcher<google::cloud::backupdr::v1::TriggerBackupRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::backupdr::v1::BackupPlanAssociation>>,
      TriggerBackup,
      (google::cloud::backupdr::v1::TriggerBackupRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, TriggerBackup(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, TriggerBackup,
      (NoAwaitTag,
       google::cloud::backupdr::v1::TriggerBackupRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, TriggerBackup(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::backupdr::v1::BackupPlanAssociation>>,
      TriggerBackup, (google::longrunning::Operation const& operation),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::location::Location>), ListLocations,
              (google::cloud::location::ListLocationsRequest request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::location::Location>, GetLocation,
              (google::cloud::location::GetLocationRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::iam::v1::Policy>, SetIamPolicy,
              (google::iam::v1::SetIamPolicyRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::iam::v1::Policy>, GetIamPolicy,
              (google::iam::v1::GetIamPolicyRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::iam::v1::TestIamPermissionsResponse>,
              TestIamPermissions,
              (google::iam::v1::TestIamPermissionsRequest const& request),
              (override));

  MOCK_METHOD((StreamRange<google::longrunning::Operation>), ListOperations,
              (google::longrunning::ListOperationsRequest request), (override));

  MOCK_METHOD(StatusOr<google::longrunning::Operation>, GetOperation,
              (google::longrunning::GetOperationRequest const& request),
              (override));

  MOCK_METHOD(Status, DeleteOperation,
              (google::longrunning::DeleteOperationRequest const& request),
              (override));

  MOCK_METHOD(Status, CancelOperation,
              (google::longrunning::CancelOperationRequest const& request),
              (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace backupdr_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BACKUPDR_V1_MOCKS_MOCK_BACKUP_DR_CONNECTION_H
