// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/backupdr/v1/backupdr.proto

#include "google/cloud/backupdr/v1/internal/backup_dr_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/backupdr/v1/backupdr.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace backupdr_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

BackupDRMetadata::BackupDRMetadata(
    std::shared_ptr<BackupDRStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::cloud::backupdr::v1::ListManagementServersResponse>
BackupDRMetadata::ListManagementServers(
    grpc::ClientContext& context, Options const& options,
    google::cloud::backupdr::v1::ListManagementServersRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListManagementServers(context, options, request);
}

StatusOr<google::cloud::backupdr::v1::ManagementServer>
BackupDRMetadata::GetManagementServer(
    grpc::ClientContext& context, Options const& options,
    google::cloud::backupdr::v1::GetManagementServerRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetManagementServer(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BackupDRMetadata::AsyncCreateManagementServer(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::backupdr::v1::CreateManagementServerRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateManagementServer(cq, std::move(context),
                                             std::move(options), request);
}

StatusOr<google::longrunning::Operation>
BackupDRMetadata::CreateManagementServer(
    grpc::ClientContext& context, Options options,
    google::cloud::backupdr::v1::CreateManagementServerRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateManagementServer(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BackupDRMetadata::AsyncDeleteManagementServer(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::backupdr::v1::DeleteManagementServerRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteManagementServer(cq, std::move(context),
                                             std::move(options), request);
}

StatusOr<google::longrunning::Operation>
BackupDRMetadata::DeleteManagementServer(
    grpc::ClientContext& context, Options options,
    google::cloud::backupdr::v1::DeleteManagementServerRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteManagementServer(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BackupDRMetadata::AsyncCreateBackupVault(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::backupdr::v1::CreateBackupVaultRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateBackupVault(cq, std::move(context),
                                        std::move(options), request);
}

StatusOr<google::longrunning::Operation> BackupDRMetadata::CreateBackupVault(
    grpc::ClientContext& context, Options options,
    google::cloud::backupdr::v1::CreateBackupVaultRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateBackupVault(context, options, request);
}

StatusOr<google::cloud::backupdr::v1::ListBackupVaultsResponse>
BackupDRMetadata::ListBackupVaults(
    grpc::ClientContext& context, Options const& options,
    google::cloud::backupdr::v1::ListBackupVaultsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListBackupVaults(context, options, request);
}

StatusOr<google::cloud::backupdr::v1::FetchUsableBackupVaultsResponse>
BackupDRMetadata::FetchUsableBackupVaults(
    grpc::ClientContext& context, Options const& options,
    google::cloud::backupdr::v1::FetchUsableBackupVaultsRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->FetchUsableBackupVaults(context, options, request);
}

StatusOr<google::cloud::backupdr::v1::BackupVault>
BackupDRMetadata::GetBackupVault(
    grpc::ClientContext& context, Options const& options,
    google::cloud::backupdr::v1::GetBackupVaultRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetBackupVault(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BackupDRMetadata::AsyncUpdateBackupVault(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::backupdr::v1::UpdateBackupVaultRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("backup_vault.name=",
                           internal::UrlEncode(request.backup_vault().name())));
  return child_->AsyncUpdateBackupVault(cq, std::move(context),
                                        std::move(options), request);
}

StatusOr<google::longrunning::Operation> BackupDRMetadata::UpdateBackupVault(
    grpc::ClientContext& context, Options options,
    google::cloud::backupdr::v1::UpdateBackupVaultRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("backup_vault.name=",
                           internal::UrlEncode(request.backup_vault().name())));
  return child_->UpdateBackupVault(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BackupDRMetadata::AsyncDeleteBackupVault(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::backupdr::v1::DeleteBackupVaultRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteBackupVault(cq, std::move(context),
                                        std::move(options), request);
}

StatusOr<google::longrunning::Operation> BackupDRMetadata::DeleteBackupVault(
    grpc::ClientContext& context, Options options,
    google::cloud::backupdr::v1::DeleteBackupVaultRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteBackupVault(context, options, request);
}

StatusOr<google::cloud::backupdr::v1::ListDataSourcesResponse>
BackupDRMetadata::ListDataSources(
    grpc::ClientContext& context, Options const& options,
    google::cloud::backupdr::v1::ListDataSourcesRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListDataSources(context, options, request);
}

StatusOr<google::cloud::backupdr::v1::DataSource>
BackupDRMetadata::GetDataSource(
    grpc::ClientContext& context, Options const& options,
    google::cloud::backupdr::v1::GetDataSourceRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetDataSource(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BackupDRMetadata::AsyncUpdateDataSource(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::backupdr::v1::UpdateDataSourceRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("data_source.name=",
                           internal::UrlEncode(request.data_source().name())));
  return child_->AsyncUpdateDataSource(cq, std::move(context),
                                       std::move(options), request);
}

StatusOr<google::longrunning::Operation> BackupDRMetadata::UpdateDataSource(
    grpc::ClientContext& context, Options options,
    google::cloud::backupdr::v1::UpdateDataSourceRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("data_source.name=",
                           internal::UrlEncode(request.data_source().name())));
  return child_->UpdateDataSource(context, options, request);
}

StatusOr<google::cloud::backupdr::v1::ListBackupsResponse>
BackupDRMetadata::ListBackups(
    grpc::ClientContext& context, Options const& options,
    google::cloud::backupdr::v1::ListBackupsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListBackups(context, options, request);
}

StatusOr<google::cloud::backupdr::v1::Backup> BackupDRMetadata::GetBackup(
    grpc::ClientContext& context, Options const& options,
    google::cloud::backupdr::v1::GetBackupRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetBackup(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BackupDRMetadata::AsyncUpdateBackup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::backupdr::v1::UpdateBackupRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("backup.name=",
                           internal::UrlEncode(request.backup().name())));
  return child_->AsyncUpdateBackup(cq, std::move(context), std::move(options),
                                   request);
}

StatusOr<google::longrunning::Operation> BackupDRMetadata::UpdateBackup(
    grpc::ClientContext& context, Options options,
    google::cloud::backupdr::v1::UpdateBackupRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("backup.name=",
                           internal::UrlEncode(request.backup().name())));
  return child_->UpdateBackup(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BackupDRMetadata::AsyncDeleteBackup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::backupdr::v1::DeleteBackupRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteBackup(cq, std::move(context), std::move(options),
                                   request);
}

StatusOr<google::longrunning::Operation> BackupDRMetadata::DeleteBackup(
    grpc::ClientContext& context, Options options,
    google::cloud::backupdr::v1::DeleteBackupRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteBackup(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BackupDRMetadata::AsyncRestoreBackup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::backupdr::v1::RestoreBackupRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncRestoreBackup(cq, std::move(context), std::move(options),
                                    request);
}

StatusOr<google::longrunning::Operation> BackupDRMetadata::RestoreBackup(
    grpc::ClientContext& context, Options options,
    google::cloud::backupdr::v1::RestoreBackupRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->RestoreBackup(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BackupDRMetadata::AsyncCreateBackupPlan(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::backupdr::v1::CreateBackupPlanRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateBackupPlan(cq, std::move(context),
                                       std::move(options), request);
}

StatusOr<google::longrunning::Operation> BackupDRMetadata::CreateBackupPlan(
    grpc::ClientContext& context, Options options,
    google::cloud::backupdr::v1::CreateBackupPlanRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateBackupPlan(context, options, request);
}

StatusOr<google::cloud::backupdr::v1::BackupPlan>
BackupDRMetadata::GetBackupPlan(
    grpc::ClientContext& context, Options const& options,
    google::cloud::backupdr::v1::GetBackupPlanRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetBackupPlan(context, options, request);
}

StatusOr<google::cloud::backupdr::v1::ListBackupPlansResponse>
BackupDRMetadata::ListBackupPlans(
    grpc::ClientContext& context, Options const& options,
    google::cloud::backupdr::v1::ListBackupPlansRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListBackupPlans(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BackupDRMetadata::AsyncDeleteBackupPlan(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::backupdr::v1::DeleteBackupPlanRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteBackupPlan(cq, std::move(context),
                                       std::move(options), request);
}

StatusOr<google::longrunning::Operation> BackupDRMetadata::DeleteBackupPlan(
    grpc::ClientContext& context, Options options,
    google::cloud::backupdr::v1::DeleteBackupPlanRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteBackupPlan(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BackupDRMetadata::AsyncCreateBackupPlanAssociation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::backupdr::v1::CreateBackupPlanAssociationRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateBackupPlanAssociation(cq, std::move(context),
                                                  std::move(options), request);
}

StatusOr<google::longrunning::Operation>
BackupDRMetadata::CreateBackupPlanAssociation(
    grpc::ClientContext& context, Options options,
    google::cloud::backupdr::v1::CreateBackupPlanAssociationRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateBackupPlanAssociation(context, options, request);
}

StatusOr<google::cloud::backupdr::v1::BackupPlanAssociation>
BackupDRMetadata::GetBackupPlanAssociation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::backupdr::v1::GetBackupPlanAssociationRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetBackupPlanAssociation(context, options, request);
}

StatusOr<google::cloud::backupdr::v1::ListBackupPlanAssociationsResponse>
BackupDRMetadata::ListBackupPlanAssociations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::backupdr::v1::ListBackupPlanAssociationsRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListBackupPlanAssociations(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BackupDRMetadata::AsyncDeleteBackupPlanAssociation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::backupdr::v1::DeleteBackupPlanAssociationRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteBackupPlanAssociation(cq, std::move(context),
                                                  std::move(options), request);
}

StatusOr<google::longrunning::Operation>
BackupDRMetadata::DeleteBackupPlanAssociation(
    grpc::ClientContext& context, Options options,
    google::cloud::backupdr::v1::DeleteBackupPlanAssociationRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteBackupPlanAssociation(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BackupDRMetadata::AsyncTriggerBackup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::backupdr::v1::TriggerBackupRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncTriggerBackup(cq, std::move(context), std::move(options),
                                    request);
}

StatusOr<google::longrunning::Operation> BackupDRMetadata::TriggerBackup(
    grpc::ClientContext& context, Options options,
    google::cloud::backupdr::v1::TriggerBackupRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->TriggerBackup(context, options, request);
}

StatusOr<google::cloud::location::ListLocationsResponse>
BackupDRMetadata::ListLocations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::ListLocationsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->ListLocations(context, options, request);
}

StatusOr<google::cloud::location::Location> BackupDRMetadata::GetLocation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::GetLocationRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetLocation(context, options, request);
}

StatusOr<google::iam::v1::Policy> BackupDRMetadata::SetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::SetIamPolicyRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->SetIamPolicy(context, options, request);
}

StatusOr<google::iam::v1::Policy> BackupDRMetadata::GetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::GetIamPolicyRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->GetIamPolicy(context, options, request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
BackupDRMetadata::TestIamPermissions(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->TestIamPermissions(context, options, request);
}

StatusOr<google::longrunning::ListOperationsResponse>
BackupDRMetadata::ListOperations(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::ListOperationsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->ListOperations(context, options, request);
}

StatusOr<google::longrunning::Operation> BackupDRMetadata::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetOperation(context, options, request);
}

Status BackupDRMetadata::DeleteOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::DeleteOperationRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteOperation(context, options, request);
}

Status BackupDRMetadata::CancelOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->CancelOperation(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BackupDRMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncGetOperation(cq, std::move(context), std::move(options),
                                   request);
}

future<Status> BackupDRMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncCancelOperation(cq, std::move(context),
                                      std::move(options), request);
}

void BackupDRMetadata::SetMetadata(grpc::ClientContext& context,
                                   Options const& options,
                                   std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void BackupDRMetadata::SetMetadata(grpc::ClientContext& context,
                                   Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace backupdr_v1_internal
}  // namespace cloud
}  // namespace google
