// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/backupdr/v1/backupdr.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BACKUPDR_V1_INTERNAL_BACKUP_DR_AUTH_DECORATOR_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BACKUPDR_V1_INTERNAL_BACKUP_DR_AUTH_DECORATOR_H

#include "google/cloud/backupdr/v1/internal/backup_dr_stub.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <set>
#include <string>

namespace google {
namespace cloud {
namespace backupdr_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class BackupDRAuth : public BackupDRStub {
 public:
  ~BackupDRAuth() override = default;
  BackupDRAuth(
      std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
      std::shared_ptr<BackupDRStub> child);

  StatusOr<google::cloud::backupdr::v1::ListManagementServersResponse>
  ListManagementServers(
      grpc::ClientContext& context, Options const& options,
      google::cloud::backupdr::v1::ListManagementServersRequest const& request)
      override;

  StatusOr<google::cloud::backupdr::v1::ManagementServer> GetManagementServer(
      grpc::ClientContext& context, Options const& options,
      google::cloud::backupdr::v1::GetManagementServerRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateManagementServer(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::backupdr::v1::CreateManagementServerRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateManagementServer(
      grpc::ClientContext& context, Options options,
      google::cloud::backupdr::v1::CreateManagementServerRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteManagementServer(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::backupdr::v1::DeleteManagementServerRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteManagementServer(
      grpc::ClientContext& context, Options options,
      google::cloud::backupdr::v1::DeleteManagementServerRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateBackupVault(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::backupdr::v1::CreateBackupVaultRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateBackupVault(
      grpc::ClientContext& context, Options options,
      google::cloud::backupdr::v1::CreateBackupVaultRequest const& request)
      override;

  StatusOr<google::cloud::backupdr::v1::ListBackupVaultsResponse>
  ListBackupVaults(grpc::ClientContext& context, Options const& options,
                   google::cloud::backupdr::v1::ListBackupVaultsRequest const&
                       request) override;

  StatusOr<google::cloud::backupdr::v1::FetchUsableBackupVaultsResponse>
  FetchUsableBackupVaults(
      grpc::ClientContext& context, Options const& options,
      google::cloud::backupdr::v1::FetchUsableBackupVaultsRequest const&
          request) override;

  StatusOr<google::cloud::backupdr::v1::BackupVault> GetBackupVault(
      grpc::ClientContext& context, Options const& options,
      google::cloud::backupdr::v1::GetBackupVaultRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncUpdateBackupVault(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::backupdr::v1::UpdateBackupVaultRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateBackupVault(
      grpc::ClientContext& context, Options options,
      google::cloud::backupdr::v1::UpdateBackupVaultRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteBackupVault(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::backupdr::v1::DeleteBackupVaultRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteBackupVault(
      grpc::ClientContext& context, Options options,
      google::cloud::backupdr::v1::DeleteBackupVaultRequest const& request)
      override;

  StatusOr<google::cloud::backupdr::v1::ListDataSourcesResponse>
  ListDataSources(grpc::ClientContext& context, Options const& options,
                  google::cloud::backupdr::v1::ListDataSourcesRequest const&
                      request) override;

  StatusOr<google::cloud::backupdr::v1::DataSource> GetDataSource(
      grpc::ClientContext& context, Options const& options,
      google::cloud::backupdr::v1::GetDataSourceRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncUpdateDataSource(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::backupdr::v1::UpdateDataSourceRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateDataSource(
      grpc::ClientContext& context, Options options,
      google::cloud::backupdr::v1::UpdateDataSourceRequest const& request)
      override;

  StatusOr<google::cloud::backupdr::v1::ListBackupsResponse> ListBackups(
      grpc::ClientContext& context, Options const& options,
      google::cloud::backupdr::v1::ListBackupsRequest const& request) override;

  StatusOr<google::cloud::backupdr::v1::Backup> GetBackup(
      grpc::ClientContext& context, Options const& options,
      google::cloud::backupdr::v1::GetBackupRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncUpdateBackup(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::backupdr::v1::UpdateBackupRequest const& request) override;

  StatusOr<google::longrunning::Operation> UpdateBackup(
      grpc::ClientContext& context, Options options,
      google::cloud::backupdr::v1::UpdateBackupRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteBackup(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::backupdr::v1::DeleteBackupRequest const& request) override;

  StatusOr<google::longrunning::Operation> DeleteBackup(
      grpc::ClientContext& context, Options options,
      google::cloud::backupdr::v1::DeleteBackupRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncRestoreBackup(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::backupdr::v1::RestoreBackupRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> RestoreBackup(
      grpc::ClientContext& context, Options options,
      google::cloud::backupdr::v1::RestoreBackupRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateBackupPlan(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::backupdr::v1::CreateBackupPlanRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateBackupPlan(
      grpc::ClientContext& context, Options options,
      google::cloud::backupdr::v1::CreateBackupPlanRequest const& request)
      override;

  StatusOr<google::cloud::backupdr::v1::BackupPlan> GetBackupPlan(
      grpc::ClientContext& context, Options const& options,
      google::cloud::backupdr::v1::GetBackupPlanRequest const& request)
      override;

  StatusOr<google::cloud::backupdr::v1::ListBackupPlansResponse>
  ListBackupPlans(grpc::ClientContext& context, Options const& options,
                  google::cloud::backupdr::v1::ListBackupPlansRequest const&
                      request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteBackupPlan(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::backupdr::v1::DeleteBackupPlanRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteBackupPlan(
      grpc::ClientContext& context, Options options,
      google::cloud::backupdr::v1::DeleteBackupPlanRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>>
  AsyncCreateBackupPlanAssociation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::backupdr::v1::CreateBackupPlanAssociationRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> CreateBackupPlanAssociation(
      grpc::ClientContext& context, Options options,
      google::cloud::backupdr::v1::CreateBackupPlanAssociationRequest const&
          request) override;

  StatusOr<google::cloud::backupdr::v1::BackupPlanAssociation>
  GetBackupPlanAssociation(
      grpc::ClientContext& context, Options const& options,
      google::cloud::backupdr::v1::GetBackupPlanAssociationRequest const&
          request) override;

  StatusOr<google::cloud::backupdr::v1::ListBackupPlanAssociationsResponse>
  ListBackupPlanAssociations(
      grpc::ClientContext& context, Options const& options,
      google::cloud::backupdr::v1::ListBackupPlanAssociationsRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>>
  AsyncDeleteBackupPlanAssociation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::backupdr::v1::DeleteBackupPlanAssociationRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteBackupPlanAssociation(
      grpc::ClientContext& context, Options options,
      google::cloud::backupdr::v1::DeleteBackupPlanAssociationRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncTriggerBackup(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::backupdr::v1::TriggerBackupRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> TriggerBackup(
      grpc::ClientContext& context, Options options,
      google::cloud::backupdr::v1::TriggerBackupRequest const& request)
      override;

  StatusOr<google::cloud::location::ListLocationsResponse> ListLocations(
      grpc::ClientContext& context, Options const& options,
      google::cloud::location::ListLocationsRequest const& request) override;

  StatusOr<google::cloud::location::Location> GetLocation(
      grpc::ClientContext& context, Options const& options,
      google::cloud::location::GetLocationRequest const& request) override;

  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::SetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::GetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::TestIamPermissionsRequest const& request) override;

  StatusOr<google::longrunning::ListOperationsResponse> ListOperations(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::ListOperationsRequest const& request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::GetOperationRequest const& request) override;

  Status DeleteOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::DeleteOperationRequest const& request) override;

  Status CancelOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::CancelOperationRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::GetOperationRequest const& request) override;

  future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth_;
  std::shared_ptr<BackupDRStub> child_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace backupdr_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BACKUPDR_V1_INTERNAL_BACKUP_DR_AUTH_DECORATOR_H
