// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/backupdr/v1/backupdr.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BACKUPDR_V1_BACKUP_DR_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BACKUPDR_V1_BACKUP_DR_CONNECTION_H

#include "google/cloud/backupdr/v1/backup_dr_connection_idempotency_policy.h"
#include "google/cloud/backupdr/v1/internal/backup_dr_retry_traits.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/backupdr/v1/backupdr.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace backupdr_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `BackupDRConnection`.
class BackupDRRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<BackupDRRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `BackupDRConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class BackupDRLimitedErrorCountRetryPolicy : public BackupDRRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit BackupDRLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  BackupDRLimitedErrorCountRetryPolicy(
      BackupDRLimitedErrorCountRetryPolicy&& rhs) noexcept
      : BackupDRLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}
  BackupDRLimitedErrorCountRetryPolicy(
      BackupDRLimitedErrorCountRetryPolicy const& rhs) noexcept
      : BackupDRLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<BackupDRRetryPolicy> clone() const override {
    return std::make_unique<BackupDRLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = BackupDRRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      backupdr_v1_internal::BackupDRRetryTraits>
      impl_;
};

/**
 * A retry policy for `BackupDRConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class BackupDRLimitedTimeRetryPolicy : public BackupDRRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit BackupDRLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  BackupDRLimitedTimeRetryPolicy(BackupDRLimitedTimeRetryPolicy&& rhs) noexcept
      : BackupDRLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  BackupDRLimitedTimeRetryPolicy(
      BackupDRLimitedTimeRetryPolicy const& rhs) noexcept
      : BackupDRLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<BackupDRRetryPolicy> clone() const override {
    return std::make_unique<BackupDRLimitedTimeRetryPolicy>(maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = BackupDRRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      backupdr_v1_internal::BackupDRRetryTraits>
      impl_;
};

/**
 * The `BackupDRConnection` object for `BackupDRClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `BackupDRClient`. This allows users to inject custom behavior
 * (e.g., with a Google Mock object) when writing tests that use objects of type
 * `BackupDRClient`.
 *
 * To create a concrete instance, see `MakeBackupDRConnection()`.
 *
 * For mocking, see `backupdr_v1_mocks::MockBackupDRConnection`.
 */
class BackupDRConnection {
 public:
  virtual ~BackupDRConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StreamRange<google::cloud::backupdr::v1::ManagementServer>
  ListManagementServers(
      google::cloud::backupdr::v1::ListManagementServersRequest request);

  virtual StatusOr<google::cloud::backupdr::v1::ManagementServer>
  GetManagementServer(
      google::cloud::backupdr::v1::GetManagementServerRequest const& request);

  virtual future<StatusOr<google::cloud::backupdr::v1::ManagementServer>>
  CreateManagementServer(
      google::cloud::backupdr::v1::CreateManagementServerRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> CreateManagementServer(
      NoAwaitTag,
      google::cloud::backupdr::v1::CreateManagementServerRequest const&
          request);

  virtual future<StatusOr<google::cloud::backupdr::v1::ManagementServer>>
  CreateManagementServer(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::backupdr::v1::OperationMetadata>>
  DeleteManagementServer(
      google::cloud::backupdr::v1::DeleteManagementServerRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> DeleteManagementServer(
      NoAwaitTag,
      google::cloud::backupdr::v1::DeleteManagementServerRequest const&
          request);

  virtual future<StatusOr<google::cloud::backupdr::v1::OperationMetadata>>
  DeleteManagementServer(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::backupdr::v1::BackupVault>>
  CreateBackupVault(
      google::cloud::backupdr::v1::CreateBackupVaultRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CreateBackupVault(
      NoAwaitTag,
      google::cloud::backupdr::v1::CreateBackupVaultRequest const& request);

  virtual future<StatusOr<google::cloud::backupdr::v1::BackupVault>>
  CreateBackupVault(google::longrunning::Operation const& operation);

  virtual StreamRange<google::cloud::backupdr::v1::BackupVault>
  ListBackupVaults(
      google::cloud::backupdr::v1::ListBackupVaultsRequest request);

  virtual StreamRange<google::cloud::backupdr::v1::BackupVault>
  FetchUsableBackupVaults(
      google::cloud::backupdr::v1::FetchUsableBackupVaultsRequest request);

  virtual StatusOr<google::cloud::backupdr::v1::BackupVault> GetBackupVault(
      google::cloud::backupdr::v1::GetBackupVaultRequest const& request);

  virtual future<StatusOr<google::cloud::backupdr::v1::BackupVault>>
  UpdateBackupVault(
      google::cloud::backupdr::v1::UpdateBackupVaultRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpdateBackupVault(
      NoAwaitTag,
      google::cloud::backupdr::v1::UpdateBackupVaultRequest const& request);

  virtual future<StatusOr<google::cloud::backupdr::v1::BackupVault>>
  UpdateBackupVault(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::backupdr::v1::OperationMetadata>>
  DeleteBackupVault(
      google::cloud::backupdr::v1::DeleteBackupVaultRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeleteBackupVault(
      NoAwaitTag,
      google::cloud::backupdr::v1::DeleteBackupVaultRequest const& request);

  virtual future<StatusOr<google::cloud::backupdr::v1::OperationMetadata>>
  DeleteBackupVault(google::longrunning::Operation const& operation);

  virtual StreamRange<google::cloud::backupdr::v1::DataSource> ListDataSources(
      google::cloud::backupdr::v1::ListDataSourcesRequest request);

  virtual StatusOr<google::cloud::backupdr::v1::DataSource> GetDataSource(
      google::cloud::backupdr::v1::GetDataSourceRequest const& request);

  virtual future<StatusOr<google::cloud::backupdr::v1::DataSource>>
  UpdateDataSource(
      google::cloud::backupdr::v1::UpdateDataSourceRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpdateDataSource(
      NoAwaitTag,
      google::cloud::backupdr::v1::UpdateDataSourceRequest const& request);

  virtual future<StatusOr<google::cloud::backupdr::v1::DataSource>>
  UpdateDataSource(google::longrunning::Operation const& operation);

  virtual StreamRange<google::cloud::backupdr::v1::Backup> ListBackups(
      google::cloud::backupdr::v1::ListBackupsRequest request);

  virtual StatusOr<google::cloud::backupdr::v1::Backup> GetBackup(
      google::cloud::backupdr::v1::GetBackupRequest const& request);

  virtual future<StatusOr<google::cloud::backupdr::v1::Backup>> UpdateBackup(
      google::cloud::backupdr::v1::UpdateBackupRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpdateBackup(
      NoAwaitTag,
      google::cloud::backupdr::v1::UpdateBackupRequest const& request);

  virtual future<StatusOr<google::cloud::backupdr::v1::Backup>> UpdateBackup(
      google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::backupdr::v1::Backup>> DeleteBackup(
      google::cloud::backupdr::v1::DeleteBackupRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeleteBackup(
      NoAwaitTag,
      google::cloud::backupdr::v1::DeleteBackupRequest const& request);

  virtual future<StatusOr<google::cloud::backupdr::v1::Backup>> DeleteBackup(
      google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::backupdr::v1::RestoreBackupResponse>>
  RestoreBackup(
      google::cloud::backupdr::v1::RestoreBackupRequest const& request);

  virtual StatusOr<google::longrunning::Operation> RestoreBackup(
      NoAwaitTag,
      google::cloud::backupdr::v1::RestoreBackupRequest const& request);

  virtual future<StatusOr<google::cloud::backupdr::v1::RestoreBackupResponse>>
  RestoreBackup(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::backupdr::v1::BackupPlan>>
  CreateBackupPlan(
      google::cloud::backupdr::v1::CreateBackupPlanRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CreateBackupPlan(
      NoAwaitTag,
      google::cloud::backupdr::v1::CreateBackupPlanRequest const& request);

  virtual future<StatusOr<google::cloud::backupdr::v1::BackupPlan>>
  CreateBackupPlan(google::longrunning::Operation const& operation);

  virtual StatusOr<google::cloud::backupdr::v1::BackupPlan> GetBackupPlan(
      google::cloud::backupdr::v1::GetBackupPlanRequest const& request);

  virtual StreamRange<google::cloud::backupdr::v1::BackupPlan> ListBackupPlans(
      google::cloud::backupdr::v1::ListBackupPlansRequest request);

  virtual future<StatusOr<google::cloud::backupdr::v1::OperationMetadata>>
  DeleteBackupPlan(
      google::cloud::backupdr::v1::DeleteBackupPlanRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeleteBackupPlan(
      NoAwaitTag,
      google::cloud::backupdr::v1::DeleteBackupPlanRequest const& request);

  virtual future<StatusOr<google::cloud::backupdr::v1::OperationMetadata>>
  DeleteBackupPlan(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::backupdr::v1::BackupPlanAssociation>>
  CreateBackupPlanAssociation(
      google::cloud::backupdr::v1::CreateBackupPlanAssociationRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> CreateBackupPlanAssociation(
      NoAwaitTag,
      google::cloud::backupdr::v1::CreateBackupPlanAssociationRequest const&
          request);

  virtual future<StatusOr<google::cloud::backupdr::v1::BackupPlanAssociation>>
  CreateBackupPlanAssociation(google::longrunning::Operation const& operation);

  virtual StatusOr<google::cloud::backupdr::v1::BackupPlanAssociation>
  GetBackupPlanAssociation(
      google::cloud::backupdr::v1::GetBackupPlanAssociationRequest const&
          request);

  virtual StreamRange<google::cloud::backupdr::v1::BackupPlanAssociation>
  ListBackupPlanAssociations(
      google::cloud::backupdr::v1::ListBackupPlanAssociationsRequest request);

  virtual future<StatusOr<google::cloud::backupdr::v1::OperationMetadata>>
  DeleteBackupPlanAssociation(
      google::cloud::backupdr::v1::DeleteBackupPlanAssociationRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> DeleteBackupPlanAssociation(
      NoAwaitTag,
      google::cloud::backupdr::v1::DeleteBackupPlanAssociationRequest const&
          request);

  virtual future<StatusOr<google::cloud::backupdr::v1::OperationMetadata>>
  DeleteBackupPlanAssociation(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::backupdr::v1::BackupPlanAssociation>>
  TriggerBackup(
      google::cloud::backupdr::v1::TriggerBackupRequest const& request);

  virtual StatusOr<google::longrunning::Operation> TriggerBackup(
      NoAwaitTag,
      google::cloud::backupdr::v1::TriggerBackupRequest const& request);

  virtual future<StatusOr<google::cloud::backupdr::v1::BackupPlanAssociation>>
  TriggerBackup(google::longrunning::Operation const& operation);

  virtual StreamRange<google::cloud::location::Location> ListLocations(
      google::cloud::location::ListLocationsRequest request);

  virtual StatusOr<google::cloud::location::Location> GetLocation(
      google::cloud::location::GetLocationRequest const& request);

  virtual StatusOr<google::iam::v1::Policy> SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request);

  virtual StatusOr<google::iam::v1::Policy> GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request);

  virtual StatusOr<google::iam::v1::TestIamPermissionsResponse>
  TestIamPermissions(google::iam::v1::TestIamPermissionsRequest const& request);

  virtual StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request);

  virtual StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request);

  virtual Status DeleteOperation(
      google::longrunning::DeleteOperationRequest const& request);

  virtual Status CancelOperation(
      google::longrunning::CancelOperationRequest const& request);
};

/**
 * A factory function to construct an object of type `BackupDRConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of BackupDRClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `BackupDRConnection`. Expected options are any of the types in
 * the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::backupdr_v1::BackupDRPolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `BackupDRConnection` created by
 * this function.
 */
std::shared_ptr<BackupDRConnection> MakeBackupDRConnection(
    Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace backupdr_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BACKUPDR_V1_BACKUP_DR_CONNECTION_H
