// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/assuredworkloads/v1/assuredworkloads.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ASSUREDWORKLOADS_V1_ASSURED_WORKLOADS_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ASSUREDWORKLOADS_V1_ASSURED_WORKLOADS_CONNECTION_H

#include "google/cloud/assuredworkloads/v1/assured_workloads_connection_idempotency_policy.h"
#include "google/cloud/assuredworkloads/v1/internal/assured_workloads_retry_traits.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/assuredworkloads/v1/assuredworkloads.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace assuredworkloads_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `AssuredWorkloadsServiceConnection`.
class AssuredWorkloadsServiceRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<AssuredWorkloadsServiceRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `AssuredWorkloadsServiceConnection` based on counting
 * errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class AssuredWorkloadsServiceLimitedErrorCountRetryPolicy
    : public AssuredWorkloadsServiceRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit AssuredWorkloadsServiceLimitedErrorCountRetryPolicy(
      int maximum_failures)
      : impl_(maximum_failures) {}

  AssuredWorkloadsServiceLimitedErrorCountRetryPolicy(
      AssuredWorkloadsServiceLimitedErrorCountRetryPolicy&& rhs) noexcept
      : AssuredWorkloadsServiceLimitedErrorCountRetryPolicy(
            rhs.maximum_failures()) {}
  AssuredWorkloadsServiceLimitedErrorCountRetryPolicy(
      AssuredWorkloadsServiceLimitedErrorCountRetryPolicy const& rhs) noexcept
      : AssuredWorkloadsServiceLimitedErrorCountRetryPolicy(
            rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<AssuredWorkloadsServiceRetryPolicy> clone() const override {
    return std::make_unique<
        AssuredWorkloadsServiceLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = AssuredWorkloadsServiceRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      assuredworkloads_v1_internal::AssuredWorkloadsServiceRetryTraits>
      impl_;
};

/**
 * A retry policy for `AssuredWorkloadsServiceConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class AssuredWorkloadsServiceLimitedTimeRetryPolicy
    : public AssuredWorkloadsServiceRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit AssuredWorkloadsServiceLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  AssuredWorkloadsServiceLimitedTimeRetryPolicy(
      AssuredWorkloadsServiceLimitedTimeRetryPolicy&& rhs) noexcept
      : AssuredWorkloadsServiceLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  AssuredWorkloadsServiceLimitedTimeRetryPolicy(
      AssuredWorkloadsServiceLimitedTimeRetryPolicy const& rhs) noexcept
      : AssuredWorkloadsServiceLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<AssuredWorkloadsServiceRetryPolicy> clone() const override {
    return std::make_unique<AssuredWorkloadsServiceLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = AssuredWorkloadsServiceRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      assuredworkloads_v1_internal::AssuredWorkloadsServiceRetryTraits>
      impl_;
};

/**
 * The `AssuredWorkloadsServiceConnection` object for
 * `AssuredWorkloadsServiceClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `AssuredWorkloadsServiceClient`. This allows users to inject custom
 * behavior (e.g., with a Google Mock object) when writing tests that use
 * objects of type `AssuredWorkloadsServiceClient`.
 *
 * To create a concrete instance, see `MakeAssuredWorkloadsServiceConnection()`.
 *
 * For mocking, see
 * `assuredworkloads_v1_mocks::MockAssuredWorkloadsServiceConnection`.
 */
class AssuredWorkloadsServiceConnection {
 public:
  virtual ~AssuredWorkloadsServiceConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual future<StatusOr<google::cloud::assuredworkloads::v1::Workload>>
  CreateWorkload(
      google::cloud::assuredworkloads::v1::CreateWorkloadRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> CreateWorkload(
      NoAwaitTag,
      google::cloud::assuredworkloads::v1::CreateWorkloadRequest const&
          request);

  virtual future<StatusOr<google::cloud::assuredworkloads::v1::Workload>>
  CreateWorkload(google::longrunning::Operation const& operation);

  virtual StatusOr<google::cloud::assuredworkloads::v1::Workload>
  UpdateWorkload(
      google::cloud::assuredworkloads::v1::UpdateWorkloadRequest const&
          request);

  virtual StatusOr<
      google::cloud::assuredworkloads::v1::RestrictAllowedResourcesResponse>
  RestrictAllowedResources(google::cloud::assuredworkloads::v1::
                               RestrictAllowedResourcesRequest const& request);

  virtual Status DeleteWorkload(
      google::cloud::assuredworkloads::v1::DeleteWorkloadRequest const&
          request);

  virtual StatusOr<google::cloud::assuredworkloads::v1::Workload> GetWorkload(
      google::cloud::assuredworkloads::v1::GetWorkloadRequest const& request);

  virtual StreamRange<google::cloud::assuredworkloads::v1::Workload>
  ListWorkloads(
      google::cloud::assuredworkloads::v1::ListWorkloadsRequest request);

  virtual StreamRange<google::cloud::assuredworkloads::v1::Violation>
  ListViolations(
      google::cloud::assuredworkloads::v1::ListViolationsRequest request);

  virtual StatusOr<google::cloud::assuredworkloads::v1::Violation> GetViolation(
      google::cloud::assuredworkloads::v1::GetViolationRequest const& request);

  virtual StatusOr<
      google::cloud::assuredworkloads::v1::AcknowledgeViolationResponse>
  AcknowledgeViolation(
      google::cloud::assuredworkloads::v1::AcknowledgeViolationRequest const&
          request);

  virtual StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request);

  virtual StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request);
};

/**
 * A factory function to construct an object of type
 * `AssuredWorkloadsServiceConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of
 * AssuredWorkloadsServiceClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `AssuredWorkloadsServiceConnection`. Expected options are any of the
 * types in the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * -
 * `google::cloud::assuredworkloads_v1::AssuredWorkloadsServicePolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `AssuredWorkloadsServiceConnection`
 * created by this function.
 */
std::shared_ptr<AssuredWorkloadsServiceConnection>
MakeAssuredWorkloadsServiceConnection(Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace assuredworkloads_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ASSUREDWORKLOADS_V1_ASSURED_WORKLOADS_CONNECTION_H
