// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/assuredworkloads/v1/assuredworkloads.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ASSUREDWORKLOADS_V1_ASSURED_WORKLOADS_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ASSUREDWORKLOADS_V1_ASSURED_WORKLOADS_CLIENT_H

#include "google/cloud/assuredworkloads/v1/assured_workloads_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace assuredworkloads_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Service to manage AssuredWorkloads.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class AssuredWorkloadsServiceClient {
 public:
  explicit AssuredWorkloadsServiceClient(
      std::shared_ptr<AssuredWorkloadsServiceConnection> connection,
      Options opts = {});
  ~AssuredWorkloadsServiceClient();

  ///@{
  /// @name Copy and move support
  AssuredWorkloadsServiceClient(AssuredWorkloadsServiceClient const&) = default;
  AssuredWorkloadsServiceClient& operator=(
      AssuredWorkloadsServiceClient const&) = default;
  AssuredWorkloadsServiceClient(AssuredWorkloadsServiceClient&&) = default;
  AssuredWorkloadsServiceClient& operator=(AssuredWorkloadsServiceClient&&) =
      default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(AssuredWorkloadsServiceClient const& a,
                         AssuredWorkloadsServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(AssuredWorkloadsServiceClient const& a,
                         AssuredWorkloadsServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Creates Assured Workload.
  ///
  /// @param parent  Required. The resource name of the new Workload's parent.
  ///  Must be of the form `organizations/{org_id}/locations/{location_id}`.
  /// @param workload  Required. Assured Workload to create
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.assuredworkloads.v1.Workload] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.assuredworkloads.v1.CreateWorkloadRequest]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L133}
  /// [google.cloud.assuredworkloads.v1.Workload]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L232}
  ///
  // clang-format on
  future<StatusOr<google::cloud::assuredworkloads::v1::Workload>>
  CreateWorkload(std::string const& parent,
                 google::cloud::assuredworkloads::v1::Workload const& workload,
                 Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateWorkload
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateWorkload(
      NoAwaitTag, std::string const& parent,
      google::cloud::assuredworkloads::v1::Workload const& workload,
      Options opts = {});

  // clang-format off
  ///
  /// Creates Assured Workload.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.assuredworkloads.v1.CreateWorkloadRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.assuredworkloads.v1.Workload] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.assuredworkloads.v1.CreateWorkloadRequest]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L133}
  /// [google.cloud.assuredworkloads.v1.Workload]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L232}
  ///
  // clang-format on
  future<StatusOr<google::cloud::assuredworkloads::v1::Workload>>
  CreateWorkload(
      google::cloud::assuredworkloads::v1::CreateWorkloadRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateWorkload
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateWorkload(
      NoAwaitTag,
      google::cloud::assuredworkloads::v1::CreateWorkloadRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateWorkload
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::assuredworkloads::v1::Workload>>
  CreateWorkload(google::longrunning::Operation const& operation,
                 Options opts = {});

  // clang-format off
  ///
  /// Updates an existing workload.
  /// Currently allows updating of workload display_name and labels.
  /// For force updates don't set etag field in the Workload.
  /// Only one update operation per workload can be in progress.
  ///
  /// @param workload  Required. The workload to update.
  ///  The workload's `name` field is used to identify the workload to be updated.
  ///  Format:
  ///  organizations/{org_id}/locations/{location_id}/workloads/{workload_id}
  /// @param update_mask  Required. The list of fields to be updated.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.assuredworkloads.v1.Workload])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.assuredworkloads.v1.UpdateWorkloadRequest]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L154}
  /// [google.cloud.assuredworkloads.v1.Workload]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L232}
  ///
  // clang-format on
  StatusOr<google::cloud::assuredworkloads::v1::Workload> UpdateWorkload(
      google::cloud::assuredworkloads::v1::Workload const& workload,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates an existing workload.
  /// Currently allows updating of workload display_name and labels.
  /// For force updates don't set etag field in the Workload.
  /// Only one update operation per workload can be in progress.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.assuredworkloads.v1.UpdateWorkloadRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.assuredworkloads.v1.Workload])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.assuredworkloads.v1.UpdateWorkloadRequest]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L154}
  /// [google.cloud.assuredworkloads.v1.Workload]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L232}
  ///
  // clang-format on
  StatusOr<google::cloud::assuredworkloads::v1::Workload> UpdateWorkload(
      google::cloud::assuredworkloads::v1::UpdateWorkloadRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Restrict the list of resources allowed in the Workload environment.
  /// The current list of allowed products can be found at
  /// https://cloud.google.com/assured-workloads/docs/supported-products
  /// In addition to assuredworkloads.workload.update permission, the user should
  /// also have orgpolicy.policy.set permission on the folder resource
  /// to use this functionality.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.assuredworkloads.v1.RestrictAllowedResourcesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.assuredworkloads.v1.RestrictAllowedResourcesResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.assuredworkloads.v1.RestrictAllowedResourcesRequest]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L534}
  /// [google.cloud.assuredworkloads.v1.RestrictAllowedResourcesResponse]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L563}
  ///
  // clang-format on
  StatusOr<
      google::cloud::assuredworkloads::v1::RestrictAllowedResourcesResponse>
  RestrictAllowedResources(google::cloud::assuredworkloads::v1::
                               RestrictAllowedResourcesRequest const& request,
                           Options opts = {});

  // clang-format off
  ///
  /// Deletes the workload. Make sure that workload's direct children are already
  /// in a deleted state, otherwise the request will fail with a
  /// FAILED_PRECONDITION error.
  ///
  /// @param name  Required. The `name` field is used to identify the workload.
  ///  Format:
  ///  organizations/{org_id}/locations/{location_id}/workloads/{workload_id}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.assuredworkloads.v1.DeleteWorkloadRequest]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L166}
  ///
  // clang-format on
  Status DeleteWorkload(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes the workload. Make sure that workload's direct children are already
  /// in a deleted state, otherwise the request will fail with a
  /// FAILED_PRECONDITION error.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.assuredworkloads.v1.DeleteWorkloadRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.assuredworkloads.v1.DeleteWorkloadRequest]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L166}
  ///
  // clang-format on
  Status DeleteWorkload(
      google::cloud::assuredworkloads::v1::DeleteWorkloadRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets Assured Workload associated with a CRM Node
  ///
  /// @param name  Required. The resource name of the Workload to fetch. This is the workload's
  ///  relative path in the API, formatted as
  ///  "organizations/{organization_id}/locations/{location_id}/workloads/{workload_id}".
  ///  For example,
  ///  "organizations/123/locations/us-east1/workloads/assured-workload-1".
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.assuredworkloads.v1.Workload])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.assuredworkloads.v1.GetWorkloadRequest]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L183}
  /// [google.cloud.assuredworkloads.v1.Workload]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L232}
  ///
  // clang-format on
  StatusOr<google::cloud::assuredworkloads::v1::Workload> GetWorkload(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets Assured Workload associated with a CRM Node
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.assuredworkloads.v1.GetWorkloadRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.assuredworkloads.v1.Workload])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.assuredworkloads.v1.GetWorkloadRequest]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L183}
  /// [google.cloud.assuredworkloads.v1.Workload]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L232}
  ///
  // clang-format on
  StatusOr<google::cloud::assuredworkloads::v1::Workload> GetWorkload(
      google::cloud::assuredworkloads::v1::GetWorkloadRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists Assured Workloads under a CRM Node.
  ///
  /// @param parent  Required. Parent Resource to list workloads from.
  ///  Must be of the form `organizations/{org_id}/locations/{location}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.assuredworkloads.v1.Workload], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.assuredworkloads.v1.ListWorkloadsRequest]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L198}
  /// [google.cloud.assuredworkloads.v1.Workload]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L232}
  ///
  // clang-format on
  StreamRange<google::cloud::assuredworkloads::v1::Workload> ListWorkloads(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists Assured Workloads under a CRM Node.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.assuredworkloads.v1.ListWorkloadsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.assuredworkloads.v1.Workload], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.assuredworkloads.v1.ListWorkloadsRequest]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L198}
  /// [google.cloud.assuredworkloads.v1.Workload]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L232}
  ///
  // clang-format on
  StreamRange<google::cloud::assuredworkloads::v1::Workload> ListWorkloads(
      google::cloud::assuredworkloads::v1::ListWorkloadsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists the Violations in the AssuredWorkload Environment.
  /// Callers may also choose to read across multiple Workloads as per
  /// [AIP-159](https://google.aip.dev/159) by using '-' (the hyphen or dash
  /// character) as a wildcard character instead of workload-id in the parent.
  /// Format `organizations/{org_id}/locations/{location}/workloads/-`
  ///
  /// @param parent  Required. The Workload name.
  ///  Format `organizations/{org_id}/locations/{location}/workloads/{workload}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.assuredworkloads.v1.Violation], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.assuredworkloads.v1.ListViolationsRequest]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L606}
  /// [google.cloud.assuredworkloads.v1.Violation]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L654}
  ///
  // clang-format on
  StreamRange<google::cloud::assuredworkloads::v1::Violation> ListViolations(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists the Violations in the AssuredWorkload Environment.
  /// Callers may also choose to read across multiple Workloads as per
  /// [AIP-159](https://google.aip.dev/159) by using '-' (the hyphen or dash
  /// character) as a wildcard character instead of workload-id in the parent.
  /// Format `organizations/{org_id}/locations/{location}/workloads/-`
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.assuredworkloads.v1.ListViolationsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.assuredworkloads.v1.Violation], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.assuredworkloads.v1.ListViolationsRequest]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L606}
  /// [google.cloud.assuredworkloads.v1.Violation]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L654}
  ///
  // clang-format on
  StreamRange<google::cloud::assuredworkloads::v1::Violation> ListViolations(
      google::cloud::assuredworkloads::v1::ListViolationsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves Assured Workload Violation based on ID.
  ///
  /// @param name  Required. The resource name of the Violation to fetch (ie. Violation.name).
  ///  Format:
  ///  organizations/{organization}/locations/{location}/workloads/{workload}/violations/{violation}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.assuredworkloads.v1.Violation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.assuredworkloads.v1.GetViolationRequest]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L641}
  /// [google.cloud.assuredworkloads.v1.Violation]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L654}
  ///
  // clang-format on
  StatusOr<google::cloud::assuredworkloads::v1::Violation> GetViolation(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieves Assured Workload Violation based on ID.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.assuredworkloads.v1.GetViolationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.assuredworkloads.v1.Violation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.assuredworkloads.v1.GetViolationRequest]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L641}
  /// [google.cloud.assuredworkloads.v1.Violation]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L654}
  ///
  // clang-format on
  StatusOr<google::cloud::assuredworkloads::v1::Violation> GetViolation(
      google::cloud::assuredworkloads::v1::GetViolationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Acknowledges an existing violation. By acknowledging a violation, users
  /// acknowledge the existence of a compliance violation in their workload and
  /// decide to ignore it due to a valid business justification. Acknowledgement
  /// is a permanent operation and it cannot be reverted.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.assuredworkloads.v1.AcknowledgeViolationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.assuredworkloads.v1.AcknowledgeViolationResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.assuredworkloads.v1.AcknowledgeViolationRequest]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L569}
  /// [google.cloud.assuredworkloads.v1.AcknowledgeViolationResponse]: @googleapis_reference_link{google/cloud/assuredworkloads/v1/assuredworkloads.proto#L592}
  ///
  // clang-format on
  StatusOr<google::cloud::assuredworkloads::v1::AcknowledgeViolationResponse>
  AcknowledgeViolation(
      google::cloud::assuredworkloads::v1::AcknowledgeViolationRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists operations that match the specified filter in the request. If the
  /// server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// NOTE: the `name` binding allows API services to override the binding
  /// to use different resource name schemes, such as `users/*/operations`. To
  /// override the binding, API services can add a binding such as
  /// `"/v1/{name=users/*}/operations"` to their service configuration.
  /// For backwards compatibility, the default name includes the operations
  /// collection id, however overriding users must ensure the name binding
  /// is the parent resource, without the operations collection id.
  ///
  /// @param name  The name of the operation's parent resource.
  /// @param filter  The standard list filter.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.longrunning.Operation], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.ListOperationsRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L171}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StreamRange<google::longrunning::Operation> ListOperations(
      std::string const& name, std::string const& filter, Options opts = {});

  // clang-format off
  ///
  /// Lists operations that match the specified filter in the request. If the
  /// server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// NOTE: the `name` binding allows API services to override the binding
  /// to use different resource name schemes, such as `users/*/operations`. To
  /// override the binding, API services can add a binding such as
  /// `"/v1/{name=users/*}/operations"` to their service configuration.
  /// For backwards compatibility, the default name includes the operations
  /// collection id, however overriding users must ensure the name binding
  /// is the parent resource, without the operations collection id.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.ListOperationsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.longrunning.Operation], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.ListOperationsRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L171}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request, Options opts = {});

  // clang-format off
  ///
  /// Gets the latest state of a long-running operation.  Clients can use this
  /// method to poll the operation result at intervals as recommended by the API
  /// service.
  ///
  /// @param name  The name of the operation resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.longrunning.Operation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.GetOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L165}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> GetOperation(std::string const& name,
                                                        Options opts = {});

  // clang-format off
  ///
  /// Gets the latest state of a long-running operation.  Clients can use this
  /// method to poll the operation result at intervals as recommended by the API
  /// service.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.GetOperationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.longrunning.Operation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.GetOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L165}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<AssuredWorkloadsServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace assuredworkloads_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ASSUREDWORKLOADS_V1_ASSURED_WORKLOADS_CLIENT_H
