// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/asset/v1/asset_service.proto

#include "google/cloud/asset/v1/internal/asset_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace asset_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

AssetServiceTracingStub::AssetServiceTracingStub(
    std::shared_ptr<AssetServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

future<StatusOr<google::longrunning::Operation>>
AssetServiceTracingStub::AsyncExportAssets(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::asset::v1::ExportAssetsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.asset.v1.AssetService",
                                     "ExportAssets");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncExportAssets(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> AssetServiceTracingStub::ExportAssets(
    grpc::ClientContext& context, Options options,
    google::cloud::asset::v1::ExportAssetsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.asset.v1.AssetService",
                                     "ExportAssets");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ExportAssets(context, options, request));
}

StatusOr<google::cloud::asset::v1::ListAssetsResponse>
AssetServiceTracingStub::ListAssets(
    grpc::ClientContext& context, Options const& options,
    google::cloud::asset::v1::ListAssetsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.asset.v1.AssetService",
                                     "ListAssets");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListAssets(context, options, request));
}

StatusOr<google::cloud::asset::v1::BatchGetAssetsHistoryResponse>
AssetServiceTracingStub::BatchGetAssetsHistory(
    grpc::ClientContext& context, Options const& options,
    google::cloud::asset::v1::BatchGetAssetsHistoryRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.asset.v1.AssetService",
                                     "BatchGetAssetsHistory");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->BatchGetAssetsHistory(context, options, request));
}

StatusOr<google::cloud::asset::v1::Feed> AssetServiceTracingStub::CreateFeed(
    grpc::ClientContext& context, Options const& options,
    google::cloud::asset::v1::CreateFeedRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.asset.v1.AssetService",
                                     "CreateFeed");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateFeed(context, options, request));
}

StatusOr<google::cloud::asset::v1::Feed> AssetServiceTracingStub::GetFeed(
    grpc::ClientContext& context, Options const& options,
    google::cloud::asset::v1::GetFeedRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.asset.v1.AssetService", "GetFeed");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetFeed(context, options, request));
}

StatusOr<google::cloud::asset::v1::ListFeedsResponse>
AssetServiceTracingStub::ListFeeds(
    grpc::ClientContext& context, Options const& options,
    google::cloud::asset::v1::ListFeedsRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.asset.v1.AssetService", "ListFeeds");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListFeeds(context, options, request));
}

StatusOr<google::cloud::asset::v1::Feed> AssetServiceTracingStub::UpdateFeed(
    grpc::ClientContext& context, Options const& options,
    google::cloud::asset::v1::UpdateFeedRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.asset.v1.AssetService",
                                     "UpdateFeed");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateFeed(context, options, request));
}

Status AssetServiceTracingStub::DeleteFeed(
    grpc::ClientContext& context, Options const& options,
    google::cloud::asset::v1::DeleteFeedRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.asset.v1.AssetService",
                                     "DeleteFeed");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteFeed(context, options, request));
}

StatusOr<google::cloud::asset::v1::SearchAllResourcesResponse>
AssetServiceTracingStub::SearchAllResources(
    grpc::ClientContext& context, Options const& options,
    google::cloud::asset::v1::SearchAllResourcesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.asset.v1.AssetService",
                                     "SearchAllResources");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->SearchAllResources(context, options, request));
}

StatusOr<google::cloud::asset::v1::SearchAllIamPoliciesResponse>
AssetServiceTracingStub::SearchAllIamPolicies(
    grpc::ClientContext& context, Options const& options,
    google::cloud::asset::v1::SearchAllIamPoliciesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.asset.v1.AssetService",
                                     "SearchAllIamPolicies");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->SearchAllIamPolicies(context, options, request));
}

StatusOr<google::cloud::asset::v1::AnalyzeIamPolicyResponse>
AssetServiceTracingStub::AnalyzeIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::cloud::asset::v1::AnalyzeIamPolicyRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.asset.v1.AssetService",
                                     "AnalyzeIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->AnalyzeIamPolicy(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
AssetServiceTracingStub::AsyncAnalyzeIamPolicyLongrunning(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::asset::v1::AnalyzeIamPolicyLongrunningRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.asset.v1.AssetService",
                                     "AnalyzeIamPolicyLongrunning");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncAnalyzeIamPolicyLongrunning(
      cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
AssetServiceTracingStub::AnalyzeIamPolicyLongrunning(
    grpc::ClientContext& context, Options options,
    google::cloud::asset::v1::AnalyzeIamPolicyLongrunningRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.asset.v1.AssetService",
                                     "AnalyzeIamPolicyLongrunning");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->AnalyzeIamPolicyLongrunning(context, options, request));
}

StatusOr<google::cloud::asset::v1::AnalyzeMoveResponse>
AssetServiceTracingStub::AnalyzeMove(
    grpc::ClientContext& context, Options const& options,
    google::cloud::asset::v1::AnalyzeMoveRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.asset.v1.AssetService",
                                     "AnalyzeMove");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->AnalyzeMove(context, options, request));
}

StatusOr<google::cloud::asset::v1::QueryAssetsResponse>
AssetServiceTracingStub::QueryAssets(
    grpc::ClientContext& context, Options const& options,
    google::cloud::asset::v1::QueryAssetsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.asset.v1.AssetService",
                                     "QueryAssets");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->QueryAssets(context, options, request));
}

StatusOr<google::cloud::asset::v1::SavedQuery>
AssetServiceTracingStub::CreateSavedQuery(
    grpc::ClientContext& context, Options const& options,
    google::cloud::asset::v1::CreateSavedQueryRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.asset.v1.AssetService",
                                     "CreateSavedQuery");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateSavedQuery(context, options, request));
}

StatusOr<google::cloud::asset::v1::SavedQuery>
AssetServiceTracingStub::GetSavedQuery(
    grpc::ClientContext& context, Options const& options,
    google::cloud::asset::v1::GetSavedQueryRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.asset.v1.AssetService",
                                     "GetSavedQuery");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetSavedQuery(context, options, request));
}

StatusOr<google::cloud::asset::v1::ListSavedQueriesResponse>
AssetServiceTracingStub::ListSavedQueries(
    grpc::ClientContext& context, Options const& options,
    google::cloud::asset::v1::ListSavedQueriesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.asset.v1.AssetService",
                                     "ListSavedQueries");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListSavedQueries(context, options, request));
}

StatusOr<google::cloud::asset::v1::SavedQuery>
AssetServiceTracingStub::UpdateSavedQuery(
    grpc::ClientContext& context, Options const& options,
    google::cloud::asset::v1::UpdateSavedQueryRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.asset.v1.AssetService",
                                     "UpdateSavedQuery");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateSavedQuery(context, options, request));
}

Status AssetServiceTracingStub::DeleteSavedQuery(
    grpc::ClientContext& context, Options const& options,
    google::cloud::asset::v1::DeleteSavedQueryRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.asset.v1.AssetService",
                                     "DeleteSavedQuery");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteSavedQuery(context, options, request));
}

StatusOr<google::cloud::asset::v1::BatchGetEffectiveIamPoliciesResponse>
AssetServiceTracingStub::BatchGetEffectiveIamPolicies(
    grpc::ClientContext& context, Options const& options,
    google::cloud::asset::v1::BatchGetEffectiveIamPoliciesRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.asset.v1.AssetService",
                                     "BatchGetEffectiveIamPolicies");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->BatchGetEffectiveIamPolicies(context, options, request));
}

StatusOr<google::cloud::asset::v1::AnalyzeOrgPoliciesResponse>
AssetServiceTracingStub::AnalyzeOrgPolicies(
    grpc::ClientContext& context, Options const& options,
    google::cloud::asset::v1::AnalyzeOrgPoliciesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.asset.v1.AssetService",
                                     "AnalyzeOrgPolicies");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->AnalyzeOrgPolicies(context, options, request));
}

StatusOr<google::cloud::asset::v1::AnalyzeOrgPolicyGovernedContainersResponse>
AssetServiceTracingStub::AnalyzeOrgPolicyGovernedContainers(
    grpc::ClientContext& context, Options const& options,
    google::cloud::asset::v1::AnalyzeOrgPolicyGovernedContainersRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.asset.v1.AssetService",
                                     "AnalyzeOrgPolicyGovernedContainers");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->AnalyzeOrgPolicyGovernedContainers(context, options, request));
}

StatusOr<google::cloud::asset::v1::AnalyzeOrgPolicyGovernedAssetsResponse>
AssetServiceTracingStub::AnalyzeOrgPolicyGovernedAssets(
    grpc::ClientContext& context, Options const& options,
    google::cloud::asset::v1::AnalyzeOrgPolicyGovernedAssetsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.asset.v1.AssetService",
                                     "AnalyzeOrgPolicyGovernedAssets");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->AnalyzeOrgPolicyGovernedAssets(context, options, request));
}

StatusOr<google::longrunning::Operation> AssetServiceTracingStub::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.asset.v1.AssetService",
                                     "GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetOperation(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
AssetServiceTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> AssetServiceTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCancelOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<AssetServiceStub> MakeAssetServiceTracingStub(
    std::shared_ptr<AssetServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<AssetServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace asset_v1_internal
}  // namespace cloud
}  // namespace google
