// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/artifactregistry/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ARTIFACTREGISTRY_V1_INTERNAL_ARTIFACT_REGISTRY_AUTH_DECORATOR_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ARTIFACTREGISTRY_V1_INTERNAL_ARTIFACT_REGISTRY_AUTH_DECORATOR_H

#include "google/cloud/artifactregistry/v1/internal/artifact_registry_stub.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <set>
#include <string>

namespace google {
namespace cloud {
namespace artifactregistry_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class ArtifactRegistryAuth : public ArtifactRegistryStub {
 public:
  ~ArtifactRegistryAuth() override = default;
  ArtifactRegistryAuth(
      std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
      std::shared_ptr<ArtifactRegistryStub> child);

  StatusOr<google::devtools::artifactregistry::v1::ListDockerImagesResponse>
  ListDockerImages(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::ListDockerImagesRequest const&
          request) override;

  StatusOr<google::devtools::artifactregistry::v1::DockerImage> GetDockerImage(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::GetDockerImageRequest const&
          request) override;

  StatusOr<google::devtools::artifactregistry::v1::ListMavenArtifactsResponse>
  ListMavenArtifacts(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::ListMavenArtifactsRequest const&
          request) override;

  StatusOr<google::devtools::artifactregistry::v1::MavenArtifact>
  GetMavenArtifact(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::GetMavenArtifactRequest const&
          request) override;

  StatusOr<google::devtools::artifactregistry::v1::ListNpmPackagesResponse>
  ListNpmPackages(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::ListNpmPackagesRequest const&
          request) override;

  StatusOr<google::devtools::artifactregistry::v1::NpmPackage> GetNpmPackage(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::GetNpmPackageRequest const&
          request) override;

  StatusOr<google::devtools::artifactregistry::v1::ListPythonPackagesResponse>
  ListPythonPackages(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::ListPythonPackagesRequest const&
          request) override;

  StatusOr<google::devtools::artifactregistry::v1::PythonPackage>
  GetPythonPackage(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::GetPythonPackageRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncImportAptArtifacts(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::devtools::artifactregistry::v1::ImportAptArtifactsRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> ImportAptArtifacts(
      grpc::ClientContext& context, Options options,
      google::devtools::artifactregistry::v1::ImportAptArtifactsRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncImportYumArtifacts(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::devtools::artifactregistry::v1::ImportYumArtifactsRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> ImportYumArtifacts(
      grpc::ClientContext& context, Options options,
      google::devtools::artifactregistry::v1::ImportYumArtifactsRequest const&
          request) override;

  StatusOr<google::devtools::artifactregistry::v1::ListRepositoriesResponse>
  ListRepositories(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::ListRepositoriesRequest const&
          request) override;

  StatusOr<google::devtools::artifactregistry::v1::Repository> GetRepository(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::GetRepositoryRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateRepository(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::devtools::artifactregistry::v1::CreateRepositoryRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> CreateRepository(
      grpc::ClientContext& context, Options options,
      google::devtools::artifactregistry::v1::CreateRepositoryRequest const&
          request) override;

  StatusOr<google::devtools::artifactregistry::v1::Repository> UpdateRepository(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::UpdateRepositoryRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteRepository(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::devtools::artifactregistry::v1::DeleteRepositoryRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteRepository(
      grpc::ClientContext& context, Options options,
      google::devtools::artifactregistry::v1::DeleteRepositoryRequest const&
          request) override;

  StatusOr<google::devtools::artifactregistry::v1::ListPackagesResponse>
  ListPackages(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::ListPackagesRequest const&
          request) override;

  StatusOr<google::devtools::artifactregistry::v1::Package> GetPackage(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::GetPackageRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeletePackage(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::devtools::artifactregistry::v1::DeletePackageRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeletePackage(
      grpc::ClientContext& context, Options options,
      google::devtools::artifactregistry::v1::DeletePackageRequest const&
          request) override;

  StatusOr<google::devtools::artifactregistry::v1::ListVersionsResponse>
  ListVersions(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::ListVersionsRequest const&
          request) override;

  StatusOr<google::devtools::artifactregistry::v1::Version> GetVersion(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::GetVersionRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteVersion(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::devtools::artifactregistry::v1::DeleteVersionRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteVersion(
      grpc::ClientContext& context, Options options,
      google::devtools::artifactregistry::v1::DeleteVersionRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncBatchDeleteVersions(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::devtools::artifactregistry::v1::BatchDeleteVersionsRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> BatchDeleteVersions(
      grpc::ClientContext& context, Options options,
      google::devtools::artifactregistry::v1::BatchDeleteVersionsRequest const&
          request) override;

  StatusOr<google::devtools::artifactregistry::v1::Version> UpdateVersion(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::UpdateVersionRequest const&
          request) override;

  StatusOr<google::devtools::artifactregistry::v1::ListFilesResponse> ListFiles(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::ListFilesRequest const& request)
      override;

  StatusOr<google::devtools::artifactregistry::v1::File> GetFile(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::GetFileRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteFile(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::devtools::artifactregistry::v1::DeleteFileRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteFile(
      grpc::ClientContext& context, Options options,
      google::devtools::artifactregistry::v1::DeleteFileRequest const& request)
      override;

  StatusOr<google::devtools::artifactregistry::v1::File> UpdateFile(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::UpdateFileRequest const& request)
      override;

  StatusOr<google::devtools::artifactregistry::v1::ListTagsResponse> ListTags(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::ListTagsRequest const& request)
      override;

  StatusOr<google::devtools::artifactregistry::v1::Tag> GetTag(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::GetTagRequest const& request)
      override;

  StatusOr<google::devtools::artifactregistry::v1::Tag> CreateTag(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::CreateTagRequest const& request)
      override;

  StatusOr<google::devtools::artifactregistry::v1::Tag> UpdateTag(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::UpdateTagRequest const& request)
      override;

  Status DeleteTag(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::DeleteTagRequest const& request)
      override;

  StatusOr<google::devtools::artifactregistry::v1::Rule> CreateRule(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::CreateRuleRequest const& request)
      override;

  StatusOr<google::devtools::artifactregistry::v1::ListRulesResponse> ListRules(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::ListRulesRequest const& request)
      override;

  StatusOr<google::devtools::artifactregistry::v1::Rule> GetRule(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::GetRuleRequest const& request)
      override;

  StatusOr<google::devtools::artifactregistry::v1::Rule> UpdateRule(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::UpdateRuleRequest const& request)
      override;

  Status DeleteRule(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::DeleteRuleRequest const& request)
      override;

  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::SetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::GetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::TestIamPermissionsRequest const& request) override;

  StatusOr<google::devtools::artifactregistry::v1::ProjectSettings>
  GetProjectSettings(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::GetProjectSettingsRequest const&
          request) override;

  StatusOr<google::devtools::artifactregistry::v1::ProjectSettings>
  UpdateProjectSettings(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::
          UpdateProjectSettingsRequest const& request) override;

  StatusOr<google::devtools::artifactregistry::v1::VPCSCConfig> GetVPCSCConfig(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::GetVPCSCConfigRequest const&
          request) override;

  StatusOr<google::devtools::artifactregistry::v1::VPCSCConfig>
  UpdateVPCSCConfig(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::UpdateVPCSCConfigRequest const&
          request) override;

  StatusOr<google::devtools::artifactregistry::v1::Package> UpdatePackage(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::UpdatePackageRequest const&
          request) override;

  StatusOr<google::devtools::artifactregistry::v1::ListAttachmentsResponse>
  ListAttachments(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::ListAttachmentsRequest const&
          request) override;

  StatusOr<google::devtools::artifactregistry::v1::Attachment> GetAttachment(
      grpc::ClientContext& context, Options const& options,
      google::devtools::artifactregistry::v1::GetAttachmentRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateAttachment(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::devtools::artifactregistry::v1::CreateAttachmentRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> CreateAttachment(
      grpc::ClientContext& context, Options options,
      google::devtools::artifactregistry::v1::CreateAttachmentRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteAttachment(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::devtools::artifactregistry::v1::DeleteAttachmentRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteAttachment(
      grpc::ClientContext& context, Options options,
      google::devtools::artifactregistry::v1::DeleteAttachmentRequest const&
          request) override;

  StatusOr<google::cloud::location::ListLocationsResponse> ListLocations(
      grpc::ClientContext& context, Options const& options,
      google::cloud::location::ListLocationsRequest const& request) override;

  StatusOr<google::cloud::location::Location> GetLocation(
      grpc::ClientContext& context, Options const& options,
      google::cloud::location::GetLocationRequest const& request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::GetOperationRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::GetOperationRequest const& request) override;

  future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth_;
  std::shared_ptr<ArtifactRegistryStub> child_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace artifactregistry_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ARTIFACTREGISTRY_V1_INTERNAL_ARTIFACT_REGISTRY_AUTH_DECORATOR_H
