// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/artifactregistry/v1/service.proto

#include "google/cloud/artifactregistry/v1/artifact_registry_connection.h"
#include "google/cloud/artifactregistry/v1/artifact_registry_options.h"
#include "google/cloud/artifactregistry/v1/internal/artifact_registry_connection_impl.h"
#include "google/cloud/artifactregistry/v1/internal/artifact_registry_option_defaults.h"
#include "google/cloud/artifactregistry/v1/internal/artifact_registry_stub_factory.h"
#include "google/cloud/artifactregistry/v1/internal/artifact_registry_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace artifactregistry_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ArtifactRegistryConnection::~ArtifactRegistryConnection() = default;

StreamRange<google::devtools::artifactregistry::v1::DockerImage>
ArtifactRegistryConnection::ListDockerImages(
    google::devtools::artifactregistry::v1::
        ListDockerImagesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::devtools::artifactregistry::v1::DockerImage>>();
}

StatusOr<google::devtools::artifactregistry::v1::DockerImage>
ArtifactRegistryConnection::GetDockerImage(
    google::devtools::artifactregistry::v1::GetDockerImageRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::devtools::artifactregistry::v1::MavenArtifact>
ArtifactRegistryConnection::ListMavenArtifacts(
    google::devtools::artifactregistry::v1::
        ListMavenArtifactsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::devtools::artifactregistry::v1::MavenArtifact>>();
}

StatusOr<google::devtools::artifactregistry::v1::MavenArtifact>
ArtifactRegistryConnection::GetMavenArtifact(
    google::devtools::artifactregistry::v1::GetMavenArtifactRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::devtools::artifactregistry::v1::NpmPackage>
ArtifactRegistryConnection::ListNpmPackages(
    google::devtools::artifactregistry::v1::
        ListNpmPackagesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::devtools::artifactregistry::v1::NpmPackage>>();
}

StatusOr<google::devtools::artifactregistry::v1::NpmPackage>
ArtifactRegistryConnection::GetNpmPackage(
    google::devtools::artifactregistry::v1::GetNpmPackageRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::devtools::artifactregistry::v1::PythonPackage>
ArtifactRegistryConnection::ListPythonPackages(
    google::devtools::artifactregistry::v1::
        ListPythonPackagesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::devtools::artifactregistry::v1::PythonPackage>>();
}

StatusOr<google::devtools::artifactregistry::v1::PythonPackage>
ArtifactRegistryConnection::GetPythonPackage(
    google::devtools::artifactregistry::v1::GetPythonPackageRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<
    google::devtools::artifactregistry::v1::ImportAptArtifactsResponse>>
ArtifactRegistryConnection::ImportAptArtifacts(
    google::devtools::artifactregistry::v1::ImportAptArtifactsRequest const&) {
  return google::cloud::make_ready_future<StatusOr<
      google::devtools::artifactregistry::v1::ImportAptArtifactsResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
ArtifactRegistryConnection::ImportAptArtifacts(
    NoAwaitTag,
    google::devtools::artifactregistry::v1::ImportAptArtifactsRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<
    google::devtools::artifactregistry::v1::ImportAptArtifactsResponse>>
ArtifactRegistryConnection::ImportAptArtifacts(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<StatusOr<
      google::devtools::artifactregistry::v1::ImportAptArtifactsResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<
    google::devtools::artifactregistry::v1::ImportYumArtifactsResponse>>
ArtifactRegistryConnection::ImportYumArtifacts(
    google::devtools::artifactregistry::v1::ImportYumArtifactsRequest const&) {
  return google::cloud::make_ready_future<StatusOr<
      google::devtools::artifactregistry::v1::ImportYumArtifactsResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
ArtifactRegistryConnection::ImportYumArtifacts(
    NoAwaitTag,
    google::devtools::artifactregistry::v1::ImportYumArtifactsRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<
    google::devtools::artifactregistry::v1::ImportYumArtifactsResponse>>
ArtifactRegistryConnection::ImportYumArtifacts(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<StatusOr<
      google::devtools::artifactregistry::v1::ImportYumArtifactsResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::devtools::artifactregistry::v1::Repository>
ArtifactRegistryConnection::ListRepositories(
    google::devtools::artifactregistry::v1::
        ListRepositoriesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::devtools::artifactregistry::v1::Repository>>();
}

StatusOr<google::devtools::artifactregistry::v1::Repository>
ArtifactRegistryConnection::GetRepository(
    google::devtools::artifactregistry::v1::GetRepositoryRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::devtools::artifactregistry::v1::Repository>>
ArtifactRegistryConnection::CreateRepository(
    google::devtools::artifactregistry::v1::CreateRepositoryRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::devtools::artifactregistry::v1::Repository>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
ArtifactRegistryConnection::CreateRepository(
    NoAwaitTag,
    google::devtools::artifactregistry::v1::CreateRepositoryRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::devtools::artifactregistry::v1::Repository>>
ArtifactRegistryConnection::CreateRepository(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::devtools::artifactregistry::v1::Repository>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::devtools::artifactregistry::v1::Repository>
ArtifactRegistryConnection::UpdateRepository(
    google::devtools::artifactregistry::v1::UpdateRepositoryRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
ArtifactRegistryConnection::DeleteRepository(
    google::devtools::artifactregistry::v1::DeleteRepositoryRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
ArtifactRegistryConnection::DeleteRepository(
    NoAwaitTag,
    google::devtools::artifactregistry::v1::DeleteRepositoryRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
ArtifactRegistryConnection::DeleteRepository(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::devtools::artifactregistry::v1::Package>
ArtifactRegistryConnection::ListPackages(
    google::devtools::artifactregistry::v1::
        ListPackagesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::devtools::artifactregistry::v1::Package>>();
}

StatusOr<google::devtools::artifactregistry::v1::Package>
ArtifactRegistryConnection::GetPackage(
    google::devtools::artifactregistry::v1::GetPackageRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
ArtifactRegistryConnection::DeletePackage(
    google::devtools::artifactregistry::v1::DeletePackageRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
ArtifactRegistryConnection::DeletePackage(
    NoAwaitTag,
    google::devtools::artifactregistry::v1::DeletePackageRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
ArtifactRegistryConnection::DeletePackage(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::devtools::artifactregistry::v1::Version>
ArtifactRegistryConnection::ListVersions(
    google::devtools::artifactregistry::v1::
        ListVersionsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::devtools::artifactregistry::v1::Version>>();
}

StatusOr<google::devtools::artifactregistry::v1::Version>
ArtifactRegistryConnection::GetVersion(
    google::devtools::artifactregistry::v1::GetVersionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
ArtifactRegistryConnection::DeleteVersion(
    google::devtools::artifactregistry::v1::DeleteVersionRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
ArtifactRegistryConnection::DeleteVersion(
    NoAwaitTag,
    google::devtools::artifactregistry::v1::DeleteVersionRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
ArtifactRegistryConnection::DeleteVersion(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<
    google::devtools::artifactregistry::v1::BatchDeleteVersionsMetadata>>
ArtifactRegistryConnection::BatchDeleteVersions(
    google::devtools::artifactregistry::v1::BatchDeleteVersionsRequest const&) {
  return google::cloud::make_ready_future<StatusOr<
      google::devtools::artifactregistry::v1::BatchDeleteVersionsMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
ArtifactRegistryConnection::BatchDeleteVersions(
    NoAwaitTag,
    google::devtools::artifactregistry::v1::BatchDeleteVersionsRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<
    google::devtools::artifactregistry::v1::BatchDeleteVersionsMetadata>>
ArtifactRegistryConnection::BatchDeleteVersions(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<StatusOr<
      google::devtools::artifactregistry::v1::BatchDeleteVersionsMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::devtools::artifactregistry::v1::Version>
ArtifactRegistryConnection::UpdateVersion(
    google::devtools::artifactregistry::v1::UpdateVersionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::devtools::artifactregistry::v1::File>
ArtifactRegistryConnection::ListFiles(
    google::devtools::artifactregistry::v1::
        ListFilesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::devtools::artifactregistry::v1::File>>();
}

StatusOr<google::devtools::artifactregistry::v1::File>
ArtifactRegistryConnection::GetFile(
    google::devtools::artifactregistry::v1::GetFileRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
ArtifactRegistryConnection::DeleteFile(
    google::devtools::artifactregistry::v1::DeleteFileRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> ArtifactRegistryConnection::DeleteFile(
    NoAwaitTag,
    google::devtools::artifactregistry::v1::DeleteFileRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
ArtifactRegistryConnection::DeleteFile(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::devtools::artifactregistry::v1::File>
ArtifactRegistryConnection::UpdateFile(
    google::devtools::artifactregistry::v1::UpdateFileRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::devtools::artifactregistry::v1::Tag>
ArtifactRegistryConnection::ListTags(
    google::devtools::artifactregistry::v1::
        ListTagsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::devtools::artifactregistry::v1::Tag>>();
}

StatusOr<google::devtools::artifactregistry::v1::Tag>
ArtifactRegistryConnection::GetTag(
    google::devtools::artifactregistry::v1::GetTagRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::devtools::artifactregistry::v1::Tag>
ArtifactRegistryConnection::CreateTag(
    google::devtools::artifactregistry::v1::CreateTagRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::devtools::artifactregistry::v1::Tag>
ArtifactRegistryConnection::UpdateTag(
    google::devtools::artifactregistry::v1::UpdateTagRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status ArtifactRegistryConnection::DeleteTag(
    google::devtools::artifactregistry::v1::DeleteTagRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::devtools::artifactregistry::v1::Rule>
ArtifactRegistryConnection::CreateRule(
    google::devtools::artifactregistry::v1::CreateRuleRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::devtools::artifactregistry::v1::Rule>
ArtifactRegistryConnection::ListRules(
    google::devtools::artifactregistry::v1::
        ListRulesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::devtools::artifactregistry::v1::Rule>>();
}

StatusOr<google::devtools::artifactregistry::v1::Rule>
ArtifactRegistryConnection::GetRule(
    google::devtools::artifactregistry::v1::GetRuleRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::devtools::artifactregistry::v1::Rule>
ArtifactRegistryConnection::UpdateRule(
    google::devtools::artifactregistry::v1::UpdateRuleRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status ArtifactRegistryConnection::DeleteRule(
    google::devtools::artifactregistry::v1::DeleteRuleRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> ArtifactRegistryConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> ArtifactRegistryConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
ArtifactRegistryConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::devtools::artifactregistry::v1::ProjectSettings>
ArtifactRegistryConnection::GetProjectSettings(
    google::devtools::artifactregistry::v1::GetProjectSettingsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::devtools::artifactregistry::v1::ProjectSettings>
ArtifactRegistryConnection::UpdateProjectSettings(
    google::devtools::artifactregistry::v1::
        UpdateProjectSettingsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::devtools::artifactregistry::v1::VPCSCConfig>
ArtifactRegistryConnection::GetVPCSCConfig(
    google::devtools::artifactregistry::v1::GetVPCSCConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::devtools::artifactregistry::v1::VPCSCConfig>
ArtifactRegistryConnection::UpdateVPCSCConfig(
    google::devtools::artifactregistry::v1::UpdateVPCSCConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::devtools::artifactregistry::v1::Package>
ArtifactRegistryConnection::UpdatePackage(
    google::devtools::artifactregistry::v1::UpdatePackageRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::devtools::artifactregistry::v1::Attachment>
ArtifactRegistryConnection::ListAttachments(
    google::devtools::artifactregistry::v1::
        ListAttachmentsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::devtools::artifactregistry::v1::Attachment>>();
}

StatusOr<google::devtools::artifactregistry::v1::Attachment>
ArtifactRegistryConnection::GetAttachment(
    google::devtools::artifactregistry::v1::GetAttachmentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::devtools::artifactregistry::v1::Attachment>>
ArtifactRegistryConnection::CreateAttachment(
    google::devtools::artifactregistry::v1::CreateAttachmentRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::devtools::artifactregistry::v1::Attachment>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
ArtifactRegistryConnection::CreateAttachment(
    NoAwaitTag,
    google::devtools::artifactregistry::v1::CreateAttachmentRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::devtools::artifactregistry::v1::Attachment>>
ArtifactRegistryConnection::CreateAttachment(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::devtools::artifactregistry::v1::Attachment>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
ArtifactRegistryConnection::DeleteAttachment(
    google::devtools::artifactregistry::v1::DeleteAttachmentRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
ArtifactRegistryConnection::DeleteAttachment(
    NoAwaitTag,
    google::devtools::artifactregistry::v1::DeleteAttachmentRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
ArtifactRegistryConnection::DeleteAttachment(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::location::Location>
ArtifactRegistryConnection::ListLocations(
    google::cloud::location::
        ListLocationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::location::Location>>();
}

StatusOr<google::cloud::location::Location>
ArtifactRegistryConnection::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::longrunning::Operation>
ArtifactRegistryConnection::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<ArtifactRegistryConnection> MakeArtifactRegistryConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 ArtifactRegistryPolicyOptionList>(options,
                                                                   __func__);
  options = artifactregistry_v1_internal::ArtifactRegistryDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = artifactregistry_v1_internal::CreateDefaultArtifactRegistryStub(
      std::move(auth), options);
  return artifactregistry_v1_internal::MakeArtifactRegistryTracingConnection(
      std::make_shared<
          artifactregistry_v1_internal::ArtifactRegistryConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace artifactregistry_v1
}  // namespace cloud
}  // namespace google
