// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/artifactregistry/v1/service.proto

#include "google/cloud/artifactregistry/v1/artifact_registry_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace artifactregistry_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ArtifactRegistryClient::ArtifactRegistryClient(
    std::shared_ptr<ArtifactRegistryConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
ArtifactRegistryClient::~ArtifactRegistryClient() = default;

StreamRange<google::devtools::artifactregistry::v1::DockerImage>
ArtifactRegistryClient::ListDockerImages(std::string const& parent,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::ListDockerImagesRequest request;
  request.set_parent(parent);
  return connection_->ListDockerImages(request);
}

StreamRange<google::devtools::artifactregistry::v1::DockerImage>
ArtifactRegistryClient::ListDockerImages(
    google::devtools::artifactregistry::v1::ListDockerImagesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListDockerImages(std::move(request));
}

StatusOr<google::devtools::artifactregistry::v1::DockerImage>
ArtifactRegistryClient::GetDockerImage(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::GetDockerImageRequest request;
  request.set_name(name);
  return connection_->GetDockerImage(request);
}

StatusOr<google::devtools::artifactregistry::v1::DockerImage>
ArtifactRegistryClient::GetDockerImage(
    google::devtools::artifactregistry::v1::GetDockerImageRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetDockerImage(request);
}

StreamRange<google::devtools::artifactregistry::v1::MavenArtifact>
ArtifactRegistryClient::ListMavenArtifacts(std::string const& parent,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::ListMavenArtifactsRequest request;
  request.set_parent(parent);
  return connection_->ListMavenArtifacts(request);
}

StreamRange<google::devtools::artifactregistry::v1::MavenArtifact>
ArtifactRegistryClient::ListMavenArtifacts(
    google::devtools::artifactregistry::v1::ListMavenArtifactsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListMavenArtifacts(std::move(request));
}

StatusOr<google::devtools::artifactregistry::v1::MavenArtifact>
ArtifactRegistryClient::GetMavenArtifact(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::GetMavenArtifactRequest request;
  request.set_name(name);
  return connection_->GetMavenArtifact(request);
}

StatusOr<google::devtools::artifactregistry::v1::MavenArtifact>
ArtifactRegistryClient::GetMavenArtifact(
    google::devtools::artifactregistry::v1::GetMavenArtifactRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetMavenArtifact(request);
}

StreamRange<google::devtools::artifactregistry::v1::NpmPackage>
ArtifactRegistryClient::ListNpmPackages(std::string const& parent,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::ListNpmPackagesRequest request;
  request.set_parent(parent);
  return connection_->ListNpmPackages(request);
}

StreamRange<google::devtools::artifactregistry::v1::NpmPackage>
ArtifactRegistryClient::ListNpmPackages(
    google::devtools::artifactregistry::v1::ListNpmPackagesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListNpmPackages(std::move(request));
}

StatusOr<google::devtools::artifactregistry::v1::NpmPackage>
ArtifactRegistryClient::GetNpmPackage(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::GetNpmPackageRequest request;
  request.set_name(name);
  return connection_->GetNpmPackage(request);
}

StatusOr<google::devtools::artifactregistry::v1::NpmPackage>
ArtifactRegistryClient::GetNpmPackage(
    google::devtools::artifactregistry::v1::GetNpmPackageRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetNpmPackage(request);
}

StreamRange<google::devtools::artifactregistry::v1::PythonPackage>
ArtifactRegistryClient::ListPythonPackages(std::string const& parent,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::ListPythonPackagesRequest request;
  request.set_parent(parent);
  return connection_->ListPythonPackages(request);
}

StreamRange<google::devtools::artifactregistry::v1::PythonPackage>
ArtifactRegistryClient::ListPythonPackages(
    google::devtools::artifactregistry::v1::ListPythonPackagesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListPythonPackages(std::move(request));
}

StatusOr<google::devtools::artifactregistry::v1::PythonPackage>
ArtifactRegistryClient::GetPythonPackage(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::GetPythonPackageRequest request;
  request.set_name(name);
  return connection_->GetPythonPackage(request);
}

StatusOr<google::devtools::artifactregistry::v1::PythonPackage>
ArtifactRegistryClient::GetPythonPackage(
    google::devtools::artifactregistry::v1::GetPythonPackageRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetPythonPackage(request);
}

future<StatusOr<
    google::devtools::artifactregistry::v1::ImportAptArtifactsResponse>>
ArtifactRegistryClient::ImportAptArtifacts(
    google::devtools::artifactregistry::v1::ImportAptArtifactsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportAptArtifacts(request);
}

StatusOr<google::longrunning::Operation>
ArtifactRegistryClient::ImportAptArtifacts(
    NoAwaitTag,
    google::devtools::artifactregistry::v1::ImportAptArtifactsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportAptArtifacts(NoAwaitTag{}, request);
}

future<StatusOr<
    google::devtools::artifactregistry::v1::ImportAptArtifactsResponse>>
ArtifactRegistryClient::ImportAptArtifacts(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportAptArtifacts(operation);
}

future<StatusOr<
    google::devtools::artifactregistry::v1::ImportYumArtifactsResponse>>
ArtifactRegistryClient::ImportYumArtifacts(
    google::devtools::artifactregistry::v1::ImportYumArtifactsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportYumArtifacts(request);
}

StatusOr<google::longrunning::Operation>
ArtifactRegistryClient::ImportYumArtifacts(
    NoAwaitTag,
    google::devtools::artifactregistry::v1::ImportYumArtifactsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportYumArtifacts(NoAwaitTag{}, request);
}

future<StatusOr<
    google::devtools::artifactregistry::v1::ImportYumArtifactsResponse>>
ArtifactRegistryClient::ImportYumArtifacts(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportYumArtifacts(operation);
}

StreamRange<google::devtools::artifactregistry::v1::Repository>
ArtifactRegistryClient::ListRepositories(std::string const& parent,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::ListRepositoriesRequest request;
  request.set_parent(parent);
  return connection_->ListRepositories(request);
}

StreamRange<google::devtools::artifactregistry::v1::Repository>
ArtifactRegistryClient::ListRepositories(
    google::devtools::artifactregistry::v1::ListRepositoriesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListRepositories(std::move(request));
}

StatusOr<google::devtools::artifactregistry::v1::Repository>
ArtifactRegistryClient::GetRepository(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::GetRepositoryRequest request;
  request.set_name(name);
  return connection_->GetRepository(request);
}

StatusOr<google::devtools::artifactregistry::v1::Repository>
ArtifactRegistryClient::GetRepository(
    google::devtools::artifactregistry::v1::GetRepositoryRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetRepository(request);
}

future<StatusOr<google::devtools::artifactregistry::v1::Repository>>
ArtifactRegistryClient::CreateRepository(
    std::string const& parent,
    google::devtools::artifactregistry::v1::Repository const& repository,
    std::string const& repository_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::CreateRepositoryRequest request;
  request.set_parent(parent);
  *request.mutable_repository() = repository;
  request.set_repository_id(repository_id);
  return connection_->CreateRepository(request);
}

StatusOr<google::longrunning::Operation>
ArtifactRegistryClient::CreateRepository(
    NoAwaitTag, std::string const& parent,
    google::devtools::artifactregistry::v1::Repository const& repository,
    std::string const& repository_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::CreateRepositoryRequest request;
  request.set_parent(parent);
  *request.mutable_repository() = repository;
  request.set_repository_id(repository_id);
  return connection_->CreateRepository(NoAwaitTag{}, request);
}

future<StatusOr<google::devtools::artifactregistry::v1::Repository>>
ArtifactRegistryClient::CreateRepository(
    google::devtools::artifactregistry::v1::CreateRepositoryRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateRepository(request);
}

StatusOr<google::longrunning::Operation>
ArtifactRegistryClient::CreateRepository(
    NoAwaitTag,
    google::devtools::artifactregistry::v1::CreateRepositoryRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateRepository(NoAwaitTag{}, request);
}

future<StatusOr<google::devtools::artifactregistry::v1::Repository>>
ArtifactRegistryClient::CreateRepository(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateRepository(operation);
}

StatusOr<google::devtools::artifactregistry::v1::Repository>
ArtifactRegistryClient::UpdateRepository(
    google::devtools::artifactregistry::v1::Repository const& repository,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::UpdateRepositoryRequest request;
  *request.mutable_repository() = repository;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateRepository(request);
}

StatusOr<google::devtools::artifactregistry::v1::Repository>
ArtifactRegistryClient::UpdateRepository(
    google::devtools::artifactregistry::v1::UpdateRepositoryRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateRepository(request);
}

future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
ArtifactRegistryClient::DeleteRepository(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::DeleteRepositoryRequest request;
  request.set_name(name);
  return connection_->DeleteRepository(request);
}

StatusOr<google::longrunning::Operation>
ArtifactRegistryClient::DeleteRepository(NoAwaitTag, std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::DeleteRepositoryRequest request;
  request.set_name(name);
  return connection_->DeleteRepository(NoAwaitTag{}, request);
}

future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
ArtifactRegistryClient::DeleteRepository(
    google::devtools::artifactregistry::v1::DeleteRepositoryRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteRepository(request);
}

StatusOr<google::longrunning::Operation>
ArtifactRegistryClient::DeleteRepository(
    NoAwaitTag,
    google::devtools::artifactregistry::v1::DeleteRepositoryRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteRepository(NoAwaitTag{}, request);
}

future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
ArtifactRegistryClient::DeleteRepository(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteRepository(operation);
}

StreamRange<google::devtools::artifactregistry::v1::Package>
ArtifactRegistryClient::ListPackages(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::ListPackagesRequest request;
  request.set_parent(parent);
  return connection_->ListPackages(request);
}

StreamRange<google::devtools::artifactregistry::v1::Package>
ArtifactRegistryClient::ListPackages(
    google::devtools::artifactregistry::v1::ListPackagesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListPackages(std::move(request));
}

StatusOr<google::devtools::artifactregistry::v1::Package>
ArtifactRegistryClient::GetPackage(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::GetPackageRequest request;
  request.set_name(name);
  return connection_->GetPackage(request);
}

StatusOr<google::devtools::artifactregistry::v1::Package>
ArtifactRegistryClient::GetPackage(
    google::devtools::artifactregistry::v1::GetPackageRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetPackage(request);
}

future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
ArtifactRegistryClient::DeletePackage(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::DeletePackageRequest request;
  request.set_name(name);
  return connection_->DeletePackage(request);
}

StatusOr<google::longrunning::Operation> ArtifactRegistryClient::DeletePackage(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::DeletePackageRequest request;
  request.set_name(name);
  return connection_->DeletePackage(NoAwaitTag{}, request);
}

future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
ArtifactRegistryClient::DeletePackage(
    google::devtools::artifactregistry::v1::DeletePackageRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeletePackage(request);
}

StatusOr<google::longrunning::Operation> ArtifactRegistryClient::DeletePackage(
    NoAwaitTag,
    google::devtools::artifactregistry::v1::DeletePackageRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeletePackage(NoAwaitTag{}, request);
}

future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
ArtifactRegistryClient::DeletePackage(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeletePackage(operation);
}

StreamRange<google::devtools::artifactregistry::v1::Version>
ArtifactRegistryClient::ListVersions(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::ListVersionsRequest request;
  request.set_parent(parent);
  return connection_->ListVersions(request);
}

StreamRange<google::devtools::artifactregistry::v1::Version>
ArtifactRegistryClient::ListVersions(
    google::devtools::artifactregistry::v1::ListVersionsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListVersions(std::move(request));
}

StatusOr<google::devtools::artifactregistry::v1::Version>
ArtifactRegistryClient::GetVersion(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::GetVersionRequest request;
  request.set_name(name);
  return connection_->GetVersion(request);
}

StatusOr<google::devtools::artifactregistry::v1::Version>
ArtifactRegistryClient::GetVersion(
    google::devtools::artifactregistry::v1::GetVersionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetVersion(request);
}

future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
ArtifactRegistryClient::DeleteVersion(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::DeleteVersionRequest request;
  request.set_name(name);
  return connection_->DeleteVersion(request);
}

StatusOr<google::longrunning::Operation> ArtifactRegistryClient::DeleteVersion(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::DeleteVersionRequest request;
  request.set_name(name);
  return connection_->DeleteVersion(NoAwaitTag{}, request);
}

future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
ArtifactRegistryClient::DeleteVersion(
    google::devtools::artifactregistry::v1::DeleteVersionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteVersion(request);
}

StatusOr<google::longrunning::Operation> ArtifactRegistryClient::DeleteVersion(
    NoAwaitTag,
    google::devtools::artifactregistry::v1::DeleteVersionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteVersion(NoAwaitTag{}, request);
}

future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
ArtifactRegistryClient::DeleteVersion(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteVersion(operation);
}

future<StatusOr<
    google::devtools::artifactregistry::v1::BatchDeleteVersionsMetadata>>
ArtifactRegistryClient::BatchDeleteVersions(
    std::string const& parent, std::vector<std::string> const& names,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::BatchDeleteVersionsRequest request;
  request.set_parent(parent);
  *request.mutable_names() = {names.begin(), names.end()};
  return connection_->BatchDeleteVersions(request);
}

StatusOr<google::longrunning::Operation>
ArtifactRegistryClient::BatchDeleteVersions(
    NoAwaitTag, std::string const& parent,
    std::vector<std::string> const& names, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::BatchDeleteVersionsRequest request;
  request.set_parent(parent);
  *request.mutable_names() = {names.begin(), names.end()};
  return connection_->BatchDeleteVersions(NoAwaitTag{}, request);
}

future<StatusOr<
    google::devtools::artifactregistry::v1::BatchDeleteVersionsMetadata>>
ArtifactRegistryClient::BatchDeleteVersions(
    google::devtools::artifactregistry::v1::BatchDeleteVersionsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchDeleteVersions(request);
}

StatusOr<google::longrunning::Operation>
ArtifactRegistryClient::BatchDeleteVersions(
    NoAwaitTag,
    google::devtools::artifactregistry::v1::BatchDeleteVersionsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchDeleteVersions(NoAwaitTag{}, request);
}

future<StatusOr<
    google::devtools::artifactregistry::v1::BatchDeleteVersionsMetadata>>
ArtifactRegistryClient::BatchDeleteVersions(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchDeleteVersions(operation);
}

StatusOr<google::devtools::artifactregistry::v1::Version>
ArtifactRegistryClient::UpdateVersion(
    google::devtools::artifactregistry::v1::Version const& version,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::UpdateVersionRequest request;
  *request.mutable_version() = version;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateVersion(request);
}

StatusOr<google::devtools::artifactregistry::v1::Version>
ArtifactRegistryClient::UpdateVersion(
    google::devtools::artifactregistry::v1::UpdateVersionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateVersion(request);
}

StreamRange<google::devtools::artifactregistry::v1::File>
ArtifactRegistryClient::ListFiles(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::ListFilesRequest request;
  request.set_parent(parent);
  return connection_->ListFiles(request);
}

StreamRange<google::devtools::artifactregistry::v1::File>
ArtifactRegistryClient::ListFiles(
    google::devtools::artifactregistry::v1::ListFilesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListFiles(std::move(request));
}

StatusOr<google::devtools::artifactregistry::v1::File>
ArtifactRegistryClient::GetFile(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::GetFileRequest request;
  request.set_name(name);
  return connection_->GetFile(request);
}

StatusOr<google::devtools::artifactregistry::v1::File>
ArtifactRegistryClient::GetFile(
    google::devtools::artifactregistry::v1::GetFileRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetFile(request);
}

future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
ArtifactRegistryClient::DeleteFile(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::DeleteFileRequest request;
  request.set_name(name);
  return connection_->DeleteFile(request);
}

StatusOr<google::longrunning::Operation> ArtifactRegistryClient::DeleteFile(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::DeleteFileRequest request;
  request.set_name(name);
  return connection_->DeleteFile(NoAwaitTag{}, request);
}

future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
ArtifactRegistryClient::DeleteFile(
    google::devtools::artifactregistry::v1::DeleteFileRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteFile(request);
}

StatusOr<google::longrunning::Operation> ArtifactRegistryClient::DeleteFile(
    NoAwaitTag,
    google::devtools::artifactregistry::v1::DeleteFileRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteFile(NoAwaitTag{}, request);
}

future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
ArtifactRegistryClient::DeleteFile(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteFile(operation);
}

StatusOr<google::devtools::artifactregistry::v1::File>
ArtifactRegistryClient::UpdateFile(
    google::devtools::artifactregistry::v1::File const& file,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::UpdateFileRequest request;
  *request.mutable_file() = file;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateFile(request);
}

StatusOr<google::devtools::artifactregistry::v1::File>
ArtifactRegistryClient::UpdateFile(
    google::devtools::artifactregistry::v1::UpdateFileRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateFile(request);
}

StreamRange<google::devtools::artifactregistry::v1::Tag>
ArtifactRegistryClient::ListTags(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::ListTagsRequest request;
  request.set_parent(parent);
  return connection_->ListTags(request);
}

StreamRange<google::devtools::artifactregistry::v1::Tag>
ArtifactRegistryClient::ListTags(
    google::devtools::artifactregistry::v1::ListTagsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListTags(std::move(request));
}

StatusOr<google::devtools::artifactregistry::v1::Tag>
ArtifactRegistryClient::GetTag(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::GetTagRequest request;
  request.set_name(name);
  return connection_->GetTag(request);
}

StatusOr<google::devtools::artifactregistry::v1::Tag>
ArtifactRegistryClient::GetTag(
    google::devtools::artifactregistry::v1::GetTagRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetTag(request);
}

StatusOr<google::devtools::artifactregistry::v1::Tag>
ArtifactRegistryClient::CreateTag(
    std::string const& parent,
    google::devtools::artifactregistry::v1::Tag const& tag,
    std::string const& tag_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::CreateTagRequest request;
  request.set_parent(parent);
  *request.mutable_tag() = tag;
  request.set_tag_id(tag_id);
  return connection_->CreateTag(request);
}

StatusOr<google::devtools::artifactregistry::v1::Tag>
ArtifactRegistryClient::CreateTag(
    google::devtools::artifactregistry::v1::CreateTagRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateTag(request);
}

StatusOr<google::devtools::artifactregistry::v1::Tag>
ArtifactRegistryClient::UpdateTag(
    google::devtools::artifactregistry::v1::Tag const& tag,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::UpdateTagRequest request;
  *request.mutable_tag() = tag;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateTag(request);
}

StatusOr<google::devtools::artifactregistry::v1::Tag>
ArtifactRegistryClient::UpdateTag(
    google::devtools::artifactregistry::v1::UpdateTagRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateTag(request);
}

Status ArtifactRegistryClient::DeleteTag(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::DeleteTagRequest request;
  request.set_name(name);
  return connection_->DeleteTag(request);
}

Status ArtifactRegistryClient::DeleteTag(
    google::devtools::artifactregistry::v1::DeleteTagRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTag(request);
}

StatusOr<google::devtools::artifactregistry::v1::Rule>
ArtifactRegistryClient::CreateRule(
    std::string const& parent,
    google::devtools::artifactregistry::v1::Rule const& rule,
    std::string const& rule_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::CreateRuleRequest request;
  request.set_parent(parent);
  *request.mutable_rule() = rule;
  request.set_rule_id(rule_id);
  return connection_->CreateRule(request);
}

StatusOr<google::devtools::artifactregistry::v1::Rule>
ArtifactRegistryClient::CreateRule(
    google::devtools::artifactregistry::v1::CreateRuleRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateRule(request);
}

StreamRange<google::devtools::artifactregistry::v1::Rule>
ArtifactRegistryClient::ListRules(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::ListRulesRequest request;
  request.set_parent(parent);
  return connection_->ListRules(request);
}

StreamRange<google::devtools::artifactregistry::v1::Rule>
ArtifactRegistryClient::ListRules(
    google::devtools::artifactregistry::v1::ListRulesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListRules(std::move(request));
}

StatusOr<google::devtools::artifactregistry::v1::Rule>
ArtifactRegistryClient::GetRule(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::GetRuleRequest request;
  request.set_name(name);
  return connection_->GetRule(request);
}

StatusOr<google::devtools::artifactregistry::v1::Rule>
ArtifactRegistryClient::GetRule(
    google::devtools::artifactregistry::v1::GetRuleRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetRule(request);
}

StatusOr<google::devtools::artifactregistry::v1::Rule>
ArtifactRegistryClient::UpdateRule(
    google::devtools::artifactregistry::v1::Rule const& rule,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::UpdateRuleRequest request;
  *request.mutable_rule() = rule;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateRule(request);
}

StatusOr<google::devtools::artifactregistry::v1::Rule>
ArtifactRegistryClient::UpdateRule(
    google::devtools::artifactregistry::v1::UpdateRuleRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateRule(request);
}

Status ArtifactRegistryClient::DeleteRule(std::string const& name,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::DeleteRuleRequest request;
  request.set_name(name);
  return connection_->DeleteRule(request);
}

Status ArtifactRegistryClient::DeleteRule(
    google::devtools::artifactregistry::v1::DeleteRuleRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteRule(request);
}

StatusOr<google::iam::v1::Policy> ArtifactRegistryClient::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> ArtifactRegistryClient::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIamPolicy(request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
ArtifactRegistryClient::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

StatusOr<google::devtools::artifactregistry::v1::ProjectSettings>
ArtifactRegistryClient::GetProjectSettings(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::GetProjectSettingsRequest request;
  request.set_name(name);
  return connection_->GetProjectSettings(request);
}

StatusOr<google::devtools::artifactregistry::v1::ProjectSettings>
ArtifactRegistryClient::GetProjectSettings(
    google::devtools::artifactregistry::v1::GetProjectSettingsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetProjectSettings(request);
}

StatusOr<google::devtools::artifactregistry::v1::ProjectSettings>
ArtifactRegistryClient::UpdateProjectSettings(
    google::devtools::artifactregistry::v1::ProjectSettings const&
        project_settings,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::UpdateProjectSettingsRequest request;
  *request.mutable_project_settings() = project_settings;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateProjectSettings(request);
}

StatusOr<google::devtools::artifactregistry::v1::ProjectSettings>
ArtifactRegistryClient::UpdateProjectSettings(
    google::devtools::artifactregistry::v1::UpdateProjectSettingsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateProjectSettings(request);
}

StatusOr<google::devtools::artifactregistry::v1::VPCSCConfig>
ArtifactRegistryClient::GetVPCSCConfig(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::GetVPCSCConfigRequest request;
  request.set_name(name);
  return connection_->GetVPCSCConfig(request);
}

StatusOr<google::devtools::artifactregistry::v1::VPCSCConfig>
ArtifactRegistryClient::GetVPCSCConfig(
    google::devtools::artifactregistry::v1::GetVPCSCConfigRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetVPCSCConfig(request);
}

StatusOr<google::devtools::artifactregistry::v1::VPCSCConfig>
ArtifactRegistryClient::UpdateVPCSCConfig(
    google::devtools::artifactregistry::v1::VPCSCConfig const& vpcsc_config,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::UpdateVPCSCConfigRequest request;
  *request.mutable_vpcsc_config() = vpcsc_config;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateVPCSCConfig(request);
}

StatusOr<google::devtools::artifactregistry::v1::VPCSCConfig>
ArtifactRegistryClient::UpdateVPCSCConfig(
    google::devtools::artifactregistry::v1::UpdateVPCSCConfigRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateVPCSCConfig(request);
}

StatusOr<google::devtools::artifactregistry::v1::Package>
ArtifactRegistryClient::UpdatePackage(
    google::devtools::artifactregistry::v1::Package const& package,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::UpdatePackageRequest request;
  *request.mutable_package() = package;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdatePackage(request);
}

StatusOr<google::devtools::artifactregistry::v1::Package>
ArtifactRegistryClient::UpdatePackage(
    google::devtools::artifactregistry::v1::UpdatePackageRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdatePackage(request);
}

StreamRange<google::devtools::artifactregistry::v1::Attachment>
ArtifactRegistryClient::ListAttachments(std::string const& parent,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::ListAttachmentsRequest request;
  request.set_parent(parent);
  return connection_->ListAttachments(request);
}

StreamRange<google::devtools::artifactregistry::v1::Attachment>
ArtifactRegistryClient::ListAttachments(
    google::devtools::artifactregistry::v1::ListAttachmentsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListAttachments(std::move(request));
}

StatusOr<google::devtools::artifactregistry::v1::Attachment>
ArtifactRegistryClient::GetAttachment(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::GetAttachmentRequest request;
  request.set_name(name);
  return connection_->GetAttachment(request);
}

StatusOr<google::devtools::artifactregistry::v1::Attachment>
ArtifactRegistryClient::GetAttachment(
    google::devtools::artifactregistry::v1::GetAttachmentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetAttachment(request);
}

future<StatusOr<google::devtools::artifactregistry::v1::Attachment>>
ArtifactRegistryClient::CreateAttachment(
    std::string const& parent,
    google::devtools::artifactregistry::v1::Attachment const& attachment,
    std::string const& attachment_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::CreateAttachmentRequest request;
  request.set_parent(parent);
  *request.mutable_attachment() = attachment;
  request.set_attachment_id(attachment_id);
  return connection_->CreateAttachment(request);
}

StatusOr<google::longrunning::Operation>
ArtifactRegistryClient::CreateAttachment(
    NoAwaitTag, std::string const& parent,
    google::devtools::artifactregistry::v1::Attachment const& attachment,
    std::string const& attachment_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::CreateAttachmentRequest request;
  request.set_parent(parent);
  *request.mutable_attachment() = attachment;
  request.set_attachment_id(attachment_id);
  return connection_->CreateAttachment(NoAwaitTag{}, request);
}

future<StatusOr<google::devtools::artifactregistry::v1::Attachment>>
ArtifactRegistryClient::CreateAttachment(
    google::devtools::artifactregistry::v1::CreateAttachmentRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateAttachment(request);
}

StatusOr<google::longrunning::Operation>
ArtifactRegistryClient::CreateAttachment(
    NoAwaitTag,
    google::devtools::artifactregistry::v1::CreateAttachmentRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateAttachment(NoAwaitTag{}, request);
}

future<StatusOr<google::devtools::artifactregistry::v1::Attachment>>
ArtifactRegistryClient::CreateAttachment(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateAttachment(operation);
}

future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
ArtifactRegistryClient::DeleteAttachment(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::DeleteAttachmentRequest request;
  request.set_name(name);
  return connection_->DeleteAttachment(request);
}

StatusOr<google::longrunning::Operation>
ArtifactRegistryClient::DeleteAttachment(NoAwaitTag, std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::devtools::artifactregistry::v1::DeleteAttachmentRequest request;
  request.set_name(name);
  return connection_->DeleteAttachment(NoAwaitTag{}, request);
}

future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
ArtifactRegistryClient::DeleteAttachment(
    google::devtools::artifactregistry::v1::DeleteAttachmentRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteAttachment(request);
}

StatusOr<google::longrunning::Operation>
ArtifactRegistryClient::DeleteAttachment(
    NoAwaitTag,
    google::devtools::artifactregistry::v1::DeleteAttachmentRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteAttachment(NoAwaitTag{}, request);
}

future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
ArtifactRegistryClient::DeleteAttachment(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteAttachment(operation);
}

StreamRange<google::cloud::location::Location>
ArtifactRegistryClient::ListLocations(
    google::cloud::location::ListLocationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLocations(std::move(request));
}

StatusOr<google::cloud::location::Location> ArtifactRegistryClient::GetLocation(
    google::cloud::location::GetLocationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetLocation(request);
}

StatusOr<google::longrunning::Operation> ArtifactRegistryClient::GetOperation(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::longrunning::Operation> ArtifactRegistryClient::GetOperation(
    google::longrunning::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace artifactregistry_v1
}  // namespace cloud
}  // namespace google
