// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/apphub/v1/apphub_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPHUB_V1_MOCKS_MOCK_APP_HUB_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPHUB_V1_MOCKS_MOCK_APP_HUB_CONNECTION_H

#include "google/cloud/apphub/v1/app_hub_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace apphub_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `AppHubConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `AppHubClient`. To do so,
 * construct an object of type `AppHubClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockAppHubConnection : public apphub_v1::AppHubConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD(
      StatusOr<
          google::cloud::apphub::v1::LookupServiceProjectAttachmentResponse>,
      LookupServiceProjectAttachment,
      (google::cloud::apphub::v1::LookupServiceProjectAttachmentRequest const&
           request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::apphub::v1::ServiceProjectAttachment>),
      ListServiceProjectAttachments,
      (google::cloud::apphub::v1::ListServiceProjectAttachmentsRequest request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateServiceProjectAttachment(Matcher<google::cloud::apphub::v1::CreateServiceProjectAttachmentRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>>,
      CreateServiceProjectAttachment,
      (google::cloud::apphub::v1::CreateServiceProjectAttachmentRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateServiceProjectAttachment(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateServiceProjectAttachment,
      (NoAwaitTag,
       google::cloud::apphub::v1::CreateServiceProjectAttachmentRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateServiceProjectAttachment(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>>,
      CreateServiceProjectAttachment,
      (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD(
      StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>,
      GetServiceProjectAttachment,
      (google::cloud::apphub::v1::GetServiceProjectAttachmentRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteServiceProjectAttachment(Matcher<google::cloud::apphub::v1::DeleteServiceProjectAttachmentRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>,
      DeleteServiceProjectAttachment,
      (google::cloud::apphub::v1::DeleteServiceProjectAttachmentRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteServiceProjectAttachment(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteServiceProjectAttachment,
      (NoAwaitTag,
       google::cloud::apphub::v1::DeleteServiceProjectAttachmentRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteServiceProjectAttachment(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>,
              DeleteServiceProjectAttachment,
              (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD(
      StatusOr<
          google::cloud::apphub::v1::DetachServiceProjectAttachmentResponse>,
      DetachServiceProjectAttachment,
      (google::cloud::apphub::v1::DetachServiceProjectAttachmentRequest const&
           request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::apphub::v1::DiscoveredService>),
      ListDiscoveredServices,
      (google::cloud::apphub::v1::ListDiscoveredServicesRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::apphub::v1::DiscoveredService>,
      GetDiscoveredService,
      (google::cloud::apphub::v1::GetDiscoveredServiceRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::apphub::v1::LookupDiscoveredServiceResponse>,
      LookupDiscoveredService,
      (google::cloud::apphub::v1::LookupDiscoveredServiceRequest const&
           request),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::apphub::v1::Service>), ListServices,
              (google::cloud::apphub::v1::ListServicesRequest request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateService(Matcher<google::cloud::apphub::v1::CreateServiceRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::apphub::v1::Service>>,
              CreateService,
              (google::cloud::apphub::v1::CreateServiceRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateService(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, CreateService,
              (NoAwaitTag,
               google::cloud::apphub::v1::CreateServiceRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, CreateService(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::apphub::v1::Service>>,
              CreateService, (google::longrunning::Operation const& operation),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::apphub::v1::Service>, GetService,
              (google::cloud::apphub::v1::GetServiceRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateService(Matcher<google::cloud::apphub::v1::UpdateServiceRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::apphub::v1::Service>>,
              UpdateService,
              (google::cloud::apphub::v1::UpdateServiceRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateService(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, UpdateService,
              (NoAwaitTag,
               google::cloud::apphub::v1::UpdateServiceRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, UpdateService(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::apphub::v1::Service>>,
              UpdateService, (google::longrunning::Operation const& operation),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteService(Matcher<google::cloud::apphub::v1::DeleteServiceRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>,
              DeleteService,
              (google::cloud::apphub::v1::DeleteServiceRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteService(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, DeleteService,
              (NoAwaitTag,
               google::cloud::apphub::v1::DeleteServiceRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, DeleteService(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>,
              DeleteService, (google::longrunning::Operation const& operation),
              (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::apphub::v1::DiscoveredWorkload>),
      ListDiscoveredWorkloads,
      (google::cloud::apphub::v1::ListDiscoveredWorkloadsRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::apphub::v1::DiscoveredWorkload>,
      GetDiscoveredWorkload,
      (google::cloud::apphub::v1::GetDiscoveredWorkloadRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::apphub::v1::LookupDiscoveredWorkloadResponse>,
      LookupDiscoveredWorkload,
      (google::cloud::apphub::v1::LookupDiscoveredWorkloadRequest const&
           request),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::apphub::v1::Workload>), ListWorkloads,
              (google::cloud::apphub::v1::ListWorkloadsRequest request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateWorkload(Matcher<google::cloud::apphub::v1::CreateWorkloadRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::apphub::v1::Workload>>,
              CreateWorkload,
              (google::cloud::apphub::v1::CreateWorkloadRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateWorkload(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, CreateWorkload,
              (NoAwaitTag,
               google::cloud::apphub::v1::CreateWorkloadRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, CreateWorkload(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::apphub::v1::Workload>>,
              CreateWorkload, (google::longrunning::Operation const& operation),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::apphub::v1::Workload>, GetWorkload,
              (google::cloud::apphub::v1::GetWorkloadRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateWorkload(Matcher<google::cloud::apphub::v1::UpdateWorkloadRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::apphub::v1::Workload>>,
              UpdateWorkload,
              (google::cloud::apphub::v1::UpdateWorkloadRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateWorkload(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, UpdateWorkload,
              (NoAwaitTag,
               google::cloud::apphub::v1::UpdateWorkloadRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, UpdateWorkload(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::apphub::v1::Workload>>,
              UpdateWorkload, (google::longrunning::Operation const& operation),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteWorkload(Matcher<google::cloud::apphub::v1::DeleteWorkloadRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>,
              DeleteWorkload,
              (google::cloud::apphub::v1::DeleteWorkloadRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteWorkload(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, DeleteWorkload,
              (NoAwaitTag,
               google::cloud::apphub::v1::DeleteWorkloadRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, DeleteWorkload(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>,
              DeleteWorkload, (google::longrunning::Operation const& operation),
              (override));

  MOCK_METHOD((StreamRange<google::cloud::apphub::v1::Application>),
              ListApplications,
              (google::cloud::apphub::v1::ListApplicationsRequest request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateApplication(Matcher<google::cloud::apphub::v1::CreateApplicationRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::apphub::v1::Application>>,
      CreateApplication,
      (google::cloud::apphub::v1::CreateApplicationRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateApplication(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateApplication,
      (NoAwaitTag,
       google::cloud::apphub::v1::CreateApplicationRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateApplication(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::apphub::v1::Application>>,
              CreateApplication,
              (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD(StatusOr<google::cloud::apphub::v1::Application>, GetApplication,
              (google::cloud::apphub::v1::GetApplicationRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateApplication(Matcher<google::cloud::apphub::v1::UpdateApplicationRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::apphub::v1::Application>>,
      UpdateApplication,
      (google::cloud::apphub::v1::UpdateApplicationRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateApplication(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdateApplication,
      (NoAwaitTag,
       google::cloud::apphub::v1::UpdateApplicationRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateApplication(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::apphub::v1::Application>>,
              UpdateApplication,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteApplication(Matcher<google::cloud::apphub::v1::DeleteApplicationRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>,
      DeleteApplication,
      (google::cloud::apphub::v1::DeleteApplicationRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteApplication(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteApplication,
      (NoAwaitTag,
       google::cloud::apphub::v1::DeleteApplicationRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteApplication(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>,
              DeleteApplication,
              (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD((StreamRange<google::cloud::location::Location>), ListLocations,
              (google::cloud::location::ListLocationsRequest request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::location::Location>, GetLocation,
              (google::cloud::location::GetLocationRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::iam::v1::Policy>, SetIamPolicy,
              (google::iam::v1::SetIamPolicyRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::iam::v1::Policy>, GetIamPolicy,
              (google::iam::v1::GetIamPolicyRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::iam::v1::TestIamPermissionsResponse>,
              TestIamPermissions,
              (google::iam::v1::TestIamPermissionsRequest const& request),
              (override));

  MOCK_METHOD((StreamRange<google::longrunning::Operation>), ListOperations,
              (google::longrunning::ListOperationsRequest request), (override));

  MOCK_METHOD(StatusOr<google::longrunning::Operation>, GetOperation,
              (google::longrunning::GetOperationRequest const& request),
              (override));

  MOCK_METHOD(Status, DeleteOperation,
              (google::longrunning::DeleteOperationRequest const& request),
              (override));

  MOCK_METHOD(Status, CancelOperation,
              (google::longrunning::CancelOperationRequest const& request),
              (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace apphub_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPHUB_V1_MOCKS_MOCK_APP_HUB_CONNECTION_H
