// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/apphub/v1/apphub_service.proto

#include "google/cloud/apphub/v1/internal/app_hub_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace apphub_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

AppHubTracingStub::AppHubTracingStub(std::shared_ptr<AppHubStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::apphub::v1::LookupServiceProjectAttachmentResponse>
AppHubTracingStub::LookupServiceProjectAttachment(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::LookupServiceProjectAttachmentRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub",
                                     "LookupServiceProjectAttachment");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->LookupServiceProjectAttachment(context, options, request));
}

StatusOr<google::cloud::apphub::v1::ListServiceProjectAttachmentsResponse>
AppHubTracingStub::ListServiceProjectAttachments(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::ListServiceProjectAttachmentsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub",
                                     "ListServiceProjectAttachments");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->ListServiceProjectAttachments(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
AppHubTracingStub::AsyncCreateServiceProjectAttachment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apphub::v1::CreateServiceProjectAttachmentRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub",
                                     "CreateServiceProjectAttachment");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateServiceProjectAttachment(
      cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
AppHubTracingStub::CreateServiceProjectAttachment(
    grpc::ClientContext& context, Options options,
    google::cloud::apphub::v1::CreateServiceProjectAttachmentRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub",
                                     "CreateServiceProjectAttachment");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->CreateServiceProjectAttachment(context, options, request));
}

StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>
AppHubTracingStub::GetServiceProjectAttachment(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::GetServiceProjectAttachmentRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub",
                                     "GetServiceProjectAttachment");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->GetServiceProjectAttachment(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
AppHubTracingStub::AsyncDeleteServiceProjectAttachment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apphub::v1::DeleteServiceProjectAttachmentRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub",
                                     "DeleteServiceProjectAttachment");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteServiceProjectAttachment(
      cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
AppHubTracingStub::DeleteServiceProjectAttachment(
    grpc::ClientContext& context, Options options,
    google::cloud::apphub::v1::DeleteServiceProjectAttachmentRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub",
                                     "DeleteServiceProjectAttachment");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->DeleteServiceProjectAttachment(context, options, request));
}

StatusOr<google::cloud::apphub::v1::DetachServiceProjectAttachmentResponse>
AppHubTracingStub::DetachServiceProjectAttachment(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::DetachServiceProjectAttachmentRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub",
                                     "DetachServiceProjectAttachment");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->DetachServiceProjectAttachment(context, options, request));
}

StatusOr<google::cloud::apphub::v1::ListDiscoveredServicesResponse>
AppHubTracingStub::ListDiscoveredServices(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::ListDiscoveredServicesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub",
                                     "ListDiscoveredServices");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->ListDiscoveredServices(context, options, request));
}

StatusOr<google::cloud::apphub::v1::DiscoveredService>
AppHubTracingStub::GetDiscoveredService(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::GetDiscoveredServiceRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub",
                                     "GetDiscoveredService");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->GetDiscoveredService(context, options, request));
}

StatusOr<google::cloud::apphub::v1::LookupDiscoveredServiceResponse>
AppHubTracingStub::LookupDiscoveredService(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::LookupDiscoveredServiceRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub",
                                     "LookupDiscoveredService");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->LookupDiscoveredService(context, options, request));
}

StatusOr<google::cloud::apphub::v1::ListServicesResponse>
AppHubTracingStub::ListServices(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::ListServicesRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub", "ListServices");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListServices(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
AppHubTracingStub::AsyncCreateService(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apphub::v1::CreateServiceRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub", "CreateService");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateService(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> AppHubTracingStub::CreateService(
    grpc::ClientContext& context, Options options,
    google::cloud::apphub::v1::CreateServiceRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub", "CreateService");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateService(context, options, request));
}

StatusOr<google::cloud::apphub::v1::Service> AppHubTracingStub::GetService(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::GetServiceRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub", "GetService");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetService(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
AppHubTracingStub::AsyncUpdateService(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apphub::v1::UpdateServiceRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub", "UpdateService");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateService(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> AppHubTracingStub::UpdateService(
    grpc::ClientContext& context, Options options,
    google::cloud::apphub::v1::UpdateServiceRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub", "UpdateService");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateService(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
AppHubTracingStub::AsyncDeleteService(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apphub::v1::DeleteServiceRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub", "DeleteService");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteService(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> AppHubTracingStub::DeleteService(
    grpc::ClientContext& context, Options options,
    google::cloud::apphub::v1::DeleteServiceRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub", "DeleteService");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteService(context, options, request));
}

StatusOr<google::cloud::apphub::v1::ListDiscoveredWorkloadsResponse>
AppHubTracingStub::ListDiscoveredWorkloads(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::ListDiscoveredWorkloadsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub",
                                     "ListDiscoveredWorkloads");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->ListDiscoveredWorkloads(context, options, request));
}

StatusOr<google::cloud::apphub::v1::DiscoveredWorkload>
AppHubTracingStub::GetDiscoveredWorkload(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::GetDiscoveredWorkloadRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub",
                                     "GetDiscoveredWorkload");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->GetDiscoveredWorkload(context, options, request));
}

StatusOr<google::cloud::apphub::v1::LookupDiscoveredWorkloadResponse>
AppHubTracingStub::LookupDiscoveredWorkload(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::LookupDiscoveredWorkloadRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub",
                                     "LookupDiscoveredWorkload");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->LookupDiscoveredWorkload(context, options, request));
}

StatusOr<google::cloud::apphub::v1::ListWorkloadsResponse>
AppHubTracingStub::ListWorkloads(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::ListWorkloadsRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub", "ListWorkloads");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListWorkloads(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
AppHubTracingStub::AsyncCreateWorkload(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apphub::v1::CreateWorkloadRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub", "CreateWorkload");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateWorkload(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> AppHubTracingStub::CreateWorkload(
    grpc::ClientContext& context, Options options,
    google::cloud::apphub::v1::CreateWorkloadRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub", "CreateWorkload");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateWorkload(context, options, request));
}

StatusOr<google::cloud::apphub::v1::Workload> AppHubTracingStub::GetWorkload(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::GetWorkloadRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub", "GetWorkload");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetWorkload(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
AppHubTracingStub::AsyncUpdateWorkload(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apphub::v1::UpdateWorkloadRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub", "UpdateWorkload");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUpdateWorkload(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> AppHubTracingStub::UpdateWorkload(
    grpc::ClientContext& context, Options options,
    google::cloud::apphub::v1::UpdateWorkloadRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub", "UpdateWorkload");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateWorkload(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
AppHubTracingStub::AsyncDeleteWorkload(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apphub::v1::DeleteWorkloadRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub", "DeleteWorkload");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteWorkload(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> AppHubTracingStub::DeleteWorkload(
    grpc::ClientContext& context, Options options,
    google::cloud::apphub::v1::DeleteWorkloadRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub", "DeleteWorkload");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteWorkload(context, options, request));
}

StatusOr<google::cloud::apphub::v1::ListApplicationsResponse>
AppHubTracingStub::ListApplications(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::ListApplicationsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub",
                                     "ListApplications");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListApplications(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
AppHubTracingStub::AsyncCreateApplication(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apphub::v1::CreateApplicationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub",
                                     "CreateApplication");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateApplication(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> AppHubTracingStub::CreateApplication(
    grpc::ClientContext& context, Options options,
    google::cloud::apphub::v1::CreateApplicationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub",
                                     "CreateApplication");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->CreateApplication(context, options, request));
}

StatusOr<google::cloud::apphub::v1::Application>
AppHubTracingStub::GetApplication(
    grpc::ClientContext& context, Options const& options,
    google::cloud::apphub::v1::GetApplicationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub", "GetApplication");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetApplication(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
AppHubTracingStub::AsyncUpdateApplication(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apphub::v1::UpdateApplicationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub",
                                     "UpdateApplication");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUpdateApplication(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> AppHubTracingStub::UpdateApplication(
    grpc::ClientContext& context, Options options,
    google::cloud::apphub::v1::UpdateApplicationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub",
                                     "UpdateApplication");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->UpdateApplication(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
AppHubTracingStub::AsyncDeleteApplication(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::apphub::v1::DeleteApplicationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub",
                                     "DeleteApplication");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteApplication(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> AppHubTracingStub::DeleteApplication(
    grpc::ClientContext& context, Options options,
    google::cloud::apphub::v1::DeleteApplicationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub",
                                     "DeleteApplication");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->DeleteApplication(context, options, request));
}

StatusOr<google::cloud::location::ListLocationsResponse>
AppHubTracingStub::ListLocations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::ListLocationsRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub", "ListLocations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListLocations(context, options, request));
}

StatusOr<google::cloud::location::Location> AppHubTracingStub::GetLocation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::GetLocationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub", "GetLocation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetLocation(context, options, request));
}

StatusOr<google::iam::v1::Policy> AppHubTracingStub::SetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub", "SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->SetIamPolicy(context, options, request));
}

StatusOr<google::iam::v1::Policy> AppHubTracingStub::GetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub", "GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetIamPolicy(context, options, request));
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
AppHubTracingStub::TestIamPermissions(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub",
                                     "TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->TestIamPermissions(context, options, request));
}

StatusOr<google::longrunning::ListOperationsResponse>
AppHubTracingStub::ListOperations(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::ListOperationsRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub", "ListOperations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListOperations(context, options, request));
}

StatusOr<google::longrunning::Operation> AppHubTracingStub::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub", "GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetOperation(context, options, request));
}

Status AppHubTracingStub::DeleteOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::DeleteOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub",
                                     "DeleteOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteOperation(context, options, request));
}

Status AppHubTracingStub::CancelOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.apphub.v1.AppHub",
                                     "CancelOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CancelOperation(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
AppHubTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> AppHubTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCancelOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<AppHubStub> MakeAppHubTracingStub(
    std::shared_ptr<AppHubStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<AppHubTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace apphub_v1_internal
}  // namespace cloud
}  // namespace google
