// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/apphub/v1/apphub_service.proto

#include "google/cloud/apphub/v1/app_hub_connection.h"
#include "google/cloud/apphub/v1/app_hub_options.h"
#include "google/cloud/apphub/v1/internal/app_hub_connection_impl.h"
#include "google/cloud/apphub/v1/internal/app_hub_option_defaults.h"
#include "google/cloud/apphub/v1/internal/app_hub_stub_factory.h"
#include "google/cloud/apphub/v1/internal/app_hub_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace apphub_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AppHubConnection::~AppHubConnection() = default;

StatusOr<google::cloud::apphub::v1::LookupServiceProjectAttachmentResponse>
AppHubConnection::LookupServiceProjectAttachment(
    google::cloud::apphub::v1::LookupServiceProjectAttachmentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::apphub::v1::ServiceProjectAttachment>
AppHubConnection::ListServiceProjectAttachments(
    google::cloud::apphub::v1::
        ListServiceProjectAttachmentsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::apphub::v1::ServiceProjectAttachment>>();
}

future<StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>>
AppHubConnection::CreateServiceProjectAttachment(
    google::cloud::apphub::v1::CreateServiceProjectAttachmentRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
AppHubConnection::CreateServiceProjectAttachment(
    NoAwaitTag,
    google::cloud::apphub::v1::CreateServiceProjectAttachmentRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>>
AppHubConnection::CreateServiceProjectAttachment(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>
AppHubConnection::GetServiceProjectAttachment(
    google::cloud::apphub::v1::GetServiceProjectAttachmentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubConnection::DeleteServiceProjectAttachment(
    google::cloud::apphub::v1::DeleteServiceProjectAttachmentRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::apphub::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
AppHubConnection::DeleteServiceProjectAttachment(
    NoAwaitTag,
    google::cloud::apphub::v1::DeleteServiceProjectAttachmentRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubConnection::DeleteServiceProjectAttachment(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::apphub::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::apphub::v1::DetachServiceProjectAttachmentResponse>
AppHubConnection::DetachServiceProjectAttachment(
    google::cloud::apphub::v1::DetachServiceProjectAttachmentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::apphub::v1::DiscoveredService>
AppHubConnection::ListDiscoveredServices(
    google::cloud::apphub::v1::
        ListDiscoveredServicesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::apphub::v1::DiscoveredService>>();
}

StatusOr<google::cloud::apphub::v1::DiscoveredService>
AppHubConnection::GetDiscoveredService(
    google::cloud::apphub::v1::GetDiscoveredServiceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::apphub::v1::LookupDiscoveredServiceResponse>
AppHubConnection::LookupDiscoveredService(
    google::cloud::apphub::v1::LookupDiscoveredServiceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::apphub::v1::Service> AppHubConnection::ListServices(
    google::cloud::apphub::v1::
        ListServicesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::apphub::v1::Service>>();
}

future<StatusOr<google::cloud::apphub::v1::Service>>
AppHubConnection::CreateService(
    google::cloud::apphub::v1::CreateServiceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::apphub::v1::Service>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> AppHubConnection::CreateService(
    NoAwaitTag, google::cloud::apphub::v1::CreateServiceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::apphub::v1::Service>>
AppHubConnection::CreateService(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::apphub::v1::Service>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::apphub::v1::Service> AppHubConnection::GetService(
    google::cloud::apphub::v1::GetServiceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::apphub::v1::Service>>
AppHubConnection::UpdateService(
    google::cloud::apphub::v1::UpdateServiceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::apphub::v1::Service>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> AppHubConnection::UpdateService(
    NoAwaitTag, google::cloud::apphub::v1::UpdateServiceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::apphub::v1::Service>>
AppHubConnection::UpdateService(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::apphub::v1::Service>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubConnection::DeleteService(
    google::cloud::apphub::v1::DeleteServiceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::apphub::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> AppHubConnection::DeleteService(
    NoAwaitTag, google::cloud::apphub::v1::DeleteServiceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubConnection::DeleteService(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::apphub::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::apphub::v1::DiscoveredWorkload>
AppHubConnection::ListDiscoveredWorkloads(
    google::cloud::apphub::v1::
        ListDiscoveredWorkloadsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::apphub::v1::DiscoveredWorkload>>();
}

StatusOr<google::cloud::apphub::v1::DiscoveredWorkload>
AppHubConnection::GetDiscoveredWorkload(
    google::cloud::apphub::v1::GetDiscoveredWorkloadRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::apphub::v1::LookupDiscoveredWorkloadResponse>
AppHubConnection::LookupDiscoveredWorkload(
    google::cloud::apphub::v1::LookupDiscoveredWorkloadRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::apphub::v1::Workload>
AppHubConnection::ListWorkloads(
    google::cloud::apphub::v1::
        ListWorkloadsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::apphub::v1::Workload>>();
}

future<StatusOr<google::cloud::apphub::v1::Workload>>
AppHubConnection::CreateWorkload(
    google::cloud::apphub::v1::CreateWorkloadRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::apphub::v1::Workload>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> AppHubConnection::CreateWorkload(
    NoAwaitTag, google::cloud::apphub::v1::CreateWorkloadRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::apphub::v1::Workload>>
AppHubConnection::CreateWorkload(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::apphub::v1::Workload>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::apphub::v1::Workload> AppHubConnection::GetWorkload(
    google::cloud::apphub::v1::GetWorkloadRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::apphub::v1::Workload>>
AppHubConnection::UpdateWorkload(
    google::cloud::apphub::v1::UpdateWorkloadRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::apphub::v1::Workload>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> AppHubConnection::UpdateWorkload(
    NoAwaitTag, google::cloud::apphub::v1::UpdateWorkloadRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::apphub::v1::Workload>>
AppHubConnection::UpdateWorkload(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::apphub::v1::Workload>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubConnection::DeleteWorkload(
    google::cloud::apphub::v1::DeleteWorkloadRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::apphub::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> AppHubConnection::DeleteWorkload(
    NoAwaitTag, google::cloud::apphub::v1::DeleteWorkloadRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubConnection::DeleteWorkload(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::apphub::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::apphub::v1::Application>
AppHubConnection::ListApplications(
    google::cloud::apphub::v1::
        ListApplicationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::apphub::v1::Application>>();
}

future<StatusOr<google::cloud::apphub::v1::Application>>
AppHubConnection::CreateApplication(
    google::cloud::apphub::v1::CreateApplicationRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::apphub::v1::Application>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> AppHubConnection::CreateApplication(
    NoAwaitTag, google::cloud::apphub::v1::CreateApplicationRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::apphub::v1::Application>>
AppHubConnection::CreateApplication(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::apphub::v1::Application>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::apphub::v1::Application>
AppHubConnection::GetApplication(
    google::cloud::apphub::v1::GetApplicationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::apphub::v1::Application>>
AppHubConnection::UpdateApplication(
    google::cloud::apphub::v1::UpdateApplicationRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::apphub::v1::Application>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> AppHubConnection::UpdateApplication(
    NoAwaitTag, google::cloud::apphub::v1::UpdateApplicationRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::apphub::v1::Application>>
AppHubConnection::UpdateApplication(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::apphub::v1::Application>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubConnection::DeleteApplication(
    google::cloud::apphub::v1::DeleteApplicationRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::apphub::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> AppHubConnection::DeleteApplication(
    NoAwaitTag, google::cloud::apphub::v1::DeleteApplicationRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubConnection::DeleteApplication(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::apphub::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::location::Location> AppHubConnection::ListLocations(
    google::cloud::location::
        ListLocationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::location::Location>>();
}

StatusOr<google::cloud::location::Location> AppHubConnection::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> AppHubConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> AppHubConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
AppHubConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::longrunning::Operation> AppHubConnection::ListOperations(
    google::longrunning::
        ListOperationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::longrunning::Operation>>();
}

StatusOr<google::longrunning::Operation> AppHubConnection::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status AppHubConnection::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status AppHubConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<AppHubConnection> MakeAppHubConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 AppHubPolicyOptionList>(options, __func__);
  options = apphub_v1_internal::AppHubDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub =
      apphub_v1_internal::CreateDefaultAppHubStub(std::move(auth), options);
  return apphub_v1_internal::MakeAppHubTracingConnection(
      std::make_shared<apphub_v1_internal::AppHubConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace apphub_v1
}  // namespace cloud
}  // namespace google
