// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/apphub/v1/apphub_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPHUB_V1_APP_HUB_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPHUB_V1_APP_HUB_CLIENT_H

#include "google/cloud/apphub/v1/app_hub_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace apphub_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// The App Hub API allows you to manage App Hub resources.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class AppHubClient {
 public:
  explicit AppHubClient(std::shared_ptr<AppHubConnection> connection,
                        Options opts = {});
  ~AppHubClient();

  ///@{
  /// @name Copy and move support
  AppHubClient(AppHubClient const&) = default;
  AppHubClient& operator=(AppHubClient const&) = default;
  AppHubClient(AppHubClient&&) = default;
  AppHubClient& operator=(AppHubClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(AppHubClient const& a, AppHubClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(AppHubClient const& a, AppHubClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists a service project attachment for a given service project. You can
  /// call this API from any project to find if it is attached to a host project.
  ///
  /// @param name  Required. Service project ID and location to lookup service project
  ///  attachment for. Only global location is supported. Expected format:
  ///  `projects/{project}/locations/{location}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.apphub.v1.LookupServiceProjectAttachmentResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.LookupServiceProjectAttachmentRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L346}
  /// [google.cloud.apphub.v1.LookupServiceProjectAttachmentResponse]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L359}
  ///
  // clang-format on
  StatusOr<google::cloud::apphub::v1::LookupServiceProjectAttachmentResponse>
  LookupServiceProjectAttachment(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Lists a service project attachment for a given service project. You can
  /// call this API from any project to find if it is attached to a host project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.apphub.v1.LookupServiceProjectAttachmentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.apphub.v1.LookupServiceProjectAttachmentResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.LookupServiceProjectAttachmentRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L346}
  /// [google.cloud.apphub.v1.LookupServiceProjectAttachmentResponse]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L359}
  ///
  // clang-format on
  StatusOr<google::cloud::apphub::v1::LookupServiceProjectAttachmentResponse>
  LookupServiceProjectAttachment(
      google::cloud::apphub::v1::LookupServiceProjectAttachmentRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists service projects attached to the host project.
  ///
  /// @param parent  Required. Host project ID and location to list service project attachments.
  ///  Only global location is supported. Expected format:
  ///  `projects/{project}/locations/{location}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.apphub.v1.ServiceProjectAttachment], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.ListServiceProjectAttachmentsRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L365}
  /// [google.cloud.apphub.v1.ServiceProjectAttachment]: @googleapis_reference_link{google/cloud/apphub/v1/service_project_attachment.proto#L37}
  ///
  // clang-format on
  StreamRange<google::cloud::apphub::v1::ServiceProjectAttachment>
  ListServiceProjectAttachments(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists service projects attached to the host project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.apphub.v1.ListServiceProjectAttachmentsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.apphub.v1.ServiceProjectAttachment], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.ListServiceProjectAttachmentsRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L365}
  /// [google.cloud.apphub.v1.ServiceProjectAttachment]: @googleapis_reference_link{google/cloud/apphub/v1/service_project_attachment.proto#L37}
  ///
  // clang-format on
  StreamRange<google::cloud::apphub::v1::ServiceProjectAttachment>
  ListServiceProjectAttachments(
      google::cloud::apphub::v1::ListServiceProjectAttachmentsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Attaches a service project to the host project.
  ///
  /// @param parent  Required. Host project ID and location to which service project is being
  ///  attached. Only global location is supported. Expected format:
  ///  `projects/{project}/locations/{location}`.
  /// @param service_project_attachment  Required. The resource being created.
  /// @param service_project_attachment_id  Required. The service project attachment identifier must contain the
  ///  project id of the service project specified in the
  ///  service_project_attachment.service_project field.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.apphub.v1.ServiceProjectAttachment] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.CreateServiceProjectAttachmentRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L403}
  /// [google.cloud.apphub.v1.ServiceProjectAttachment]: @googleapis_reference_link{google/cloud/apphub/v1/service_project_attachment.proto#L37}
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>>
  CreateServiceProjectAttachment(
      std::string const& parent,
      google::cloud::apphub::v1::ServiceProjectAttachment const&
          service_project_attachment,
      std::string const& service_project_attachment_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateServiceProjectAttachment
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateServiceProjectAttachment(
      NoAwaitTag, std::string const& parent,
      google::cloud::apphub::v1::ServiceProjectAttachment const&
          service_project_attachment,
      std::string const& service_project_attachment_id, Options opts = {});

  // clang-format off
  ///
  /// Attaches a service project to the host project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.apphub.v1.CreateServiceProjectAttachmentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.apphub.v1.ServiceProjectAttachment] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.CreateServiceProjectAttachmentRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L403}
  /// [google.cloud.apphub.v1.ServiceProjectAttachment]: @googleapis_reference_link{google/cloud/apphub/v1/service_project_attachment.proto#L37}
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>>
  CreateServiceProjectAttachment(
      google::cloud::apphub::v1::CreateServiceProjectAttachmentRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateServiceProjectAttachment
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateServiceProjectAttachment(
      NoAwaitTag,
      google::cloud::apphub::v1::CreateServiceProjectAttachmentRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateServiceProjectAttachment
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>>
  CreateServiceProjectAttachment(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Gets a service project attachment.
  ///
  /// @param name  Required. Fully qualified name of the service project attachment to
  ///  retrieve. Expected format:
  ///  `projects/{project}/locations/{location}/serviceProjectAttachments/{serviceProjectAttachment}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.apphub.v1.ServiceProjectAttachment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.GetServiceProjectAttachmentRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L441}
  /// [google.cloud.apphub.v1.ServiceProjectAttachment]: @googleapis_reference_link{google/cloud/apphub/v1/service_project_attachment.proto#L37}
  ///
  // clang-format on
  StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>
  GetServiceProjectAttachment(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a service project attachment.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.apphub.v1.GetServiceProjectAttachmentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.apphub.v1.ServiceProjectAttachment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.GetServiceProjectAttachmentRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L441}
  /// [google.cloud.apphub.v1.ServiceProjectAttachment]: @googleapis_reference_link{google/cloud/apphub/v1/service_project_attachment.proto#L37}
  ///
  // clang-format on
  StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>
  GetServiceProjectAttachment(
      google::cloud::apphub::v1::GetServiceProjectAttachmentRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a service project attachment.
  ///
  /// @param name  Required. Fully qualified name of the service project attachment to delete.
  ///  Expected format:
  ///  `projects/{project}/locations/{location}/serviceProjectAttachments/{serviceProjectAttachment}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.apphub.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.DeleteServiceProjectAttachmentRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L454}
  /// [google.cloud.apphub.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L1081}
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
  DeleteServiceProjectAttachment(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteServiceProjectAttachment
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteServiceProjectAttachment(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a service project attachment.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.apphub.v1.DeleteServiceProjectAttachmentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.apphub.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.DeleteServiceProjectAttachmentRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L454}
  /// [google.cloud.apphub.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L1081}
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
  DeleteServiceProjectAttachment(
      google::cloud::apphub::v1::DeleteServiceProjectAttachmentRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteServiceProjectAttachment
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteServiceProjectAttachment(
      NoAwaitTag,
      google::cloud::apphub::v1::DeleteServiceProjectAttachmentRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteServiceProjectAttachment
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
  DeleteServiceProjectAttachment(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Detaches a service project from a host project.
  /// You can call this API from any service project without needing access to
  /// the host project that it is attached to.
  ///
  /// @param name  Required. Service project id and location to detach from a host project.
  ///  Only global location is supported. Expected format:
  ///  `projects/{project}/locations/{location}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.apphub.v1.DetachServiceProjectAttachmentResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.DetachServiceProjectAttachmentRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L482}
  /// [google.cloud.apphub.v1.DetachServiceProjectAttachmentResponse]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L495}
  ///
  // clang-format on
  StatusOr<google::cloud::apphub::v1::DetachServiceProjectAttachmentResponse>
  DetachServiceProjectAttachment(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Detaches a service project from a host project.
  /// You can call this API from any service project without needing access to
  /// the host project that it is attached to.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.apphub.v1.DetachServiceProjectAttachmentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.apphub.v1.DetachServiceProjectAttachmentResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.DetachServiceProjectAttachmentRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L482}
  /// [google.cloud.apphub.v1.DetachServiceProjectAttachmentResponse]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L495}
  ///
  // clang-format on
  StatusOr<google::cloud::apphub::v1::DetachServiceProjectAttachmentResponse>
  DetachServiceProjectAttachment(
      google::cloud::apphub::v1::DetachServiceProjectAttachmentRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists Discovered Services that can be added to an Application in a host
  /// project and location.
  ///
  /// @param parent  Required. Project and location to list Discovered Services on.
  ///  Expected format: `projects/{project}/locations/{location}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.apphub.v1.DiscoveredService], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.DiscoveredService]: @googleapis_reference_link{google/cloud/apphub/v1/service.proto#L140}
  /// [google.cloud.apphub.v1.ListDiscoveredServicesRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L536}
  ///
  // clang-format on
  StreamRange<google::cloud::apphub::v1::DiscoveredService>
  ListDiscoveredServices(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists Discovered Services that can be added to an Application in a host
  /// project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.apphub.v1.ListDiscoveredServicesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.apphub.v1.DiscoveredService], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.DiscoveredService]: @googleapis_reference_link{google/cloud/apphub/v1/service.proto#L140}
  /// [google.cloud.apphub.v1.ListDiscoveredServicesRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L536}
  ///
  // clang-format on
  StreamRange<google::cloud::apphub::v1::DiscoveredService>
  ListDiscoveredServices(
      google::cloud::apphub::v1::ListDiscoveredServicesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a Discovered Service in a host project and location.
  ///
  /// @param name  Required. Fully qualified name of the Discovered Service to fetch.
  ///  Expected format:
  ///  `projects/{project}/locations/{location}/discoveredServices/{discoveredService}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.apphub.v1.DiscoveredService])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.DiscoveredService]: @googleapis_reference_link{google/cloud/apphub/v1/service.proto#L140}
  /// [google.cloud.apphub.v1.GetDiscoveredServiceRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L621}
  ///
  // clang-format on
  StatusOr<google::cloud::apphub::v1::DiscoveredService> GetDiscoveredService(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a Discovered Service in a host project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.apphub.v1.GetDiscoveredServiceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.apphub.v1.DiscoveredService])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.DiscoveredService]: @googleapis_reference_link{google/cloud/apphub/v1/service.proto#L140}
  /// [google.cloud.apphub.v1.GetDiscoveredServiceRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L621}
  ///
  // clang-format on
  StatusOr<google::cloud::apphub::v1::DiscoveredService> GetDiscoveredService(
      google::cloud::apphub::v1::GetDiscoveredServiceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists a Discovered Service in a host project and location, with a
  /// given resource URI.
  ///
  /// @param parent  Required. Host project ID and location to lookup Discovered Service in.
  ///  Expected format: `projects/{project}/locations/{location}`.
  /// @param uri  Required. Resource URI to find DiscoveredService for.
  ///  Accepts both project number and project ID and does translation when
  ///  needed.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.apphub.v1.LookupDiscoveredServiceResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.LookupDiscoveredServiceRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L634}
  /// [google.cloud.apphub.v1.LookupDiscoveredServiceResponse]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L651}
  ///
  // clang-format on
  StatusOr<google::cloud::apphub::v1::LookupDiscoveredServiceResponse>
  LookupDiscoveredService(std::string const& parent, std::string const& uri,
                          Options opts = {});

  // clang-format off
  ///
  /// Lists a Discovered Service in a host project and location, with a
  /// given resource URI.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.apphub.v1.LookupDiscoveredServiceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.apphub.v1.LookupDiscoveredServiceResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.LookupDiscoveredServiceRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L634}
  /// [google.cloud.apphub.v1.LookupDiscoveredServiceResponse]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L651}
  ///
  // clang-format on
  StatusOr<google::cloud::apphub::v1::LookupDiscoveredServiceResponse>
  LookupDiscoveredService(
      google::cloud::apphub::v1::LookupDiscoveredServiceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists Services in an Application.
  ///
  /// @param parent  Required. Fully qualified name of the parent Application to list Services
  ///  for. Expected format:
  ///  `projects/{project}/locations/{location}/applications/{application}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.apphub.v1.Service], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.ListServicesRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L498}
  /// [google.cloud.apphub.v1.Service]: @googleapis_reference_link{google/cloud/apphub/v1/service.proto#L36}
  ///
  // clang-format on
  StreamRange<google::cloud::apphub::v1::Service> ListServices(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists Services in an Application.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.apphub.v1.ListServicesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.apphub.v1.Service], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.ListServicesRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L498}
  /// [google.cloud.apphub.v1.Service]: @googleapis_reference_link{google/cloud/apphub/v1/service.proto#L36}
  ///
  // clang-format on
  StreamRange<google::cloud::apphub::v1::Service> ListServices(
      google::cloud::apphub::v1::ListServicesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a Service in an Application.
  ///
  /// @param parent  Required. Fully qualified name of the parent Application to create the
  ///  Service in. Expected format:
  ///  `projects/{project}/locations/{location}/applications/{application}`.
  /// @param service  Required. The resource being created.
  /// @param service_id  Required. The Service identifier.
  ///  Must contain only lowercase letters, numbers
  ///  or hyphens, with the first character a letter, the last a letter or a
  ///  number, and a 63 character maximum.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.apphub.v1.Service] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.CreateServiceRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L573}
  /// [google.cloud.apphub.v1.Service]: @googleapis_reference_link{google/cloud/apphub/v1/service.proto#L36}
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::Service>> CreateService(
      std::string const& parent,
      google::cloud::apphub::v1::Service const& service,
      std::string const& service_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateService
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateService(
      NoAwaitTag, std::string const& parent,
      google::cloud::apphub::v1::Service const& service,
      std::string const& service_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a Service in an Application.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.apphub.v1.CreateServiceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.apphub.v1.Service] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.CreateServiceRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L573}
  /// [google.cloud.apphub.v1.Service]: @googleapis_reference_link{google/cloud/apphub/v1/service.proto#L36}
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::Service>> CreateService(
      google::cloud::apphub::v1::CreateServiceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateService
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateService(
      NoAwaitTag,
      google::cloud::apphub::v1::CreateServiceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateService
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::Service>> CreateService(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Gets a Service in an Application.
  ///
  /// @param name  Required. Fully qualified name of the Service to fetch.
  ///  Expected format:
  ///  `projects/{project}/locations/{location}/applications/{application}/services/{service}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.apphub.v1.Service])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.GetServiceRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L610}
  /// [google.cloud.apphub.v1.Service]: @googleapis_reference_link{google/cloud/apphub/v1/service.proto#L36}
  ///
  // clang-format on
  StatusOr<google::cloud::apphub::v1::Service> GetService(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a Service in an Application.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.apphub.v1.GetServiceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.apphub.v1.Service])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.GetServiceRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L610}
  /// [google.cloud.apphub.v1.Service]: @googleapis_reference_link{google/cloud/apphub/v1/service.proto#L36}
  ///
  // clang-format on
  StatusOr<google::cloud::apphub::v1::Service> GetService(
      google::cloud::apphub::v1::GetServiceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a Service in an Application.
  ///
  /// @param service  Required. The resource being updated.
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  Service resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request.
  ///  The API changes the values of the fields as specified in the update_mask.
  ///  The API ignores the values of all fields not covered by the update_mask.
  ///  You can also unset a field by not specifying it in the updated message, but
  ///  adding the field to the mask. This clears whatever value the field
  ///  previously had.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.apphub.v1.Service] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.Service]: @googleapis_reference_link{google/cloud/apphub/v1/service.proto#L36}
  /// [google.cloud.apphub.v1.UpdateServiceRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L657}
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::Service>> UpdateService(
      google::cloud::apphub::v1::Service const& service,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateService
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateService(
      NoAwaitTag, google::cloud::apphub::v1::Service const& service,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a Service in an Application.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.apphub.v1.UpdateServiceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.apphub.v1.Service] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.Service]: @googleapis_reference_link{google/cloud/apphub/v1/service.proto#L36}
  /// [google.cloud.apphub.v1.UpdateServiceRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L657}
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::Service>> UpdateService(
      google::cloud::apphub::v1::UpdateServiceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateService
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateService(
      NoAwaitTag,
      google::cloud::apphub::v1::UpdateServiceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateService
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::Service>> UpdateService(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Deletes a Service from an Application.
  ///
  /// @param name  Required. Fully qualified name of the Service to delete from an
  ///  Application. Expected format:
  ///  `projects/{project}/locations/{location}/applications/{application}/services/{service}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.apphub.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.DeleteServiceRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L690}
  /// [google.cloud.apphub.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L1081}
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::OperationMetadata>> DeleteService(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteService
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteService(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a Service from an Application.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.apphub.v1.DeleteServiceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.apphub.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.DeleteServiceRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L690}
  /// [google.cloud.apphub.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L1081}
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::OperationMetadata>> DeleteService(
      google::cloud::apphub::v1::DeleteServiceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteService
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteService(
      NoAwaitTag,
      google::cloud::apphub::v1::DeleteServiceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteService
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::OperationMetadata>> DeleteService(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Lists Discovered Workloads that can be added to an Application in a host
  /// project and location.
  ///
  /// @param parent  Required. Project and location to list Discovered Workloads on.
  ///  Expected format: `projects/{project}/locations/{location}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.apphub.v1.DiscoveredWorkload], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.DiscoveredWorkload]: @googleapis_reference_link{google/cloud/apphub/v1/workload.proto#L141}
  /// [google.cloud.apphub.v1.ListDiscoveredWorkloadsRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L901}
  ///
  // clang-format on
  StreamRange<google::cloud::apphub::v1::DiscoveredWorkload>
  ListDiscoveredWorkloads(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists Discovered Workloads that can be added to an Application in a host
  /// project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.apphub.v1.ListDiscoveredWorkloadsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.apphub.v1.DiscoveredWorkload], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.DiscoveredWorkload]: @googleapis_reference_link{google/cloud/apphub/v1/workload.proto#L141}
  /// [google.cloud.apphub.v1.ListDiscoveredWorkloadsRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L901}
  ///
  // clang-format on
  StreamRange<google::cloud::apphub::v1::DiscoveredWorkload>
  ListDiscoveredWorkloads(
      google::cloud::apphub::v1::ListDiscoveredWorkloadsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a Discovered Workload in a host project and location.
  ///
  /// @param name  Required. Fully qualified name of the Discovered Workload to fetch.
  ///  Expected format:
  ///  `projects/{project}/locations/{location}/discoveredWorkloads/{discoveredWorkload}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.apphub.v1.DiscoveredWorkload])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.DiscoveredWorkload]: @googleapis_reference_link{google/cloud/apphub/v1/workload.proto#L141}
  /// [google.cloud.apphub.v1.GetDiscoveredWorkloadRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L986}
  ///
  // clang-format on
  StatusOr<google::cloud::apphub::v1::DiscoveredWorkload> GetDiscoveredWorkload(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a Discovered Workload in a host project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.apphub.v1.GetDiscoveredWorkloadRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.apphub.v1.DiscoveredWorkload])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.DiscoveredWorkload]: @googleapis_reference_link{google/cloud/apphub/v1/workload.proto#L141}
  /// [google.cloud.apphub.v1.GetDiscoveredWorkloadRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L986}
  ///
  // clang-format on
  StatusOr<google::cloud::apphub::v1::DiscoveredWorkload> GetDiscoveredWorkload(
      google::cloud::apphub::v1::GetDiscoveredWorkloadRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists a Discovered Workload in a host project and location, with a
  /// given resource URI.
  ///
  /// @param parent  Required. Host project ID and location to lookup Discovered Workload in.
  ///  Expected format: `projects/{project}/locations/{location}`.
  /// @param uri  Required. Resource URI to find Discovered Workload for.
  ///  Accepts both project number and project ID and does translation when
  ///  needed.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.apphub.v1.LookupDiscoveredWorkloadResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.LookupDiscoveredWorkloadRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L999}
  /// [google.cloud.apphub.v1.LookupDiscoveredWorkloadResponse]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L1016}
  ///
  // clang-format on
  StatusOr<google::cloud::apphub::v1::LookupDiscoveredWorkloadResponse>
  LookupDiscoveredWorkload(std::string const& parent, std::string const& uri,
                           Options opts = {});

  // clang-format off
  ///
  /// Lists a Discovered Workload in a host project and location, with a
  /// given resource URI.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.apphub.v1.LookupDiscoveredWorkloadRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.apphub.v1.LookupDiscoveredWorkloadResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.LookupDiscoveredWorkloadRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L999}
  /// [google.cloud.apphub.v1.LookupDiscoveredWorkloadResponse]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L1016}
  ///
  // clang-format on
  StatusOr<google::cloud::apphub::v1::LookupDiscoveredWorkloadResponse>
  LookupDiscoveredWorkload(
      google::cloud::apphub::v1::LookupDiscoveredWorkloadRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists Workloads in an Application.
  ///
  /// @param parent  Required. Fully qualified name of the parent Application to list Workloads
  ///  for. Expected format:
  ///  `projects/{project}/locations/{location}/applications/{application}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.apphub.v1.Workload], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.ListWorkloadsRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L863}
  /// [google.cloud.apphub.v1.Workload]: @googleapis_reference_link{google/cloud/apphub/v1/workload.proto#L37}
  ///
  // clang-format on
  StreamRange<google::cloud::apphub::v1::Workload> ListWorkloads(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists Workloads in an Application.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.apphub.v1.ListWorkloadsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.apphub.v1.Workload], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.ListWorkloadsRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L863}
  /// [google.cloud.apphub.v1.Workload]: @googleapis_reference_link{google/cloud/apphub/v1/workload.proto#L37}
  ///
  // clang-format on
  StreamRange<google::cloud::apphub::v1::Workload> ListWorkloads(
      google::cloud::apphub::v1::ListWorkloadsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a Workload in an Application.
  ///
  /// @param parent  Required. Fully qualified name of the Application to create Workload in.
  ///  Expected format:
  ///  `projects/{project}/locations/{location}/applications/{application}`.
  /// @param workload  Required. The resource being created.
  /// @param workload_id  Required. The Workload identifier.
  ///  Must contain only lowercase letters, numbers
  ///  or hyphens, with the first character a letter, the last a letter or a
  ///  number, and a 63 character maximum.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.apphub.v1.Workload] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.CreateWorkloadRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L938}
  /// [google.cloud.apphub.v1.Workload]: @googleapis_reference_link{google/cloud/apphub/v1/workload.proto#L37}
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::Workload>> CreateWorkload(
      std::string const& parent,
      google::cloud::apphub::v1::Workload const& workload,
      std::string const& workload_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateWorkload
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateWorkload(
      NoAwaitTag, std::string const& parent,
      google::cloud::apphub::v1::Workload const& workload,
      std::string const& workload_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a Workload in an Application.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.apphub.v1.CreateWorkloadRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.apphub.v1.Workload] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.CreateWorkloadRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L938}
  /// [google.cloud.apphub.v1.Workload]: @googleapis_reference_link{google/cloud/apphub/v1/workload.proto#L37}
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::Workload>> CreateWorkload(
      google::cloud::apphub::v1::CreateWorkloadRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateWorkload
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateWorkload(
      NoAwaitTag,
      google::cloud::apphub::v1::CreateWorkloadRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateWorkload
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::Workload>> CreateWorkload(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Gets a Workload in an Application.
  ///
  /// @param name  Required. Fully qualified name of the Workload to fetch.
  ///  Expected format:
  ///  `projects/{project}/locations/{location}/applications/{application}/workloads/{workload}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.apphub.v1.Workload])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.GetWorkloadRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L975}
  /// [google.cloud.apphub.v1.Workload]: @googleapis_reference_link{google/cloud/apphub/v1/workload.proto#L37}
  ///
  // clang-format on
  StatusOr<google::cloud::apphub::v1::Workload> GetWorkload(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a Workload in an Application.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.apphub.v1.GetWorkloadRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.apphub.v1.Workload])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.GetWorkloadRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L975}
  /// [google.cloud.apphub.v1.Workload]: @googleapis_reference_link{google/cloud/apphub/v1/workload.proto#L37}
  ///
  // clang-format on
  StatusOr<google::cloud::apphub::v1::Workload> GetWorkload(
      google::cloud::apphub::v1::GetWorkloadRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a Workload in an Application.
  ///
  /// @param workload  Required. The resource being updated.
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  Workload resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request.
  ///  The API changes the values of the fields as specified in the update_mask.
  ///  The API ignores the values of all fields not covered by the update_mask.
  ///  You can also unset a field by not specifying it in the updated message, but
  ///  adding the field to the mask. This clears whatever value the field
  ///  previously had.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.apphub.v1.Workload] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.UpdateWorkloadRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L1022}
  /// [google.cloud.apphub.v1.Workload]: @googleapis_reference_link{google/cloud/apphub/v1/workload.proto#L37}
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::Workload>> UpdateWorkload(
      google::cloud::apphub::v1::Workload const& workload,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateWorkload
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateWorkload(
      NoAwaitTag, google::cloud::apphub::v1::Workload const& workload,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a Workload in an Application.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.apphub.v1.UpdateWorkloadRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.apphub.v1.Workload] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.UpdateWorkloadRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L1022}
  /// [google.cloud.apphub.v1.Workload]: @googleapis_reference_link{google/cloud/apphub/v1/workload.proto#L37}
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::Workload>> UpdateWorkload(
      google::cloud::apphub::v1::UpdateWorkloadRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateWorkload
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateWorkload(
      NoAwaitTag,
      google::cloud::apphub::v1::UpdateWorkloadRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateWorkload
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::Workload>> UpdateWorkload(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Deletes a Workload from an Application.
  ///
  /// @param name  Required. Fully qualified name of the Workload to delete from an
  ///  Application. Expected format:
  ///  `projects/{project}/locations/{location}/applications/{application}/workloads/{workload}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.apphub.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.DeleteWorkloadRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L1055}
  /// [google.cloud.apphub.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L1081}
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::OperationMetadata>> DeleteWorkload(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteWorkload
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteWorkload(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a Workload from an Application.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.apphub.v1.DeleteWorkloadRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.apphub.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.DeleteWorkloadRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L1055}
  /// [google.cloud.apphub.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L1081}
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::OperationMetadata>> DeleteWorkload(
      google::cloud::apphub::v1::DeleteWorkloadRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteWorkload
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteWorkload(
      NoAwaitTag,
      google::cloud::apphub::v1::DeleteWorkloadRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteWorkload
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::OperationMetadata>> DeleteWorkload(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Lists Applications in a host project and location.
  ///
  /// @param parent  Required. Project and location to list Applications on.
  ///  Expected format: `projects/{project}/locations/{location}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.apphub.v1.Application], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.Application]: @googleapis_reference_link{google/cloud/apphub/v1/application.proto#L37}
  /// [google.cloud.apphub.v1.ListApplicationsRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L716}
  ///
  // clang-format on
  StreamRange<google::cloud::apphub::v1::Application> ListApplications(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists Applications in a host project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.apphub.v1.ListApplicationsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.apphub.v1.Application], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.Application]: @googleapis_reference_link{google/cloud/apphub/v1/application.proto#L37}
  /// [google.cloud.apphub.v1.ListApplicationsRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L716}
  ///
  // clang-format on
  StreamRange<google::cloud::apphub::v1::Application> ListApplications(
      google::cloud::apphub::v1::ListApplicationsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates an Application in a host project and location.
  ///
  /// @param parent  Required. Project and location to create Application in.
  ///  Expected format: `projects/{project}/locations/{location}`.
  /// @param application  Required. The resource being created
  /// @param application_id  Required. The Application identifier.
  ///  Must contain only lowercase letters, numbers
  ///  or hyphens, with the first character a letter, the last a letter or a
  ///  number, and a 63 character maximum.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.apphub.v1.Application] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.Application]: @googleapis_reference_link{google/cloud/apphub/v1/application.proto#L37}
  /// [google.cloud.apphub.v1.CreateApplicationRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L753}
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::Application>> CreateApplication(
      std::string const& parent,
      google::cloud::apphub::v1::Application const& application,
      std::string const& application_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateApplication
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateApplication(
      NoAwaitTag, std::string const& parent,
      google::cloud::apphub::v1::Application const& application,
      std::string const& application_id, Options opts = {});

  // clang-format off
  ///
  /// Creates an Application in a host project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.apphub.v1.CreateApplicationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.apphub.v1.Application] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.Application]: @googleapis_reference_link{google/cloud/apphub/v1/application.proto#L37}
  /// [google.cloud.apphub.v1.CreateApplicationRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L753}
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::Application>> CreateApplication(
      google::cloud::apphub::v1::CreateApplicationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateApplication
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateApplication(
      NoAwaitTag,
      google::cloud::apphub::v1::CreateApplicationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateApplication
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::Application>> CreateApplication(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Gets an Application in a host project and location.
  ///
  /// @param name  Required. Fully qualified name of the Application to fetch.
  ///  Expected format:
  ///  `projects/{project}/locations/{location}/applications/{application}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.apphub.v1.Application])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.Application]: @googleapis_reference_link{google/cloud/apphub/v1/application.proto#L37}
  /// [google.cloud.apphub.v1.GetApplicationRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L789}
  ///
  // clang-format on
  StatusOr<google::cloud::apphub::v1::Application> GetApplication(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets an Application in a host project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.apphub.v1.GetApplicationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.apphub.v1.Application])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.Application]: @googleapis_reference_link{google/cloud/apphub/v1/application.proto#L37}
  /// [google.cloud.apphub.v1.GetApplicationRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L789}
  ///
  // clang-format on
  StatusOr<google::cloud::apphub::v1::Application> GetApplication(
      google::cloud::apphub::v1::GetApplicationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates an Application in a host project and location.
  ///
  /// @param application  Required. The resource being updated.
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  Application resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request.
  ///  The API changes the values of the fields as specified in the update_mask.
  ///  The API ignores the values of all fields not covered by the update_mask.
  ///  You can also unset a field by not specifying it in the updated message, but
  ///  adding the field to the mask. This clears whatever value the field
  ///  previously had.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.apphub.v1.Application] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.Application]: @googleapis_reference_link{google/cloud/apphub/v1/application.proto#L37}
  /// [google.cloud.apphub.v1.UpdateApplicationRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L802}
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::Application>> UpdateApplication(
      google::cloud::apphub::v1::Application const& application,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateApplication
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateApplication(
      NoAwaitTag, google::cloud::apphub::v1::Application const& application,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates an Application in a host project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.apphub.v1.UpdateApplicationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.apphub.v1.Application] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.Application]: @googleapis_reference_link{google/cloud/apphub/v1/application.proto#L37}
  /// [google.cloud.apphub.v1.UpdateApplicationRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L802}
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::Application>> UpdateApplication(
      google::cloud::apphub::v1::UpdateApplicationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateApplication
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateApplication(
      NoAwaitTag,
      google::cloud::apphub::v1::UpdateApplicationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateApplication
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::Application>> UpdateApplication(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Deletes an Application in a host project and location.
  ///
  /// @param name  Required. Fully qualified name of the Application to delete.
  ///  Expected format:
  ///  `projects/{project}/locations/{location}/applications/{application}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.apphub.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.DeleteApplicationRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L835}
  /// [google.cloud.apphub.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L1081}
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
  DeleteApplication(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteApplication
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteApplication(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes an Application in a host project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.apphub.v1.DeleteApplicationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.apphub.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.apphub.v1.DeleteApplicationRequest]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L835}
  /// [google.cloud.apphub.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/apphub/v1/apphub_service.proto#L1081}
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
  DeleteApplication(
      google::cloud::apphub::v1::DeleteApplicationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteApplication
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteApplication(
      NoAwaitTag,
      google::cloud::apphub::v1::DeleteApplicationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteApplication
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
  DeleteApplication(google::longrunning::Operation const& operation,
                    Options opts = {});

  // clang-format off
  ///
  /// Lists information about the supported locations for this service.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.location.ListLocationsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.location.Location], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.location.ListLocationsRequest]: @googleapis_reference_link{google/cloud/location/locations.proto#L58}
  /// [google.cloud.location.Location]: @googleapis_reference_link{google/cloud/location/locations.proto#L88}
  ///
  // clang-format on
  StreamRange<google::cloud::location::Location> ListLocations(
      google::cloud::location::ListLocationsRequest request, Options opts = {});

  // clang-format off
  ///
  /// Gets information about a location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.location.GetLocationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.location.Location])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.location.GetLocationRequest]: @googleapis_reference_link{google/cloud/location/locations.proto#L82}
  /// [google.cloud.location.Location]: @googleapis_reference_link{google/cloud/location/locations.proto#L88}
  ///
  // clang-format on
  StatusOr<google::cloud::location::Location> GetLocation(
      google::cloud::location::GetLocationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Sets the access control policy on the specified resource. Replaces any
  /// existing policy.
  ///
  /// Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.iam.v1.SetIamPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.iam.v1.Policy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.iam.v1.Policy]: @googleapis_reference_link{google/iam/v1/policy.proto#L102}
  /// [google.iam.v1.SetIamPolicyRequest]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L100}
  ///
  // clang-format on
  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Gets the access control policy for a resource.
  /// Returns an empty policy if the resource exists and does not have a policy
  /// set.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.iam.v1.GetIamPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.iam.v1.Policy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.iam.v1.GetIamPolicyRequest]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L123}
  /// [google.iam.v1.Policy]: @googleapis_reference_link{google/iam/v1/policy.proto#L102}
  ///
  // clang-format on
  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Returns permissions that a caller has on the specified resource.
  /// If the resource does not exist, this will return an empty set of
  /// permissions, not a `NOT_FOUND` error.
  ///
  /// Note: This operation is designed to be used for building permission-aware
  /// UIs and command-line tools, not for authorization checking. This operation
  /// may "fail open" without warning.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.iam.v1.TestIamPermissionsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.iam.v1.TestIamPermissionsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.iam.v1.TestIamPermissionsRequest]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L137}
  /// [google.iam.v1.TestIamPermissionsResponse]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L153}
  ///
  // clang-format on
  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists operations that match the specified filter in the request. If the
  /// server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// NOTE: the `name` binding allows API services to override the binding
  /// to use different resource name schemes, such as `users/*/operations`. To
  /// override the binding, API services can add a binding such as
  /// `"/v1/{name=users/*}/operations"` to their service configuration.
  /// For backwards compatibility, the default name includes the operations
  /// collection id, however overriding users must ensure the name binding
  /// is the parent resource, without the operations collection id.
  ///
  /// @param name  The name of the operation's parent resource.
  /// @param filter  The standard list filter.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.longrunning.Operation], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.ListOperationsRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L171}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StreamRange<google::longrunning::Operation> ListOperations(
      std::string const& name, std::string const& filter, Options opts = {});

  // clang-format off
  ///
  /// Lists operations that match the specified filter in the request. If the
  /// server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// NOTE: the `name` binding allows API services to override the binding
  /// to use different resource name schemes, such as `users/*/operations`. To
  /// override the binding, API services can add a binding such as
  /// `"/v1/{name=users/*}/operations"` to their service configuration.
  /// For backwards compatibility, the default name includes the operations
  /// collection id, however overriding users must ensure the name binding
  /// is the parent resource, without the operations collection id.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.ListOperationsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.longrunning.Operation], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.ListOperationsRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L171}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request, Options opts = {});

  // clang-format off
  ///
  /// Gets the latest state of a long-running operation.  Clients can use this
  /// method to poll the operation result at intervals as recommended by the API
  /// service.
  ///
  /// @param name  The name of the operation resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.longrunning.Operation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.GetOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L165}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> GetOperation(std::string const& name,
                                                        Options opts = {});

  // clang-format off
  ///
  /// Gets the latest state of a long-running operation.  Clients can use this
  /// method to poll the operation result at intervals as recommended by the API
  /// service.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.GetOperationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.longrunning.Operation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.GetOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L165}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a long-running operation. This method indicates that the client is
  /// no longer interested in the operation result. It does not cancel the
  /// operation. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// @param name  The name of the operation resource to be deleted.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.DeleteOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L201}
  ///
  // clang-format on
  Status DeleteOperation(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a long-running operation. This method indicates that the client is
  /// no longer interested in the operation result. It does not cancel the
  /// operation. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.DeleteOperationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.DeleteOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L201}
  ///
  // clang-format on
  Status DeleteOperation(
      google::longrunning::DeleteOperationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Starts asynchronous cancellation on a long-running operation.  The server
  /// makes a best effort to cancel the operation, but success is not
  /// guaranteed.  If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`.  Clients can use
  /// [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
  /// other methods to check whether the cancellation succeeded or whether the
  /// operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with
  /// an [Operation.error][google.longrunning.Operation.error] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
  /// corresponding to `Code.CANCELLED`.
  ///
  /// @param name  The name of the operation resource to be cancelled.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.CancelOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L195}
  /// [google.longrunning.Operation.error]: @googleapis_reference_link{google/longrunning/operations.proto#L150}
  /// [google.longrunning.Operations.GetOperation]: @googleapis_reference_link{google/longrunning/operations.proto#L77}
  /// [google.rpc.Status.code]: @googleapis_reference_link{google/rpc/status.proto#L38}
  ///
  // clang-format on
  Status CancelOperation(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Starts asynchronous cancellation on a long-running operation.  The server
  /// makes a best effort to cancel the operation, but success is not
  /// guaranteed.  If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`.  Clients can use
  /// [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
  /// other methods to check whether the cancellation succeeded or whether the
  /// operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with
  /// an [Operation.error][google.longrunning.Operation.error] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
  /// corresponding to `Code.CANCELLED`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.CancelOperationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.CancelOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L195}
  /// [google.longrunning.Operation.error]: @googleapis_reference_link{google/longrunning/operations.proto#L150}
  /// [google.longrunning.Operations.GetOperation]: @googleapis_reference_link{google/longrunning/operations.proto#L77}
  /// [google.rpc.Status.code]: @googleapis_reference_link{google/rpc/status.proto#L38}
  ///
  // clang-format on
  Status CancelOperation(
      google::longrunning::CancelOperationRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<AppHubConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace apphub_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPHUB_V1_APP_HUB_CLIENT_H
