// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/apikeys/v2/apikeys.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APIKEYS_V2_API_KEYS_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APIKEYS_V2_API_KEYS_CLIENT_H

#include "google/cloud/apikeys/v2/api_keys_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace apikeys_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Manages the API keys associated with projects.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class ApiKeysClient {
 public:
  explicit ApiKeysClient(std::shared_ptr<ApiKeysConnection> connection,
                         Options opts = {});
  ~ApiKeysClient();

  ///@{
  /// @name Copy and move support
  ApiKeysClient(ApiKeysClient const&) = default;
  ApiKeysClient& operator=(ApiKeysClient const&) = default;
  ApiKeysClient(ApiKeysClient&&) = default;
  ApiKeysClient& operator=(ApiKeysClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(ApiKeysClient const& a, ApiKeysClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(ApiKeysClient const& a, ApiKeysClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Creates a new API key.
  ///
  /// NOTE: Key is a global resource; hence the only supported value for
  /// location is `global`.
  ///
  /// @param parent  Required. The project in which the API key is created.
  /// @param key  Required. The API key fields to set at creation time.
  ///  You can configure only the `display_name`, `restrictions`, and
  ///  `annotations` fields.
  /// @param key_id  User specified key id (optional). If specified, it will become the final
  ///  component of the key resource name.
  ///  @n
  ///  The id must be unique within the project, must conform with RFC-1034,
  ///  is restricted to lower-cased letters, and has a maximum length of 63
  ///  characters. In another word, the id must match the regular
  ///  expression: `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
  ///  @n
  ///  The id must NOT be a UUID-like string.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.api.apikeys.v2.Key] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.apikeys.v2.CreateKeyRequest]: @googleapis_reference_link{google/api/apikeys/v2/apikeys.proto#L155}
  /// [google.api.apikeys.v2.Key]: @googleapis_reference_link{google/api/apikeys/v2/resources.proto#L32}
  ///
  // clang-format on
  future<StatusOr<google::api::apikeys::v2::Key>> CreateKey(
      std::string const& parent, google::api::apikeys::v2::Key const& key,
      std::string const& key_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateKey
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateKey(
      NoAwaitTag, std::string const& parent,
      google::api::apikeys::v2::Key const& key, std::string const& key_id,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new API key.
  ///
  /// NOTE: Key is a global resource; hence the only supported value for
  /// location is `global`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.api.apikeys.v2.CreateKeyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.api.apikeys.v2.Key] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.apikeys.v2.CreateKeyRequest]: @googleapis_reference_link{google/api/apikeys/v2/apikeys.proto#L155}
  /// [google.api.apikeys.v2.Key]: @googleapis_reference_link{google/api/apikeys/v2/resources.proto#L32}
  ///
  // clang-format on
  future<StatusOr<google::api::apikeys::v2::Key>> CreateKey(
      google::api::apikeys::v2::CreateKeyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateKey
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateKey(
      NoAwaitTag, google::api::apikeys::v2::CreateKeyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateKey
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::api::apikeys::v2::Key>> CreateKey(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Lists the API keys owned by a project. The key string of the API key
  /// isn't included in the response.
  ///
  /// NOTE: Key is a global resource; hence the only supported value for
  /// location is `global`.
  ///
  /// @param parent  Required. Lists all API keys associated with this project.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.api.apikeys.v2.Key], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.apikeys.v2.Key]: @googleapis_reference_link{google/api/apikeys/v2/resources.proto#L32}
  /// [google.api.apikeys.v2.ListKeysRequest]: @googleapis_reference_link{google/api/apikeys/v2/apikeys.proto#L182}
  ///
  // clang-format on
  StreamRange<google::api::apikeys::v2::Key> ListKeys(std::string const& parent,
                                                      Options opts = {});

  // clang-format off
  ///
  /// Lists the API keys owned by a project. The key string of the API key
  /// isn't included in the response.
  ///
  /// NOTE: Key is a global resource; hence the only supported value for
  /// location is `global`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.api.apikeys.v2.ListKeysRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.api.apikeys.v2.Key], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.apikeys.v2.Key]: @googleapis_reference_link{google/api/apikeys/v2/resources.proto#L32}
  /// [google.api.apikeys.v2.ListKeysRequest]: @googleapis_reference_link{google/api/apikeys/v2/apikeys.proto#L182}
  ///
  // clang-format on
  StreamRange<google::api::apikeys::v2::Key> ListKeys(
      google::api::apikeys::v2::ListKeysRequest request, Options opts = {});

  // clang-format off
  ///
  /// Gets the metadata for an API key. The key string of the API key
  /// isn't included in the response.
  ///
  /// NOTE: Key is a global resource; hence the only supported value for
  /// location is `global`.
  ///
  /// @param name  Required. The resource name of the API key to get.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.api.apikeys.v2.Key])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.apikeys.v2.GetKeyRequest]: @googleapis_reference_link{google/api/apikeys/v2/apikeys.proto#L212}
  /// [google.api.apikeys.v2.Key]: @googleapis_reference_link{google/api/apikeys/v2/resources.proto#L32}
  ///
  // clang-format on
  StatusOr<google::api::apikeys::v2::Key> GetKey(std::string const& name,
                                                 Options opts = {});

  // clang-format off
  ///
  /// Gets the metadata for an API key. The key string of the API key
  /// isn't included in the response.
  ///
  /// NOTE: Key is a global resource; hence the only supported value for
  /// location is `global`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.api.apikeys.v2.GetKeyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.api.apikeys.v2.Key])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.apikeys.v2.GetKeyRequest]: @googleapis_reference_link{google/api/apikeys/v2/apikeys.proto#L212}
  /// [google.api.apikeys.v2.Key]: @googleapis_reference_link{google/api/apikeys/v2/resources.proto#L32}
  ///
  // clang-format on
  StatusOr<google::api::apikeys::v2::Key> GetKey(
      google::api::apikeys::v2::GetKeyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Get the key string for an API key.
  ///
  /// NOTE: Key is a global resource; hence the only supported value for
  /// location is `global`.
  ///
  /// @param name  Required. The resource name of the API key to be retrieved.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.api.apikeys.v2.GetKeyStringResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.apikeys.v2.GetKeyStringRequest]: @googleapis_reference_link{google/api/apikeys/v2/apikeys.proto#L221}
  /// [google.api.apikeys.v2.GetKeyStringResponse]: @googleapis_reference_link{google/api/apikeys/v2/apikeys.proto#L230}
  ///
  // clang-format on
  StatusOr<google::api::apikeys::v2::GetKeyStringResponse> GetKeyString(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Get the key string for an API key.
  ///
  /// NOTE: Key is a global resource; hence the only supported value for
  /// location is `global`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.api.apikeys.v2.GetKeyStringRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.api.apikeys.v2.GetKeyStringResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.apikeys.v2.GetKeyStringRequest]: @googleapis_reference_link{google/api/apikeys/v2/apikeys.proto#L221}
  /// [google.api.apikeys.v2.GetKeyStringResponse]: @googleapis_reference_link{google/api/apikeys/v2/apikeys.proto#L230}
  ///
  // clang-format on
  StatusOr<google::api::apikeys::v2::GetKeyStringResponse> GetKeyString(
      google::api::apikeys::v2::GetKeyStringRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Patches the modifiable fields of an API key.
  /// The key string of the API key isn't included in the response.
  ///
  /// NOTE: Key is a global resource; hence the only supported value for
  /// location is `global`.
  ///
  /// @param key  Required. Set the `name` field to the resource name of the API key to be
  ///  updated. You can update only the `display_name`, `restrictions`, and
  ///  `annotations` fields.
  /// @param update_mask  The field mask specifies which fields to be updated as part of this
  ///  request. All other fields are ignored.
  ///  Mutable fields are: `display_name`, `restrictions`, and `annotations`.
  ///  If an update mask is not provided, the service treats it as an implied mask
  ///  equivalent to all allowed fields that are set on the wire. If the field
  ///  mask has a special value "*", the service treats it equivalent to replace
  ///  all allowed mutable fields.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.api.apikeys.v2.Key] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.apikeys.v2.Key]: @googleapis_reference_link{google/api/apikeys/v2/resources.proto#L32}
  /// [google.api.apikeys.v2.UpdateKeyRequest]: @googleapis_reference_link{google/api/apikeys/v2/apikeys.proto#L236}
  ///
  // clang-format on
  future<StatusOr<google::api::apikeys::v2::Key>> UpdateKey(
      google::api::apikeys::v2::Key const& key,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateKey
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateKey(
      NoAwaitTag, google::api::apikeys::v2::Key const& key,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Patches the modifiable fields of an API key.
  /// The key string of the API key isn't included in the response.
  ///
  /// NOTE: Key is a global resource; hence the only supported value for
  /// location is `global`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.api.apikeys.v2.UpdateKeyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.api.apikeys.v2.Key] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.apikeys.v2.Key]: @googleapis_reference_link{google/api/apikeys/v2/resources.proto#L32}
  /// [google.api.apikeys.v2.UpdateKeyRequest]: @googleapis_reference_link{google/api/apikeys/v2/apikeys.proto#L236}
  ///
  // clang-format on
  future<StatusOr<google::api::apikeys::v2::Key>> UpdateKey(
      google::api::apikeys::v2::UpdateKeyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateKey
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateKey(
      NoAwaitTag, google::api::apikeys::v2::UpdateKeyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateKey
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::api::apikeys::v2::Key>> UpdateKey(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Deletes an API key. Deleted key can be retrieved within 30 days of
  /// deletion. Afterward, key will be purged from the project.
  ///
  /// NOTE: Key is a global resource; hence the only supported value for
  /// location is `global`.
  ///
  /// @param name  Required. The resource name of the API key to be deleted.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.api.apikeys.v2.Key] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.apikeys.v2.DeleteKeyRequest]: @googleapis_reference_link{google/api/apikeys/v2/apikeys.proto#L253}
  /// [google.api.apikeys.v2.Key]: @googleapis_reference_link{google/api/apikeys/v2/resources.proto#L32}
  ///
  // clang-format on
  future<StatusOr<google::api::apikeys::v2::Key>> DeleteKey(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteKey
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteKey(NoAwaitTag,
                                                     std::string const& name,
                                                     Options opts = {});

  // clang-format off
  ///
  /// Deletes an API key. Deleted key can be retrieved within 30 days of
  /// deletion. Afterward, key will be purged from the project.
  ///
  /// NOTE: Key is a global resource; hence the only supported value for
  /// location is `global`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.api.apikeys.v2.DeleteKeyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.api.apikeys.v2.Key] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.apikeys.v2.DeleteKeyRequest]: @googleapis_reference_link{google/api/apikeys/v2/apikeys.proto#L253}
  /// [google.api.apikeys.v2.Key]: @googleapis_reference_link{google/api/apikeys/v2/resources.proto#L32}
  ///
  // clang-format on
  future<StatusOr<google::api::apikeys::v2::Key>> DeleteKey(
      google::api::apikeys::v2::DeleteKeyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteKey
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteKey(
      NoAwaitTag, google::api::apikeys::v2::DeleteKeyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteKey
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::api::apikeys::v2::Key>> DeleteKey(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Undeletes an API key which was deleted within 30 days.
  ///
  /// NOTE: Key is a global resource; hence the only supported value for
  /// location is `global`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.api.apikeys.v2.UndeleteKeyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.api.apikeys.v2.Key] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.apikeys.v2.Key]: @googleapis_reference_link{google/api/apikeys/v2/resources.proto#L32}
  /// [google.api.apikeys.v2.UndeleteKeyRequest]: @googleapis_reference_link{google/api/apikeys/v2/apikeys.proto#L266}
  ///
  // clang-format on
  future<StatusOr<google::api::apikeys::v2::Key>> UndeleteKey(
      google::api::apikeys::v2::UndeleteKeyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UndeleteKey
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UndeleteKey(
      NoAwaitTag, google::api::apikeys::v2::UndeleteKeyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UndeleteKey
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::api::apikeys::v2::Key>> UndeleteKey(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Find the parent project and resource name of the API
  /// key that matches the key string in the request. If the API key has been
  /// purged, resource name will not be set.
  /// The service account must have the `apikeys.keys.lookup` permission
  /// on the parent project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.api.apikeys.v2.LookupKeyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.api.apikeys.v2.LookupKeyResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.apikeys.v2.LookupKeyRequest]: @googleapis_reference_link{google/api/apikeys/v2/apikeys.proto#L275}
  /// [google.api.apikeys.v2.LookupKeyResponse]: @googleapis_reference_link{google/api/apikeys/v2/apikeys.proto#L281}
  ///
  // clang-format on
  StatusOr<google::api::apikeys::v2::LookupKeyResponse> LookupKey(
      google::api::apikeys::v2::LookupKeyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the latest state of a long-running operation.  Clients can use this
  /// method to poll the operation result at intervals as recommended by the API
  /// service.
  ///
  /// @param name  The name of the operation resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.longrunning.Operation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.GetOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L165}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> GetOperation(std::string const& name,
                                                        Options opts = {});

  // clang-format off
  ///
  /// Gets the latest state of a long-running operation.  Clients can use this
  /// method to poll the operation result at intervals as recommended by the API
  /// service.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.GetOperationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.longrunning.Operation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.GetOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L165}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<ApiKeysConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace apikeys_v2
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APIKEYS_V2_API_KEYS_CLIENT_H
