// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/alloydb/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ALLOYDB_V1_ALLOY_DB_ADMIN_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ALLOYDB_V1_ALLOY_DB_ADMIN_CONNECTION_H

#include "google/cloud/alloydb/v1/alloy_db_admin_connection_idempotency_policy.h"
#include "google/cloud/alloydb/v1/internal/alloy_db_admin_retry_traits.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/alloydb/v1/service.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace alloydb_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `AlloyDBAdminConnection`.
class AlloyDBAdminRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<AlloyDBAdminRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `AlloyDBAdminConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class AlloyDBAdminLimitedErrorCountRetryPolicy
    : public AlloyDBAdminRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit AlloyDBAdminLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  AlloyDBAdminLimitedErrorCountRetryPolicy(
      AlloyDBAdminLimitedErrorCountRetryPolicy&& rhs) noexcept
      : AlloyDBAdminLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}
  AlloyDBAdminLimitedErrorCountRetryPolicy(
      AlloyDBAdminLimitedErrorCountRetryPolicy const& rhs) noexcept
      : AlloyDBAdminLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<AlloyDBAdminRetryPolicy> clone() const override {
    return std::make_unique<AlloyDBAdminLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = AlloyDBAdminRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      alloydb_v1_internal::AlloyDBAdminRetryTraits>
      impl_;
};

/**
 * A retry policy for `AlloyDBAdminConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class AlloyDBAdminLimitedTimeRetryPolicy : public AlloyDBAdminRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit AlloyDBAdminLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  AlloyDBAdminLimitedTimeRetryPolicy(
      AlloyDBAdminLimitedTimeRetryPolicy&& rhs) noexcept
      : AlloyDBAdminLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  AlloyDBAdminLimitedTimeRetryPolicy(
      AlloyDBAdminLimitedTimeRetryPolicy const& rhs) noexcept
      : AlloyDBAdminLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<AlloyDBAdminRetryPolicy> clone() const override {
    return std::make_unique<AlloyDBAdminLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = AlloyDBAdminRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      alloydb_v1_internal::AlloyDBAdminRetryTraits>
      impl_;
};

/**
 * The `AlloyDBAdminConnection` object for `AlloyDBAdminClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `AlloyDBAdminClient`. This allows users to inject custom behavior
 * (e.g., with a Google Mock object) when writing tests that use objects of type
 * `AlloyDBAdminClient`.
 *
 * To create a concrete instance, see `MakeAlloyDBAdminConnection()`.
 *
 * For mocking, see `alloydb_v1_mocks::MockAlloyDBAdminConnection`.
 */
class AlloyDBAdminConnection {
 public:
  virtual ~AlloyDBAdminConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StreamRange<google::cloud::alloydb::v1::Cluster> ListClusters(
      google::cloud::alloydb::v1::ListClustersRequest request);

  virtual StatusOr<google::cloud::alloydb::v1::Cluster> GetCluster(
      google::cloud::alloydb::v1::GetClusterRequest const& request);

  virtual future<StatusOr<google::cloud::alloydb::v1::Cluster>> CreateCluster(
      google::cloud::alloydb::v1::CreateClusterRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CreateCluster(
      NoAwaitTag,
      google::cloud::alloydb::v1::CreateClusterRequest const& request);

  virtual future<StatusOr<google::cloud::alloydb::v1::Cluster>> CreateCluster(
      google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::alloydb::v1::Cluster>> UpdateCluster(
      google::cloud::alloydb::v1::UpdateClusterRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpdateCluster(
      NoAwaitTag,
      google::cloud::alloydb::v1::UpdateClusterRequest const& request);

  virtual future<StatusOr<google::cloud::alloydb::v1::Cluster>> UpdateCluster(
      google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::alloydb::v1::OperationMetadata>>
  DeleteCluster(
      google::cloud::alloydb::v1::DeleteClusterRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeleteCluster(
      NoAwaitTag,
      google::cloud::alloydb::v1::DeleteClusterRequest const& request);

  virtual future<StatusOr<google::cloud::alloydb::v1::OperationMetadata>>
  DeleteCluster(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::alloydb::v1::Cluster>> PromoteCluster(
      google::cloud::alloydb::v1::PromoteClusterRequest const& request);

  virtual StatusOr<google::longrunning::Operation> PromoteCluster(
      NoAwaitTag,
      google::cloud::alloydb::v1::PromoteClusterRequest const& request);

  virtual future<StatusOr<google::cloud::alloydb::v1::Cluster>> PromoteCluster(
      google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::alloydb::v1::Cluster>>
  SwitchoverCluster(
      google::cloud::alloydb::v1::SwitchoverClusterRequest const& request);

  virtual StatusOr<google::longrunning::Operation> SwitchoverCluster(
      NoAwaitTag,
      google::cloud::alloydb::v1::SwitchoverClusterRequest const& request);

  virtual future<StatusOr<google::cloud::alloydb::v1::Cluster>>
  SwitchoverCluster(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::alloydb::v1::Cluster>> RestoreCluster(
      google::cloud::alloydb::v1::RestoreClusterRequest const& request);

  virtual StatusOr<google::longrunning::Operation> RestoreCluster(
      NoAwaitTag,
      google::cloud::alloydb::v1::RestoreClusterRequest const& request);

  virtual future<StatusOr<google::cloud::alloydb::v1::Cluster>> RestoreCluster(
      google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::alloydb::v1::Cluster>>
  CreateSecondaryCluster(
      google::cloud::alloydb::v1::CreateSecondaryClusterRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CreateSecondaryCluster(
      NoAwaitTag,
      google::cloud::alloydb::v1::CreateSecondaryClusterRequest const& request);

  virtual future<StatusOr<google::cloud::alloydb::v1::Cluster>>
  CreateSecondaryCluster(google::longrunning::Operation const& operation);

  virtual StreamRange<google::cloud::alloydb::v1::Instance> ListInstances(
      google::cloud::alloydb::v1::ListInstancesRequest request);

  virtual StatusOr<google::cloud::alloydb::v1::Instance> GetInstance(
      google::cloud::alloydb::v1::GetInstanceRequest const& request);

  virtual future<StatusOr<google::cloud::alloydb::v1::Instance>> CreateInstance(
      google::cloud::alloydb::v1::CreateInstanceRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CreateInstance(
      NoAwaitTag,
      google::cloud::alloydb::v1::CreateInstanceRequest const& request);

  virtual future<StatusOr<google::cloud::alloydb::v1::Instance>> CreateInstance(
      google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::alloydb::v1::Instance>>
  CreateSecondaryInstance(
      google::cloud::alloydb::v1::CreateSecondaryInstanceRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> CreateSecondaryInstance(
      NoAwaitTag,
      google::cloud::alloydb::v1::CreateSecondaryInstanceRequest const&
          request);

  virtual future<StatusOr<google::cloud::alloydb::v1::Instance>>
  CreateSecondaryInstance(google::longrunning::Operation const& operation);

  virtual future<
      StatusOr<google::cloud::alloydb::v1::BatchCreateInstancesResponse>>
  BatchCreateInstances(
      google::cloud::alloydb::v1::BatchCreateInstancesRequest const& request);

  virtual StatusOr<google::longrunning::Operation> BatchCreateInstances(
      NoAwaitTag,
      google::cloud::alloydb::v1::BatchCreateInstancesRequest const& request);

  virtual future<
      StatusOr<google::cloud::alloydb::v1::BatchCreateInstancesResponse>>
  BatchCreateInstances(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::alloydb::v1::Instance>> UpdateInstance(
      google::cloud::alloydb::v1::UpdateInstanceRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpdateInstance(
      NoAwaitTag,
      google::cloud::alloydb::v1::UpdateInstanceRequest const& request);

  virtual future<StatusOr<google::cloud::alloydb::v1::Instance>> UpdateInstance(
      google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::alloydb::v1::OperationMetadata>>
  DeleteInstance(
      google::cloud::alloydb::v1::DeleteInstanceRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeleteInstance(
      NoAwaitTag,
      google::cloud::alloydb::v1::DeleteInstanceRequest const& request);

  virtual future<StatusOr<google::cloud::alloydb::v1::OperationMetadata>>
  DeleteInstance(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::alloydb::v1::Instance>>
  FailoverInstance(
      google::cloud::alloydb::v1::FailoverInstanceRequest const& request);

  virtual StatusOr<google::longrunning::Operation> FailoverInstance(
      NoAwaitTag,
      google::cloud::alloydb::v1::FailoverInstanceRequest const& request);

  virtual future<StatusOr<google::cloud::alloydb::v1::Instance>>
  FailoverInstance(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::alloydb::v1::Instance>> InjectFault(
      google::cloud::alloydb::v1::InjectFaultRequest const& request);

  virtual StatusOr<google::longrunning::Operation> InjectFault(
      NoAwaitTag,
      google::cloud::alloydb::v1::InjectFaultRequest const& request);

  virtual future<StatusOr<google::cloud::alloydb::v1::Instance>> InjectFault(
      google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::alloydb::v1::Instance>>
  RestartInstance(
      google::cloud::alloydb::v1::RestartInstanceRequest const& request);

  virtual StatusOr<google::longrunning::Operation> RestartInstance(
      NoAwaitTag,
      google::cloud::alloydb::v1::RestartInstanceRequest const& request);

  virtual future<StatusOr<google::cloud::alloydb::v1::Instance>>
  RestartInstance(google::longrunning::Operation const& operation);

  virtual StatusOr<google::cloud::alloydb::v1::ExecuteSqlResponse> ExecuteSql(
      google::cloud::alloydb::v1::ExecuteSqlRequest const& request);

  virtual StreamRange<google::cloud::alloydb::v1::Backup> ListBackups(
      google::cloud::alloydb::v1::ListBackupsRequest request);

  virtual StatusOr<google::cloud::alloydb::v1::Backup> GetBackup(
      google::cloud::alloydb::v1::GetBackupRequest const& request);

  virtual future<StatusOr<google::cloud::alloydb::v1::Backup>> CreateBackup(
      google::cloud::alloydb::v1::CreateBackupRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CreateBackup(
      NoAwaitTag,
      google::cloud::alloydb::v1::CreateBackupRequest const& request);

  virtual future<StatusOr<google::cloud::alloydb::v1::Backup>> CreateBackup(
      google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::alloydb::v1::Backup>> UpdateBackup(
      google::cloud::alloydb::v1::UpdateBackupRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpdateBackup(
      NoAwaitTag,
      google::cloud::alloydb::v1::UpdateBackupRequest const& request);

  virtual future<StatusOr<google::cloud::alloydb::v1::Backup>> UpdateBackup(
      google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::alloydb::v1::OperationMetadata>>
  DeleteBackup(google::cloud::alloydb::v1::DeleteBackupRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeleteBackup(
      NoAwaitTag,
      google::cloud::alloydb::v1::DeleteBackupRequest const& request);

  virtual future<StatusOr<google::cloud::alloydb::v1::OperationMetadata>>
  DeleteBackup(google::longrunning::Operation const& operation);

  virtual StreamRange<google::cloud::alloydb::v1::SupportedDatabaseFlag>
  ListSupportedDatabaseFlags(
      google::cloud::alloydb::v1::ListSupportedDatabaseFlagsRequest request);

  virtual StatusOr<
      google::cloud::alloydb::v1::GenerateClientCertificateResponse>
  GenerateClientCertificate(
      google::cloud::alloydb::v1::GenerateClientCertificateRequest const&
          request);

  virtual StatusOr<google::cloud::alloydb::v1::ConnectionInfo>
  GetConnectionInfo(
      google::cloud::alloydb::v1::GetConnectionInfoRequest const& request);

  virtual StreamRange<google::cloud::alloydb::v1::User> ListUsers(
      google::cloud::alloydb::v1::ListUsersRequest request);

  virtual StatusOr<google::cloud::alloydb::v1::User> GetUser(
      google::cloud::alloydb::v1::GetUserRequest const& request);

  virtual StatusOr<google::cloud::alloydb::v1::User> CreateUser(
      google::cloud::alloydb::v1::CreateUserRequest const& request);

  virtual StatusOr<google::cloud::alloydb::v1::User> UpdateUser(
      google::cloud::alloydb::v1::UpdateUserRequest const& request);

  virtual Status DeleteUser(
      google::cloud::alloydb::v1::DeleteUserRequest const& request);

  virtual StreamRange<google::cloud::alloydb::v1::Database> ListDatabases(
      google::cloud::alloydb::v1::ListDatabasesRequest request);

  virtual StreamRange<google::cloud::location::Location> ListLocations(
      google::cloud::location::ListLocationsRequest request);

  virtual StatusOr<google::cloud::location::Location> GetLocation(
      google::cloud::location::GetLocationRequest const& request);

  virtual StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request);

  virtual StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request);

  virtual Status DeleteOperation(
      google::longrunning::DeleteOperationRequest const& request);

  virtual Status CancelOperation(
      google::longrunning::CancelOperationRequest const& request);
};

/**
 * A factory function to construct an object of type `AlloyDBAdminConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of AlloyDBAdminClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `AlloyDBAdminConnection`. Expected options are any of the types in
 * the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::alloydb_v1::AlloyDBAdminPolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `AlloyDBAdminConnection` created by
 * this function.
 */
std::shared_ptr<AlloyDBAdminConnection> MakeAlloyDBAdminConnection(
    Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace alloydb_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ALLOYDB_V1_ALLOY_DB_ADMIN_CONNECTION_H
