// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/tensorboard_service.proto

#include "google/cloud/aiplatform/v1/tensorboard_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TensorboardServiceClient::TensorboardServiceClient(
    std::shared_ptr<TensorboardServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
TensorboardServiceClient::~TensorboardServiceClient() = default;

future<StatusOr<google::cloud::aiplatform::v1::Tensorboard>>
TensorboardServiceClient::CreateTensorboard(
    std::string const& parent,
    google::cloud::aiplatform::v1::Tensorboard const& tensorboard,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CreateTensorboardRequest request;
  request.set_parent(parent);
  *request.mutable_tensorboard() = tensorboard;
  return connection_->CreateTensorboard(request);
}

StatusOr<google::longrunning::Operation>
TensorboardServiceClient::CreateTensorboard(
    NoAwaitTag, std::string const& parent,
    google::cloud::aiplatform::v1::Tensorboard const& tensorboard,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CreateTensorboardRequest request;
  request.set_parent(parent);
  *request.mutable_tensorboard() = tensorboard;
  return connection_->CreateTensorboard(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::Tensorboard>>
TensorboardServiceClient::CreateTensorboard(
    google::cloud::aiplatform::v1::CreateTensorboardRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateTensorboard(request);
}

StatusOr<google::longrunning::Operation>
TensorboardServiceClient::CreateTensorboard(
    NoAwaitTag,
    google::cloud::aiplatform::v1::CreateTensorboardRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateTensorboard(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::Tensorboard>>
TensorboardServiceClient::CreateTensorboard(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateTensorboard(operation);
}

StatusOr<google::cloud::aiplatform::v1::Tensorboard>
TensorboardServiceClient::GetTensorboard(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::GetTensorboardRequest request;
  request.set_name(name);
  return connection_->GetTensorboard(request);
}

StatusOr<google::cloud::aiplatform::v1::Tensorboard>
TensorboardServiceClient::GetTensorboard(
    google::cloud::aiplatform::v1::GetTensorboardRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetTensorboard(request);
}

future<StatusOr<google::cloud::aiplatform::v1::Tensorboard>>
TensorboardServiceClient::UpdateTensorboard(
    google::cloud::aiplatform::v1::Tensorboard const& tensorboard,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::UpdateTensorboardRequest request;
  *request.mutable_tensorboard() = tensorboard;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateTensorboard(request);
}

StatusOr<google::longrunning::Operation>
TensorboardServiceClient::UpdateTensorboard(
    NoAwaitTag, google::cloud::aiplatform::v1::Tensorboard const& tensorboard,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::UpdateTensorboardRequest request;
  *request.mutable_tensorboard() = tensorboard;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateTensorboard(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::Tensorboard>>
TensorboardServiceClient::UpdateTensorboard(
    google::cloud::aiplatform::v1::UpdateTensorboardRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateTensorboard(request);
}

StatusOr<google::longrunning::Operation>
TensorboardServiceClient::UpdateTensorboard(
    NoAwaitTag,
    google::cloud::aiplatform::v1::UpdateTensorboardRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateTensorboard(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::Tensorboard>>
TensorboardServiceClient::UpdateTensorboard(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateTensorboard(operation);
}

StreamRange<google::cloud::aiplatform::v1::Tensorboard>
TensorboardServiceClient::ListTensorboards(std::string const& parent,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ListTensorboardsRequest request;
  request.set_parent(parent);
  return connection_->ListTensorboards(request);
}

StreamRange<google::cloud::aiplatform::v1::Tensorboard>
TensorboardServiceClient::ListTensorboards(
    google::cloud::aiplatform::v1::ListTensorboardsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListTensorboards(std::move(request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
TensorboardServiceClient::DeleteTensorboard(std::string const& name,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteTensorboardRequest request;
  request.set_name(name);
  return connection_->DeleteTensorboard(request);
}

StatusOr<google::longrunning::Operation>
TensorboardServiceClient::DeleteTensorboard(NoAwaitTag, std::string const& name,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteTensorboardRequest request;
  request.set_name(name);
  return connection_->DeleteTensorboard(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
TensorboardServiceClient::DeleteTensorboard(
    google::cloud::aiplatform::v1::DeleteTensorboardRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTensorboard(request);
}

StatusOr<google::longrunning::Operation>
TensorboardServiceClient::DeleteTensorboard(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteTensorboardRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTensorboard(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
TensorboardServiceClient::DeleteTensorboard(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTensorboard(operation);
}

StatusOr<google::cloud::aiplatform::v1::ReadTensorboardUsageResponse>
TensorboardServiceClient::ReadTensorboardUsage(std::string const& tensorboard,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ReadTensorboardUsageRequest request;
  request.set_tensorboard(tensorboard);
  return connection_->ReadTensorboardUsage(request);
}

StatusOr<google::cloud::aiplatform::v1::ReadTensorboardUsageResponse>
TensorboardServiceClient::ReadTensorboardUsage(
    google::cloud::aiplatform::v1::ReadTensorboardUsageRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ReadTensorboardUsage(request);
}

StatusOr<google::cloud::aiplatform::v1::ReadTensorboardSizeResponse>
TensorboardServiceClient::ReadTensorboardSize(std::string const& tensorboard,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ReadTensorboardSizeRequest request;
  request.set_tensorboard(tensorboard);
  return connection_->ReadTensorboardSize(request);
}

StatusOr<google::cloud::aiplatform::v1::ReadTensorboardSizeResponse>
TensorboardServiceClient::ReadTensorboardSize(
    google::cloud::aiplatform::v1::ReadTensorboardSizeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ReadTensorboardSize(request);
}

StatusOr<google::cloud::aiplatform::v1::TensorboardExperiment>
TensorboardServiceClient::CreateTensorboardExperiment(
    std::string const& parent,
    google::cloud::aiplatform::v1::TensorboardExperiment const&
        tensorboard_experiment,
    std::string const& tensorboard_experiment_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CreateTensorboardExperimentRequest request;
  request.set_parent(parent);
  *request.mutable_tensorboard_experiment() = tensorboard_experiment;
  request.set_tensorboard_experiment_id(tensorboard_experiment_id);
  return connection_->CreateTensorboardExperiment(request);
}

StatusOr<google::cloud::aiplatform::v1::TensorboardExperiment>
TensorboardServiceClient::CreateTensorboardExperiment(
    google::cloud::aiplatform::v1::CreateTensorboardExperimentRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateTensorboardExperiment(request);
}

StatusOr<google::cloud::aiplatform::v1::TensorboardExperiment>
TensorboardServiceClient::GetTensorboardExperiment(std::string const& name,
                                                   Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::GetTensorboardExperimentRequest request;
  request.set_name(name);
  return connection_->GetTensorboardExperiment(request);
}

StatusOr<google::cloud::aiplatform::v1::TensorboardExperiment>
TensorboardServiceClient::GetTensorboardExperiment(
    google::cloud::aiplatform::v1::GetTensorboardExperimentRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetTensorboardExperiment(request);
}

StatusOr<google::cloud::aiplatform::v1::TensorboardExperiment>
TensorboardServiceClient::UpdateTensorboardExperiment(
    google::cloud::aiplatform::v1::TensorboardExperiment const&
        tensorboard_experiment,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::UpdateTensorboardExperimentRequest request;
  *request.mutable_tensorboard_experiment() = tensorboard_experiment;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateTensorboardExperiment(request);
}

StatusOr<google::cloud::aiplatform::v1::TensorboardExperiment>
TensorboardServiceClient::UpdateTensorboardExperiment(
    google::cloud::aiplatform::v1::UpdateTensorboardExperimentRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateTensorboardExperiment(request);
}

StreamRange<google::cloud::aiplatform::v1::TensorboardExperiment>
TensorboardServiceClient::ListTensorboardExperiments(std::string const& parent,
                                                     Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ListTensorboardExperimentsRequest request;
  request.set_parent(parent);
  return connection_->ListTensorboardExperiments(request);
}

StreamRange<google::cloud::aiplatform::v1::TensorboardExperiment>
TensorboardServiceClient::ListTensorboardExperiments(
    google::cloud::aiplatform::v1::ListTensorboardExperimentsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListTensorboardExperiments(std::move(request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
TensorboardServiceClient::DeleteTensorboardExperiment(std::string const& name,
                                                      Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteTensorboardExperimentRequest request;
  request.set_name(name);
  return connection_->DeleteTensorboardExperiment(request);
}

StatusOr<google::longrunning::Operation>
TensorboardServiceClient::DeleteTensorboardExperiment(NoAwaitTag,
                                                      std::string const& name,
                                                      Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteTensorboardExperimentRequest request;
  request.set_name(name);
  return connection_->DeleteTensorboardExperiment(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
TensorboardServiceClient::DeleteTensorboardExperiment(
    google::cloud::aiplatform::v1::DeleteTensorboardExperimentRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTensorboardExperiment(request);
}

StatusOr<google::longrunning::Operation>
TensorboardServiceClient::DeleteTensorboardExperiment(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteTensorboardExperimentRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTensorboardExperiment(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
TensorboardServiceClient::DeleteTensorboardExperiment(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTensorboardExperiment(operation);
}

StatusOr<google::cloud::aiplatform::v1::TensorboardRun>
TensorboardServiceClient::CreateTensorboardRun(
    std::string const& parent,
    google::cloud::aiplatform::v1::TensorboardRun const& tensorboard_run,
    std::string const& tensorboard_run_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CreateTensorboardRunRequest request;
  request.set_parent(parent);
  *request.mutable_tensorboard_run() = tensorboard_run;
  request.set_tensorboard_run_id(tensorboard_run_id);
  return connection_->CreateTensorboardRun(request);
}

StatusOr<google::cloud::aiplatform::v1::TensorboardRun>
TensorboardServiceClient::CreateTensorboardRun(
    google::cloud::aiplatform::v1::CreateTensorboardRunRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateTensorboardRun(request);
}

StatusOr<google::cloud::aiplatform::v1::BatchCreateTensorboardRunsResponse>
TensorboardServiceClient::BatchCreateTensorboardRuns(
    std::string const& parent,
    std::vector<
        google::cloud::aiplatform::v1::CreateTensorboardRunRequest> const&
        requests,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::BatchCreateTensorboardRunsRequest request;
  request.set_parent(parent);
  *request.mutable_requests() = {requests.begin(), requests.end()};
  return connection_->BatchCreateTensorboardRuns(request);
}

StatusOr<google::cloud::aiplatform::v1::BatchCreateTensorboardRunsResponse>
TensorboardServiceClient::BatchCreateTensorboardRuns(
    google::cloud::aiplatform::v1::BatchCreateTensorboardRunsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchCreateTensorboardRuns(request);
}

StatusOr<google::cloud::aiplatform::v1::TensorboardRun>
TensorboardServiceClient::GetTensorboardRun(std::string const& name,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::GetTensorboardRunRequest request;
  request.set_name(name);
  return connection_->GetTensorboardRun(request);
}

StatusOr<google::cloud::aiplatform::v1::TensorboardRun>
TensorboardServiceClient::GetTensorboardRun(
    google::cloud::aiplatform::v1::GetTensorboardRunRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetTensorboardRun(request);
}

StatusOr<google::cloud::aiplatform::v1::TensorboardRun>
TensorboardServiceClient::UpdateTensorboardRun(
    google::cloud::aiplatform::v1::TensorboardRun const& tensorboard_run,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::UpdateTensorboardRunRequest request;
  *request.mutable_tensorboard_run() = tensorboard_run;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateTensorboardRun(request);
}

StatusOr<google::cloud::aiplatform::v1::TensorboardRun>
TensorboardServiceClient::UpdateTensorboardRun(
    google::cloud::aiplatform::v1::UpdateTensorboardRunRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateTensorboardRun(request);
}

StreamRange<google::cloud::aiplatform::v1::TensorboardRun>
TensorboardServiceClient::ListTensorboardRuns(std::string const& parent,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ListTensorboardRunsRequest request;
  request.set_parent(parent);
  return connection_->ListTensorboardRuns(request);
}

StreamRange<google::cloud::aiplatform::v1::TensorboardRun>
TensorboardServiceClient::ListTensorboardRuns(
    google::cloud::aiplatform::v1::ListTensorboardRunsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListTensorboardRuns(std::move(request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
TensorboardServiceClient::DeleteTensorboardRun(std::string const& name,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteTensorboardRunRequest request;
  request.set_name(name);
  return connection_->DeleteTensorboardRun(request);
}

StatusOr<google::longrunning::Operation>
TensorboardServiceClient::DeleteTensorboardRun(NoAwaitTag,
                                               std::string const& name,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteTensorboardRunRequest request;
  request.set_name(name);
  return connection_->DeleteTensorboardRun(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
TensorboardServiceClient::DeleteTensorboardRun(
    google::cloud::aiplatform::v1::DeleteTensorboardRunRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTensorboardRun(request);
}

StatusOr<google::longrunning::Operation>
TensorboardServiceClient::DeleteTensorboardRun(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteTensorboardRunRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTensorboardRun(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
TensorboardServiceClient::DeleteTensorboardRun(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTensorboardRun(operation);
}

StatusOr<
    google::cloud::aiplatform::v1::BatchCreateTensorboardTimeSeriesResponse>
TensorboardServiceClient::BatchCreateTensorboardTimeSeries(
    std::string const& parent,
    std::vector<google::cloud::aiplatform::v1::
                    CreateTensorboardTimeSeriesRequest> const& requests,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::BatchCreateTensorboardTimeSeriesRequest
      request;
  request.set_parent(parent);
  *request.mutable_requests() = {requests.begin(), requests.end()};
  return connection_->BatchCreateTensorboardTimeSeries(request);
}

StatusOr<
    google::cloud::aiplatform::v1::BatchCreateTensorboardTimeSeriesResponse>
TensorboardServiceClient::BatchCreateTensorboardTimeSeries(
    google::cloud::aiplatform::v1::
        BatchCreateTensorboardTimeSeriesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchCreateTensorboardTimeSeries(request);
}

StatusOr<google::cloud::aiplatform::v1::TensorboardTimeSeries>
TensorboardServiceClient::CreateTensorboardTimeSeries(
    std::string const& parent,
    google::cloud::aiplatform::v1::TensorboardTimeSeries const&
        tensorboard_time_series,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CreateTensorboardTimeSeriesRequest request;
  request.set_parent(parent);
  *request.mutable_tensorboard_time_series() = tensorboard_time_series;
  return connection_->CreateTensorboardTimeSeries(request);
}

StatusOr<google::cloud::aiplatform::v1::TensorboardTimeSeries>
TensorboardServiceClient::CreateTensorboardTimeSeries(
    google::cloud::aiplatform::v1::CreateTensorboardTimeSeriesRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateTensorboardTimeSeries(request);
}

StatusOr<google::cloud::aiplatform::v1::TensorboardTimeSeries>
TensorboardServiceClient::GetTensorboardTimeSeries(std::string const& name,
                                                   Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::GetTensorboardTimeSeriesRequest request;
  request.set_name(name);
  return connection_->GetTensorboardTimeSeries(request);
}

StatusOr<google::cloud::aiplatform::v1::TensorboardTimeSeries>
TensorboardServiceClient::GetTensorboardTimeSeries(
    google::cloud::aiplatform::v1::GetTensorboardTimeSeriesRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetTensorboardTimeSeries(request);
}

StatusOr<google::cloud::aiplatform::v1::TensorboardTimeSeries>
TensorboardServiceClient::UpdateTensorboardTimeSeries(
    google::cloud::aiplatform::v1::TensorboardTimeSeries const&
        tensorboard_time_series,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::UpdateTensorboardTimeSeriesRequest request;
  *request.mutable_tensorboard_time_series() = tensorboard_time_series;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateTensorboardTimeSeries(request);
}

StatusOr<google::cloud::aiplatform::v1::TensorboardTimeSeries>
TensorboardServiceClient::UpdateTensorboardTimeSeries(
    google::cloud::aiplatform::v1::UpdateTensorboardTimeSeriesRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateTensorboardTimeSeries(request);
}

StreamRange<google::cloud::aiplatform::v1::TensorboardTimeSeries>
TensorboardServiceClient::ListTensorboardTimeSeries(std::string const& parent,
                                                    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ListTensorboardTimeSeriesRequest request;
  request.set_parent(parent);
  return connection_->ListTensorboardTimeSeries(request);
}

StreamRange<google::cloud::aiplatform::v1::TensorboardTimeSeries>
TensorboardServiceClient::ListTensorboardTimeSeries(
    google::cloud::aiplatform::v1::ListTensorboardTimeSeriesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListTensorboardTimeSeries(std::move(request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
TensorboardServiceClient::DeleteTensorboardTimeSeries(std::string const& name,
                                                      Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteTensorboardTimeSeriesRequest request;
  request.set_name(name);
  return connection_->DeleteTensorboardTimeSeries(request);
}

StatusOr<google::longrunning::Operation>
TensorboardServiceClient::DeleteTensorboardTimeSeries(NoAwaitTag,
                                                      std::string const& name,
                                                      Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteTensorboardTimeSeriesRequest request;
  request.set_name(name);
  return connection_->DeleteTensorboardTimeSeries(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
TensorboardServiceClient::DeleteTensorboardTimeSeries(
    google::cloud::aiplatform::v1::DeleteTensorboardTimeSeriesRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTensorboardTimeSeries(request);
}

StatusOr<google::longrunning::Operation>
TensorboardServiceClient::DeleteTensorboardTimeSeries(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteTensorboardTimeSeriesRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTensorboardTimeSeries(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
TensorboardServiceClient::DeleteTensorboardTimeSeries(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTensorboardTimeSeries(operation);
}

StatusOr<
    google::cloud::aiplatform::v1::BatchReadTensorboardTimeSeriesDataResponse>
TensorboardServiceClient::BatchReadTensorboardTimeSeriesData(
    std::string const& tensorboard, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::BatchReadTensorboardTimeSeriesDataRequest
      request;
  request.set_tensorboard(tensorboard);
  return connection_->BatchReadTensorboardTimeSeriesData(request);
}

StatusOr<
    google::cloud::aiplatform::v1::BatchReadTensorboardTimeSeriesDataResponse>
TensorboardServiceClient::BatchReadTensorboardTimeSeriesData(
    google::cloud::aiplatform::v1::
        BatchReadTensorboardTimeSeriesDataRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchReadTensorboardTimeSeriesData(request);
}

StatusOr<google::cloud::aiplatform::v1::ReadTensorboardTimeSeriesDataResponse>
TensorboardServiceClient::ReadTensorboardTimeSeriesData(
    std::string const& tensorboard_time_series, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ReadTensorboardTimeSeriesDataRequest request;
  request.set_tensorboard_time_series(tensorboard_time_series);
  return connection_->ReadTensorboardTimeSeriesData(request);
}

StatusOr<google::cloud::aiplatform::v1::ReadTensorboardTimeSeriesDataResponse>
TensorboardServiceClient::ReadTensorboardTimeSeriesData(
    google::cloud::aiplatform::v1::ReadTensorboardTimeSeriesDataRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ReadTensorboardTimeSeriesData(request);
}

StreamRange<google::cloud::aiplatform::v1::ReadTensorboardBlobDataResponse>
TensorboardServiceClient::ReadTensorboardBlobData(
    std::string const& time_series, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ReadTensorboardBlobDataRequest request;
  request.set_time_series(time_series);
  return connection_->ReadTensorboardBlobData(request);
}

StreamRange<google::cloud::aiplatform::v1::ReadTensorboardBlobDataResponse>
TensorboardServiceClient::ReadTensorboardBlobData(
    google::cloud::aiplatform::v1::ReadTensorboardBlobDataRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ReadTensorboardBlobData(request);
}

StatusOr<google::cloud::aiplatform::v1::WriteTensorboardExperimentDataResponse>
TensorboardServiceClient::WriteTensorboardExperimentData(
    std::string const& tensorboard_experiment,
    std::vector<
        google::cloud::aiplatform::v1::WriteTensorboardRunDataRequest> const&
        write_run_data_requests,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::WriteTensorboardExperimentDataRequest request;
  request.set_tensorboard_experiment(tensorboard_experiment);
  *request.mutable_write_run_data_requests() = {write_run_data_requests.begin(),
                                                write_run_data_requests.end()};
  return connection_->WriteTensorboardExperimentData(request);
}

StatusOr<google::cloud::aiplatform::v1::WriteTensorboardExperimentDataResponse>
TensorboardServiceClient::WriteTensorboardExperimentData(
    google::cloud::aiplatform::v1::WriteTensorboardExperimentDataRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->WriteTensorboardExperimentData(request);
}

StatusOr<google::cloud::aiplatform::v1::WriteTensorboardRunDataResponse>
TensorboardServiceClient::WriteTensorboardRunData(
    std::string const& tensorboard_run,
    std::vector<google::cloud::aiplatform::v1::TimeSeriesData> const&
        time_series_data,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::WriteTensorboardRunDataRequest request;
  request.set_tensorboard_run(tensorboard_run);
  *request.mutable_time_series_data() = {time_series_data.begin(),
                                         time_series_data.end()};
  return connection_->WriteTensorboardRunData(request);
}

StatusOr<google::cloud::aiplatform::v1::WriteTensorboardRunDataResponse>
TensorboardServiceClient::WriteTensorboardRunData(
    google::cloud::aiplatform::v1::WriteTensorboardRunDataRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->WriteTensorboardRunData(request);
}

StreamRange<google::cloud::aiplatform::v1::TimeSeriesDataPoint>
TensorboardServiceClient::ExportTensorboardTimeSeriesData(
    std::string const& tensorboard_time_series, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ExportTensorboardTimeSeriesDataRequest request;
  request.set_tensorboard_time_series(tensorboard_time_series);
  return connection_->ExportTensorboardTimeSeriesData(request);
}

StreamRange<google::cloud::aiplatform::v1::TimeSeriesDataPoint>
TensorboardServiceClient::ExportTensorboardTimeSeriesData(
    google::cloud::aiplatform::v1::ExportTensorboardTimeSeriesDataRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ExportTensorboardTimeSeriesData(std::move(request));
}

StreamRange<google::cloud::location::Location>
TensorboardServiceClient::ListLocations(
    google::cloud::location::ListLocationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLocations(std::move(request));
}

StatusOr<google::cloud::location::Location>
TensorboardServiceClient::GetLocation(
    google::cloud::location::GetLocationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetLocation(request);
}

StatusOr<google::iam::v1::Policy> TensorboardServiceClient::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> TensorboardServiceClient::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIamPolicy(request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
TensorboardServiceClient::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

StreamRange<google::longrunning::Operation>
TensorboardServiceClient::ListOperations(std::string const& name,
                                         std::string const& filter,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::ListOperationsRequest request;
  request.set_name(name);
  request.set_filter(filter);
  return connection_->ListOperations(request);
}

StreamRange<google::longrunning::Operation>
TensorboardServiceClient::ListOperations(
    google::longrunning::ListOperationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOperations(std::move(request));
}

StatusOr<google::longrunning::Operation> TensorboardServiceClient::GetOperation(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::longrunning::Operation> TensorboardServiceClient::GetOperation(
    google::longrunning::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

Status TensorboardServiceClient::DeleteOperation(std::string const& name,
                                                 Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::DeleteOperationRequest request;
  request.set_name(name);
  return connection_->DeleteOperation(request);
}

Status TensorboardServiceClient::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteOperation(request);
}

Status TensorboardServiceClient::CancelOperation(std::string const& name,
                                                 Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::CancelOperationRequest request;
  request.set_name(name);
  return connection_->CancelOperation(request);
}

Status TensorboardServiceClient::CancelOperation(
    google::longrunning::CancelOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelOperation(request);
}

StatusOr<google::longrunning::Operation>
TensorboardServiceClient::WaitOperation(
    google::longrunning::WaitOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->WaitOperation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google
