// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/pipeline_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_PIPELINE_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_PIPELINE_CONNECTION_H

#include "google/cloud/aiplatform/v1/internal/pipeline_retry_traits.h"
#include "google/cloud/aiplatform/v1/pipeline_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/aiplatform/v1/pipeline_service.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `PipelineServiceConnection`.
class PipelineServiceRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<PipelineServiceRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `PipelineServiceConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class PipelineServiceLimitedErrorCountRetryPolicy
    : public PipelineServiceRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit PipelineServiceLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  PipelineServiceLimitedErrorCountRetryPolicy(
      PipelineServiceLimitedErrorCountRetryPolicy&& rhs) noexcept
      : PipelineServiceLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}
  PipelineServiceLimitedErrorCountRetryPolicy(
      PipelineServiceLimitedErrorCountRetryPolicy const& rhs) noexcept
      : PipelineServiceLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<PipelineServiceRetryPolicy> clone() const override {
    return std::make_unique<PipelineServiceLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = PipelineServiceRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      aiplatform_v1_internal::PipelineServiceRetryTraits>
      impl_;
};

/**
 * A retry policy for `PipelineServiceConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class PipelineServiceLimitedTimeRetryPolicy
    : public PipelineServiceRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit PipelineServiceLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  PipelineServiceLimitedTimeRetryPolicy(
      PipelineServiceLimitedTimeRetryPolicy&& rhs) noexcept
      : PipelineServiceLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  PipelineServiceLimitedTimeRetryPolicy(
      PipelineServiceLimitedTimeRetryPolicy const& rhs) noexcept
      : PipelineServiceLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<PipelineServiceRetryPolicy> clone() const override {
    return std::make_unique<PipelineServiceLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = PipelineServiceRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      aiplatform_v1_internal::PipelineServiceRetryTraits>
      impl_;
};

/**
 * The `PipelineServiceConnection` object for `PipelineServiceClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `PipelineServiceClient`. This allows users to inject custom behavior
 * (e.g., with a Google Mock object) when writing tests that use objects of type
 * `PipelineServiceClient`.
 *
 * To create a concrete instance, see `MakePipelineServiceConnection()`.
 *
 * For mocking, see `aiplatform_v1_mocks::MockPipelineServiceConnection`.
 */
class PipelineServiceConnection {
 public:
  virtual ~PipelineServiceConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StatusOr<google::cloud::aiplatform::v1::TrainingPipeline>
  CreateTrainingPipeline(
      google::cloud::aiplatform::v1::CreateTrainingPipelineRequest const&
          request);

  virtual StatusOr<google::cloud::aiplatform::v1::TrainingPipeline>
  GetTrainingPipeline(
      google::cloud::aiplatform::v1::GetTrainingPipelineRequest const& request);

  virtual StreamRange<google::cloud::aiplatform::v1::TrainingPipeline>
  ListTrainingPipelines(
      google::cloud::aiplatform::v1::ListTrainingPipelinesRequest request);

  virtual future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteTrainingPipeline(
      google::cloud::aiplatform::v1::DeleteTrainingPipelineRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> DeleteTrainingPipeline(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteTrainingPipelineRequest const&
          request);

  virtual future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteTrainingPipeline(google::longrunning::Operation const& operation);

  virtual Status CancelTrainingPipeline(
      google::cloud::aiplatform::v1::CancelTrainingPipelineRequest const&
          request);

  virtual StatusOr<google::cloud::aiplatform::v1::PipelineJob>
  CreatePipelineJob(
      google::cloud::aiplatform::v1::CreatePipelineJobRequest const& request);

  virtual StatusOr<google::cloud::aiplatform::v1::PipelineJob> GetPipelineJob(
      google::cloud::aiplatform::v1::GetPipelineJobRequest const& request);

  virtual StreamRange<google::cloud::aiplatform::v1::PipelineJob>
  ListPipelineJobs(
      google::cloud::aiplatform::v1::ListPipelineJobsRequest request);

  virtual future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeletePipelineJob(
      google::cloud::aiplatform::v1::DeletePipelineJobRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeletePipelineJob(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeletePipelineJobRequest const& request);

  virtual future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeletePipelineJob(google::longrunning::Operation const& operation);

  virtual future<
      StatusOr<google::cloud::aiplatform::v1::BatchDeletePipelineJobsResponse>>
  BatchDeletePipelineJobs(
      google::cloud::aiplatform::v1::BatchDeletePipelineJobsRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> BatchDeletePipelineJobs(
      NoAwaitTag,
      google::cloud::aiplatform::v1::BatchDeletePipelineJobsRequest const&
          request);

  virtual future<
      StatusOr<google::cloud::aiplatform::v1::BatchDeletePipelineJobsResponse>>
  BatchDeletePipelineJobs(google::longrunning::Operation const& operation);

  virtual Status CancelPipelineJob(
      google::cloud::aiplatform::v1::CancelPipelineJobRequest const& request);

  virtual future<
      StatusOr<google::cloud::aiplatform::v1::BatchCancelPipelineJobsResponse>>
  BatchCancelPipelineJobs(
      google::cloud::aiplatform::v1::BatchCancelPipelineJobsRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> BatchCancelPipelineJobs(
      NoAwaitTag,
      google::cloud::aiplatform::v1::BatchCancelPipelineJobsRequest const&
          request);

  virtual future<
      StatusOr<google::cloud::aiplatform::v1::BatchCancelPipelineJobsResponse>>
  BatchCancelPipelineJobs(google::longrunning::Operation const& operation);

  virtual StreamRange<google::cloud::location::Location> ListLocations(
      google::cloud::location::ListLocationsRequest request);

  virtual StatusOr<google::cloud::location::Location> GetLocation(
      google::cloud::location::GetLocationRequest const& request);

  virtual StatusOr<google::iam::v1::Policy> SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request);

  virtual StatusOr<google::iam::v1::Policy> GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request);

  virtual StatusOr<google::iam::v1::TestIamPermissionsResponse>
  TestIamPermissions(google::iam::v1::TestIamPermissionsRequest const& request);

  virtual StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request);

  virtual StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request);

  virtual Status DeleteOperation(
      google::longrunning::DeleteOperationRequest const& request);

  virtual Status CancelOperation(
      google::longrunning::CancelOperationRequest const& request);

  virtual StatusOr<google::longrunning::Operation> WaitOperation(
      google::longrunning::WaitOperationRequest const& request);
};

/**
 * A factory function to construct an object of type
 * `PipelineServiceConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of PipelineServiceClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `PipelineServiceConnection`. Expected options are any of the types
 * in the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::aiplatform_v1::PipelineServicePolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param location Sets the prefix for the default `EndpointOption` value.
 * @param options (optional) Configure the `PipelineServiceConnection` created
 * by this function.
 */
std::shared_ptr<PipelineServiceConnection> MakePipelineServiceConnection(
    std::string const& location, Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_PIPELINE_CONNECTION_H
