// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/pipeline_service.proto

#include "google/cloud/aiplatform/v1/pipeline_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

PipelineServiceClient::PipelineServiceClient(
    std::shared_ptr<PipelineServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
PipelineServiceClient::~PipelineServiceClient() = default;

StatusOr<google::cloud::aiplatform::v1::TrainingPipeline>
PipelineServiceClient::CreateTrainingPipeline(
    std::string const& parent,
    google::cloud::aiplatform::v1::TrainingPipeline const& training_pipeline,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CreateTrainingPipelineRequest request;
  request.set_parent(parent);
  *request.mutable_training_pipeline() = training_pipeline;
  return connection_->CreateTrainingPipeline(request);
}

StatusOr<google::cloud::aiplatform::v1::TrainingPipeline>
PipelineServiceClient::CreateTrainingPipeline(
    google::cloud::aiplatform::v1::CreateTrainingPipelineRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateTrainingPipeline(request);
}

StatusOr<google::cloud::aiplatform::v1::TrainingPipeline>
PipelineServiceClient::GetTrainingPipeline(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::GetTrainingPipelineRequest request;
  request.set_name(name);
  return connection_->GetTrainingPipeline(request);
}

StatusOr<google::cloud::aiplatform::v1::TrainingPipeline>
PipelineServiceClient::GetTrainingPipeline(
    google::cloud::aiplatform::v1::GetTrainingPipelineRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetTrainingPipeline(request);
}

StreamRange<google::cloud::aiplatform::v1::TrainingPipeline>
PipelineServiceClient::ListTrainingPipelines(std::string const& parent,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ListTrainingPipelinesRequest request;
  request.set_parent(parent);
  return connection_->ListTrainingPipelines(request);
}

StreamRange<google::cloud::aiplatform::v1::TrainingPipeline>
PipelineServiceClient::ListTrainingPipelines(
    google::cloud::aiplatform::v1::ListTrainingPipelinesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListTrainingPipelines(std::move(request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
PipelineServiceClient::DeleteTrainingPipeline(std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteTrainingPipelineRequest request;
  request.set_name(name);
  return connection_->DeleteTrainingPipeline(request);
}

StatusOr<google::longrunning::Operation>
PipelineServiceClient::DeleteTrainingPipeline(NoAwaitTag,
                                              std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteTrainingPipelineRequest request;
  request.set_name(name);
  return connection_->DeleteTrainingPipeline(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
PipelineServiceClient::DeleteTrainingPipeline(
    google::cloud::aiplatform::v1::DeleteTrainingPipelineRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTrainingPipeline(request);
}

StatusOr<google::longrunning::Operation>
PipelineServiceClient::DeleteTrainingPipeline(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteTrainingPipelineRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTrainingPipeline(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
PipelineServiceClient::DeleteTrainingPipeline(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTrainingPipeline(operation);
}

Status PipelineServiceClient::CancelTrainingPipeline(std::string const& name,
                                                     Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CancelTrainingPipelineRequest request;
  request.set_name(name);
  return connection_->CancelTrainingPipeline(request);
}

Status PipelineServiceClient::CancelTrainingPipeline(
    google::cloud::aiplatform::v1::CancelTrainingPipelineRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelTrainingPipeline(request);
}

StatusOr<google::cloud::aiplatform::v1::PipelineJob>
PipelineServiceClient::CreatePipelineJob(
    std::string const& parent,
    google::cloud::aiplatform::v1::PipelineJob const& pipeline_job,
    std::string const& pipeline_job_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CreatePipelineJobRequest request;
  request.set_parent(parent);
  *request.mutable_pipeline_job() = pipeline_job;
  request.set_pipeline_job_id(pipeline_job_id);
  return connection_->CreatePipelineJob(request);
}

StatusOr<google::cloud::aiplatform::v1::PipelineJob>
PipelineServiceClient::CreatePipelineJob(
    google::cloud::aiplatform::v1::CreatePipelineJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreatePipelineJob(request);
}

StatusOr<google::cloud::aiplatform::v1::PipelineJob>
PipelineServiceClient::GetPipelineJob(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::GetPipelineJobRequest request;
  request.set_name(name);
  return connection_->GetPipelineJob(request);
}

StatusOr<google::cloud::aiplatform::v1::PipelineJob>
PipelineServiceClient::GetPipelineJob(
    google::cloud::aiplatform::v1::GetPipelineJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetPipelineJob(request);
}

StreamRange<google::cloud::aiplatform::v1::PipelineJob>
PipelineServiceClient::ListPipelineJobs(std::string const& parent,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ListPipelineJobsRequest request;
  request.set_parent(parent);
  return connection_->ListPipelineJobs(request);
}

StreamRange<google::cloud::aiplatform::v1::PipelineJob>
PipelineServiceClient::ListPipelineJobs(
    google::cloud::aiplatform::v1::ListPipelineJobsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListPipelineJobs(std::move(request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
PipelineServiceClient::DeletePipelineJob(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeletePipelineJobRequest request;
  request.set_name(name);
  return connection_->DeletePipelineJob(request);
}

StatusOr<google::longrunning::Operation>
PipelineServiceClient::DeletePipelineJob(NoAwaitTag, std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeletePipelineJobRequest request;
  request.set_name(name);
  return connection_->DeletePipelineJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
PipelineServiceClient::DeletePipelineJob(
    google::cloud::aiplatform::v1::DeletePipelineJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeletePipelineJob(request);
}

StatusOr<google::longrunning::Operation>
PipelineServiceClient::DeletePipelineJob(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeletePipelineJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeletePipelineJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
PipelineServiceClient::DeletePipelineJob(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeletePipelineJob(operation);
}

future<StatusOr<google::cloud::aiplatform::v1::BatchDeletePipelineJobsResponse>>
PipelineServiceClient::BatchDeletePipelineJobs(
    std::string const& parent, std::vector<std::string> const& names,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::BatchDeletePipelineJobsRequest request;
  request.set_parent(parent);
  *request.mutable_names() = {names.begin(), names.end()};
  return connection_->BatchDeletePipelineJobs(request);
}

StatusOr<google::longrunning::Operation>
PipelineServiceClient::BatchDeletePipelineJobs(
    NoAwaitTag, std::string const& parent,
    std::vector<std::string> const& names, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::BatchDeletePipelineJobsRequest request;
  request.set_parent(parent);
  *request.mutable_names() = {names.begin(), names.end()};
  return connection_->BatchDeletePipelineJobs(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::BatchDeletePipelineJobsResponse>>
PipelineServiceClient::BatchDeletePipelineJobs(
    google::cloud::aiplatform::v1::BatchDeletePipelineJobsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchDeletePipelineJobs(request);
}

StatusOr<google::longrunning::Operation>
PipelineServiceClient::BatchDeletePipelineJobs(
    NoAwaitTag,
    google::cloud::aiplatform::v1::BatchDeletePipelineJobsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchDeletePipelineJobs(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::BatchDeletePipelineJobsResponse>>
PipelineServiceClient::BatchDeletePipelineJobs(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchDeletePipelineJobs(operation);
}

Status PipelineServiceClient::CancelPipelineJob(std::string const& name,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CancelPipelineJobRequest request;
  request.set_name(name);
  return connection_->CancelPipelineJob(request);
}

Status PipelineServiceClient::CancelPipelineJob(
    google::cloud::aiplatform::v1::CancelPipelineJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelPipelineJob(request);
}

future<StatusOr<google::cloud::aiplatform::v1::BatchCancelPipelineJobsResponse>>
PipelineServiceClient::BatchCancelPipelineJobs(
    std::string const& parent, std::vector<std::string> const& names,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::BatchCancelPipelineJobsRequest request;
  request.set_parent(parent);
  *request.mutable_names() = {names.begin(), names.end()};
  return connection_->BatchCancelPipelineJobs(request);
}

StatusOr<google::longrunning::Operation>
PipelineServiceClient::BatchCancelPipelineJobs(
    NoAwaitTag, std::string const& parent,
    std::vector<std::string> const& names, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::BatchCancelPipelineJobsRequest request;
  request.set_parent(parent);
  *request.mutable_names() = {names.begin(), names.end()};
  return connection_->BatchCancelPipelineJobs(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::BatchCancelPipelineJobsResponse>>
PipelineServiceClient::BatchCancelPipelineJobs(
    google::cloud::aiplatform::v1::BatchCancelPipelineJobsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchCancelPipelineJobs(request);
}

StatusOr<google::longrunning::Operation>
PipelineServiceClient::BatchCancelPipelineJobs(
    NoAwaitTag,
    google::cloud::aiplatform::v1::BatchCancelPipelineJobsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchCancelPipelineJobs(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::BatchCancelPipelineJobsResponse>>
PipelineServiceClient::BatchCancelPipelineJobs(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchCancelPipelineJobs(operation);
}

StreamRange<google::cloud::location::Location>
PipelineServiceClient::ListLocations(
    google::cloud::location::ListLocationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLocations(std::move(request));
}

StatusOr<google::cloud::location::Location> PipelineServiceClient::GetLocation(
    google::cloud::location::GetLocationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetLocation(request);
}

StatusOr<google::iam::v1::Policy> PipelineServiceClient::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> PipelineServiceClient::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIamPolicy(request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
PipelineServiceClient::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

StreamRange<google::longrunning::Operation>
PipelineServiceClient::ListOperations(std::string const& name,
                                      std::string const& filter, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::ListOperationsRequest request;
  request.set_name(name);
  request.set_filter(filter);
  return connection_->ListOperations(request);
}

StreamRange<google::longrunning::Operation>
PipelineServiceClient::ListOperations(
    google::longrunning::ListOperationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOperations(std::move(request));
}

StatusOr<google::longrunning::Operation> PipelineServiceClient::GetOperation(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::longrunning::Operation> PipelineServiceClient::GetOperation(
    google::longrunning::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

Status PipelineServiceClient::DeleteOperation(std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::DeleteOperationRequest request;
  request.set_name(name);
  return connection_->DeleteOperation(request);
}

Status PipelineServiceClient::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteOperation(request);
}

Status PipelineServiceClient::CancelOperation(std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::CancelOperationRequest request;
  request.set_name(name);
  return connection_->CancelOperation(request);
}

Status PipelineServiceClient::CancelOperation(
    google::longrunning::CancelOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelOperation(request);
}

StatusOr<google::longrunning::Operation> PipelineServiceClient::WaitOperation(
    google::longrunning::WaitOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->WaitOperation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google
