// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/notebook_service.proto

#include "google/cloud/aiplatform/v1/notebook_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

NotebookServiceClient::NotebookServiceClient(
    std::shared_ptr<NotebookServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
NotebookServiceClient::~NotebookServiceClient() = default;

future<StatusOr<google::cloud::aiplatform::v1::NotebookRuntimeTemplate>>
NotebookServiceClient::CreateNotebookRuntimeTemplate(
    std::string const& parent,
    google::cloud::aiplatform::v1::NotebookRuntimeTemplate const&
        notebook_runtime_template,
    std::string const& notebook_runtime_template_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CreateNotebookRuntimeTemplateRequest request;
  request.set_parent(parent);
  *request.mutable_notebook_runtime_template() = notebook_runtime_template;
  request.set_notebook_runtime_template_id(notebook_runtime_template_id);
  return connection_->CreateNotebookRuntimeTemplate(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::CreateNotebookRuntimeTemplate(
    NoAwaitTag, std::string const& parent,
    google::cloud::aiplatform::v1::NotebookRuntimeTemplate const&
        notebook_runtime_template,
    std::string const& notebook_runtime_template_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CreateNotebookRuntimeTemplateRequest request;
  request.set_parent(parent);
  *request.mutable_notebook_runtime_template() = notebook_runtime_template;
  request.set_notebook_runtime_template_id(notebook_runtime_template_id);
  return connection_->CreateNotebookRuntimeTemplate(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::NotebookRuntimeTemplate>>
NotebookServiceClient::CreateNotebookRuntimeTemplate(
    google::cloud::aiplatform::v1::CreateNotebookRuntimeTemplateRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateNotebookRuntimeTemplate(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::CreateNotebookRuntimeTemplate(
    NoAwaitTag,
    google::cloud::aiplatform::v1::CreateNotebookRuntimeTemplateRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateNotebookRuntimeTemplate(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::NotebookRuntimeTemplate>>
NotebookServiceClient::CreateNotebookRuntimeTemplate(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateNotebookRuntimeTemplate(operation);
}

StatusOr<google::cloud::aiplatform::v1::NotebookRuntimeTemplate>
NotebookServiceClient::GetNotebookRuntimeTemplate(std::string const& name,
                                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::GetNotebookRuntimeTemplateRequest request;
  request.set_name(name);
  return connection_->GetNotebookRuntimeTemplate(request);
}

StatusOr<google::cloud::aiplatform::v1::NotebookRuntimeTemplate>
NotebookServiceClient::GetNotebookRuntimeTemplate(
    google::cloud::aiplatform::v1::GetNotebookRuntimeTemplateRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetNotebookRuntimeTemplate(request);
}

StreamRange<google::cloud::aiplatform::v1::NotebookRuntimeTemplate>
NotebookServiceClient::ListNotebookRuntimeTemplates(std::string const& parent,
                                                    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ListNotebookRuntimeTemplatesRequest request;
  request.set_parent(parent);
  return connection_->ListNotebookRuntimeTemplates(request);
}

StreamRange<google::cloud::aiplatform::v1::NotebookRuntimeTemplate>
NotebookServiceClient::ListNotebookRuntimeTemplates(
    google::cloud::aiplatform::v1::ListNotebookRuntimeTemplatesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListNotebookRuntimeTemplates(std::move(request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
NotebookServiceClient::DeleteNotebookRuntimeTemplate(std::string const& name,
                                                     Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteNotebookRuntimeTemplateRequest request;
  request.set_name(name);
  return connection_->DeleteNotebookRuntimeTemplate(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::DeleteNotebookRuntimeTemplate(NoAwaitTag,
                                                     std::string const& name,
                                                     Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteNotebookRuntimeTemplateRequest request;
  request.set_name(name);
  return connection_->DeleteNotebookRuntimeTemplate(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
NotebookServiceClient::DeleteNotebookRuntimeTemplate(
    google::cloud::aiplatform::v1::DeleteNotebookRuntimeTemplateRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNotebookRuntimeTemplate(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::DeleteNotebookRuntimeTemplate(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteNotebookRuntimeTemplateRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNotebookRuntimeTemplate(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
NotebookServiceClient::DeleteNotebookRuntimeTemplate(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNotebookRuntimeTemplate(operation);
}

StatusOr<google::cloud::aiplatform::v1::NotebookRuntimeTemplate>
NotebookServiceClient::UpdateNotebookRuntimeTemplate(
    google::cloud::aiplatform::v1::NotebookRuntimeTemplate const&
        notebook_runtime_template,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::UpdateNotebookRuntimeTemplateRequest request;
  *request.mutable_notebook_runtime_template() = notebook_runtime_template;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateNotebookRuntimeTemplate(request);
}

StatusOr<google::cloud::aiplatform::v1::NotebookRuntimeTemplate>
NotebookServiceClient::UpdateNotebookRuntimeTemplate(
    google::cloud::aiplatform::v1::UpdateNotebookRuntimeTemplateRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateNotebookRuntimeTemplate(request);
}

future<StatusOr<google::cloud::aiplatform::v1::NotebookRuntime>>
NotebookServiceClient::AssignNotebookRuntime(
    std::string const& parent, std::string const& notebook_runtime_template,
    google::cloud::aiplatform::v1::NotebookRuntime const& notebook_runtime,
    std::string const& notebook_runtime_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::AssignNotebookRuntimeRequest request;
  request.set_parent(parent);
  request.set_notebook_runtime_template(notebook_runtime_template);
  *request.mutable_notebook_runtime() = notebook_runtime;
  request.set_notebook_runtime_id(notebook_runtime_id);
  return connection_->AssignNotebookRuntime(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::AssignNotebookRuntime(
    NoAwaitTag, std::string const& parent,
    std::string const& notebook_runtime_template,
    google::cloud::aiplatform::v1::NotebookRuntime const& notebook_runtime,
    std::string const& notebook_runtime_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::AssignNotebookRuntimeRequest request;
  request.set_parent(parent);
  request.set_notebook_runtime_template(notebook_runtime_template);
  *request.mutable_notebook_runtime() = notebook_runtime;
  request.set_notebook_runtime_id(notebook_runtime_id);
  return connection_->AssignNotebookRuntime(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::NotebookRuntime>>
NotebookServiceClient::AssignNotebookRuntime(
    google::cloud::aiplatform::v1::AssignNotebookRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AssignNotebookRuntime(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::AssignNotebookRuntime(
    NoAwaitTag,
    google::cloud::aiplatform::v1::AssignNotebookRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AssignNotebookRuntime(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::NotebookRuntime>>
NotebookServiceClient::AssignNotebookRuntime(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AssignNotebookRuntime(operation);
}

StatusOr<google::cloud::aiplatform::v1::NotebookRuntime>
NotebookServiceClient::GetNotebookRuntime(std::string const& name,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::GetNotebookRuntimeRequest request;
  request.set_name(name);
  return connection_->GetNotebookRuntime(request);
}

StatusOr<google::cloud::aiplatform::v1::NotebookRuntime>
NotebookServiceClient::GetNotebookRuntime(
    google::cloud::aiplatform::v1::GetNotebookRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetNotebookRuntime(request);
}

StreamRange<google::cloud::aiplatform::v1::NotebookRuntime>
NotebookServiceClient::ListNotebookRuntimes(std::string const& parent,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ListNotebookRuntimesRequest request;
  request.set_parent(parent);
  return connection_->ListNotebookRuntimes(request);
}

StreamRange<google::cloud::aiplatform::v1::NotebookRuntime>
NotebookServiceClient::ListNotebookRuntimes(
    google::cloud::aiplatform::v1::ListNotebookRuntimesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListNotebookRuntimes(std::move(request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
NotebookServiceClient::DeleteNotebookRuntime(std::string const& name,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteNotebookRuntimeRequest request;
  request.set_name(name);
  return connection_->DeleteNotebookRuntime(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::DeleteNotebookRuntime(NoAwaitTag,
                                             std::string const& name,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteNotebookRuntimeRequest request;
  request.set_name(name);
  return connection_->DeleteNotebookRuntime(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
NotebookServiceClient::DeleteNotebookRuntime(
    google::cloud::aiplatform::v1::DeleteNotebookRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNotebookRuntime(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::DeleteNotebookRuntime(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteNotebookRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNotebookRuntime(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
NotebookServiceClient::DeleteNotebookRuntime(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNotebookRuntime(operation);
}

future<StatusOr<google::cloud::aiplatform::v1::UpgradeNotebookRuntimeResponse>>
NotebookServiceClient::UpgradeNotebookRuntime(std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::UpgradeNotebookRuntimeRequest request;
  request.set_name(name);
  return connection_->UpgradeNotebookRuntime(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::UpgradeNotebookRuntime(NoAwaitTag,
                                              std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::UpgradeNotebookRuntimeRequest request;
  request.set_name(name);
  return connection_->UpgradeNotebookRuntime(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::UpgradeNotebookRuntimeResponse>>
NotebookServiceClient::UpgradeNotebookRuntime(
    google::cloud::aiplatform::v1::UpgradeNotebookRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpgradeNotebookRuntime(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::UpgradeNotebookRuntime(
    NoAwaitTag,
    google::cloud::aiplatform::v1::UpgradeNotebookRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpgradeNotebookRuntime(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::UpgradeNotebookRuntimeResponse>>
NotebookServiceClient::UpgradeNotebookRuntime(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpgradeNotebookRuntime(operation);
}

future<StatusOr<google::cloud::aiplatform::v1::StartNotebookRuntimeResponse>>
NotebookServiceClient::StartNotebookRuntime(std::string const& name,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::StartNotebookRuntimeRequest request;
  request.set_name(name);
  return connection_->StartNotebookRuntime(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::StartNotebookRuntime(NoAwaitTag, std::string const& name,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::StartNotebookRuntimeRequest request;
  request.set_name(name);
  return connection_->StartNotebookRuntime(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::StartNotebookRuntimeResponse>>
NotebookServiceClient::StartNotebookRuntime(
    google::cloud::aiplatform::v1::StartNotebookRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StartNotebookRuntime(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::StartNotebookRuntime(
    NoAwaitTag,
    google::cloud::aiplatform::v1::StartNotebookRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StartNotebookRuntime(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::StartNotebookRuntimeResponse>>
NotebookServiceClient::StartNotebookRuntime(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StartNotebookRuntime(operation);
}

future<StatusOr<google::cloud::aiplatform::v1::StopNotebookRuntimeResponse>>
NotebookServiceClient::StopNotebookRuntime(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::StopNotebookRuntimeRequest request;
  request.set_name(name);
  return connection_->StopNotebookRuntime(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::StopNotebookRuntime(NoAwaitTag, std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::StopNotebookRuntimeRequest request;
  request.set_name(name);
  return connection_->StopNotebookRuntime(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::StopNotebookRuntimeResponse>>
NotebookServiceClient::StopNotebookRuntime(
    google::cloud::aiplatform::v1::StopNotebookRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StopNotebookRuntime(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::StopNotebookRuntime(
    NoAwaitTag,
    google::cloud::aiplatform::v1::StopNotebookRuntimeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StopNotebookRuntime(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::StopNotebookRuntimeResponse>>
NotebookServiceClient::StopNotebookRuntime(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StopNotebookRuntime(operation);
}

future<StatusOr<google::cloud::aiplatform::v1::NotebookExecutionJob>>
NotebookServiceClient::CreateNotebookExecutionJob(
    std::string const& parent,
    google::cloud::aiplatform::v1::NotebookExecutionJob const&
        notebook_execution_job,
    std::string const& notebook_execution_job_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CreateNotebookExecutionJobRequest request;
  request.set_parent(parent);
  *request.mutable_notebook_execution_job() = notebook_execution_job;
  request.set_notebook_execution_job_id(notebook_execution_job_id);
  return connection_->CreateNotebookExecutionJob(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::CreateNotebookExecutionJob(
    NoAwaitTag, std::string const& parent,
    google::cloud::aiplatform::v1::NotebookExecutionJob const&
        notebook_execution_job,
    std::string const& notebook_execution_job_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CreateNotebookExecutionJobRequest request;
  request.set_parent(parent);
  *request.mutable_notebook_execution_job() = notebook_execution_job;
  request.set_notebook_execution_job_id(notebook_execution_job_id);
  return connection_->CreateNotebookExecutionJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::NotebookExecutionJob>>
NotebookServiceClient::CreateNotebookExecutionJob(
    google::cloud::aiplatform::v1::CreateNotebookExecutionJobRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateNotebookExecutionJob(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::CreateNotebookExecutionJob(
    NoAwaitTag,
    google::cloud::aiplatform::v1::CreateNotebookExecutionJobRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateNotebookExecutionJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::NotebookExecutionJob>>
NotebookServiceClient::CreateNotebookExecutionJob(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateNotebookExecutionJob(operation);
}

StatusOr<google::cloud::aiplatform::v1::NotebookExecutionJob>
NotebookServiceClient::GetNotebookExecutionJob(std::string const& name,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::GetNotebookExecutionJobRequest request;
  request.set_name(name);
  return connection_->GetNotebookExecutionJob(request);
}

StatusOr<google::cloud::aiplatform::v1::NotebookExecutionJob>
NotebookServiceClient::GetNotebookExecutionJob(
    google::cloud::aiplatform::v1::GetNotebookExecutionJobRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetNotebookExecutionJob(request);
}

StreamRange<google::cloud::aiplatform::v1::NotebookExecutionJob>
NotebookServiceClient::ListNotebookExecutionJobs(std::string const& parent,
                                                 Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ListNotebookExecutionJobsRequest request;
  request.set_parent(parent);
  return connection_->ListNotebookExecutionJobs(request);
}

StreamRange<google::cloud::aiplatform::v1::NotebookExecutionJob>
NotebookServiceClient::ListNotebookExecutionJobs(
    google::cloud::aiplatform::v1::ListNotebookExecutionJobsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListNotebookExecutionJobs(std::move(request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
NotebookServiceClient::DeleteNotebookExecutionJob(std::string const& name,
                                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteNotebookExecutionJobRequest request;
  request.set_name(name);
  return connection_->DeleteNotebookExecutionJob(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::DeleteNotebookExecutionJob(NoAwaitTag,
                                                  std::string const& name,
                                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteNotebookExecutionJobRequest request;
  request.set_name(name);
  return connection_->DeleteNotebookExecutionJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
NotebookServiceClient::DeleteNotebookExecutionJob(
    google::cloud::aiplatform::v1::DeleteNotebookExecutionJobRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNotebookExecutionJob(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::DeleteNotebookExecutionJob(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteNotebookExecutionJobRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNotebookExecutionJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
NotebookServiceClient::DeleteNotebookExecutionJob(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNotebookExecutionJob(operation);
}

StreamRange<google::cloud::location::Location>
NotebookServiceClient::ListLocations(
    google::cloud::location::ListLocationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLocations(std::move(request));
}

StatusOr<google::cloud::location::Location> NotebookServiceClient::GetLocation(
    google::cloud::location::GetLocationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetLocation(request);
}

StatusOr<google::iam::v1::Policy> NotebookServiceClient::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> NotebookServiceClient::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIamPolicy(request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
NotebookServiceClient::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

StreamRange<google::longrunning::Operation>
NotebookServiceClient::ListOperations(std::string const& name,
                                      std::string const& filter, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::ListOperationsRequest request;
  request.set_name(name);
  request.set_filter(filter);
  return connection_->ListOperations(request);
}

StreamRange<google::longrunning::Operation>
NotebookServiceClient::ListOperations(
    google::longrunning::ListOperationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOperations(std::move(request));
}

StatusOr<google::longrunning::Operation> NotebookServiceClient::GetOperation(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::longrunning::Operation> NotebookServiceClient::GetOperation(
    google::longrunning::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

Status NotebookServiceClient::DeleteOperation(std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::DeleteOperationRequest request;
  request.set_name(name);
  return connection_->DeleteOperation(request);
}

Status NotebookServiceClient::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteOperation(request);
}

Status NotebookServiceClient::CancelOperation(std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::CancelOperationRequest request;
  request.set_name(name);
  return connection_->CancelOperation(request);
}

Status NotebookServiceClient::CancelOperation(
    google::longrunning::CancelOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelOperation(request);
}

StatusOr<google::longrunning::Operation> NotebookServiceClient::WaitOperation(
    google::longrunning::WaitOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->WaitOperation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google
