// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/vizier_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_VIZIER_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_VIZIER_CONNECTION_IMPL_H

#include "google/cloud/aiplatform/v1/internal/vizier_retry_traits.h"
#include "google/cloud/aiplatform/v1/internal/vizier_stub.h"
#include "google/cloud/aiplatform/v1/vizier_connection.h"
#include "google/cloud/aiplatform/v1/vizier_connection_idempotency_policy.h"
#include "google/cloud/aiplatform/v1/vizier_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class VizierServiceConnectionImpl
    : public aiplatform_v1::VizierServiceConnection {
 public:
  ~VizierServiceConnectionImpl() override = default;

  VizierServiceConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<aiplatform_v1_internal::VizierServiceStub> stub,
      Options options);

  Options options() override { return options_; }

  StatusOr<google::cloud::aiplatform::v1::Study> CreateStudy(
      google::cloud::aiplatform::v1::CreateStudyRequest const& request)
      override;

  StatusOr<google::cloud::aiplatform::v1::Study> GetStudy(
      google::cloud::aiplatform::v1::GetStudyRequest const& request) override;

  StreamRange<google::cloud::aiplatform::v1::Study> ListStudies(
      google::cloud::aiplatform::v1::ListStudiesRequest request) override;

  Status DeleteStudy(google::cloud::aiplatform::v1::DeleteStudyRequest const&
                         request) override;

  StatusOr<google::cloud::aiplatform::v1::Study> LookupStudy(
      google::cloud::aiplatform::v1::LookupStudyRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::SuggestTrialsResponse>>
  SuggestTrials(google::cloud::aiplatform::v1::SuggestTrialsRequest const&
                    request) override;

  StatusOr<google::longrunning::Operation> SuggestTrials(
      NoAwaitTag,
      google::cloud::aiplatform::v1::SuggestTrialsRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::SuggestTrialsResponse>>
  SuggestTrials(google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::aiplatform::v1::Trial> CreateTrial(
      google::cloud::aiplatform::v1::CreateTrialRequest const& request)
      override;

  StatusOr<google::cloud::aiplatform::v1::Trial> GetTrial(
      google::cloud::aiplatform::v1::GetTrialRequest const& request) override;

  StreamRange<google::cloud::aiplatform::v1::Trial> ListTrials(
      google::cloud::aiplatform::v1::ListTrialsRequest request) override;

  StatusOr<google::cloud::aiplatform::v1::Trial> AddTrialMeasurement(
      google::cloud::aiplatform::v1::AddTrialMeasurementRequest const& request)
      override;

  StatusOr<google::cloud::aiplatform::v1::Trial> CompleteTrial(
      google::cloud::aiplatform::v1::CompleteTrialRequest const& request)
      override;

  Status DeleteTrial(google::cloud::aiplatform::v1::DeleteTrialRequest const&
                         request) override;

  future<StatusOr<
      google::cloud::aiplatform::v1::CheckTrialEarlyStoppingStateResponse>>
  CheckTrialEarlyStoppingState(
      google::cloud::aiplatform::v1::CheckTrialEarlyStoppingStateRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> CheckTrialEarlyStoppingState(
      NoAwaitTag,
      google::cloud::aiplatform::v1::CheckTrialEarlyStoppingStateRequest const&
          request) override;

  future<StatusOr<
      google::cloud::aiplatform::v1::CheckTrialEarlyStoppingStateResponse>>
  CheckTrialEarlyStoppingState(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::aiplatform::v1::Trial> StopTrial(
      google::cloud::aiplatform::v1::StopTrialRequest const& request) override;

  StatusOr<google::cloud::aiplatform::v1::ListOptimalTrialsResponse>
  ListOptimalTrials(
      google::cloud::aiplatform::v1::ListOptimalTrialsRequest const& request)
      override;

  StreamRange<google::cloud::location::Location> ListLocations(
      google::cloud::location::ListLocationsRequest request) override;

  StatusOr<google::cloud::location::Location> GetLocation(
      google::cloud::location::GetLocationRequest const& request) override;

  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request) override;

  StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request) override;

  Status DeleteOperation(
      google::longrunning::DeleteOperationRequest const& request) override;

  Status CancelOperation(
      google::longrunning::CancelOperationRequest const& request) override;

  StatusOr<google::longrunning::Operation> WaitOperation(
      google::longrunning::WaitOperationRequest const& request) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<aiplatform_v1_internal::VizierServiceStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_VIZIER_CONNECTION_IMPL_H
