// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/tensorboard_service.proto

#include "google/cloud/aiplatform/v1/internal/tensorboard_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

TensorboardServiceTracingConnection::TensorboardServiceTracingConnection(
    std::shared_ptr<aiplatform_v1::TensorboardServiceConnection> child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::aiplatform::v1::Tensorboard>>
TensorboardServiceTracingConnection::CreateTensorboard(
    google::cloud::aiplatform::v1::CreateTensorboardRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::CreateTensorboard");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateTensorboard(request));
}

StatusOr<google::longrunning::Operation>
TensorboardServiceTracingConnection::CreateTensorboard(
    NoAwaitTag,
    google::cloud::aiplatform::v1::CreateTensorboardRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::CreateTensorboard");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateTensorboard(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::Tensorboard>>
TensorboardServiceTracingConnection::CreateTensorboard(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::CreateTensorboard");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateTensorboard(operation));
}

StatusOr<google::cloud::aiplatform::v1::Tensorboard>
TensorboardServiceTracingConnection::GetTensorboard(
    google::cloud::aiplatform::v1::GetTensorboardRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::GetTensorboard");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetTensorboard(request));
}

future<StatusOr<google::cloud::aiplatform::v1::Tensorboard>>
TensorboardServiceTracingConnection::UpdateTensorboard(
    google::cloud::aiplatform::v1::UpdateTensorboardRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::UpdateTensorboard");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateTensorboard(request));
}

StatusOr<google::longrunning::Operation>
TensorboardServiceTracingConnection::UpdateTensorboard(
    NoAwaitTag,
    google::cloud::aiplatform::v1::UpdateTensorboardRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::UpdateTensorboard");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateTensorboard(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::Tensorboard>>
TensorboardServiceTracingConnection::UpdateTensorboard(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::UpdateTensorboard");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateTensorboard(operation));
}

StreamRange<google::cloud::aiplatform::v1::Tensorboard>
TensorboardServiceTracingConnection::ListTensorboards(
    google::cloud::aiplatform::v1::ListTensorboardsRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::ListTensorboards");
  internal::OTelScope scope(span);
  auto sr = child_->ListTensorboards(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::aiplatform::v1::Tensorboard>(std::move(span),
                                                  std::move(sr));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
TensorboardServiceTracingConnection::DeleteTensorboard(
    google::cloud::aiplatform::v1::DeleteTensorboardRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::DeleteTensorboard");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteTensorboard(request));
}

StatusOr<google::longrunning::Operation>
TensorboardServiceTracingConnection::DeleteTensorboard(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteTensorboardRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::DeleteTensorboard");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteTensorboard(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
TensorboardServiceTracingConnection::DeleteTensorboard(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::DeleteTensorboard");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteTensorboard(operation));
}

StatusOr<google::cloud::aiplatform::v1::ReadTensorboardUsageResponse>
TensorboardServiceTracingConnection::ReadTensorboardUsage(
    google::cloud::aiplatform::v1::ReadTensorboardUsageRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::ReadTensorboardUsage");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->ReadTensorboardUsage(request));
}

StatusOr<google::cloud::aiplatform::v1::ReadTensorboardSizeResponse>
TensorboardServiceTracingConnection::ReadTensorboardSize(
    google::cloud::aiplatform::v1::ReadTensorboardSizeRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::ReadTensorboardSize");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->ReadTensorboardSize(request));
}

StatusOr<google::cloud::aiplatform::v1::TensorboardExperiment>
TensorboardServiceTracingConnection::CreateTensorboardExperiment(
    google::cloud::aiplatform::v1::CreateTensorboardExperimentRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::"
      "CreateTensorboardExperiment");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateTensorboardExperiment(request));
}

StatusOr<google::cloud::aiplatform::v1::TensorboardExperiment>
TensorboardServiceTracingConnection::GetTensorboardExperiment(
    google::cloud::aiplatform::v1::GetTensorboardExperimentRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::GetTensorboardExperiment");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetTensorboardExperiment(request));
}

StatusOr<google::cloud::aiplatform::v1::TensorboardExperiment>
TensorboardServiceTracingConnection::UpdateTensorboardExperiment(
    google::cloud::aiplatform::v1::UpdateTensorboardExperimentRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::"
      "UpdateTensorboardExperiment");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateTensorboardExperiment(request));
}

StreamRange<google::cloud::aiplatform::v1::TensorboardExperiment>
TensorboardServiceTracingConnection::ListTensorboardExperiments(
    google::cloud::aiplatform::v1::ListTensorboardExperimentsRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::"
      "ListTensorboardExperiments");
  internal::OTelScope scope(span);
  auto sr = child_->ListTensorboardExperiments(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::aiplatform::v1::TensorboardExperiment>(std::move(span),
                                                            std::move(sr));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
TensorboardServiceTracingConnection::DeleteTensorboardExperiment(
    google::cloud::aiplatform::v1::DeleteTensorboardExperimentRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::"
      "DeleteTensorboardExperiment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteTensorboardExperiment(request));
}

StatusOr<google::longrunning::Operation>
TensorboardServiceTracingConnection::DeleteTensorboardExperiment(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteTensorboardExperimentRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::"
      "DeleteTensorboardExperiment");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->DeleteTensorboardExperiment(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
TensorboardServiceTracingConnection::DeleteTensorboardExperiment(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::"
      "DeleteTensorboardExperiment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteTensorboardExperiment(operation));
}

StatusOr<google::cloud::aiplatform::v1::TensorboardRun>
TensorboardServiceTracingConnection::CreateTensorboardRun(
    google::cloud::aiplatform::v1::CreateTensorboardRunRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::CreateTensorboardRun");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateTensorboardRun(request));
}

StatusOr<google::cloud::aiplatform::v1::BatchCreateTensorboardRunsResponse>
TensorboardServiceTracingConnection::BatchCreateTensorboardRuns(
    google::cloud::aiplatform::v1::BatchCreateTensorboardRunsRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::"
      "BatchCreateTensorboardRuns");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->BatchCreateTensorboardRuns(request));
}

StatusOr<google::cloud::aiplatform::v1::TensorboardRun>
TensorboardServiceTracingConnection::GetTensorboardRun(
    google::cloud::aiplatform::v1::GetTensorboardRunRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::GetTensorboardRun");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetTensorboardRun(request));
}

StatusOr<google::cloud::aiplatform::v1::TensorboardRun>
TensorboardServiceTracingConnection::UpdateTensorboardRun(
    google::cloud::aiplatform::v1::UpdateTensorboardRunRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::UpdateTensorboardRun");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateTensorboardRun(request));
}

StreamRange<google::cloud::aiplatform::v1::TensorboardRun>
TensorboardServiceTracingConnection::ListTensorboardRuns(
    google::cloud::aiplatform::v1::ListTensorboardRunsRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::ListTensorboardRuns");
  internal::OTelScope scope(span);
  auto sr = child_->ListTensorboardRuns(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::aiplatform::v1::TensorboardRun>(std::move(span),
                                                     std::move(sr));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
TensorboardServiceTracingConnection::DeleteTensorboardRun(
    google::cloud::aiplatform::v1::DeleteTensorboardRunRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::DeleteTensorboardRun");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteTensorboardRun(request));
}

StatusOr<google::longrunning::Operation>
TensorboardServiceTracingConnection::DeleteTensorboardRun(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteTensorboardRunRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::DeleteTensorboardRun");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteTensorboardRun(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
TensorboardServiceTracingConnection::DeleteTensorboardRun(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::DeleteTensorboardRun");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteTensorboardRun(operation));
}

StatusOr<
    google::cloud::aiplatform::v1::BatchCreateTensorboardTimeSeriesResponse>
TensorboardServiceTracingConnection::BatchCreateTensorboardTimeSeries(
    google::cloud::aiplatform::v1::
        BatchCreateTensorboardTimeSeriesRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::"
      "BatchCreateTensorboardTimeSeries");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span,
                           child_->BatchCreateTensorboardTimeSeries(request));
}

StatusOr<google::cloud::aiplatform::v1::TensorboardTimeSeries>
TensorboardServiceTracingConnection::CreateTensorboardTimeSeries(
    google::cloud::aiplatform::v1::CreateTensorboardTimeSeriesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::"
      "CreateTensorboardTimeSeries");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateTensorboardTimeSeries(request));
}

StatusOr<google::cloud::aiplatform::v1::TensorboardTimeSeries>
TensorboardServiceTracingConnection::GetTensorboardTimeSeries(
    google::cloud::aiplatform::v1::GetTensorboardTimeSeriesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::GetTensorboardTimeSeries");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetTensorboardTimeSeries(request));
}

StatusOr<google::cloud::aiplatform::v1::TensorboardTimeSeries>
TensorboardServiceTracingConnection::UpdateTensorboardTimeSeries(
    google::cloud::aiplatform::v1::UpdateTensorboardTimeSeriesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::"
      "UpdateTensorboardTimeSeries");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateTensorboardTimeSeries(request));
}

StreamRange<google::cloud::aiplatform::v1::TensorboardTimeSeries>
TensorboardServiceTracingConnection::ListTensorboardTimeSeries(
    google::cloud::aiplatform::v1::ListTensorboardTimeSeriesRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::ListTensorboardTimeSeries");
  internal::OTelScope scope(span);
  auto sr = child_->ListTensorboardTimeSeries(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::aiplatform::v1::TensorboardTimeSeries>(std::move(span),
                                                            std::move(sr));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
TensorboardServiceTracingConnection::DeleteTensorboardTimeSeries(
    google::cloud::aiplatform::v1::DeleteTensorboardTimeSeriesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::"
      "DeleteTensorboardTimeSeries");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteTensorboardTimeSeries(request));
}

StatusOr<google::longrunning::Operation>
TensorboardServiceTracingConnection::DeleteTensorboardTimeSeries(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteTensorboardTimeSeriesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::"
      "DeleteTensorboardTimeSeries");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->DeleteTensorboardTimeSeries(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
TensorboardServiceTracingConnection::DeleteTensorboardTimeSeries(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::"
      "DeleteTensorboardTimeSeries");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteTensorboardTimeSeries(operation));
}

StatusOr<
    google::cloud::aiplatform::v1::BatchReadTensorboardTimeSeriesDataResponse>
TensorboardServiceTracingConnection::BatchReadTensorboardTimeSeriesData(
    google::cloud::aiplatform::v1::
        BatchReadTensorboardTimeSeriesDataRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::"
      "BatchReadTensorboardTimeSeriesData");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span,
                           child_->BatchReadTensorboardTimeSeriesData(request));
}

StatusOr<google::cloud::aiplatform::v1::ReadTensorboardTimeSeriesDataResponse>
TensorboardServiceTracingConnection::ReadTensorboardTimeSeriesData(
    google::cloud::aiplatform::v1::ReadTensorboardTimeSeriesDataRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::"
      "ReadTensorboardTimeSeriesData");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span,
                           child_->ReadTensorboardTimeSeriesData(request));
}

StreamRange<google::cloud::aiplatform::v1::ReadTensorboardBlobDataResponse>
TensorboardServiceTracingConnection::ReadTensorboardBlobData(
    google::cloud::aiplatform::v1::ReadTensorboardBlobDataRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::ReadTensorboardBlobData");
  internal::OTelScope scope(span);
  auto sr = child_->ReadTensorboardBlobData(request);
  return internal::MakeTracedStreamRange<
      google::cloud::aiplatform::v1::ReadTensorboardBlobDataResponse>(
      std::move(span), std::move(sr));
}
StatusOr<google::cloud::aiplatform::v1::WriteTensorboardExperimentDataResponse>
TensorboardServiceTracingConnection::WriteTensorboardExperimentData(
    google::cloud::aiplatform::v1::WriteTensorboardExperimentDataRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::"
      "WriteTensorboardExperimentData");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span,
                           child_->WriteTensorboardExperimentData(request));
}

StatusOr<google::cloud::aiplatform::v1::WriteTensorboardRunDataResponse>
TensorboardServiceTracingConnection::WriteTensorboardRunData(
    google::cloud::aiplatform::v1::WriteTensorboardRunDataRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::WriteTensorboardRunData");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->WriteTensorboardRunData(request));
}

StreamRange<google::cloud::aiplatform::v1::TimeSeriesDataPoint>
TensorboardServiceTracingConnection::ExportTensorboardTimeSeriesData(
    google::cloud::aiplatform::v1::ExportTensorboardTimeSeriesDataRequest
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::"
      "ExportTensorboardTimeSeriesData");
  internal::OTelScope scope(span);
  auto sr = child_->ExportTensorboardTimeSeriesData(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::aiplatform::v1::TimeSeriesDataPoint>(std::move(span),
                                                          std::move(sr));
}

StreamRange<google::cloud::location::Location>
TensorboardServiceTracingConnection::ListLocations(
    google::cloud::location::ListLocationsRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::ListLocations");
  internal::OTelScope scope(span);
  auto sr = child_->ListLocations(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::location::Location>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::location::Location>
TensorboardServiceTracingConnection::GetLocation(
    google::cloud::location::GetLocationRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::GetLocation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetLocation(request));
}

StatusOr<google::iam::v1::Policy>
TensorboardServiceTracingConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SetIamPolicy(request));
}

StatusOr<google::iam::v1::Policy>
TensorboardServiceTracingConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIamPolicy(request));
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
TensorboardServiceTracingConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TestIamPermissions(request));
}

StreamRange<google::longrunning::Operation>
TensorboardServiceTracingConnection::ListOperations(
    google::longrunning::ListOperationsRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::ListOperations");
  internal::OTelScope scope(span);
  auto sr = child_->ListOperations(std::move(request));
  return internal::MakeTracedStreamRange<google::longrunning::Operation>(
      std::move(span), std::move(sr));
}

StatusOr<google::longrunning::Operation>
TensorboardServiceTracingConnection::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetOperation(request));
}

Status TensorboardServiceTracingConnection::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::DeleteOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteOperation(request));
}

Status TensorboardServiceTracingConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::CancelOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CancelOperation(request));
}

StatusOr<google::longrunning::Operation>
TensorboardServiceTracingConnection::WaitOperation(
    google::longrunning::WaitOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::TensorboardServiceConnection::WaitOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->WaitOperation(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<aiplatform_v1::TensorboardServiceConnection>
MakeTensorboardServiceTracingConnection(
    std::shared_ptr<aiplatform_v1::TensorboardServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn =
        std::make_shared<TensorboardServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google
