// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/prediction_service.proto

#include "google/cloud/aiplatform/v1/internal/prediction_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

PredictionServiceTracingConnection::PredictionServiceTracingConnection(
    std::shared_ptr<aiplatform_v1::PredictionServiceConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::aiplatform::v1::PredictResponse>
PredictionServiceTracingConnection::Predict(
    google::cloud::aiplatform::v1::PredictRequest const& request) {
  auto span =
      internal::MakeSpan("aiplatform_v1::PredictionServiceConnection::Predict");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->Predict(request));
}

StatusOr<google::api::HttpBody> PredictionServiceTracingConnection::RawPredict(
    google::cloud::aiplatform::v1::RawPredictRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PredictionServiceConnection::RawPredict");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->RawPredict(request));
}

StreamRange<google::api::HttpBody>
PredictionServiceTracingConnection::StreamRawPredict(
    google::cloud::aiplatform::v1::StreamRawPredictRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PredictionServiceConnection::StreamRawPredict");
  internal::OTelScope scope(span);
  auto sr = child_->StreamRawPredict(request);
  return internal::MakeTracedStreamRange<google::api::HttpBody>(std::move(span),
                                                                std::move(sr));
}
StatusOr<google::cloud::aiplatform::v1::DirectPredictResponse>
PredictionServiceTracingConnection::DirectPredict(
    google::cloud::aiplatform::v1::DirectPredictRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PredictionServiceConnection::DirectPredict");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DirectPredict(request));
}

StatusOr<google::cloud::aiplatform::v1::DirectRawPredictResponse>
PredictionServiceTracingConnection::DirectRawPredict(
    google::cloud::aiplatform::v1::DirectRawPredictRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PredictionServiceConnection::DirectRawPredict");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DirectRawPredict(request));
}

std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
    google::cloud::aiplatform::v1::StreamDirectPredictRequest,
    google::cloud::aiplatform::v1::StreamDirectPredictResponse>>
PredictionServiceTracingConnection::AsyncStreamDirectPredict() {
  return child_->AsyncStreamDirectPredict();
}

std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
    google::cloud::aiplatform::v1::StreamDirectRawPredictRequest,
    google::cloud::aiplatform::v1::StreamDirectRawPredictResponse>>
PredictionServiceTracingConnection::AsyncStreamDirectRawPredict() {
  return child_->AsyncStreamDirectRawPredict();
}

std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
    google::cloud::aiplatform::v1::StreamingPredictRequest,
    google::cloud::aiplatform::v1::StreamingPredictResponse>>
PredictionServiceTracingConnection::AsyncStreamingPredict() {
  return child_->AsyncStreamingPredict();
}

StreamRange<google::cloud::aiplatform::v1::StreamingPredictResponse>
PredictionServiceTracingConnection::ServerStreamingPredict(
    google::cloud::aiplatform::v1::StreamingPredictRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PredictionServiceConnection::ServerStreamingPredict");
  internal::OTelScope scope(span);
  auto sr = child_->ServerStreamingPredict(request);
  return internal::MakeTracedStreamRange<
      google::cloud::aiplatform::v1::StreamingPredictResponse>(std::move(span),
                                                               std::move(sr));
}
std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
    google::cloud::aiplatform::v1::StreamingRawPredictRequest,
    google::cloud::aiplatform::v1::StreamingRawPredictResponse>>
PredictionServiceTracingConnection::AsyncStreamingRawPredict() {
  return child_->AsyncStreamingRawPredict();
}

StatusOr<google::cloud::aiplatform::v1::ExplainResponse>
PredictionServiceTracingConnection::Explain(
    google::cloud::aiplatform::v1::ExplainRequest const& request) {
  auto span =
      internal::MakeSpan("aiplatform_v1::PredictionServiceConnection::Explain");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->Explain(request));
}

StatusOr<google::cloud::aiplatform::v1::GenerateContentResponse>
PredictionServiceTracingConnection::GenerateContent(
    google::cloud::aiplatform::v1::GenerateContentRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PredictionServiceConnection::GenerateContent");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GenerateContent(request));
}

StreamRange<google::cloud::aiplatform::v1::GenerateContentResponse>
PredictionServiceTracingConnection::StreamGenerateContent(
    google::cloud::aiplatform::v1::GenerateContentRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PredictionServiceConnection::StreamGenerateContent");
  internal::OTelScope scope(span);
  auto sr = child_->StreamGenerateContent(request);
  return internal::MakeTracedStreamRange<
      google::cloud::aiplatform::v1::GenerateContentResponse>(std::move(span),
                                                              std::move(sr));
}
StreamRange<google::cloud::location::Location>
PredictionServiceTracingConnection::ListLocations(
    google::cloud::location::ListLocationsRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PredictionServiceConnection::ListLocations");
  internal::OTelScope scope(span);
  auto sr = child_->ListLocations(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::location::Location>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::location::Location>
PredictionServiceTracingConnection::GetLocation(
    google::cloud::location::GetLocationRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PredictionServiceConnection::GetLocation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetLocation(request));
}

StatusOr<google::iam::v1::Policy>
PredictionServiceTracingConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PredictionServiceConnection::SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SetIamPolicy(request));
}

StatusOr<google::iam::v1::Policy>
PredictionServiceTracingConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PredictionServiceConnection::GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIamPolicy(request));
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
PredictionServiceTracingConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PredictionServiceConnection::TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TestIamPermissions(request));
}

StreamRange<google::longrunning::Operation>
PredictionServiceTracingConnection::ListOperations(
    google::longrunning::ListOperationsRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PredictionServiceConnection::ListOperations");
  internal::OTelScope scope(span);
  auto sr = child_->ListOperations(std::move(request));
  return internal::MakeTracedStreamRange<google::longrunning::Operation>(
      std::move(span), std::move(sr));
}

StatusOr<google::longrunning::Operation>
PredictionServiceTracingConnection::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PredictionServiceConnection::GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetOperation(request));
}

Status PredictionServiceTracingConnection::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PredictionServiceConnection::DeleteOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteOperation(request));
}

Status PredictionServiceTracingConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PredictionServiceConnection::CancelOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CancelOperation(request));
}

StatusOr<google::longrunning::Operation>
PredictionServiceTracingConnection::WaitOperation(
    google::longrunning::WaitOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PredictionServiceConnection::WaitOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->WaitOperation(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<aiplatform_v1::PredictionServiceConnection>
MakePredictionServiceTracingConnection(
    std::shared_ptr<aiplatform_v1::PredictionServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn =
        std::make_shared<PredictionServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google
