// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/prediction_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_PREDICTION_LOGGING_DECORATOR_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_PREDICTION_LOGGING_DECORATOR_H

#include "google/cloud/aiplatform/v1/internal/prediction_stub.h"
#include "google/cloud/tracing_options.h"
#include "google/cloud/version.h"
#include <memory>
#include <set>
#include <string>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class PredictionServiceLogging : public PredictionServiceStub {
 public:
  ~PredictionServiceLogging() override = default;
  PredictionServiceLogging(std::shared_ptr<PredictionServiceStub> child,
                           TracingOptions tracing_options,
                           std::set<std::string> const& components);

  StatusOr<google::cloud::aiplatform::v1::PredictResponse> Predict(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::PredictRequest const& request) override;

  StatusOr<google::api::HttpBody> RawPredict(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::RawPredictRequest const& request) override;

  std::unique_ptr<
      google::cloud::internal::StreamingReadRpc<google::api::HttpBody>>
  StreamRawPredict(std::shared_ptr<grpc::ClientContext> context,
                   Options const& options,
                   google::cloud::aiplatform::v1::StreamRawPredictRequest const&
                       request) override;

  StatusOr<google::cloud::aiplatform::v1::DirectPredictResponse> DirectPredict(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::DirectPredictRequest const& request)
      override;

  StatusOr<google::cloud::aiplatform::v1::DirectRawPredictResponse>
  DirectRawPredict(grpc::ClientContext& context, Options const& options,
                   google::cloud::aiplatform::v1::DirectRawPredictRequest const&
                       request) override;

  std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
      google::cloud::aiplatform::v1::StreamDirectPredictRequest,
      google::cloud::aiplatform::v1::StreamDirectPredictResponse>>
  AsyncStreamDirectPredict(
      google::cloud::CompletionQueue const& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options) override;

  std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
      google::cloud::aiplatform::v1::StreamDirectRawPredictRequest,
      google::cloud::aiplatform::v1::StreamDirectRawPredictResponse>>
  AsyncStreamDirectRawPredict(
      google::cloud::CompletionQueue const& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options) override;

  std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
      google::cloud::aiplatform::v1::StreamingPredictRequest,
      google::cloud::aiplatform::v1::StreamingPredictResponse>>
  AsyncStreamingPredict(
      google::cloud::CompletionQueue const& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options) override;

  std::unique_ptr<google::cloud::internal::StreamingReadRpc<
      google::cloud::aiplatform::v1::StreamingPredictResponse>>
  ServerStreamingPredict(
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::aiplatform::v1::StreamingPredictRequest const& request)
      override;

  std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
      google::cloud::aiplatform::v1::StreamingRawPredictRequest,
      google::cloud::aiplatform::v1::StreamingRawPredictResponse>>
  AsyncStreamingRawPredict(
      google::cloud::CompletionQueue const& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options) override;

  StatusOr<google::cloud::aiplatform::v1::ExplainResponse> Explain(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::ExplainRequest const& request) override;

  StatusOr<google::cloud::aiplatform::v1::GenerateContentResponse>
  GenerateContent(grpc::ClientContext& context, Options const& options,
                  google::cloud::aiplatform::v1::GenerateContentRequest const&
                      request) override;

  std::unique_ptr<google::cloud::internal::StreamingReadRpc<
      google::cloud::aiplatform::v1::GenerateContentResponse>>
  StreamGenerateContent(
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::aiplatform::v1::GenerateContentRequest const& request)
      override;

  StatusOr<google::cloud::location::ListLocationsResponse> ListLocations(
      grpc::ClientContext& context, Options const& options,
      google::cloud::location::ListLocationsRequest const& request) override;

  StatusOr<google::cloud::location::Location> GetLocation(
      grpc::ClientContext& context, Options const& options,
      google::cloud::location::GetLocationRequest const& request) override;

  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::SetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::GetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::TestIamPermissionsRequest const& request) override;

  StatusOr<google::longrunning::ListOperationsResponse> ListOperations(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::ListOperationsRequest const& request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::GetOperationRequest const& request) override;

  Status DeleteOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::DeleteOperationRequest const& request) override;

  Status CancelOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::CancelOperationRequest const& request) override;

  StatusOr<google::longrunning::Operation> WaitOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::WaitOperationRequest const& request) override;

 private:
  std::shared_ptr<PredictionServiceStub> child_;
  TracingOptions tracing_options_;
  bool stream_logging_;
};  // PredictionServiceLogging

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_PREDICTION_LOGGING_DECORATOR_H
