// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/prediction_service.proto

#include "google/cloud/aiplatform/v1/internal/prediction_connection_impl.h"
#include "google/cloud/aiplatform/v1/internal/prediction_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/resumable_streaming_read_rpc.h"
#include "google/cloud/internal/retry_loop.h"
#include "google/cloud/internal/streaming_read_rpc_logging.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<aiplatform_v1::PredictionServiceRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<aiplatform_v1::PredictionServiceRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<aiplatform_v1::PredictionServiceBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<aiplatform_v1::PredictionServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<aiplatform_v1::PredictionServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

void PredictionServiceStreamRawPredictStreamingUpdater(
    google::api::HttpBody const&,
    google::cloud::aiplatform::v1::StreamRawPredictRequest&) {}

void PredictionServiceServerStreamingPredictStreamingUpdater(
    google::cloud::aiplatform::v1::StreamingPredictResponse const&,
    google::cloud::aiplatform::v1::StreamingPredictRequest&) {}

void PredictionServiceStreamGenerateContentStreamingUpdater(
    google::cloud::aiplatform::v1::GenerateContentResponse const&,
    google::cloud::aiplatform::v1::GenerateContentRequest&) {}

PredictionServiceConnectionImpl::PredictionServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<aiplatform_v1_internal::PredictionServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), PredictionServiceConnection::options())) {}

StatusOr<google::cloud::aiplatform::v1::PredictResponse>
PredictionServiceConnectionImpl::Predict(
    google::cloud::aiplatform::v1::PredictRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->Predict(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::aiplatform::v1::PredictRequest const& request) {
        return stub_->Predict(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::api::HttpBody> PredictionServiceConnectionImpl::RawPredict(
    google::cloud::aiplatform::v1::RawPredictRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->RawPredict(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::aiplatform::v1::RawPredictRequest const& request) {
        return stub_->RawPredict(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::api::HttpBody>
PredictionServiceConnectionImpl::StreamRawPredict(
    google::cloud::aiplatform::v1::StreamRawPredictRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto factory =
      [stub = stub_,
       current](google::cloud::aiplatform::v1::StreamRawPredictRequest const&
                    request) {
        return stub->StreamRawPredict(std::make_shared<grpc::ClientContext>(),
                                      *current, request);
      };
  auto resumable = internal::MakeResumableStreamingReadRpc<
      google::api::HttpBody,
      google::cloud::aiplatform::v1::StreamRawPredictRequest>(
      retry_policy(*current), backoff_policy(*current), factory,
      PredictionServiceStreamRawPredictStreamingUpdater, request);
  return internal::MakeStreamRange(
      internal::StreamReader<google::api::HttpBody>(
          [resumable] { return resumable->Read(); }));
}

StatusOr<google::cloud::aiplatform::v1::DirectPredictResponse>
PredictionServiceConnectionImpl::DirectPredict(
    google::cloud::aiplatform::v1::DirectPredictRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DirectPredict(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::aiplatform::v1::DirectPredictRequest const& request) {
        return stub_->DirectPredict(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::aiplatform::v1::DirectRawPredictResponse>
PredictionServiceConnectionImpl::DirectRawPredict(
    google::cloud::aiplatform::v1::DirectRawPredictRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DirectRawPredict(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::aiplatform::v1::DirectRawPredictRequest const&
                 request) {
        return stub_->DirectRawPredict(context, options, request);
      },
      *current, request, __func__);
}

std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
    google::cloud::aiplatform::v1::StreamDirectPredictRequest,
    google::cloud::aiplatform::v1::StreamDirectPredictResponse>>
PredictionServiceConnectionImpl::AsyncStreamDirectPredict() {
  return stub_->AsyncStreamDirectPredict(
      background_->cq(), std::make_shared<grpc::ClientContext>(),
      internal::SaveCurrentOptions());
}

std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
    google::cloud::aiplatform::v1::StreamDirectRawPredictRequest,
    google::cloud::aiplatform::v1::StreamDirectRawPredictResponse>>
PredictionServiceConnectionImpl::AsyncStreamDirectRawPredict() {
  return stub_->AsyncStreamDirectRawPredict(
      background_->cq(), std::make_shared<grpc::ClientContext>(),
      internal::SaveCurrentOptions());
}

std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
    google::cloud::aiplatform::v1::StreamingPredictRequest,
    google::cloud::aiplatform::v1::StreamingPredictResponse>>
PredictionServiceConnectionImpl::AsyncStreamingPredict() {
  return stub_->AsyncStreamingPredict(background_->cq(),
                                      std::make_shared<grpc::ClientContext>(),
                                      internal::SaveCurrentOptions());
}

StreamRange<google::cloud::aiplatform::v1::StreamingPredictResponse>
PredictionServiceConnectionImpl::ServerStreamingPredict(
    google::cloud::aiplatform::v1::StreamingPredictRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto factory =
      [stub = stub_,
       current](google::cloud::aiplatform::v1::StreamingPredictRequest const&
                    request) {
        return stub->ServerStreamingPredict(
            std::make_shared<grpc::ClientContext>(), *current, request);
      };
  auto resumable = internal::MakeResumableStreamingReadRpc<
      google::cloud::aiplatform::v1::StreamingPredictResponse,
      google::cloud::aiplatform::v1::StreamingPredictRequest>(
      retry_policy(*current), backoff_policy(*current), factory,
      PredictionServiceServerStreamingPredictStreamingUpdater, request);
  return internal::MakeStreamRange(
      internal::StreamReader<
          google::cloud::aiplatform::v1::StreamingPredictResponse>(
          [resumable] { return resumable->Read(); }));
}

std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
    google::cloud::aiplatform::v1::StreamingRawPredictRequest,
    google::cloud::aiplatform::v1::StreamingRawPredictResponse>>
PredictionServiceConnectionImpl::AsyncStreamingRawPredict() {
  return stub_->AsyncStreamingRawPredict(
      background_->cq(), std::make_shared<grpc::ClientContext>(),
      internal::SaveCurrentOptions());
}

StatusOr<google::cloud::aiplatform::v1::ExplainResponse>
PredictionServiceConnectionImpl::Explain(
    google::cloud::aiplatform::v1::ExplainRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->Explain(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::aiplatform::v1::ExplainRequest const& request) {
        return stub_->Explain(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::aiplatform::v1::GenerateContentResponse>
PredictionServiceConnectionImpl::GenerateContent(
    google::cloud::aiplatform::v1::GenerateContentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GenerateContent(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::aiplatform::v1::GenerateContentRequest const&
                 request) {
        return stub_->GenerateContent(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::aiplatform::v1::GenerateContentResponse>
PredictionServiceConnectionImpl::StreamGenerateContent(
    google::cloud::aiplatform::v1::GenerateContentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto factory =
      [stub = stub_,
       current](google::cloud::aiplatform::v1::GenerateContentRequest const&
                    request) {
        return stub->StreamGenerateContent(
            std::make_shared<grpc::ClientContext>(), *current, request);
      };
  auto resumable = internal::MakeResumableStreamingReadRpc<
      google::cloud::aiplatform::v1::GenerateContentResponse,
      google::cloud::aiplatform::v1::GenerateContentRequest>(
      retry_policy(*current), backoff_policy(*current), factory,
      PredictionServiceStreamGenerateContentStreamingUpdater, request);
  return internal::MakeStreamRange(
      internal::StreamReader<
          google::cloud::aiplatform::v1::GenerateContentResponse>(
          [resumable] { return resumable->Read(); }));
}

StreamRange<google::cloud::location::Location>
PredictionServiceConnectionImpl::ListLocations(
    google::cloud::location::ListLocationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListLocations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::location::Location>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<aiplatform_v1::PredictionServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::location::ListLocationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::location::ListLocationsRequest const& request) {
              return stub->ListLocations(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::location::ListLocationsResponse r) {
        std::vector<google::cloud::location::Location> result(
            r.locations().size());
        auto& messages = *r.mutable_locations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::location::Location>
PredictionServiceConnectionImpl::GetLocation(
    google::cloud::location::GetLocationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetLocation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::location::GetLocationRequest const& request) {
        return stub_->GetLocation(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::iam::v1::Policy> PredictionServiceConnectionImpl::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->SetIamPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::SetIamPolicyRequest const& request) {
        return stub_->SetIamPolicy(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::iam::v1::Policy> PredictionServiceConnectionImpl::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetIamPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::GetIamPolicyRequest const& request) {
        return stub_->GetIamPolicy(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
PredictionServiceConnectionImpl::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->TestIamPermissions(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::TestIamPermissionsRequest const& request) {
        return stub_->TestIamPermissions(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::longrunning::Operation>
PredictionServiceConnectionImpl::ListOperations(
    google::longrunning::ListOperationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListOperations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::longrunning::Operation>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<aiplatform_v1::PredictionServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::longrunning::ListOperationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::longrunning::ListOperationsRequest const& request) {
              return stub->ListOperations(context, options, request);
            },
            options, r, function_name);
      },
      [](google::longrunning::ListOperationsResponse r) {
        std::vector<google::longrunning::Operation> result(
            r.operations().size());
        auto& messages = *r.mutable_operations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::longrunning::Operation>
PredictionServiceConnectionImpl::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetOperation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::GetOperationRequest const& request) {
        return stub_->GetOperation(context, options, request);
      },
      *current, request, __func__);
}

Status PredictionServiceConnectionImpl::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteOperation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::DeleteOperationRequest const& request) {
        return stub_->DeleteOperation(context, options, request);
      },
      *current, request, __func__);
}

Status PredictionServiceConnectionImpl::CancelOperation(
    google::longrunning::CancelOperationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CancelOperation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::CancelOperationRequest const& request) {
        return stub_->CancelOperation(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::longrunning::Operation>
PredictionServiceConnectionImpl::WaitOperation(
    google::longrunning::WaitOperationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->WaitOperation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::WaitOperationRequest const& request) {
        return stub_->WaitOperation(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google
