// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/persistent_resource_service.proto

#include "google/cloud/aiplatform/v1/internal/persistent_resource_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

PersistentResourceServiceTracingConnection::
    PersistentResourceServiceTracingConnection(
        std::shared_ptr<aiplatform_v1::PersistentResourceServiceConnection>
            child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::aiplatform::v1::PersistentResource>>
PersistentResourceServiceTracingConnection::CreatePersistentResource(
    google::cloud::aiplatform::v1::CreatePersistentResourceRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PersistentResourceServiceConnection::"
      "CreatePersistentResource");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreatePersistentResource(request));
}

StatusOr<google::longrunning::Operation>
PersistentResourceServiceTracingConnection::CreatePersistentResource(
    NoAwaitTag,
    google::cloud::aiplatform::v1::CreatePersistentResourceRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PersistentResourceServiceConnection::"
      "CreatePersistentResource");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->CreatePersistentResource(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::PersistentResource>>
PersistentResourceServiceTracingConnection::CreatePersistentResource(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PersistentResourceServiceConnection::"
      "CreatePersistentResource");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreatePersistentResource(operation));
}

StatusOr<google::cloud::aiplatform::v1::PersistentResource>
PersistentResourceServiceTracingConnection::GetPersistentResource(
    google::cloud::aiplatform::v1::GetPersistentResourceRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PersistentResourceServiceConnection::"
      "GetPersistentResource");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetPersistentResource(request));
}

StreamRange<google::cloud::aiplatform::v1::PersistentResource>
PersistentResourceServiceTracingConnection::ListPersistentResources(
    google::cloud::aiplatform::v1::ListPersistentResourcesRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PersistentResourceServiceConnection::"
      "ListPersistentResources");
  internal::OTelScope scope(span);
  auto sr = child_->ListPersistentResources(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::aiplatform::v1::PersistentResource>(std::move(span),
                                                         std::move(sr));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
PersistentResourceServiceTracingConnection::DeletePersistentResource(
    google::cloud::aiplatform::v1::DeletePersistentResourceRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PersistentResourceServiceConnection::"
      "DeletePersistentResource");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeletePersistentResource(request));
}

StatusOr<google::longrunning::Operation>
PersistentResourceServiceTracingConnection::DeletePersistentResource(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeletePersistentResourceRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PersistentResourceServiceConnection::"
      "DeletePersistentResource");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->DeletePersistentResource(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
PersistentResourceServiceTracingConnection::DeletePersistentResource(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PersistentResourceServiceConnection::"
      "DeletePersistentResource");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeletePersistentResource(operation));
}

future<StatusOr<google::cloud::aiplatform::v1::PersistentResource>>
PersistentResourceServiceTracingConnection::UpdatePersistentResource(
    google::cloud::aiplatform::v1::UpdatePersistentResourceRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PersistentResourceServiceConnection::"
      "UpdatePersistentResource");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdatePersistentResource(request));
}

StatusOr<google::longrunning::Operation>
PersistentResourceServiceTracingConnection::UpdatePersistentResource(
    NoAwaitTag,
    google::cloud::aiplatform::v1::UpdatePersistentResourceRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PersistentResourceServiceConnection::"
      "UpdatePersistentResource");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->UpdatePersistentResource(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::PersistentResource>>
PersistentResourceServiceTracingConnection::UpdatePersistentResource(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PersistentResourceServiceConnection::"
      "UpdatePersistentResource");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdatePersistentResource(operation));
}

future<StatusOr<google::cloud::aiplatform::v1::PersistentResource>>
PersistentResourceServiceTracingConnection::RebootPersistentResource(
    google::cloud::aiplatform::v1::RebootPersistentResourceRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PersistentResourceServiceConnection::"
      "RebootPersistentResource");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->RebootPersistentResource(request));
}

StatusOr<google::longrunning::Operation>
PersistentResourceServiceTracingConnection::RebootPersistentResource(
    NoAwaitTag,
    google::cloud::aiplatform::v1::RebootPersistentResourceRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PersistentResourceServiceConnection::"
      "RebootPersistentResource");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->RebootPersistentResource(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::PersistentResource>>
PersistentResourceServiceTracingConnection::RebootPersistentResource(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PersistentResourceServiceConnection::"
      "RebootPersistentResource");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->RebootPersistentResource(operation));
}

StreamRange<google::cloud::location::Location>
PersistentResourceServiceTracingConnection::ListLocations(
    google::cloud::location::ListLocationsRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PersistentResourceServiceConnection::ListLocations");
  internal::OTelScope scope(span);
  auto sr = child_->ListLocations(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::location::Location>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::location::Location>
PersistentResourceServiceTracingConnection::GetLocation(
    google::cloud::location::GetLocationRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PersistentResourceServiceConnection::GetLocation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetLocation(request));
}

StatusOr<google::iam::v1::Policy>
PersistentResourceServiceTracingConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PersistentResourceServiceConnection::SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SetIamPolicy(request));
}

StatusOr<google::iam::v1::Policy>
PersistentResourceServiceTracingConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PersistentResourceServiceConnection::GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIamPolicy(request));
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
PersistentResourceServiceTracingConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PersistentResourceServiceConnection::TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TestIamPermissions(request));
}

StreamRange<google::longrunning::Operation>
PersistentResourceServiceTracingConnection::ListOperations(
    google::longrunning::ListOperationsRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PersistentResourceServiceConnection::ListOperations");
  internal::OTelScope scope(span);
  auto sr = child_->ListOperations(std::move(request));
  return internal::MakeTracedStreamRange<google::longrunning::Operation>(
      std::move(span), std::move(sr));
}

StatusOr<google::longrunning::Operation>
PersistentResourceServiceTracingConnection::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PersistentResourceServiceConnection::GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetOperation(request));
}

Status PersistentResourceServiceTracingConnection::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PersistentResourceServiceConnection::DeleteOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteOperation(request));
}

Status PersistentResourceServiceTracingConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PersistentResourceServiceConnection::CancelOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CancelOperation(request));
}

StatusOr<google::longrunning::Operation>
PersistentResourceServiceTracingConnection::WaitOperation(
    google::longrunning::WaitOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::PersistentResourceServiceConnection::WaitOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->WaitOperation(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<aiplatform_v1::PersistentResourceServiceConnection>
MakePersistentResourceServiceTracingConnection(
    std::shared_ptr<aiplatform_v1::PersistentResourceServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<PersistentResourceServiceTracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google
