// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/notebook_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_NOTEBOOK_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_NOTEBOOK_TRACING_CONNECTION_H

#include "google/cloud/aiplatform/v1/notebook_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class NotebookServiceTracingConnection
    : public aiplatform_v1::NotebookServiceConnection {
 public:
  ~NotebookServiceTracingConnection() override = default;

  explicit NotebookServiceTracingConnection(
      std::shared_ptr<aiplatform_v1::NotebookServiceConnection> child);

  Options options() override { return child_->options(); }

  future<StatusOr<google::cloud::aiplatform::v1::NotebookRuntimeTemplate>>
  CreateNotebookRuntimeTemplate(
      google::cloud::aiplatform::v1::CreateNotebookRuntimeTemplateRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> CreateNotebookRuntimeTemplate(
      NoAwaitTag,
      google::cloud::aiplatform::v1::CreateNotebookRuntimeTemplateRequest const&
          request) override;

  future<StatusOr<google::cloud::aiplatform::v1::NotebookRuntimeTemplate>>
  CreateNotebookRuntimeTemplate(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::aiplatform::v1::NotebookRuntimeTemplate>
  GetNotebookRuntimeTemplate(
      google::cloud::aiplatform::v1::GetNotebookRuntimeTemplateRequest const&
          request) override;

  StreamRange<google::cloud::aiplatform::v1::NotebookRuntimeTemplate>
  ListNotebookRuntimeTemplates(
      google::cloud::aiplatform::v1::ListNotebookRuntimeTemplatesRequest
          request) override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteNotebookRuntimeTemplate(
      google::cloud::aiplatform::v1::DeleteNotebookRuntimeTemplateRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteNotebookRuntimeTemplate(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteNotebookRuntimeTemplateRequest const&
          request) override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteNotebookRuntimeTemplate(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::aiplatform::v1::NotebookRuntimeTemplate>
  UpdateNotebookRuntimeTemplate(
      google::cloud::aiplatform::v1::UpdateNotebookRuntimeTemplateRequest const&
          request) override;

  future<StatusOr<google::cloud::aiplatform::v1::NotebookRuntime>>
  AssignNotebookRuntime(
      google::cloud::aiplatform::v1::AssignNotebookRuntimeRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> AssignNotebookRuntime(
      NoAwaitTag,
      google::cloud::aiplatform::v1::AssignNotebookRuntimeRequest const&
          request) override;

  future<StatusOr<google::cloud::aiplatform::v1::NotebookRuntime>>
  AssignNotebookRuntime(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::aiplatform::v1::NotebookRuntime> GetNotebookRuntime(
      google::cloud::aiplatform::v1::GetNotebookRuntimeRequest const& request)
      override;

  StreamRange<google::cloud::aiplatform::v1::NotebookRuntime>
  ListNotebookRuntimes(
      google::cloud::aiplatform::v1::ListNotebookRuntimesRequest request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteNotebookRuntime(
      google::cloud::aiplatform::v1::DeleteNotebookRuntimeRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteNotebookRuntime(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteNotebookRuntimeRequest const&
          request) override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteNotebookRuntime(
      google::longrunning::Operation const& operation) override;

  future<
      StatusOr<google::cloud::aiplatform::v1::UpgradeNotebookRuntimeResponse>>
  UpgradeNotebookRuntime(
      google::cloud::aiplatform::v1::UpgradeNotebookRuntimeRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> UpgradeNotebookRuntime(
      NoAwaitTag,
      google::cloud::aiplatform::v1::UpgradeNotebookRuntimeRequest const&
          request) override;

  future<
      StatusOr<google::cloud::aiplatform::v1::UpgradeNotebookRuntimeResponse>>
  UpgradeNotebookRuntime(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::aiplatform::v1::StartNotebookRuntimeResponse>>
  StartNotebookRuntime(
      google::cloud::aiplatform::v1::StartNotebookRuntimeRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> StartNotebookRuntime(
      NoAwaitTag,
      google::cloud::aiplatform::v1::StartNotebookRuntimeRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::StartNotebookRuntimeResponse>>
  StartNotebookRuntime(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::aiplatform::v1::StopNotebookRuntimeResponse>>
  StopNotebookRuntime(
      google::cloud::aiplatform::v1::StopNotebookRuntimeRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> StopNotebookRuntime(
      NoAwaitTag,
      google::cloud::aiplatform::v1::StopNotebookRuntimeRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::StopNotebookRuntimeResponse>>
  StopNotebookRuntime(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::aiplatform::v1::NotebookExecutionJob>>
  CreateNotebookExecutionJob(
      google::cloud::aiplatform::v1::CreateNotebookExecutionJobRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> CreateNotebookExecutionJob(
      NoAwaitTag,
      google::cloud::aiplatform::v1::CreateNotebookExecutionJobRequest const&
          request) override;

  future<StatusOr<google::cloud::aiplatform::v1::NotebookExecutionJob>>
  CreateNotebookExecutionJob(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::aiplatform::v1::NotebookExecutionJob>
  GetNotebookExecutionJob(
      google::cloud::aiplatform::v1::GetNotebookExecutionJobRequest const&
          request) override;

  StreamRange<google::cloud::aiplatform::v1::NotebookExecutionJob>
  ListNotebookExecutionJobs(
      google::cloud::aiplatform::v1::ListNotebookExecutionJobsRequest request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteNotebookExecutionJob(
      google::cloud::aiplatform::v1::DeleteNotebookExecutionJobRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteNotebookExecutionJob(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteNotebookExecutionJobRequest const&
          request) override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteNotebookExecutionJob(
      google::longrunning::Operation const& operation) override;

  StreamRange<google::cloud::location::Location> ListLocations(
      google::cloud::location::ListLocationsRequest request) override;

  StatusOr<google::cloud::location::Location> GetLocation(
      google::cloud::location::GetLocationRequest const& request) override;

  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request) override;

  StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request) override;

  Status DeleteOperation(
      google::longrunning::DeleteOperationRequest const& request) override;

  Status CancelOperation(
      google::longrunning::CancelOperationRequest const& request) override;

  StatusOr<google::longrunning::Operation> WaitOperation(
      google::longrunning::WaitOperationRequest const& request) override;

 private:
  std::shared_ptr<aiplatform_v1::NotebookServiceConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<aiplatform_v1::NotebookServiceConnection>
MakeNotebookServiceTracingConnection(
    std::shared_ptr<aiplatform_v1::NotebookServiceConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_NOTEBOOK_TRACING_CONNECTION_H
