// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/notebook_service.proto

#include "google/cloud/aiplatform/v1/internal/notebook_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

NotebookServiceTracingConnection::NotebookServiceTracingConnection(
    std::shared_ptr<aiplatform_v1::NotebookServiceConnection> child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::aiplatform::v1::NotebookRuntimeTemplate>>
NotebookServiceTracingConnection::CreateNotebookRuntimeTemplate(
    google::cloud::aiplatform::v1::CreateNotebookRuntimeTemplateRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::"
      "CreateNotebookRuntimeTemplate");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateNotebookRuntimeTemplate(request));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingConnection::CreateNotebookRuntimeTemplate(
    NoAwaitTag,
    google::cloud::aiplatform::v1::CreateNotebookRuntimeTemplateRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::"
      "CreateNotebookRuntimeTemplate");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->CreateNotebookRuntimeTemplate(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::NotebookRuntimeTemplate>>
NotebookServiceTracingConnection::CreateNotebookRuntimeTemplate(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::"
      "CreateNotebookRuntimeTemplate");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateNotebookRuntimeTemplate(operation));
}

StatusOr<google::cloud::aiplatform::v1::NotebookRuntimeTemplate>
NotebookServiceTracingConnection::GetNotebookRuntimeTemplate(
    google::cloud::aiplatform::v1::GetNotebookRuntimeTemplateRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::GetNotebookRuntimeTemplate");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetNotebookRuntimeTemplate(request));
}

StreamRange<google::cloud::aiplatform::v1::NotebookRuntimeTemplate>
NotebookServiceTracingConnection::ListNotebookRuntimeTemplates(
    google::cloud::aiplatform::v1::ListNotebookRuntimeTemplatesRequest
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::ListNotebookRuntimeTemplates");
  internal::OTelScope scope(span);
  auto sr = child_->ListNotebookRuntimeTemplates(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::aiplatform::v1::NotebookRuntimeTemplate>(std::move(span),
                                                              std::move(sr));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
NotebookServiceTracingConnection::DeleteNotebookRuntimeTemplate(
    google::cloud::aiplatform::v1::DeleteNotebookRuntimeTemplateRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::"
      "DeleteNotebookRuntimeTemplate");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteNotebookRuntimeTemplate(request));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingConnection::DeleteNotebookRuntimeTemplate(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteNotebookRuntimeTemplateRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::"
      "DeleteNotebookRuntimeTemplate");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->DeleteNotebookRuntimeTemplate(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
NotebookServiceTracingConnection::DeleteNotebookRuntimeTemplate(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::"
      "DeleteNotebookRuntimeTemplate");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteNotebookRuntimeTemplate(operation));
}

StatusOr<google::cloud::aiplatform::v1::NotebookRuntimeTemplate>
NotebookServiceTracingConnection::UpdateNotebookRuntimeTemplate(
    google::cloud::aiplatform::v1::UpdateNotebookRuntimeTemplateRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::"
      "UpdateNotebookRuntimeTemplate");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateNotebookRuntimeTemplate(request));
}

future<StatusOr<google::cloud::aiplatform::v1::NotebookRuntime>>
NotebookServiceTracingConnection::AssignNotebookRuntime(
    google::cloud::aiplatform::v1::AssignNotebookRuntimeRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::AssignNotebookRuntime");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->AssignNotebookRuntime(request));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingConnection::AssignNotebookRuntime(
    NoAwaitTag,
    google::cloud::aiplatform::v1::AssignNotebookRuntimeRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::AssignNotebookRuntime");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->AssignNotebookRuntime(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::NotebookRuntime>>
NotebookServiceTracingConnection::AssignNotebookRuntime(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::AssignNotebookRuntime");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->AssignNotebookRuntime(operation));
}

StatusOr<google::cloud::aiplatform::v1::NotebookRuntime>
NotebookServiceTracingConnection::GetNotebookRuntime(
    google::cloud::aiplatform::v1::GetNotebookRuntimeRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::GetNotebookRuntime");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetNotebookRuntime(request));
}

StreamRange<google::cloud::aiplatform::v1::NotebookRuntime>
NotebookServiceTracingConnection::ListNotebookRuntimes(
    google::cloud::aiplatform::v1::ListNotebookRuntimesRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::ListNotebookRuntimes");
  internal::OTelScope scope(span);
  auto sr = child_->ListNotebookRuntimes(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::aiplatform::v1::NotebookRuntime>(std::move(span),
                                                      std::move(sr));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
NotebookServiceTracingConnection::DeleteNotebookRuntime(
    google::cloud::aiplatform::v1::DeleteNotebookRuntimeRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::DeleteNotebookRuntime");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteNotebookRuntime(request));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingConnection::DeleteNotebookRuntime(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteNotebookRuntimeRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::DeleteNotebookRuntime");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->DeleteNotebookRuntime(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
NotebookServiceTracingConnection::DeleteNotebookRuntime(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::DeleteNotebookRuntime");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteNotebookRuntime(operation));
}

future<StatusOr<google::cloud::aiplatform::v1::UpgradeNotebookRuntimeResponse>>
NotebookServiceTracingConnection::UpgradeNotebookRuntime(
    google::cloud::aiplatform::v1::UpgradeNotebookRuntimeRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::UpgradeNotebookRuntime");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpgradeNotebookRuntime(request));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingConnection::UpgradeNotebookRuntime(
    NoAwaitTag,
    google::cloud::aiplatform::v1::UpgradeNotebookRuntimeRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::UpgradeNotebookRuntime");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->UpgradeNotebookRuntime(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::UpgradeNotebookRuntimeResponse>>
NotebookServiceTracingConnection::UpgradeNotebookRuntime(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::UpgradeNotebookRuntime");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpgradeNotebookRuntime(operation));
}

future<StatusOr<google::cloud::aiplatform::v1::StartNotebookRuntimeResponse>>
NotebookServiceTracingConnection::StartNotebookRuntime(
    google::cloud::aiplatform::v1::StartNotebookRuntimeRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::StartNotebookRuntime");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->StartNotebookRuntime(request));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingConnection::StartNotebookRuntime(
    NoAwaitTag,
    google::cloud::aiplatform::v1::StartNotebookRuntimeRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::StartNotebookRuntime");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->StartNotebookRuntime(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::StartNotebookRuntimeResponse>>
NotebookServiceTracingConnection::StartNotebookRuntime(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::StartNotebookRuntime");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->StartNotebookRuntime(operation));
}

future<StatusOr<google::cloud::aiplatform::v1::StopNotebookRuntimeResponse>>
NotebookServiceTracingConnection::StopNotebookRuntime(
    google::cloud::aiplatform::v1::StopNotebookRuntimeRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::StopNotebookRuntime");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->StopNotebookRuntime(request));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingConnection::StopNotebookRuntime(
    NoAwaitTag,
    google::cloud::aiplatform::v1::StopNotebookRuntimeRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::StopNotebookRuntime");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->StopNotebookRuntime(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::StopNotebookRuntimeResponse>>
NotebookServiceTracingConnection::StopNotebookRuntime(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::StopNotebookRuntime");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->StopNotebookRuntime(operation));
}

future<StatusOr<google::cloud::aiplatform::v1::NotebookExecutionJob>>
NotebookServiceTracingConnection::CreateNotebookExecutionJob(
    google::cloud::aiplatform::v1::CreateNotebookExecutionJobRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::CreateNotebookExecutionJob");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateNotebookExecutionJob(request));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingConnection::CreateNotebookExecutionJob(
    NoAwaitTag,
    google::cloud::aiplatform::v1::CreateNotebookExecutionJobRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::CreateNotebookExecutionJob");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->CreateNotebookExecutionJob(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::NotebookExecutionJob>>
NotebookServiceTracingConnection::CreateNotebookExecutionJob(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::CreateNotebookExecutionJob");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateNotebookExecutionJob(operation));
}

StatusOr<google::cloud::aiplatform::v1::NotebookExecutionJob>
NotebookServiceTracingConnection::GetNotebookExecutionJob(
    google::cloud::aiplatform::v1::GetNotebookExecutionJobRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::GetNotebookExecutionJob");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetNotebookExecutionJob(request));
}

StreamRange<google::cloud::aiplatform::v1::NotebookExecutionJob>
NotebookServiceTracingConnection::ListNotebookExecutionJobs(
    google::cloud::aiplatform::v1::ListNotebookExecutionJobsRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::ListNotebookExecutionJobs");
  internal::OTelScope scope(span);
  auto sr = child_->ListNotebookExecutionJobs(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::aiplatform::v1::NotebookExecutionJob>(std::move(span),
                                                           std::move(sr));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
NotebookServiceTracingConnection::DeleteNotebookExecutionJob(
    google::cloud::aiplatform::v1::DeleteNotebookExecutionJobRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::DeleteNotebookExecutionJob");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteNotebookExecutionJob(request));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingConnection::DeleteNotebookExecutionJob(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteNotebookExecutionJobRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::DeleteNotebookExecutionJob");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->DeleteNotebookExecutionJob(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
NotebookServiceTracingConnection::DeleteNotebookExecutionJob(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::DeleteNotebookExecutionJob");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteNotebookExecutionJob(operation));
}

StreamRange<google::cloud::location::Location>
NotebookServiceTracingConnection::ListLocations(
    google::cloud::location::ListLocationsRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::ListLocations");
  internal::OTelScope scope(span);
  auto sr = child_->ListLocations(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::location::Location>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::location::Location>
NotebookServiceTracingConnection::GetLocation(
    google::cloud::location::GetLocationRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::GetLocation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetLocation(request));
}

StatusOr<google::iam::v1::Policy>
NotebookServiceTracingConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SetIamPolicy(request));
}

StatusOr<google::iam::v1::Policy>
NotebookServiceTracingConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIamPolicy(request));
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
NotebookServiceTracingConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TestIamPermissions(request));
}

StreamRange<google::longrunning::Operation>
NotebookServiceTracingConnection::ListOperations(
    google::longrunning::ListOperationsRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::ListOperations");
  internal::OTelScope scope(span);
  auto sr = child_->ListOperations(std::move(request));
  return internal::MakeTracedStreamRange<google::longrunning::Operation>(
      std::move(span), std::move(sr));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingConnection::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetOperation(request));
}

Status NotebookServiceTracingConnection::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::DeleteOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteOperation(request));
}

Status NotebookServiceTracingConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::CancelOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CancelOperation(request));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingConnection::WaitOperation(
    google::longrunning::WaitOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::NotebookServiceConnection::WaitOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->WaitOperation(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<aiplatform_v1::NotebookServiceConnection>
MakeNotebookServiceTracingConnection(
    std::shared_ptr<aiplatform_v1::NotebookServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<NotebookServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google
