// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/metadata_service.proto

#include "google/cloud/aiplatform/v1/internal/metadata_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/aiplatform/v1/metadata_service.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

MetadataServiceMetadata::MetadataServiceMetadata(
    std::shared_ptr<MetadataServiceStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

future<StatusOr<google::longrunning::Operation>>
MetadataServiceMetadata::AsyncCreateMetadataStore(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::aiplatform::v1::CreateMetadataStoreRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateMetadataStore(cq, std::move(context),
                                          std::move(options), request);
}

StatusOr<google::longrunning::Operation>
MetadataServiceMetadata::CreateMetadataStore(
    grpc::ClientContext& context, Options options,
    google::cloud::aiplatform::v1::CreateMetadataStoreRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateMetadataStore(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::MetadataStore>
MetadataServiceMetadata::GetMetadataStore(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::GetMetadataStoreRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetMetadataStore(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::ListMetadataStoresResponse>
MetadataServiceMetadata::ListMetadataStores(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::ListMetadataStoresRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListMetadataStores(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
MetadataServiceMetadata::AsyncDeleteMetadataStore(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::aiplatform::v1::DeleteMetadataStoreRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteMetadataStore(cq, std::move(context),
                                          std::move(options), request);
}

StatusOr<google::longrunning::Operation>
MetadataServiceMetadata::DeleteMetadataStore(
    grpc::ClientContext& context, Options options,
    google::cloud::aiplatform::v1::DeleteMetadataStoreRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteMetadataStore(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::Artifact>
MetadataServiceMetadata::CreateArtifact(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::CreateArtifactRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateArtifact(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::Artifact>
MetadataServiceMetadata::GetArtifact(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::GetArtifactRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetArtifact(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::ListArtifactsResponse>
MetadataServiceMetadata::ListArtifacts(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::ListArtifactsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListArtifacts(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::Artifact>
MetadataServiceMetadata::UpdateArtifact(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::UpdateArtifactRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("artifact.name=",
                           internal::UrlEncode(request.artifact().name())));
  return child_->UpdateArtifact(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
MetadataServiceMetadata::AsyncDeleteArtifact(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::aiplatform::v1::DeleteArtifactRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteArtifact(cq, std::move(context), std::move(options),
                                     request);
}

StatusOr<google::longrunning::Operation>
MetadataServiceMetadata::DeleteArtifact(
    grpc::ClientContext& context, Options options,
    google::cloud::aiplatform::v1::DeleteArtifactRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteArtifact(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
MetadataServiceMetadata::AsyncPurgeArtifacts(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::aiplatform::v1::PurgeArtifactsRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncPurgeArtifacts(cq, std::move(context), std::move(options),
                                     request);
}

StatusOr<google::longrunning::Operation>
MetadataServiceMetadata::PurgeArtifacts(
    grpc::ClientContext& context, Options options,
    google::cloud::aiplatform::v1::PurgeArtifactsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->PurgeArtifacts(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::Context>
MetadataServiceMetadata::CreateContext(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::CreateContextRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateContext(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::Context>
MetadataServiceMetadata::GetContext(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::GetContextRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetContext(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::ListContextsResponse>
MetadataServiceMetadata::ListContexts(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::ListContextsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListContexts(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::Context>
MetadataServiceMetadata::UpdateContext(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::UpdateContextRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("context.name=",
                           internal::UrlEncode(request.context().name())));
  return child_->UpdateContext(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
MetadataServiceMetadata::AsyncDeleteContext(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::aiplatform::v1::DeleteContextRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteContext(cq, std::move(context), std::move(options),
                                    request);
}

StatusOr<google::longrunning::Operation> MetadataServiceMetadata::DeleteContext(
    grpc::ClientContext& context, Options options,
    google::cloud::aiplatform::v1::DeleteContextRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteContext(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
MetadataServiceMetadata::AsyncPurgeContexts(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::aiplatform::v1::PurgeContextsRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncPurgeContexts(cq, std::move(context), std::move(options),
                                    request);
}

StatusOr<google::longrunning::Operation> MetadataServiceMetadata::PurgeContexts(
    grpc::ClientContext& context, Options options,
    google::cloud::aiplatform::v1::PurgeContextsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->PurgeContexts(context, options, request);
}

StatusOr<
    google::cloud::aiplatform::v1::AddContextArtifactsAndExecutionsResponse>
MetadataServiceMetadata::AddContextArtifactsAndExecutions(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::
        AddContextArtifactsAndExecutionsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("context=", internal::UrlEncode(request.context())));
  return child_->AddContextArtifactsAndExecutions(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::AddContextChildrenResponse>
MetadataServiceMetadata::AddContextChildren(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::AddContextChildrenRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("context=", internal::UrlEncode(request.context())));
  return child_->AddContextChildren(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::RemoveContextChildrenResponse>
MetadataServiceMetadata::RemoveContextChildren(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::RemoveContextChildrenRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("context=", internal::UrlEncode(request.context())));
  return child_->RemoveContextChildren(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::LineageSubgraph>
MetadataServiceMetadata::QueryContextLineageSubgraph(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::QueryContextLineageSubgraphRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("context=", internal::UrlEncode(request.context())));
  return child_->QueryContextLineageSubgraph(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::Execution>
MetadataServiceMetadata::CreateExecution(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::CreateExecutionRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateExecution(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::Execution>
MetadataServiceMetadata::GetExecution(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::GetExecutionRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetExecution(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::ListExecutionsResponse>
MetadataServiceMetadata::ListExecutions(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::ListExecutionsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListExecutions(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::Execution>
MetadataServiceMetadata::UpdateExecution(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::UpdateExecutionRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("execution.name=",
                           internal::UrlEncode(request.execution().name())));
  return child_->UpdateExecution(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
MetadataServiceMetadata::AsyncDeleteExecution(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::aiplatform::v1::DeleteExecutionRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteExecution(cq, std::move(context),
                                      std::move(options), request);
}

StatusOr<google::longrunning::Operation>
MetadataServiceMetadata::DeleteExecution(
    grpc::ClientContext& context, Options options,
    google::cloud::aiplatform::v1::DeleteExecutionRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteExecution(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
MetadataServiceMetadata::AsyncPurgeExecutions(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::aiplatform::v1::PurgeExecutionsRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncPurgeExecutions(cq, std::move(context),
                                      std::move(options), request);
}

StatusOr<google::longrunning::Operation>
MetadataServiceMetadata::PurgeExecutions(
    grpc::ClientContext& context, Options options,
    google::cloud::aiplatform::v1::PurgeExecutionsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->PurgeExecutions(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::AddExecutionEventsResponse>
MetadataServiceMetadata::AddExecutionEvents(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::AddExecutionEventsRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("execution=", internal::UrlEncode(request.execution())));
  return child_->AddExecutionEvents(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::LineageSubgraph>
MetadataServiceMetadata::QueryExecutionInputsAndOutputs(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::QueryExecutionInputsAndOutputsRequest const&
        request) {
  SetMetadata(
      context, options,
      absl::StrCat("execution=", internal::UrlEncode(request.execution())));
  return child_->QueryExecutionInputsAndOutputs(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::MetadataSchema>
MetadataServiceMetadata::CreateMetadataSchema(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::CreateMetadataSchemaRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateMetadataSchema(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::MetadataSchema>
MetadataServiceMetadata::GetMetadataSchema(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::GetMetadataSchemaRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetMetadataSchema(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::ListMetadataSchemasResponse>
MetadataServiceMetadata::ListMetadataSchemas(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::ListMetadataSchemasRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListMetadataSchemas(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::LineageSubgraph>
MetadataServiceMetadata::QueryArtifactLineageSubgraph(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::QueryArtifactLineageSubgraphRequest const&
        request) {
  SetMetadata(
      context, options,
      absl::StrCat("artifact=", internal::UrlEncode(request.artifact())));
  return child_->QueryArtifactLineageSubgraph(context, options, request);
}

StatusOr<google::cloud::location::ListLocationsResponse>
MetadataServiceMetadata::ListLocations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::ListLocationsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->ListLocations(context, options, request);
}

StatusOr<google::cloud::location::Location>
MetadataServiceMetadata::GetLocation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::GetLocationRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetLocation(context, options, request);
}

StatusOr<google::iam::v1::Policy> MetadataServiceMetadata::SetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::SetIamPolicyRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->SetIamPolicy(context, options, request);
}

StatusOr<google::iam::v1::Policy> MetadataServiceMetadata::GetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::GetIamPolicyRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->GetIamPolicy(context, options, request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
MetadataServiceMetadata::TestIamPermissions(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->TestIamPermissions(context, options, request);
}

StatusOr<google::longrunning::ListOperationsResponse>
MetadataServiceMetadata::ListOperations(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::ListOperationsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->ListOperations(context, options, request);
}

StatusOr<google::longrunning::Operation> MetadataServiceMetadata::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetOperation(context, options, request);
}

Status MetadataServiceMetadata::DeleteOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::DeleteOperationRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteOperation(context, options, request);
}

Status MetadataServiceMetadata::CancelOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->CancelOperation(context, options, request);
}

StatusOr<google::longrunning::Operation> MetadataServiceMetadata::WaitOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::WaitOperationRequest const& request) {
  SetMetadata(context, options);
  return child_->WaitOperation(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
MetadataServiceMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncGetOperation(cq, std::move(context), std::move(options),
                                   request);
}

future<Status> MetadataServiceMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncCancelOperation(cq, std::move(context),
                                      std::move(options), request);
}

void MetadataServiceMetadata::SetMetadata(grpc::ClientContext& context,
                                          Options const& options,
                                          std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void MetadataServiceMetadata::SetMetadata(grpc::ClientContext& context,
                                          Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google
