// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/featurestore_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_FEATURESTORE_METADATA_DECORATOR_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_FEATURESTORE_METADATA_DECORATOR_H

#include "google/cloud/aiplatform/v1/internal/featurestore_stub.h"
#include "google/cloud/options.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class FeaturestoreServiceMetadata : public FeaturestoreServiceStub {
 public:
  ~FeaturestoreServiceMetadata() override = default;
  FeaturestoreServiceMetadata(
      std::shared_ptr<FeaturestoreServiceStub> child,
      std::multimap<std::string, std::string> fixed_metadata,
      std::string api_client_header = "");

  future<StatusOr<google::longrunning::Operation>> AsyncCreateFeaturestore(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::CreateFeaturestoreRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateFeaturestore(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::CreateFeaturestoreRequest const& request)
      override;

  StatusOr<google::cloud::aiplatform::v1::Featurestore> GetFeaturestore(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::GetFeaturestoreRequest const& request)
      override;

  StatusOr<google::cloud::aiplatform::v1::ListFeaturestoresResponse>
  ListFeaturestores(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::ListFeaturestoresRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncUpdateFeaturestore(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::UpdateFeaturestoreRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateFeaturestore(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::UpdateFeaturestoreRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteFeaturestore(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::DeleteFeaturestoreRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteFeaturestore(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::DeleteFeaturestoreRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateEntityType(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::CreateEntityTypeRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateEntityType(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::CreateEntityTypeRequest const& request)
      override;

  StatusOr<google::cloud::aiplatform::v1::EntityType> GetEntityType(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::GetEntityTypeRequest const& request)
      override;

  StatusOr<google::cloud::aiplatform::v1::ListEntityTypesResponse>
  ListEntityTypes(grpc::ClientContext& context, Options const& options,
                  google::cloud::aiplatform::v1::ListEntityTypesRequest const&
                      request) override;

  StatusOr<google::cloud::aiplatform::v1::EntityType> UpdateEntityType(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::UpdateEntityTypeRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteEntityType(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::DeleteEntityTypeRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteEntityType(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::DeleteEntityTypeRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateFeature(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::CreateFeatureRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateFeature(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::CreateFeatureRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncBatchCreateFeatures(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::BatchCreateFeaturesRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> BatchCreateFeatures(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::BatchCreateFeaturesRequest const& request)
      override;

  StatusOr<google::cloud::aiplatform::v1::Feature> GetFeature(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::GetFeatureRequest const& request) override;

  StatusOr<google::cloud::aiplatform::v1::ListFeaturesResponse> ListFeatures(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::ListFeaturesRequest const& request)
      override;

  StatusOr<google::cloud::aiplatform::v1::Feature> UpdateFeature(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::UpdateFeatureRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteFeature(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::DeleteFeatureRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteFeature(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::DeleteFeatureRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncImportFeatureValues(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::ImportFeatureValuesRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> ImportFeatureValues(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::ImportFeatureValuesRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncBatchReadFeatureValues(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::BatchReadFeatureValuesRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> BatchReadFeatureValues(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::BatchReadFeatureValuesRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncExportFeatureValues(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::ExportFeatureValuesRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> ExportFeatureValues(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::ExportFeatureValuesRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteFeatureValues(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::DeleteFeatureValuesRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteFeatureValues(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::DeleteFeatureValuesRequest const& request)
      override;

  StatusOr<google::cloud::aiplatform::v1::SearchFeaturesResponse>
  SearchFeatures(grpc::ClientContext& context, Options const& options,
                 google::cloud::aiplatform::v1::SearchFeaturesRequest const&
                     request) override;

  StatusOr<google::cloud::location::ListLocationsResponse> ListLocations(
      grpc::ClientContext& context, Options const& options,
      google::cloud::location::ListLocationsRequest const& request) override;

  StatusOr<google::cloud::location::Location> GetLocation(
      grpc::ClientContext& context, Options const& options,
      google::cloud::location::GetLocationRequest const& request) override;

  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::SetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::GetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::TestIamPermissionsRequest const& request) override;

  StatusOr<google::longrunning::ListOperationsResponse> ListOperations(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::ListOperationsRequest const& request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::GetOperationRequest const& request) override;

  Status DeleteOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::DeleteOperationRequest const& request) override;

  Status CancelOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::CancelOperationRequest const& request) override;

  StatusOr<google::longrunning::Operation> WaitOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::WaitOperationRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::GetOperationRequest const& request) override;

  future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  void SetMetadata(grpc::ClientContext& context, Options const& options,
                   std::string const& request_params);
  void SetMetadata(grpc::ClientContext& context, Options const& options);

  std::shared_ptr<FeaturestoreServiceStub> child_;
  std::multimap<std::string, std::string> fixed_metadata_;
  std::string api_client_header_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_FEATURESTORE_METADATA_DECORATOR_H
