// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/deployment_resource_pool_service.proto

#include "google/cloud/aiplatform/v1/internal/deployment_resource_pool_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

DeploymentResourcePoolServiceTracingConnection::
    DeploymentResourcePoolServiceTracingConnection(
        std::shared_ptr<aiplatform_v1::DeploymentResourcePoolServiceConnection>
            child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::aiplatform::v1::DeploymentResourcePool>>
DeploymentResourcePoolServiceTracingConnection::CreateDeploymentResourcePool(
    google::cloud::aiplatform::v1::CreateDeploymentResourcePoolRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::DeploymentResourcePoolServiceConnection::"
      "CreateDeploymentResourcePool");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateDeploymentResourcePool(request));
}

StatusOr<google::longrunning::Operation>
DeploymentResourcePoolServiceTracingConnection::CreateDeploymentResourcePool(
    NoAwaitTag,
    google::cloud::aiplatform::v1::CreateDeploymentResourcePoolRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::DeploymentResourcePoolServiceConnection::"
      "CreateDeploymentResourcePool");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->CreateDeploymentResourcePool(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeploymentResourcePool>>
DeploymentResourcePoolServiceTracingConnection::CreateDeploymentResourcePool(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::DeploymentResourcePoolServiceConnection::"
      "CreateDeploymentResourcePool");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateDeploymentResourcePool(operation));
}

StatusOr<google::cloud::aiplatform::v1::DeploymentResourcePool>
DeploymentResourcePoolServiceTracingConnection::GetDeploymentResourcePool(
    google::cloud::aiplatform::v1::GetDeploymentResourcePoolRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::DeploymentResourcePoolServiceConnection::"
      "GetDeploymentResourcePool");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetDeploymentResourcePool(request));
}

StreamRange<google::cloud::aiplatform::v1::DeploymentResourcePool>
DeploymentResourcePoolServiceTracingConnection::ListDeploymentResourcePools(
    google::cloud::aiplatform::v1::ListDeploymentResourcePoolsRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::DeploymentResourcePoolServiceConnection::"
      "ListDeploymentResourcePools");
  internal::OTelScope scope(span);
  auto sr = child_->ListDeploymentResourcePools(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::aiplatform::v1::DeploymentResourcePool>(std::move(span),
                                                             std::move(sr));
}

future<StatusOr<google::cloud::aiplatform::v1::DeploymentResourcePool>>
DeploymentResourcePoolServiceTracingConnection::UpdateDeploymentResourcePool(
    google::cloud::aiplatform::v1::UpdateDeploymentResourcePoolRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::DeploymentResourcePoolServiceConnection::"
      "UpdateDeploymentResourcePool");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateDeploymentResourcePool(request));
}

StatusOr<google::longrunning::Operation>
DeploymentResourcePoolServiceTracingConnection::UpdateDeploymentResourcePool(
    NoAwaitTag,
    google::cloud::aiplatform::v1::UpdateDeploymentResourcePoolRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::DeploymentResourcePoolServiceConnection::"
      "UpdateDeploymentResourcePool");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->UpdateDeploymentResourcePool(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeploymentResourcePool>>
DeploymentResourcePoolServiceTracingConnection::UpdateDeploymentResourcePool(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::DeploymentResourcePoolServiceConnection::"
      "UpdateDeploymentResourcePool");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateDeploymentResourcePool(operation));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
DeploymentResourcePoolServiceTracingConnection::DeleteDeploymentResourcePool(
    google::cloud::aiplatform::v1::DeleteDeploymentResourcePoolRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::DeploymentResourcePoolServiceConnection::"
      "DeleteDeploymentResourcePool");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteDeploymentResourcePool(request));
}

StatusOr<google::longrunning::Operation>
DeploymentResourcePoolServiceTracingConnection::DeleteDeploymentResourcePool(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteDeploymentResourcePoolRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::DeploymentResourcePoolServiceConnection::"
      "DeleteDeploymentResourcePool");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->DeleteDeploymentResourcePool(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
DeploymentResourcePoolServiceTracingConnection::DeleteDeploymentResourcePool(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::DeploymentResourcePoolServiceConnection::"
      "DeleteDeploymentResourcePool");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteDeploymentResourcePool(operation));
}

StreamRange<google::cloud::location::Location>
DeploymentResourcePoolServiceTracingConnection::ListLocations(
    google::cloud::location::ListLocationsRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::DeploymentResourcePoolServiceConnection::ListLocations");
  internal::OTelScope scope(span);
  auto sr = child_->ListLocations(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::location::Location>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::location::Location>
DeploymentResourcePoolServiceTracingConnection::GetLocation(
    google::cloud::location::GetLocationRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::DeploymentResourcePoolServiceConnection::GetLocation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetLocation(request));
}

StatusOr<google::iam::v1::Policy>
DeploymentResourcePoolServiceTracingConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::DeploymentResourcePoolServiceConnection::SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SetIamPolicy(request));
}

StatusOr<google::iam::v1::Policy>
DeploymentResourcePoolServiceTracingConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::DeploymentResourcePoolServiceConnection::GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIamPolicy(request));
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
DeploymentResourcePoolServiceTracingConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::DeploymentResourcePoolServiceConnection::"
      "TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TestIamPermissions(request));
}

StreamRange<google::longrunning::Operation>
DeploymentResourcePoolServiceTracingConnection::ListOperations(
    google::longrunning::ListOperationsRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::DeploymentResourcePoolServiceConnection::ListOperations");
  internal::OTelScope scope(span);
  auto sr = child_->ListOperations(std::move(request));
  return internal::MakeTracedStreamRange<google::longrunning::Operation>(
      std::move(span), std::move(sr));
}

StatusOr<google::longrunning::Operation>
DeploymentResourcePoolServiceTracingConnection::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::DeploymentResourcePoolServiceConnection::GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetOperation(request));
}

Status DeploymentResourcePoolServiceTracingConnection::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::DeploymentResourcePoolServiceConnection::"
      "DeleteOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteOperation(request));
}

Status DeploymentResourcePoolServiceTracingConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::DeploymentResourcePoolServiceConnection::"
      "CancelOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CancelOperation(request));
}

StatusOr<google::longrunning::Operation>
DeploymentResourcePoolServiceTracingConnection::WaitOperation(
    google::longrunning::WaitOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::DeploymentResourcePoolServiceConnection::WaitOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->WaitOperation(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<aiplatform_v1::DeploymentResourcePoolServiceConnection>
MakeDeploymentResourcePoolServiceTracingConnection(
    std::shared_ptr<aiplatform_v1::DeploymentResourcePoolServiceConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<DeploymentResourcePoolServiceTracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google
