// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/index_endpoint_service.proto

#include "google/cloud/aiplatform/v1/index_endpoint_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

IndexEndpointServiceConnectionIdempotencyPolicy::
    ~IndexEndpointServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<IndexEndpointServiceConnectionIdempotencyPolicy>
IndexEndpointServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<IndexEndpointServiceConnectionIdempotencyPolicy>(
      *this);
}

Idempotency
IndexEndpointServiceConnectionIdempotencyPolicy::CreateIndexEndpoint(
    google::cloud::aiplatform::v1::CreateIndexEndpointRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency IndexEndpointServiceConnectionIdempotencyPolicy::GetIndexEndpoint(
    google::cloud::aiplatform::v1::GetIndexEndpointRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency IndexEndpointServiceConnectionIdempotencyPolicy::ListIndexEndpoints(
    google::cloud::aiplatform::v1::ListIndexEndpointsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency
IndexEndpointServiceConnectionIdempotencyPolicy::UpdateIndexEndpoint(
    google::cloud::aiplatform::v1::UpdateIndexEndpointRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
IndexEndpointServiceConnectionIdempotencyPolicy::DeleteIndexEndpoint(
    google::cloud::aiplatform::v1::DeleteIndexEndpointRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency IndexEndpointServiceConnectionIdempotencyPolicy::DeployIndex(
    google::cloud::aiplatform::v1::DeployIndexRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency IndexEndpointServiceConnectionIdempotencyPolicy::UndeployIndex(
    google::cloud::aiplatform::v1::UndeployIndexRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
IndexEndpointServiceConnectionIdempotencyPolicy::MutateDeployedIndex(
    google::cloud::aiplatform::v1::MutateDeployedIndexRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency IndexEndpointServiceConnectionIdempotencyPolicy::ListLocations(
    google::cloud::location::ListLocationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency IndexEndpointServiceConnectionIdempotencyPolicy::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency IndexEndpointServiceConnectionIdempotencyPolicy::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return request.policy().etag().empty() ? Idempotency::kNonIdempotent
                                         : Idempotency::kIdempotent;
}

Idempotency IndexEndpointServiceConnectionIdempotencyPolicy::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency IndexEndpointServiceConnectionIdempotencyPolicy::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency IndexEndpointServiceConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency IndexEndpointServiceConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency IndexEndpointServiceConnectionIdempotencyPolicy::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency IndexEndpointServiceConnectionIdempotencyPolicy::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency IndexEndpointServiceConnectionIdempotencyPolicy::WaitOperation(
    google::longrunning::WaitOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<IndexEndpointServiceConnectionIdempotencyPolicy>
MakeDefaultIndexEndpointServiceConnectionIdempotencyPolicy() {
  return std::make_unique<IndexEndpointServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google
