// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/genai_tuning_service.proto

#include "google/cloud/aiplatform/v1/gen_ai_tuning_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

GenAiTuningServiceConnectionIdempotencyPolicy::
    ~GenAiTuningServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<GenAiTuningServiceConnectionIdempotencyPolicy>
GenAiTuningServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<GenAiTuningServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency GenAiTuningServiceConnectionIdempotencyPolicy::CreateTuningJob(
    google::cloud::aiplatform::v1::CreateTuningJobRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency GenAiTuningServiceConnectionIdempotencyPolicy::GetTuningJob(
    google::cloud::aiplatform::v1::GetTuningJobRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency GenAiTuningServiceConnectionIdempotencyPolicy::ListTuningJobs(
    google::cloud::aiplatform::v1::ListTuningJobsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency GenAiTuningServiceConnectionIdempotencyPolicy::CancelTuningJob(
    google::cloud::aiplatform::v1::CancelTuningJobRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency GenAiTuningServiceConnectionIdempotencyPolicy::RebaseTunedModel(
    google::cloud::aiplatform::v1::RebaseTunedModelRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency GenAiTuningServiceConnectionIdempotencyPolicy::ListLocations(
    google::cloud::location::ListLocationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency GenAiTuningServiceConnectionIdempotencyPolicy::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency GenAiTuningServiceConnectionIdempotencyPolicy::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return request.policy().etag().empty() ? Idempotency::kNonIdempotent
                                         : Idempotency::kIdempotent;
}

Idempotency GenAiTuningServiceConnectionIdempotencyPolicy::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency GenAiTuningServiceConnectionIdempotencyPolicy::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency GenAiTuningServiceConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency GenAiTuningServiceConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency GenAiTuningServiceConnectionIdempotencyPolicy::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency GenAiTuningServiceConnectionIdempotencyPolicy::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency GenAiTuningServiceConnectionIdempotencyPolicy::WaitOperation(
    google::longrunning::WaitOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<GenAiTuningServiceConnectionIdempotencyPolicy>
MakeDefaultGenAiTuningServiceConnectionIdempotencyPolicy() {
  return std::make_unique<GenAiTuningServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google
